/*
 * Copyright (C) 2016 Stefan Roese <sr@denx.de>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#ifndef _CONFIG_MVEBU_ARMADA_H
#define _CONFIG_MVEBU_ARMADA_H

#include <asm/arch/soc.h>

/*
 * High Level Configuration Options (easy to change)
 */
#define CONFIG_DISPLAY_BOARDINFO_LATE

/* additions for new ARM relocation support */
#define CONFIG_SYS_SDRAM_BASE	0x00000000

/* auto boot */
#define CONFIG_PREBOOT

#define CONFIG_BAUDRATE			115200
#define CONFIG_SYS_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, \
					  115200, 230400, 460800, 921600 }

#ifdef CONFIG_SILEX
#define CONFIG_MISC_INIT_R
#define SX_BOARD_VERMAJOR	"JQ01"
#define SX_BOARD_VERMINER	""
#define SX_SILEX_VERSION	(SX_BOARD_VERMAJOR SX_BOARD_VERMINER)

#define BOOTMODE_NORMAL			0	/* normal boot */
#define BOOTMODE_MANUFACTURE		1	/* manufacturing boot */
#define BOOTMODE_FACTORYDEFAULT		2	/* default boot and do factory default */
#define BOOTMODE_RECOVERY			3	/* recovery boot */

#define KERNEL_OFFS		0x00400000     /* Start offset of Application */
#define PHY_ANEG_TIMEOUT        60000          /* PHY needs longer aneg time */
#endif /* CONFIG_SILEX */

/* Default Env vars */
#define CONFIG_IPADDR			0.0.0.0	/* In order to cause an error */
#define CONFIG_SERVERIP			0.0.0.0	/* In order to cause an error */
#define CONFIG_NETMASK			255.255.255.0
#define CONFIG_GATEWAYIP		10.4.50.254
#define CONFIG_HAS_ETH1
#define CONFIG_HAS_ETH2
#define CONFIG_ETHPRIME			"eth0"
#define CONFIG_ROOTPATH                 "/srv/nfs/" /* Default Dir for NFS */
#define CONFIG_ENV_OVERWRITE		/* ethaddr can be reprogrammed */
#define CONFIG_EXTRA_ENV_SETTINGS	\
	"bootcmd=run bootcmd_rom;\0"	\
	"file_path=" SX_BOARD_VERMAJOR "/\0"	\
	"ethaddr=00:80:92:00:11:fa\0"	\
	"eth1addr=00:80:92:00:11:fb\0"	\
	"eth2addr=00:80:92:00:11:fc\0"	\
	"eth3addr=00:80:92:00:11:fd\0"	\
	"eth4addr=00:80:92:00:11:ff\0"	\
	"ipaddr=192.168.0.10\0"		\
	"serverip=192.168.0.1\0"	\
	"gatewayip=192.168.0.1\0"	\
	"update_flg=0\0"			\
	"kernel_addr_l=0x1500000\0"	\
	"kernel_addr_r=0x3000000\0"	\
	"kernel_name=Image.gz\0"	\
	"recovery_kernel_name=recovery-Image.gz\0"	\
	"initrd_addr=0x3000000\0"	\
	"initrd_name=initrd.img\0"	\
	"romfs_name=rootfs.squashfs\0"	\
	"recovery_romfs_name=recovery-rootfs.squashfs\0"	\
	"fdt_high=0xffffffffffffffff\0"	\
	"fdt_addr=0x01400000\0"		\
	"fdt_name=fdt.dtb\0"		\
	"recovery_fdt_name=recovery-fdt.dtb\0"		\
	"loadaddr=0x1500000\0"		\
	"bootcmd_net="			\
		"echo Trying load from TFTP server...; "		\
		"tftpboot $fdt_addr $file_path$fdt_name; "	\
		"tftpboot $kernel_addr_r $file_path$kernel_name; "\
		"unzip $kernel_addr_r $kernel_addr_l; "		\
		"tftpboot $initrd_addr $file_path$initrd_name; "	\
		"run set_bootargs_net; "				\
		"booti ${kernel_addr_l} - ${fdt_addr}\0"		\
	"set_bootargs_net="		\
		"setenv bootargs $console $mtdparts initrd=$initrd_addr,0x$filesize $extra_params $cpuidle\0" \
	"bootcmd_rom="			\
		"sf probe 0:0; "	\
		"sf read ${fdt_addr} 0x400000 0x10000; "		\
		"sf read ${kernel_addr_r} 0x410000 0x3f0000; "	\
		"unzip ${kernel_addr_r} ${kernel_addr_l}; "		\
		"run set_bootargs_rom; "						\
		"booti ${kernel_addr_l} - ${fdt_addr}\0"		\
	"bootcmd_recovery="			\
		"sf probe 0:0; "	\
		"sf read ${fdt_addr} 0x1600000 0x10000; "		\
		"sf read ${kernel_addr_r} 0x1610000 0x3f0000; "	\
		"unzip ${kernel_addr_r} ${kernel_addr_l}; "		\
		"run set_bootargs_recovery_rom; "				\
		"booti ${kernel_addr_l} - ${fdt_addr}\0"		\
	"set_bootargs_rom="			\
		"setenv bootargs $console $mtdparts $root $extra_params $cpuidle\0" \
	"set_bootargs_recovery_rom="			\
		"setenv bootargs $console $mtdparts $recovery_root $extra_params $cpuidle\0" \
	"mtdparts=mtdparts=spi0.0:1m(uboot),64k(uboot-env0),64k(uboot-env1),128k(config0),128k(config1),2688k(log),64k(fdt1),5056k(kernel1),13312k(rootfs1),64k(fdt2),5056k(kernel2),-(rootfs2)\0" \
	"update_firmware="		\
		"sf probe 0:0;"		\
		"echo Erasing application area...; "			\
		"sf erase 0x400000 0x1000000; " 			\
		"tftpboot ${fdt_addr} ${file_path}${fdt_name}; "	\
		"sf write ${fdt_addr} 0x400000 0x$filesize; "		\
		"tftpboot ${kernel_addr_r} ${file_path}${kernel_name}; "\
		"sf write ${kernel_addr_r} 0x410000 0x$filesize; "	\
		"tftpboot ${initrd_addr} ${file_path}${romfs_name}; "	\
		"sf write ${initrd_addr} 0x900000 0x$filesize;\0"	\
	"update_recovery_firmware="		\
		"sf probe 0:0;"		\
		"echo Erasing recovery_application area...; "			\
		"sf erase 0x1600000 0xA00000; " 			\
		"tftpboot ${fdt_addr} ${file_path}${recovery_fdt_name}; "	\
		"sf write ${fdt_addr} 0x1600000 0x$filesize; "		\
		"tftpboot ${kernel_addr_r} ${file_path}${recovery_kernel_name}; "\
		"sf write ${kernel_addr_r} 0x1610000 0x$filesize; "	\
		"tftpboot ${initrd_addr} ${file_path}${recovery_romfs_name}; "	\
		"sf write ${initrd_addr} 0x1B00000 0x$filesize;\0"	\
	"extra_params=pci=pcie_bus_safe\0" \
	"cpuidle=cpuidle.off=1\0"	\
	"netdev=eth0\0"			\
	"erase_all="							\
		"sf probe 0:0;"						\
		"echo Erasing ROM without U-Boot...; "			\
		"sf erase 0x100000 0x1f00000;\0"				\
	"erase_env=sf probe 0:0; sf erase 0x100000 0x20000\0" \
	"console=" CONFIG_DEFAULT_CONSOLE "\0"\
	"root=root=/dev/mtdblock8 init=/init.overlayfs\0"	\
	"recovery_root=root=/dev/mtdblock11 init=/init.overlayfs\0"	\
	"usb_pgood_delay=5000"
/*
 * For booting Linux, the board info and command line data
 * have to be in the first 8 MB of memory, since this is
 * the maximum mapped by the Linux kernel during initialization.
 */
#define CONFIG_CMDLINE_TAG		/* enable passing of ATAGs  */
#define CONFIG_INITRD_TAG		/* enable INITRD tag */
#define CONFIG_SETUP_MEMORY_TAGS	/* enable memory tag */

#define	CONFIG_SYS_CBSIZE	1024	/* Console I/O Buff Size */
#define	CONFIG_SYS_PBSIZE	(CONFIG_SYS_CBSIZE \
		+ sizeof(CONFIG_SYS_PROMPT) + 16)	/* Print Buff */

/*
 * Size of malloc() pool
 */
#define CONFIG_SYS_MALLOC_LEN	(9 << 20) /* 16MiB for malloc() */

/*
 * Other required minimal configurations
 */
#define CONFIG_ARCH_CPU_INIT		/* call arch_cpu_init() */
#define CONFIG_SYS_LOAD_ADDR	0x00800000	/* default load adr- 8M */
#define CONFIG_SYS_MEMTEST_START 0x00800000	/* 8M */
#define CONFIG_SYS_MEMTEST_END	0x00ffffff	/*(_16M -1) */
#define CONFIG_SYS_RESET_ADDRESS 0xffff0000	/* Rst Vector Adr */
#define CONFIG_SYS_MAXARGS	32	/* max number of command args */

#define CONFIG_SYS_ALT_MEMTEST

/* End of 16M scrubbed by training in bootrom */
#define CONFIG_SYS_INIT_SP_ADDR         (CONFIG_SYS_TEXT_BASE + 0xFF0000)

/*
 * SPI Flash configuration
 */
#define CONFIG_ENV_SPI_BUS		0
#define CONFIG_ENV_SPI_CS		0

/* SPI NOR flash default params, used by sf commands */
#define CONFIG_SF_DEFAULT_SPEED		40000000
#define CONFIG_SF_DEFAULT_MODE		SPI_MODE_0
#define CONFIG_ENV_SPI_MODE		CONFIG_SF_DEFAULT_MODE

/*
 * Assume minimum flash/eMMC boot partition size of 4MB
 * and save the environment at the end of the boot device
 * There is one exclusion from this rule - the EspressoBIN board with eMMC.
 * The eMMC device found on some EspressoBIN V7 boards has 2MB boot partition.
 */
#define CONFIG_ENV_SIZE			(64 << 10) /* 64KiB */
#define CONFIG_ENV_SECT_SIZE		(64 << 10) /* 64KiB sectors */

#ifdef CONFIG_MVEBU_NAND_BOOT
/* In case of NAND, we want to start the environment on page boundary */
#define CONFIG_ENV_OFFSET		0x400000
#else
#if defined(CONFIG_ENV_IS_IN_MMC) && \
defined(CONFIG_TARGET_MVEBU_ARMADA_37XX) && defined(CONFIG_MV88E6XXX_SWITCH)
/* This one should be EspressoBin, since A3700 DB does not have
 * MV88E6XXX switch enabled. Is there any other way to detect it?
 */
#define CONFIG_ENV_OFFSET		(0x200000 - CONFIG_ENV_SIZE)
#else
#define CONFIG_ENV_OFFSET		(0x100000)
#endif
#endif
/* Redundant environment */
#define CONFIG_SYS_REDUNDAND_ENVIRONMENT
#define CONFIG_ENV_OFFSET_REDUND	(CONFIG_ENV_OFFSET + CONFIG_ENV_SECT_SIZE)
#define CONFIG_ENV_SIZE_REDUND		CONFIG_ENV_SECT_SIZE

/*
 * Device ID and Boot partition defined in external script
 */
#define CONFIG_SYS_MMC_ENV_DEV		(CONFIG_MVEBU_BOOT_DEVICE)
#define CONFIG_SYS_MMC_ENV_PART		(CONFIG_MVEBU_BOOT_PART)

/*
 * SATA/SCSI/AHCI configuration
 */
#define CONFIG_SCSI_AHCI_PLAT
#define CONFIG_LBA48
#define CONFIG_SYS_64BIT_LBA

#define CONFIG_SYS_SCSI_MAX_SCSI_ID	2
#define CONFIG_SYS_SCSI_MAX_LUN		1
#define CONFIG_SYS_SCSI_MAX_DEVICE	(CONFIG_SYS_SCSI_MAX_SCSI_ID * \
					 CONFIG_SYS_SCSI_MAX_LUN)

/*
 * Ethernet Driver configuration
 */
#define CONFIG_ARP_TIMEOUT	200
#define CONFIG_NET_RETRY_COUNT	50

/*
 * The EEPROM ST M24C64 has 32 byte page write mode and takes up to 10 msec.
 */
#define CONFIG_SYS_EEPROM_PAGE_WRITE_DELAY_MS 10

#endif /* _CONFIG_MVEBU_ARMADA_H */
