/**
 * @file sxbr_table_function.c
 * encode : UTF-8/LF (日:JPN)
 *
 * Station Bridge Table
 *
 * CONFIDENTIAL Copyright (C) 2019 silex technology, Inc.
**/

#include <linux/module.h>
#include <linux/kernel.h>

#include "br_table_option.h"

/* global */
static struct sxbrt_function_option g_func_option = {NULL, NULL};

/**
 * ブリッジテーブル関数への関数ポインタを登録する関数
 *
 * @param[in] opt: ブリッジテーブル関数群として登録する関数ポインタを持った構造体
 *
 * @return 0 success
 *
 * @section note
 *  bridge tableから呼ばれる
**/
int sxbrtf_set_fp(struct sxbrt_function_option *opt)
{
	if (opt == NULL) {
		memset(&g_func_option, 0, sizeof(struct sxbrt_function_option));
		return 0;
	}
	if (opt->init                 == NULL ||
	    opt->exit                 == NULL ||
	    opt->is_enable            == NULL ||
	    opt->input                == NULL ||
	    opt->event                == NULL ||
	    opt->forward              == NULL ||
	    opt->overwrite_for_forward == NULL)
	{
		return -EINVAL;
	}

	memcpy(&g_func_option, opt, sizeof(struct sxbrt_function_option));
	return 0;
}
EXPORT_SYMBOL(sxbrtf_set_fp);

/**
 * ブリッジテーブル関数への関数ポインタを取得する関数
 *
 * @param[out] opt : ブリッジテーブル関数群への関数ポインタが登録される構造体
 *
 * @return 0 success
 *
 * @section note
 *  bridgeから呼ばれる
**/
int sxbrtf_get_fp(struct sxbrt_function_option **opt)
{
	if (g_func_option.init                 == NULL ||
	    g_func_option.exit                 == NULL ||
	    g_func_option.is_enable            == NULL ||
	    g_func_option.input                == NULL ||
	    g_func_option.event                == NULL ||
	    g_func_option.forward              == NULL ||
	    g_func_option.overwrite_for_forward == NULL)
	{
		return -EAGAIN;
	}

	*opt = &g_func_option;

	return 0;
}
EXPORT_SYMBOL(sxbrtf_get_fp);
