/**
 * @file br_table_option.h
 * encode : UTF-8/LF (日:JPN)
 *
 * Station Bridge Table関数群への、関数ポインタが、格納される構造体の定義
 *
 * CONFIDENTIAL Copyright (C) 2019 silex technology, Inc.
**/

#ifndef __SXBR_TABLE_OPTION_H__
#define __SXBR_TABLE_OPTION_H__ 1

#include "../br_private.h"

struct sxbrt_function_option
{
	int (*event)(struct net_bridge*,struct net_bridge_port*, int);

	int (*forward)(struct net_bridge*, const struct net_bridge_port*, struct sk_buff*);
	int (*overwrite_for_forward)  (const struct net_bridge*, const struct net_bridge_port*, const struct sk_buff*);
	int (*input)  (struct net_bridge*, const struct net_bridge_port*, struct sk_buff*);

	int (*is_enable)(struct net_bridge*);

	int (*init)(struct net_bridge*);
	void (*exit)(struct net_bridge*);
};

int sxbrtf_set_fp(struct sxbrt_function_option *opt);
int sxbrtf_get_fp(struct sxbrt_function_option **opt);

#endif
