/* Linux kernel driver for resistive touch panel on some Quatro reference boards
 *
 * Quasar resistive touch panel kernel driver
 * 
 * Copyright (c) 2014, 2015, The Linux Foundation.
 * All rights reserved.
 *
 * Redistribution and use
 * in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer
 * below) provided that the following conditions are met :
 *   *Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *   *Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and
 *    the following disclaimer
 *    in the documentation and/or other materials provided
 *    with the distribution.
 *
 *  NO EXPRESS OR IMPLIED LICENSES TO ANY PARTYS PATENT
 *  RIGHTS ARE GRANTED BY THIS LICENSE.
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS
 *  AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *  AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 *  OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 *  OF SUCH DAMAGE
 *
 */
#ifndef __DRIVERS_WDT8913A_CORE_H
#define __DRIVERS_WDT8913A_CORE_H

#define WDT8913A_MAX_TOUCH_POINTS    10
#define WDT8913A_MAX_TOUCH_ID        WDT8913A_MAX_TOUCH_POINTS-1

#define WDT8913A_VALID_TOUCH_ID(id) ((id) >= 0 && (id) <= WDT8913A_MAX_TOUCH_ID)

/**
 * struct wdt8913a_dev - represent a wdt8913a device
 * @client: i2c client for the i2c slave
 * @input:  the input device 
 * @flags:  input conditions for different touch id
 * @int_reg_cause: interrupt cause register, which stores
 *      which pin causing the interrupt
 * @int_reg_dat: interrupt register, which stores current
 *      interrupt value (either high or low)
 * @int_off: the offset of related interrupt registers to
 *      represent the pin we use as interrupt source
 * 
 * A wdt8913a_dev is responsible to retrieve data from
 * i2c bus and then transform it to the input data for
 * user space applications.
 */
struct wdt8913a_dev
{
	struct i2c_client *client;
	struct input_dev  *input;
	bool               flags[WDT8913A_MAX_TOUCH_POINTS];
	void __iomem      *int_reg_cause;
	void __iomem      *int_reg_dat;
	u8                 int_off;
};

extern irqreturn_t wdt8913a_isr(int this_irq, void *dev_id);

#endif
