/*=================================================================================================
Filename:    vos_kernel.h
Description: abstraction functions of Linux kernel  
Data:        Initial revision. Bob@2019-12-05
==================================================================================================*/
#ifndef VOS_KERNEL_H
#define VOS_KERNEL_H

#include <linux/module.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/cdev.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/device.h>
#include <linux/slab.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/kallsyms.h>
#include <linux/kfifo.h>
#include <linux/hardirq.h>
#include <linux/list.h>
#include <linux/ioctl.h>
#include <linux/uio.h>
#include <stdarg.h>
#include <linux/clk.h>
#include <linux/clk-provider.h>
#include <linux/delay.h>
#include <linux/gpio.h>
#include <linux/input.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/io.h>
#include <linux/irqreturn.h>
#include <linux/kthread.h>
#include <linux/kernel.h>
#include <linux/linkage.h>
#include <linux/pci.h>
#include <linux/poll.h>
#include <linux/printk.h>
#include <linux/platform_device.h>
#include <linux/string.h>
#include <linux/syscalls.h>
#include <linux/spinlock.h>
#include <linux/sysctl.h>
#include <linux/timer.h>
#include <linux/uaccess.h>
#include <linux/wait.h>
#include <linux/workqueue.h>
#include <linux/mod_devicetable.h>
#include <asm/dma.h>
#include <asm/current.h>
#include <linux/seq_file.h>
#include <linux/jiffies.h>
//#include <assert.h>
#include <linux/timer.h>

typedef enum _e_vos_type
{
	VOS_TASK_TYPE = 0xbea1,
	VOS_MSGQUE_TYPE = 0xbea2,
	VOS_MUTEX_TYPE = 0xbea3,
	VOS_SEM_TYPE = 0xbea4,
	VOS_TIMER_TYPE = 0xbea5,
	VOS_EVENT_TYPE = 0xbea6,
	VOS_IPC_TYPE = 0xbea7,
	VOS_SOCKET_TYPE = 0xbea8,
	VOS_SMEM_TYPE = 0xbea9,
} E_VOS_TYPE;

////DLK: double link
#define VOS_DLK_MAGIC_ID 0xabcd1234
#define VOS_DLK_HEAD_ID 0x55cc
#define VOS_DLQ_LIST_MAX 16
#define VOS_DLQ_MAGIC_ID VOS_DLK_MAGIC_ID

typedef struct tagVosDlk
{
	unsigned long nMagicId;
	unsigned long nDataSize;
	unsigned long nNodeCnt;
	HVOSMUTEX hMutex;
	HVOSMUTEX hMutexTree;
	pfDlFunc pfGetKey;
	unsigned long nSortFlag; //nFlag: 0-no sort; 1-increase; 2-decrease
	DLK_NODE *pHead;
}VosDlk_S;

typedef VosDlk_S VosDlq_S;

typedef struct tagVosRbuf
{
	unsigned long nMagicId;
	unsigned long nUnitSize;
	unsigned long nMaxCnt;
	unsigned long nReadIndex; //empty: nReadIndex=nWriteIndex, full: nReadIndex=nWriteIndex+1
	unsigned long nWriteIndex;
	HVOSMUTEX hWtMutex;
	HVOSMUTEX hRdMutex;
	char *pBuff;
}VosRbuf_S;
#define VOS_RBUF_MAGIC_ID 0xabcd5678

//task
#define VOS_TASK_MAX_NUM 32
typedef struct tagTaskItem
{
	char sName[32];
	unsigned long nFunAddr;
	struct task_struct * nTaskID;
	unsigned long vosType;
}TASK_ITEM_S;
void vos_taskInit(void);

typedef int ( * pTaskFunc)(int, int, int);
typedef struct tagTaskCallBack
{
	pTaskFunc pFunc;
	int par1;
	int par2;
	int par3;
}TASK_CK_S;


//Mutex
#define VOS_MUTEX_MAX_NUM 32
typedef struct tagMutexItem
{
	char sName[12];
	struct mutex *pMutex;
	int nUsedThread;
	int nCnt;
	unsigned long vosType;
}Mutex_ITEM_S;
void vos_mutexInit(void);

//Semphore
#define VOS_SEM_MAX_NUM 32
typedef struct tagSemItem
{
	char sName[12];
	struct semaphore * pSem;
	unsigned long vosType;
}Sem_ITEM_S;
void vos_semInit(void);

//Queue
#define VOS_QUE_MAX_NUM 32
typedef struct tagQueItem
{
	char sName[12];
    HVOSSEM sem;
    struct kfifo fifo;
    spinlock_t lock;
	unsigned short nMaxCounter;
	unsigned short nMaxItemSize;
	unsigned long vosType;
}Que_ITEM_S;
typedef struct tagQueMsg
{
	unsigned long nCmd1;
	unsigned long nCmd2;
	unsigned long nData[6];	
}VosMsg_S;
void vos_queInit(void);

//Timer
#define VOS_TIMER_MAX_NUM 8
typedef struct tagTimerItem
{
	char sName[12];
	struct timer_list * pTimer;
	TimeFunc pfFunc;
	unsigned long param;
	int nMilliSec;
	int nInterMilliSec;
	unsigned long vosType;
}Timer_ITEM_S;
void vos_timerInit(void);
//hrTimer
typedef struct taghrTimerItem
{
	char sName[12];
	struct hrtimer *pTimer;
	TimeFunc pfFunc;
	unsigned long param;
	int nanoSec;
	int status;
	unsigned long cnt;
}hrTimer_ITEM_S;
void vos_hrtimerInit(void);

//dma_pool
unsigned long vos_dplCreate(unsigned long nPoolSize, unsigned long nPhyStartAddr, unsigned long nKvirStartAddr);

//Misc
#define VOS_CLOCK_FLAG 3
#define VOS_IRQ_NUM 16
typedef struct tagIrq_Item
{
	int status;
	unsigned long int_num;
	char name[20];
	void *handler;
	void *context;
}IRQ_ITEM_S;

typedef enum _e_irq_status
{
	VOS_IRQ_NULL = 0,
	VOS_IRQ_ATTACH,
	VOS_IRQ_ENABLE,
	VOS_IRQ_DISABLE,
} E_IRQ_STATUS;

//TRACE_BUFF
#define DBG_TRACE_NUM_MAX 512
#define DBG_TRACE_BUFF_SIZE 128

#define SHELL_SC_SOURCE_CODE_SIZE 12
typedef struct tagSHELL_SC_NODE
{
	unsigned long ulFunAddr;
	unsigned long ulRetVal;
	unsigned long ulCodeData[SHELL_SC_SOURCE_CODE_SIZE/4];
}SHELL_SC_NODE_S;

#define VOS_ALIGN(a,b)        (((a)+(b)-1)/(b)*(b))

void vos_miscInitAll(void);
void vos_memInit(void);
void * vos_dmalloc(int flag, unsigned long size, void *pPhyAddr);
void vos_dfree(flag, size, pKvirAddr, pPhyAddr);
void *vos_dmemCoherence(unsigned long kv_addr, int len, int type);
void *vos_dmemSync(unsigned long kv_addr, int len, int type);
unsigned long vos_kvAddrRd(unsigned long vAddr, unsigned long len);
unsigned long vos_kvAddrWt(unsigned long vAddr, unsigned long val, unsigned long len);
void vos_dd(unsigned long ulAddr, unsigned long ulUnits, unsigned long ulWidth, char * pInfo1);
void vos_mm(unsigned long ulAddr, unsigned long ulVal, unsigned long ulWidth, char * pInfo);

//vos_mPool
#define MPL_USING_IN_KENERL 1
typedef struct _s_mpl_node
{
	unsigned short nMagicId;
	unsigned short nLine;
	const char * szFile;
	
	struct _s_mpl_node *pNext;
	struct _s_mpl_node *pPrev;
	unsigned int nStartAddr; //phsical addr
	unsigned int nUsedSize;		
	unsigned int nPhyAddr; //malloc return phy addr
	HVOSMPL hPool;
}S_MPL_NODE, *PS_MPL_NODE;
#define MPL_MEM_MAGIC_ID 0x5a5a

#define VOS_MPL_MAGIC_ID 0x12345a5a
#define VOS_MPL_NAME_MAX_SIZE 32
typedef struct _s_mevos_mpl
{
	int nMagicId;
	int type; //type: 0-no phyAddr, no USING_EXTERNAL_NODE; 1-have phyAddr, no USING_EXTERNAL_NODE; 2-have phyAddr, have USING_EXTERNAL_NODE
	HVOSDLK nameList;
	char szPoolName[12]; 
	unsigned int nPoolAddrStart; //only used for destroy	
	unsigned int nPhyAddrStart;	 //only used for destroy
	
	HVOSMUTEX hMtx;
	int nTotalSize;
	int nRemainSize;
	int nPeakUsed;
	unsigned int nPoolAddr;
	unsigned int nPhyAddr;
	PS_MPL_NODE pTailNode;
	PS_MPL_NODE pHeadNode;
}S_MPL_POOL, *PS_MPL_POOL;


//vos_mtmPool
#define VOS_MTM_MAGIC_ID 0x12345678

typedef struct tagMTM_POOL
{	
	int nMagicId;
	int type;	//type: 0-no phyAddr, no USING_EXTERNAL_NODE; 1-have phyAddr, no USING_EXTERNAL_NODE; 2-have phyAddr, have USING_EXTERNAL_NODE
	int memType; //0-using vos_malloc; 1-using VOS_KMALLOC; 2-using vos_kmalloc_coherent
	char poolName[16];
	HVOSMUTEX hMtx;
	int nPoolNum;
	int nPoolSize;
	int usedPoolNum;
	int nTotalSize;
	int usedSize;	
	int peakSize;
	
	HVOSDLK useList;
	HVOSDLK freeList;
	
}MTM_POOL_S;

#define TS_MAX_NUM 500000
#define TS_NUM_PER_TIME (TS_MAX_NUM/200)
#define TS_MAX_LOAD_TASKNUM 256
typedef struct _s_ts_rec
{
	short p1, p2;
	char *pName;
	unsigned long sec;
	unsigned long ns;
	unsigned long irqTime;
	unsigned long irqNum;
}S_TS_REC;

typedef struct _s_ts_load
{
	short p1, p2;
	char *pName;
	unsigned long totalTimeUs;
	unsigned long switchCnt;
	unsigned long perCent;
}S_TS_LOAD;

typedef struct _s_seg_load
{
	S_TS_LOAD stLoad[TS_MAX_LOAD_TASKNUM];
	unsigned long startUs;
	unsigned long endUs;
	unsigned long startIndex;
	unsigned long endIndex;
}S_SEG_LOAD;

typedef struct _s_ts_info
{
	int type;
	int flag; //1-start;0-stop;0x10-stop&saved
	unsigned long index;
	unsigned long irqCnt;
	unsigned long irqTotalUs;
	S_TS_REC *psBuff;
	S_SEG_LOAD stLoadWhole;
	unsigned long segments;
	unsigned long segSartIndex[128];
	S_SEG_LOAD *pSegLoad;
}S_TS_INFO;

typedef void ( * PFuncRecd)(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
typedef unsigned int ( * pFuncVct)(unsigned int, unsigned int, unsigned int, unsigned int, unsigned int, unsigned int);
void tsr_recTrace(unsigned int p1, unsigned int p2, unsigned int p3, unsigned int p4, unsigned int p5);
void tsr_recLoading(unsigned int p1, unsigned int p2, unsigned int p3, unsigned int p4, unsigned int p5);
void tsr_setFlag(int flag, int type); //flag: 1-start;0-stop.
int tsr_showRec(int flag);
extern void ts_regRecordFunc(PFuncRecd pFuncRec, unsigned int irqFlag);


#endif /*end #ifndef VOS_KERNEL_H*/


