/*=================================================================================================
Filename:    vos_dpool.c
Description: dma memory pool API 
Data:        Initial revision. Bob@2020-4-24
==================================================================================================*/
#ifdef __cplusplus 
    extern "C" { 
#endif

#include "vos_if.h"
#include "vos_innr.h"

#define DMA_POOL_PHY_ADDR 0X9f000000
#define DMA_POOL_MAX_SIZE (16*1024*1024)

HVOSMPL g_hDmaPool = NULL;
unsigned long vos_dplCreate(unsigned long nPoolSize, unsigned long nPhyStartAddr, unsigned long nKvirStartAddr)
{
	unsigned long dplKvAddr=0;
	
	if(g_hDmaPool != NULL)return 0;
	
	if(nKvirStartAddr == 0) //using external node
	{
		g_hDmaPool = vos_mplCreatePoolPhy("dma_pool", 1, NULL, nPoolSize, nPhyStartAddr, 1);
	}
	else	
	{
		dplKvAddr = (unsigned long)ioremap(nPhyStartAddr, nPoolSize);
		if(0 == dplKvAddr)return 1;
		
		g_hDmaPool = vos_mplCreatePoolPhy("dma_pool", 1, (void *)dplKvAddr, nPoolSize, nPhyStartAddr, 1);
	}

	if(g_hDmaPool == NULL)return 2;
	return 0;
}

void vos_dplShowPool(int prtlLog)
{
	PS_MPL_POOL pPool = (PS_MPL_POOL)g_hDmaPool;
	if(g_hDmaPool == NULL)return;
	
	vosPrintf("DMA_POOL_PHY_ADDR: 0x%x, MAX_SIZE: 0x%x, KvAddr=0x%x\r\n", pPool->nPhyAddr, pPool->nTotalSize, pPool->nPoolAddr);
	(void)vos_mplInfo(g_hDmaPool, NULL, prtlLog);
	return;
}

void *vos_dplGetPhyAddr(void *pVirAddr)
{
	void *pPhyddr = NULL;

	if(g_hDmaPool == NULL)return NULL;

	pPhyddr = vos_mplGetPhyAddr(g_hDmaPool, pVirAddr);
	return pPhyddr;
}

void  *vos_dplMalloc(int size, char *szFunc, int nLine)
{
	void *pVirAddr = NULL;
	
	if(g_hDmaPool == NULL)return NULL;

	pVirAddr = vos_mplAlloc(g_hDmaPool, size, 32, szFunc, nLine);
	if(pVirAddr == NULL)
	{
		vosPrintf("vos_dplMalloc fail!!!\r\n");
		vos_dplShowPool(1);
	}
	return pVirAddr;
}

void  vos_dplFree(void *pVirAddr)
{
	if(g_hDmaPool == NULL)return;

	return vos_mplFree(g_hDmaPool, pVirAddr);
}

//1-OK, 0-fail
int vos_dplCheck(void *pVirAddr)
{
	if(g_hDmaPool == NULL)return 0;
	
	return vos_mplCheck(g_hDmaPool, pVirAddr);
}

HVOSMTP g_hMtmPool = NULL;
unsigned long vos_mdplCreate(int type, int nPoolNum, int nPoolSize)
{
	if(g_hMtmPool != NULL)return 0;
	
	g_hMtmPool = vos_mtpCreatePool("vos_kpl", type, 1, nPoolNum, nPoolSize);
	return 0;
}

void  *vos_mdplMalloc(int size, char *szFunc, int nLine)
{
	if(g_hMtmPool == NULL)return NULL;
	return vos_mtpMalloc(g_hMtmPool, size, 32, szFunc, nLine);
}

void  vos_mdplFree(void *pVirAddr)
{
	if(g_hMtmPool == NULL)return;
	vos_mtpFree(g_hMtmPool, pVirAddr);
}

void *vos_mdplGetPhyAddr(void *pVirAddr)
{
	void *pPhyddr = NULL;

	if(g_hMtmPool == NULL)return NULL;

	pPhyddr = vos_mplGetPhyAddr(g_hMtmPool, pVirAddr);
	return pPhyddr;
}

void vos_mdplShowPool(int prtlLog)
{
	if(g_hMtmPool == NULL)return;
	vos_mtpShow(g_hMtmPool, prtlLog);
}

EXPORT_SYMBOL(vos_dplCreate);
EXPORT_SYMBOL(vos_dplGetPhyAddr);
EXPORT_SYMBOL(vos_dplMalloc);
EXPORT_SYMBOL(vos_dplFree);
EXPORT_SYMBOL(vos_dplCheck);

EXPORT_SYMBOL(vos_mdplCreate);
EXPORT_SYMBOL(vos_mdplMalloc);
EXPORT_SYMBOL(vos_mdplGetPhyAddr);
EXPORT_SYMBOL(vos_mdplFree);

#ifdef __cplusplus 
    }
#endif

