/*=================================================================================================
Filename:    vos_dev.c
Description: vos device  
Data:        Initial revision. Bob@2019-12-5
==================================================================================================*/

#include "vos_if.h"
#include "vos_innr.h"
#include "vos_usr_if.h"

//cp /home/bob/simva_code/linux_sys/platform_sys/build-bundle/poky/build/tmp/work/simva32-poky-linux-gnueabi/vos/1.0-r0/vos.ko /home/bob/simva_code/simva_fw/VOS/kernel_linux/
//scp /home/bob/simva_code/simva_fw/VOS/kernel_linux/vos.ko root@10.16.10.43:/lib/
#define VOS_DRIVER_NAME "vosdev"

static int vosdev_inc = 0;
dev_t vosdev_dev;
struct class *vosdev_class;
struct cdev vos_cdev;
struct device *g_pVosDev = NULL;


int vosdev_open(struct inode *inode, struct file *filp)
{
	//printk("vosdev_open: vosdev_inc=%d", vosdev_inc);
	if (vosdev_inc > 0)
	{
		printk("open error! vosdev_inc=%d", vosdev_inc);
		//return -ERESTARTSYS;
		return 0;
	}

	vosdev_inc++;
	return 0;
}

int vosdev_release(struct inode *inode, struct file *filp)
{
	if (vosdev_inc <= 0)
	{
		printk("close error!, vosdev_inc=%d", vosdev_inc);
		//return -EFAULT;
		return 0;
	}
	vosdev_inc--;
	return 0;
}

int vosdev_read(struct file *filp, char __user *buf, size_t count, loff_t *f_ops)
{
	KRPC_S sDevCmd = {0,};
	void *pkVirAddr, *pPhyAddr;
	unsigned long ulVal, t1;	
	HVOSMTP hMtmPool = NULL;	
	int flag = 9;
	char sName[32] = {0,};
	pFuncVct pFunc;
	static char g_string[128] = {0,};

	if(count != sizeof(KRPC_S))return 0;

	copy_from_user((char *)&sDevCmd, buf, count);
	sDevCmd.ulResult = 0;

	switch(sDevCmd.ulCmd)
	{
		case VOSCMD_DMALLOC:
			flag = 0;
		case VOSCMD_DMALLOC_UNCACHED:
			if(flag == 9)flag = 1;
		case VOSCMD_DMALLOC_WRITECOMBINE:
			if(flag == 9)flag = 2;

			pkVirAddr = vos_dmalloc(flag, sDevCmd.ulPar[0], (void *)&pPhyAddr);
			sDevCmd.output[0] = (unsigned long)pPhyAddr;
			sDevCmd.output[1] = (unsigned long)pkVirAddr;
			break;

		case VOSCMD_DMA_CACHE2PHY:
			if(sDevCmd.ulPar[2] == 0)
				sDevCmd.output[0] = (unsigned long)vos_dmemCoherence(sDevCmd.ulPar[0], sDevCmd.ulPar[1], DMA_TO_DEVICE);
			else
				sDevCmd.output[0] = (unsigned long)vos_dmemSync(sDevCmd.ulPar[0], sDevCmd.ulPar[1], DMA_TO_DEVICE);
			break;
			
		case VOSCMD_DMA_CACHE_MISS:
			if(sDevCmd.ulPar[2] == 0)
				sDevCmd.output[0] = (unsigned long)vos_dmemCoherence(sDevCmd.ulPar[0], sDevCmd.ulPar[1], DMA_FROM_DEVICE);
			else
				sDevCmd.output[0] = (unsigned long)vos_dmemSync(sDevCmd.ulPar[0], sDevCmd.ulPar[1], DMA_FROM_DEVICE);				
			break;
			
		case VOSCMD_DFREE:
			vos_dfree(sDevCmd.ulPar[0], sDevCmd.ulPar[1], sDevCmd.ulPar[2], sDevCmd.ulPar[3]);
			break;
			
		case READ_CMD:
			ulVal = vos_kvAddrRd(sDevCmd.ulPar[0], sDevCmd.ulPar[1]);
			sprintf(sDevCmd.sInfo, "read kv_addr(0x%x): 0x%x\r\n", sDevCmd.ulPar[0], ulVal);
			break;
			
		case WRITE_CMD:
			ulVal = vos_kvAddrWt(sDevCmd.ulPar[0], sDevCmd.ulPar[1], sDevCmd.ulPar[2]);
			sprintf(sDevCmd.sInfo, "write kv_addr(0x%x): 0x%x, wide=%d\r\n", sDevCmd.ulPar[0], sDevCmd.ulPar[1], ulVal);
			break;
			
		case MAP_CMD:
			ulVal = vos_phyAddrMap(sDevCmd.ulPar[0], sDevCmd.ulPar[1]);
			sprintf(sDevCmd.sInfo, "Map phy_addr(0x%x) to kvAddr(0x%x), size=%d\r\n", sDevCmd.ulPar[0], ulVal, sDevCmd.ulPar[1]);
			break;
			
		case UNMAP_CMD:
			ulVal = vos_phyAddrUnmap(sDevCmd.ulPar[0]);
			sprintf(sDevCmd.sInfo, "Unmap kvAddr(0x%x)\r\n", ulVal);
			break;
			
		case MAP_READ_CMD:
			ulVal = vos_phyAddrRd(sDevCmd.ulPar[0], sDevCmd.ulPar[1]);
			sprintf(sDevCmd.sInfo, "read phy_addr(0x%x): 0x%x\r\n", sDevCmd.ulPar[0], ulVal);
			break;
			
		case MAP_WRITE_CMD:
			ulVal = vos_phyAddrWt(sDevCmd.ulPar[0], sDevCmd.ulPar[1], sDevCmd.ulPar[2]);
			sprintf(sDevCmd.sInfo, "write phy_addr(0x%x): 0x%x, wide=%d\r\n", sDevCmd.ulPar[0], sDevCmd.ulPar[1], ulVal);
			break;
			
		case PHY_TO_VIRT_CMD:
			ulVal = vos_memPhy2vir(sDevCmd.ulPar[0]);
			sprintf(sDevCmd.sInfo, "phy_addr(0x%x) to kv_addr(0x%x)\r\n", sDevCmd.ulPar[0], ulVal);
			break;

		case VIRT_TO_PHY_CMD:
			ulVal = vos_memVir2Phy(sDevCmd.ulPar[0]);
			sprintf(sDevCmd.sInfo, "kv_addr(0x%x) to phy_addr(0x%x)\r\n", sDevCmd.ulPar[0], ulVal);
			break;
			
		case VOSCMD_DPOOL_CREATE:
			pkVirAddr = ioremap(sDevCmd.ulPar[1], sDevCmd.ulPar[0]);
			if(NULL == pkVirAddr)
			{
				sDevCmd.output[0] = 0; //return NULL
				sDevCmd.ulResult = 1;
				break;;
			}
			ulVal = (unsigned long)vos_mplCreatePoolPhy("dma_pool", 1, pkVirAddr, sDevCmd.ulPar[0], sDevCmd.ulPar[1], 1);
			vosPrintf("vos_mplCreatePoolPhy(0x%x): size=0x%x, phyAddr=0x%x, pkVirAddr=0x%x\r\n", ulVal, sDevCmd.ulPar[0], sDevCmd.ulPar[1], pkVirAddr);
			sDevCmd.output[0] = ulVal;
			break;

		case VOSCMD_DPOOL_MALLOC:			
			pkVirAddr = vos_mplAlloc((HVOSMPL)sDevCmd.ulPar[0], sDevCmd.ulPar[1], 32, sDevCmd.sInfo, (int)sDevCmd.ulPar[2]);
			sDevCmd.output[0] = (unsigned long)vos_mplGetPhyAddr((HVOSMPL)sDevCmd.ulPar[0], pkVirAddr);
			sDevCmd.output[1] = (unsigned long)pkVirAddr;
			break;

		case VOSCMD_DPOOL_FREE:
			pkVirAddr = (void *)sDevCmd.ulPar[1];
			vos_mplFree((HVOSMPL)sDevCmd.ulPar[0], pkVirAddr);
			break;

		case VOSCMD_DPOOL_FREE_ALL:
			vos_mplFreeAll((HVOSMPL)sDevCmd.ulPar[0]);
			break;

		case VOSCMD_DPOOL_SHOW:
			vos_mplInfo((HVOSMPL)sDevCmd.ulPar[0], NULL, sDevCmd.ulPar[1]);
			break;
			
		case VOSCMD_MTMPOOL_CREATE:
			hMtmPool = vos_mtpCreatePool("vos_kpl", (int)sDevCmd.ulPar[0], (int)sDevCmd.ulPar[1], (int)sDevCmd.ulPar[2], (int)sDevCmd.ulPar[3]);
			sDevCmd.output[0] = (unsigned long)hMtmPool;
			break;

		case VOSCMD_MTMPOOL_MALLOC:
			pkVirAddr = vos_mtpMalloc((HVOSMTP)sDevCmd.ulPar[0], (int)sDevCmd.ulPar[1], 32, sDevCmd.sInfo, (int)sDevCmd.ulPar[2]);
			sDevCmd.output[0] = (unsigned long)vos_mplGetPhyAddr(1, pkVirAddr);
			sDevCmd.output[1] = (unsigned long)pkVirAddr;
			break;

		case VOSCMD_MTMPOOL_FREE:
			pkVirAddr = (void *)sDevCmd.ulPar[1];
			vos_mtpFree((HVOSMTP)sDevCmd.ulPar[0], pkVirAddr);
			break;

		case VOSCMD_MTMPOOL_FREE_ALL:
			vos_mtpFreeAll((HVOSMTP)sDevCmd.ulPar[0]);
			break;

		case VOSCMD_MTMPOOL_DESTROY:
			vos_mtpDestroyPool((HVOSMTP)sDevCmd.ulPar[0]);
			break;

		case VOSCMD_MTMPOOL_SHOW:
			vos_mtpShow((HVOSMTP)sDevCmd.ulPar[0], (int)sDevCmd.ulPar[1]);
			break;

		case TS_REC_CMD:
			tsr_setFlag((int)sDevCmd.ulPar[0], (int)sDevCmd.ulPar[1]);
			break;

		case TS_REC_SHOW_CMD:
			sDevCmd.ulResult = tsr_showRec((int)sDevCmd.ulPar[0]);
			break;

		case KQUE_GET_CMD:
			sDevCmd.ulResult = vos_kqueRecv((void *)sDevCmd.output, sDevCmd.ulPar[0]);
			break;

		case KQUE_SEND_CMD:
			sDevCmd.ulResult = vos_kqueSend((void *)sDevCmd.output, sDevCmd.ulPar[0]);
			break;

		case KVCT_D_CMD:
			vos_dd(sDevCmd.ulPar[0], sDevCmd.ulPar[1], sDevCmd.ulPar[2], sDevCmd.sInfo);
			break;

		case KVCT_M_CMD:
			vos_mm(sDevCmd.ulPar[0], sDevCmd.ulPar[1], sDevCmd.ulPar[2], sDevCmd.sInfo);
			break;

		case KVCT_D_VAR_CMD:
            strncpy(sName, sDevCmd.sInfo, 31);
            sprintf(sDevCmd.sInfo,"%s=0x%x, in Address:0x%x\r\n", sName, *(unsigned long *)sDevCmd.ulPar[0], sDevCmd.ulPar[0]);
			break;

        case KVCT_M_VAR_CMD: 
            *(unsigned long *)sDevCmd.ulPar[0] = sDevCmd.ulPar[1];
            strncpy(sName, sDevCmd.sInfo, 31);
            sprintf(sDevCmd.sInfo,"write %s(0x%x)=0x%x\r\n", sName, sDevCmd.ulPar[0], sDevCmd.ulPar[1]);
            break;
			
        case KVCT_MK_STR_CMD: 
			strncpy(g_string, sDevCmd.sInfo, 127);
			sDevCmd.output[0] = (unsigned long)g_string;
			break;
		case KVCT_CALL_FUNC_CMD: 
            strncpy(sName, sDevCmd.sInfo, 31);
            //pFunc = (pFuncVct)__symbol_get(sName);	
            pFunc = (pFuncVct)sDevCmd.ulPar[0];
			t1 = vos_GetSysCntUs();
			//printk("%s(0x%x):(0x%x, 0x%x, 0x%x, 0x%x, 0x%x, 0x%x)", sName, pFunc, sDevCmd.ulPar[1], sDevCmd.ulPar[2], sDevCmd.ulPar[3], sDevCmd.output[0], sDevCmd.output[1], sDevCmd.output[2]);
            ulVal = pFunc(sDevCmd.ulPar[1], sDevCmd.ulPar[2], sDevCmd.ulPar[3], sDevCmd.output[0], sDevCmd.output[1], sDevCmd.output[2]);
			sprintf(sDevCmd.sInfo,"Run %s(0x%x), return %u(0x%x), take %uus\r\n", sName, sDevCmd.ulPar[0], ulVal, ulVal, vos_GetSysCntUs()-t1);
            break;
			
		default:
			return 0;
			break;

	}
	
	copy_to_user(buf, (char *)&sDevCmd, count);
	
	return count;
}

int vosdev_write(struct file *filp, char __user *buf, size_t count, loff_t *f_ops)
{
	char demoBuffer[32];
	if (copy_from_user(demoBuffer+*f_ops, buf, count))
		count = -EFAULT;
	
	return count;
}

static const struct file_operations vosdev_fops = {
	.owner = THIS_MODULE,
	.open = vosdev_open,
	.release = vosdev_release,
	.read = vosdev_read,
	.write = vosdev_write,
};

int vosdev_init_module(void)
{
	int ret, dsn=3;
	unsigned long  ulRet = 0;
	//struct device *g_pVosDev;

	ret = alloc_chrdev_region(&vosdev_dev, dsn, 1, VOS_DRIVER_NAME);
	if (ret) 
	{
		printk("error alloc_chrdev_region = %d \n", ret);
		return ret;
	}

	printk("vosdev_dev = %d \n", vosdev_dev);
	cdev_init(&vos_cdev, &vosdev_fops);
	vos_cdev.owner = THIS_MODULE;
	ret = cdev_add(&vos_cdev, vosdev_dev, dsn+1);
	if (ret) 
	{
		printk("error cdev_add = %d \n", ret);
		return ret;
	}
	
	vosdev_class = class_create(THIS_MODULE, VOS_DRIVER_NAME);
	if (IS_ERR(vosdev_class)) 
	{
		printk("error class_create\n");
		return PTR_ERR(vosdev_class);
	}

	g_pVosDev = device_create(vosdev_class, NULL, vosdev_dev, NULL, VOS_DRIVER_NAME);
	if (IS_ERR(g_pVosDev)) 
	{
		printk("error device_create\n");
		return PTR_ERR(g_pVosDev);
	}
	dma_set_coherent_mask(g_pVosDev, 0xffffffff); //add for coherent DMA mask

	vos_miscInitAll();
	
	return 0;
}

void vosdev_cleanup_module(void)
{
	device_destroy(vosdev_class, vosdev_dev);
	class_destroy(vosdev_class);
	cdev_del(&vos_cdev);
	unregister_chrdev_region(vosdev_dev, 1);
	printk("vosdev_cleanup_module OK!\n");
}

module_init(vosdev_init_module);
module_exit(vosdev_cleanup_module);

MODULE_AUTHOR("Copyright (c) 2020 - 2030 Primax");
MODULE_DESCRIPTION("Primax export vos interface to application space");
MODULE_VERSION("1.0");
MODULE_LICENSE("Dual MPL/GPL");
//MODULE_LICENSE("Dual BSD/GPL");

