/*
 * quasardev.h -- quasar-device - a bulk endpoint device for 
 *                composite usb gadget driver under qcomposite
 *
 * Copyright (c) 2014, 2015, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
/** 
 * This implements helper functions for implementing a driver i/o 
 * interface on top of a usb composite device function driver
 */
extern const struct usb_descriptor_header *otg_desc[];
extern char quasar_pnp_string[];

/*-------------------------------------------------------------------------*/
#define USB_DT_DEVICEINFO			0x21

/* USB_DT_DEVICEINFO: DeviceInfo descriptor for IPPUSB */
struct usb_deviceinfo_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	__u8  bcdReleaseNumber;
	__u8  bNumDescriptors;
	__u8  bCapabilitiesType;
	__u8  bCapabilitiesLength;
	__u16 wBasicCapabilities;
	__u8  iIPPVersionSupported;
	__u8  iIPPPrinterUUID;
} __attribute__ ((packed));

/*-------------------------------------------------------------------------*/

struct quasar_dev {
	struct usb_composite_dev *cdev;
	struct usb_function 	function;
	struct semaphore	sem;		/* lock this structure */
	/* lock buffer lists during read/write calls */
	spinlock_t		lock_io;
	/* locks everything else */
	struct mutex mutex;
	struct usb_gadget	*gadget;
	int			enabled;
	struct usb_ep		*in_ep, *out_ep;
	const struct usb_endpoint_descriptor
				*in, *out;
	struct list_head	rx_reqs;	/* List of free RX structs */
	struct list_head	rx_reqs_active;	/* List of Active RX xfers */
	struct list_head	rx_buffers;	/* List of completed xfers */
	/* wait until there is data to be read. */
	wait_queue_head_t	rx_wait;
	struct list_head	tx_reqs;	/* List of free TX structs */
	struct list_head	tx_reqs_active; /* List of Active TX xfers */
	/* Wait until there are write buffers available to use. */
	wait_queue_head_t	tx_wait;
	/* Wait until all write buffers have been sent. */
	wait_queue_head_t	tx_flush_wait;
	struct usb_request	*current_rx_req;
	size_t			current_rx_bytes;
	u8			*current_rx_buf;
	u8			reset_request;
	struct cdev		my_chardev;
	struct device		*pdev;
	int			cdevno;
	u8			cdev_open;
	wait_queue_head_t	wait;
	void			*priv;		/* place for intf to attach their own data */
};

static inline struct quasar_dev *func_to_qdev(struct usb_function *f)
{
	return container_of(f, struct quasar_dev, function);
}

/* holds our biggest descriptor */
#define USB_DESC_BUFSIZE	256
#define USB_BUFSIZE			16384

/* IOCTL cmd */
#define FIOPMXSCNSTSGET 0x40000001
#define FIOPMXSCNSTSSET 0x40000002
#define FIOPMXSDCSETINDEX 0x40001000
#define FIOPMXSDCSTATUS 0x40002000
#define FIOPMXSDCGETDATA 0x40003000

#define FIOPMXFLUSHBUF 0x20000001
#define FIOPMXNBIOMODE 0x20000002
#define FIOPMXMFPSTATUS 0x20000003
#define FIOPMXMFPGETEVERDISCON 0x20000004
#define FIOPMXMFPCLREVERDISCON 0x20000005
#define FIOPMXMFPUPDATEPROG 0x20000006
#define FIOPMXMFGETUSBSPEED 0x20000007

/*-------For SDC--------------------------------------------------------*/
#define USB_VENDOR_REQ_SDC_SET_INDEX 0x60
#define USB_VENDOR_REQ_SDC_GET_STATUS 0x61
#define USB_VENDOR_REQ_SDC_SET_PARA 0x62

#define USB_VENDOR_REQ_GET_DEVICEID 0x80
/*-------For Scan--------------------------------------------------------*/
#define USB_VENDOR_REQ_SCN_STATUS_UPDATE 0x70
#define USB_VENDOR_REQ_SCN_STATUS_READ 0x71
#define USB_VENDOR_REQ_SCN_STATUS_UPDATE_DONE 0x7f
/*---------------------------------------------------------------------*/
#define USB_VENDOR_REQ_INVALID 0xff


#define SCNSTS_DATA_SIZE (80)
#define SCNSTS_CMD_SIZE (12)

struct scnStsBuf
{
	u8 scnCmd[SCNSTS_CMD_SIZE];
	u8 scnBlock[SCNSTS_DATA_SIZE];
	int actLen;
    int isScnBufReady;
};

struct usb_request *qdev_req_alloc(struct usb_ep *ep, unsigned len, gfp_t gfp_flags, u8 num);
void qdev_req_free(struct usb_ep *ep, struct usb_request *req);
ssize_t qdev_read(struct file *fd, char __user *buf, size_t len, loff_t *ptr);
ssize_t qdev_write(struct file *fd, const char __user *buf, size_t len, loff_t *ptr);
int qdev_fsync(struct file *fd, int datasync);
unsigned int qdev_poll(struct file *fd, poll_table *wait);


