//******************************************************************************
// Copyright (C) 2012 Cambridge Silicon Radio Ltd.
// Header: //depot/inferno/kernel/drivers/quatro/icu.h
// Change: Date:
//
// @file
/// Interrupt controller targeted include.
/// This file includes the appropriate definitions for interrupt controllers
/// on the target CPU as defined in TARGET
//
// @ingroup BIOS Framework
// 
//*****************************************************************************/
// =========================================================
//
//           Q QQ QQ Q
//       QQ QQ QQ QQ QQ Q
//    QQ QQ QQ QQ QQ QQ QQ QQ     BBBBBBBB      iiii
//  Q QQ QQ             QQ QQ Q   BBBBBBBBBB    iii   ttt
// QQ QQ       QQ QQ       QQ QQ  BBB    BBB          ttt
// QQ QQ       QQ QQ       QQ QQ  BBB    BBB          tttttt
// QQ QQ       QQ QQ       QQ QQ  BBBBBBBBBB    iii   ttttt
// QQ QQ       QQ QQ       QQ QQ  BBBBBBBBBBB   iii   ttt
// QQ QQ       QQ QQ       QQ QQ  BBB     BBBB  iii   ttt
//  Q QQ       QQ QQ       QQ Q   BBB     BBBB  iii   ttt
//    QQ QQ             QQ QQ     BBBBBBBBBBBB  iii   tttttt
//     Q QQ QQ QQ QQ       Q      BBBBBBBBBB    iii    tttt
//          QQ QQ QQ QQ
//           Q QQ QQ Q            
// 
// Copyright (C) 2017-2018 QBit Semiconductor LTD.
// =========================================================
//
/// @file
/// Interrupt controller targeted include.
/// This file includes the appropriate definitions for interrupt controllers
/// on the target CPU as defined in TARGET
//
//  $DateTime: 2021/10/28 10:29:17 $
//  $Change: 54504 $
//
// =========================================================
#ifndef ICU_H
#define ICU_H 1

#if defined(Q6300)
    #include "./6300/icu6300.h"  
#elif defined(Q6600)
    #include "./6600/icu6600.h"
#elif defined(Windows)
#elif defined(Linux)
#else
#error "Unable to determine which ICU file to use"
#endif

#if defined IRQ_RTC && !defined IRQ_RTCR
    #define IRQ_RTCR IRQ_RTC
#endif

#endif
