//*****************************************************************************
// Copyright (c) 2015 Cambridge Silicon Radio Ltd.
// Header: 
// Change: 
//
//*****************************************************************************
// =========================================================
//
//           Q QQ QQ Q
//       QQ QQ QQ QQ QQ Q
//    QQ QQ QQ QQ QQ QQ QQ QQ     BBBBBBBB      iiii
//  Q QQ QQ             QQ QQ Q   BBBBBBBBBB    iii   ttt
// QQ QQ       QQ QQ       QQ QQ  BBB    BBB          ttt
// QQ QQ       QQ QQ       QQ QQ  BBB    BBB          tttttt
// QQ QQ       QQ QQ       QQ QQ  BBBBBBBBBB    iii   ttttt
// QQ QQ       QQ QQ       QQ QQ  BBBBBBBBBBB   iii   ttt
// QQ QQ       QQ QQ       QQ QQ  BBB     BBBB  iii   ttt
//  Q QQ       QQ QQ       QQ Q   BBB     BBBB  iii   ttt
//    QQ QQ             QQ QQ     BBBBBBBBBBBB  iii   tttttt
//     Q QQ QQ QQ QQ       Q      BBBBBBBBBB    iii    tttt
//          QQ QQ QQ QQ
//           Q QQ QQ Q            
// 
// Copyright (C) 2017-2018 QBit Semiconductor LTD.
// =========================================================
//
///  @file
/// Interrupt Controller definitions for 6300.
/// <b>Do not include directly, include icu.h</b>
//
//  $DateTime: 2021/10/28 10:29:17 $
//  $Change: 54504 $
//
// =========================================================
#ifndef __ICU6300_H__//TODO
#define __ICU6300_H__ multiple-inclusion guard

#define IRQ_USSD3    32
#define IRQ_UHSH    33
#define IRQ_RTC    34
#define IRQ_RTL    35
#define IRQ_TIM0    36
#define IRQ_TIM1    37
#define IRQ_TIM2    38
#define IRQ_TIM3    39
#define IRQ_TIM4    40
#define IRQ_TIM5    41
#define IRQ_TIM6    42
#define IRQ_DMA0    43
#define IRQ_SPIO0    44
#define IRQ_SPIO1    45
#define IRQ_SPIO2    46
#define IRQ_SPIO3    47
#define IRQ_SPION    48
#define IRQ_LLDMA0    49
#define IRQ_UART2    50
#define IRQ_I2C0    51
#define IRQ_IRQS20    52
#define IRQ_QSPI0    53
#define IRQ_LLDMA1    54
#define IRQ_XSPI0E    55
#define IRQ_XSPI0D    56
#define IRQ_GMAC    57
#define IRQ_IRQS26    58
#define IRQ_IRQS27    59
#define IRQ_IRQS28    60
#define IRQ_CIP0    61
#define IRQ_CIP1    62
#define IRQ_CIP2    63
#define IRQ_UART1    64
#define IRQ_SYSWD    65
#define IRQ_SDIO0    66
#define IRQ_I2C3    67
#define IRQ_SDIO1    68
#define IRQ_I2C4    69
#define IRQ_SDIO2    70
#define IRQ_I2C5    71
#define IRQ_A7_GFP    72
#define IRQ_PCI_GFP    73
#define IRQ_XSPI1E    74
#define IRQ_XSPI1D    75
#define IRQ_DMA1    76
#define IRQ_UART0    77
#define IRQ_JPEG0    78
#define IRQ_JPEG1    79
#define IRQ_TCC0    80
#define IRQ_I2C1    81
#define IRQ_JBIG0    82
#define IRQ_JBIG1    83
#define IRQ_I2C2    84
#define IRQ_LLDMA2    85
#define IRQ_LLDMA3    86
#define IRQ_LCD    87
#define IRQ_GVIF    88
#define IRQ_DDRIO0    89
#define IRQ_DDRIO1    90
#define IRQ_DDRIO2    91
#define IRQ_DDRIO3    92
#define IRQ_DDRION    93
#define IRQ_PCIE1    94
#define IRQ_PCIE_BUS    95
#define IRQ_DSP0MB    96
#define IRQ_DSP0HALT    97
#define IRQ_DSP1MB    98
#define IRQ_DSP1HALT    99
#define IRQ_DSP2MB    100
#define IRQ_DSP2HALT    101
#define IRQ_DSP3MB    102
#define IRQ_DSP3HALT    103
#define IRQ_DSP_A2B    104
#define IRQ_IRQS73    105
#define IRQ_IRQS74    106
#define IRQ_TGEN3    107
#define IRQ_IRQS76    108
#define IRQ_IRQS77    109
#define IRQ_CDIF    110
#define IRQ_SBE0    111
#define IRQ_SBE1    112
#define IRQ_FIR0    113
#define IRQ_FIR1    114
#define IRQ_SCAL0    115
#ifdef Q6300A0
#define IRQ_TGEN_M30_WD    116
#endif
#define IRQ_SCRN0    117
#define IRQ_SCRN1    118
#define IRQ_ADC_DONE    119
#define IRQ_ADC_CRITA    120
#define IRQ_ADC_CRITB    121
#define IRQ_M3_0_0    122
#define IRQ_M3_0_1    123
#define IRQ_M3_0_2    124
#define IRQ_M3_1_0    125
#define IRQ_M3_1_1    126
#define IRQ_M3_1_2    127
#define IRQ_TGEN2_0    128
#define IRQ_TGEN2_1    129
#define IRQ_TGEN2_2    130
#define IRQ_TGEN2_3    131
#define IRQ_TGEN2_4    132
#define IRQ_TGEN2_5    133
#define IRQ_TGEN2_6    134
#define IRQ_TGEN2_7    135
#define IRQ_TGEN2_8    136
#define IRQ_TGEN2_9    137
#define IRQ_TGEN2_10    138
#define IRQ_TGEN2_11    139
#define IRQ_TGEN2_12    140
#define IRQ_TGEN2_13    141
#ifdef Q6300A0
#define IRQ_TGEN2_14    142
#define IRQ_TGEN2_15    143
#define IRQ_TGEN2_16    144
#endif
#ifdef Q6300B0
#define IRQ_TGEN_M30_WD    142
#define IRQ_TGEN_M31_WD    143
#define IRQ_TGEN2_WD    144
#endif
#define IRQ_TGEN2_17    145
#ifdef Q6300A0
#define IRQ_TGEN2_WD    146
#define IRQ_TGEN_M31_WD    147
#endif
#define IRQ_UART3    148
#define IRQ_UART4    149
#define IRQ_SC0BD    150
#define IRQ_SC0LD    151
#define IRQ_SC0DD    152
#define IRQ_SC0CD    153
#define IRQ_SCA0ERR    154
#define IRQ_SC1BD    155
#define IRQ_SC1LD    156
#define IRQ_SC1DD    157
#define IRQ_SC1CD    158
#define IRQ_SCA1ERR    159
#define IRQ_LSR0DD    160
#define IRQ_LSR0DE    161
#define IRQ_LSR0CD    162
#define IRQ_LSR1DD    163
#define IRQ_LSR1DE    164
#define IRQ_LSR1CD    165
#define IRQ_LSR2DD    166
#define IRQ_LSR2DE    167
#define IRQ_LSR2CD    168
#define IRQ_LSR3DD    169
#define IRQ_LSR3DE    170
#define IRQ_LSR3CD    171
#define IRQ_LSR4DD    172
#define IRQ_LSR4DE    173
#define IRQ_LSR4CD    174
#define IRQ_LSR5DD    175
#define IRQ_LSR5DE    176
#define IRQ_LSR5CD    177
#define IRQ_LSR6DD    178
#define IRQ_LSR6DE    179
#define IRQ_LSR6CD    180
#define IRQ_LSR7DD    181
#define IRQ_LSR7DE    182
#define IRQ_LSR7CD    183
#define IRQ_UART5    184
#define IRQ_UART6    185
#define IRQ_UART7    186
#define IRQ_CCIEVOVF0    187
#define IRQ_CCIEVOVF1    188
#define IRQ_CCIEVOVF2    189
#define IRQ_CCIEVOVF3    190
#define IRQ_CCIEVOVF4    191
#define IRQ_CCI    192
#define IRQ_SYS_BERR    193
#define IRQ_IPM1_BERR    194
#define IRQ_IPM2_BERR    195
#define IRQ_SCA_BERR    196
#define IRQ_PRT_BERR    197
#define IRQ_CIP_BERR    198
#define IRQ_DDR_SRPD    199
#define IRQ_OTP    200
#define IRQ_IRQS169    201
#define IRQ_PRTPIO0    202
#define IRQ_PRTPIO1    203
#define IRQ_PRTPIO2    204
#define IRQ_PRTPIO3    205
#define IRQ_PRTPION    206
#define IRQ_SCAPIO0    207
#define IRQ_SCAPIO1    208
#define IRQ_SCAPIO2    209
#define IRQ_SCAPIO3    210
#define IRQ_SCAPION    211
#define IRQ_IRQS180    212
#define IRQ_IRQS181    213
#define IRQ_IRQS182    214
#define IRQ_IRQS183    215
#define IRQ_IRQS184    216
#define IRQ_IRQS185    217
#define IRQ_IRQS186    218
#define IRQ_IRQS187    219
#define IRQ_IRQS188    220
#define IRQ_IRQS189    221
#define IRQ_IRQS190    222
#define IRQ_IRQS191    223

#include "qbsoc_regs6300.h"

#if defined(GICD_SPISR0__USSD3__SHIFT) && GICD_SPISR0__USSD3__SHIFT != 0
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for USSD3"

#elif defined(GICD_SPISR0__UHSH__SHIFT) && GICD_SPISR0__UHSH__SHIFT != 1
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UHSH"

#elif defined(GICD_SPISR0__RTC__SHIFT) && GICD_SPISR0__RTC__SHIFT != 2
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for RTC"

#elif defined(GICD_SPISR0__RTL__SHIFT) && GICD_SPISR0__RTL__SHIFT != 3
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for RTL"

#elif defined(GICD_SPISR0__TIM0__SHIFT) && GICD_SPISR0__TIM0__SHIFT != 4
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TIM0"

#elif defined(GICD_SPISR0__TIM1__SHIFT) && GICD_SPISR0__TIM1__SHIFT != 5
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TIM1"

#elif defined(GICD_SPISR0__TIM2__SHIFT) && GICD_SPISR0__TIM2__SHIFT != 6
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TIM2"

#elif defined(GICD_SPISR0__TIM3__SHIFT) && GICD_SPISR0__TIM3__SHIFT != 7
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TIM3"

#elif defined(GICD_SPISR0__TIM4__SHIFT) && GICD_SPISR0__TIM4__SHIFT != 8
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TIM4"

#elif defined(GICD_SPISR0__TIM5__SHIFT) && GICD_SPISR0__TIM5__SHIFT != 9
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TIM5"

#elif defined(GICD_SPISR0__TIM6__SHIFT) && GICD_SPISR0__TIM6__SHIFT != 10
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TIM6"

#elif defined(GICD_SPISR0__DMA0__SHIFT) && GICD_SPISR0__DMA0__SHIFT != 11
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DMA0"

#elif defined(GICD_SPISR0__SPIO0__SHIFT) && GICD_SPISR0__SPIO0__SHIFT != 12
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SPIO0"

#elif defined(GICD_SPISR0__SPIO1__SHIFT) && GICD_SPISR0__SPIO1__SHIFT != 13
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SPIO1"

#elif defined(GICD_SPISR0__SPIO2__SHIFT) && GICD_SPISR0__SPIO2__SHIFT != 14
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SPIO2"

#elif defined(GICD_SPISR0__SPIO3__SHIFT) && GICD_SPISR0__SPIO3__SHIFT != 15
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SPIO3"

#elif defined(GICD_SPISR0__SPION__SHIFT) && GICD_SPISR0__SPION__SHIFT != 16
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SPION"

#elif defined(GICD_SPISR0__LLDMA0__SHIFT) && GICD_SPISR0__LLDMA0__SHIFT != 17
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LLDMA0"

#elif defined(GICD_SPISR0__UART2__SHIFT) && GICD_SPISR0__UART2__SHIFT != 18
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART2"

#elif defined(GICD_SPISR0__I2C0__SHIFT) && GICD_SPISR0__I2C0__SHIFT != 19
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for I2C0"

#elif defined(GICD_SPISR0__IRQS20__SHIFT) && GICD_SPISR0__IRQS20__SHIFT != 20
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS20"

#elif defined(GICD_SPISR0__QSPI0__SHIFT) && GICD_SPISR0__QSPI0__SHIFT != 21
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for QSPI0"

#elif defined(GICD_SPISR0__LLDMA1__SHIFT) && GICD_SPISR0__LLDMA1__SHIFT != 22
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LLDMA1"

#elif defined(GICD_SPISR0__XSPI0E__SHIFT) && GICD_SPISR0__XSPI0E__SHIFT != 23
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for XSPI0E"

#elif defined(GICD_SPISR0__XSPI0D__SHIFT) && GICD_SPISR0__XSPI0D__SHIFT != 24
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for XSPI0D"

#elif defined(GICD_SPISR0__GMAC__SHIFT) && GICD_SPISR0__GMAC__SHIFT != 25
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for GMAC"

#elif defined(GICD_SPISR0__IRQS26__SHIFT) && GICD_SPISR0__IRQS26__SHIFT != 26
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS26"

#elif defined(GICD_SPISR0__IRQS27__SHIFT) && GICD_SPISR0__IRQS27__SHIFT != 27
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS27"

#elif defined(GICD_SPISR0__IRQS28__SHIFT) && GICD_SPISR0__IRQS28__SHIFT != 28
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS28"

#elif defined(GICD_SPISR0__CIP0__SHIFT) && GICD_SPISR0__CIP0__SHIFT != 29
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CIP0"

#elif defined(GICD_SPISR0__CIP1__SHIFT) && GICD_SPISR0__CIP1__SHIFT != 30
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CIP1"

#elif defined(GICD_SPISR0__CIP2__SHIFT) && GICD_SPISR0__CIP2__SHIFT != 31
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CIP2"

#elif defined(GICD_SPISR1__UART1__SHIFT) && GICD_SPISR1__UART1__SHIFT != 0
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART1"

#elif defined(GICD_SPISR1__SYSWD__SHIFT) && GICD_SPISR1__SYSWD__SHIFT != 1
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SYSWD"

#elif defined(GICD_SPISR1__SDIO0__SHIFT) && GICD_SPISR1__SDIO0__SHIFT != 2
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SDIO0"

#elif defined(GICD_SPISR1__I2C3__SHIFT) && GICD_SPISR1__I2C3__SHIFT != 3
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for I2C3"

#elif defined(GICD_SPISR1__SDIO1__SHIFT) && GICD_SPISR1__SDIO1__SHIFT != 4
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SDIO1"

#elif defined(GICD_SPISR1__I2C4__SHIFT) && GICD_SPISR1__I2C4__SHIFT != 5
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for I2C4"

#elif defined(GICD_SPISR1__SDIO2__SHIFT) && GICD_SPISR1__SDIO2__SHIFT != 6
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SDIO2"

#elif defined(GICD_SPISR1__I2C5__SHIFT) && GICD_SPISR1__I2C5__SHIFT != 7
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for I2C5"

#elif defined(GICD_SPISR1__A7_GFP__SHIFT) && GICD_SPISR1__A7_GFP__SHIFT != 8
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for A7_GFP"

#elif defined(GICD_SPISR1__PCI_GFP__SHIFT) && GICD_SPISR1__PCI_GFP__SHIFT != 9
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PCI_GFP"

#elif defined(GICD_SPISR1__XSPI1E__SHIFT) && GICD_SPISR1__XSPI1E__SHIFT != 10
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for XSPI1E"

#elif defined(GICD_SPISR1__XSPI1D__SHIFT) && GICD_SPISR1__XSPI1D__SHIFT != 11
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for XSPI1D"

#elif defined(GICD_SPISR1__DMA1__SHIFT) && GICD_SPISR1__DMA1__SHIFT != 12
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DMA1"

#elif defined(GICD_SPISR1__UART0__SHIFT) && GICD_SPISR1__UART0__SHIFT != 13
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART0"

#elif defined(GICD_SPISR1__JPEG0__SHIFT) && GICD_SPISR1__JPEG0__SHIFT != 14
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for JPEG0"

#elif defined(GICD_SPISR1__JPEG1__SHIFT) && GICD_SPISR1__JPEG1__SHIFT != 15
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for JPEG1"

#elif defined(GICD_SPISR1__TCC0__SHIFT) && GICD_SPISR1__TCC0__SHIFT != 16
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TCC0"

#elif defined(GICD_SPISR1__I2C1__SHIFT) && GICD_SPISR1__I2C1__SHIFT != 17
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for I2C1"

#elif defined(GICD_SPISR1__JBIG0__SHIFT) && GICD_SPISR1__JBIG0__SHIFT != 18
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for JBIG0"

#elif defined(GICD_SPISR1__JBIG1__SHIFT) && GICD_SPISR1__JBIG1__SHIFT != 19
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for JBIG1"

#elif defined(GICD_SPISR1__I2C2__SHIFT) && GICD_SPISR1__I2C2__SHIFT != 20
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for I2C2"

#elif defined(GICD_SPISR1__LLDMA2__SHIFT) && GICD_SPISR1__LLDMA2__SHIFT != 21
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LLDMA2"

#elif defined(GICD_SPISR1__LLDMA3__SHIFT) && GICD_SPISR1__LLDMA3__SHIFT != 22
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LLDMA3"

#elif defined(GICD_SPISR1__LCD__SHIFT) && GICD_SPISR1__LCD__SHIFT != 23
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LCD"

#elif defined(GICD_SPISR1__GVIF__SHIFT) && GICD_SPISR1__GVIF__SHIFT != 24
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for GVIF"

#elif defined(GICD_SPISR1__DDRIO0__SHIFT) && GICD_SPISR1__DDRIO0__SHIFT != 25
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DDRIO0"

#elif defined(GICD_SPISR1__DDRIO1__SHIFT) && GICD_SPISR1__DDRIO1__SHIFT != 26
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DDRIO1"

#elif defined(GICD_SPISR1__DDRIO2__SHIFT) && GICD_SPISR1__DDRIO2__SHIFT != 27
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DDRIO2"

#elif defined(GICD_SPISR1__DDRIO3__SHIFT) && GICD_SPISR1__DDRIO3__SHIFT != 28
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DDRIO3"

#elif defined(GICD_SPISR1__DDRION__SHIFT) && GICD_SPISR1__DDRION__SHIFT != 29
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DDRION"

#elif defined(GICD_SPISR1__PCIE1__SHIFT) && GICD_SPISR1__PCIE1__SHIFT != 30
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PCIE1"

#elif defined(GICD_SPISR1__PCIE_BUS__SHIFT) && GICD_SPISR1__PCIE_BUS__SHIFT != 31
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PCIE_BUS"

#elif defined(GICD_SPISR2__DSP0MB__SHIFT) && GICD_SPISR2__DSP0MB__SHIFT != 0
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP0MB"

#elif defined(GICD_SPISR2__DSP0HALT__SHIFT) && GICD_SPISR2__DSP0HALT__SHIFT != 1
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP0HALT"

#elif defined(GICD_SPISR2__DSP1MB__SHIFT) && GICD_SPISR2__DSP1MB__SHIFT != 2
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP1MB"

#elif defined(GICD_SPISR2__DSP1HALT__SHIFT) && GICD_SPISR2__DSP1HALT__SHIFT != 3
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP1HALT"

#elif defined(GICD_SPISR2__DSP2MB__SHIFT) && GICD_SPISR2__DSP2MB__SHIFT != 4
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP2MB"

#elif defined(GICD_SPISR2__DSP2HALT__SHIFT) && GICD_SPISR2__DSP2HALT__SHIFT != 5
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP2HALT"

#elif defined(GICD_SPISR2__DSP3MB__SHIFT) && GICD_SPISR2__DSP3MB__SHIFT != 6
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP3MB"

#elif defined(GICD_SPISR2__DSP3HALT__SHIFT) && GICD_SPISR2__DSP3HALT__SHIFT != 7
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP3HALT"

#elif defined(GICD_SPISR2__DSP_A2B__SHIFT) && GICD_SPISR2__DSP_A2B__SHIFT != 8
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DSP_A2B"

#elif defined(GICD_SPISR2__IRQS73__SHIFT) && GICD_SPISR2__IRQS73__SHIFT != 9
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS73"

#elif defined(GICD_SPISR2__IRQS74__SHIFT) && GICD_SPISR2__IRQS74__SHIFT != 10
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS74"

#elif defined(GICD_SPISR2__TGEN3__SHIFT) && GICD_SPISR2__TGEN3__SHIFT != 11
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN3"

#elif defined(GICD_SPISR2__IRQS76__SHIFT) && GICD_SPISR2__IRQS76__SHIFT != 12
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS76"

#elif defined(GICD_SPISR2__IRQS77__SHIFT) && GICD_SPISR2__IRQS77__SHIFT != 13
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS77"

#elif defined(GICD_SPISR2__CDIF__SHIFT) && GICD_SPISR2__CDIF__SHIFT != 14
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CDIF"

#elif defined(GICD_SPISR2__SBE0__SHIFT) && GICD_SPISR2__SBE0__SHIFT != 15
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SBE0"

#elif defined(GICD_SPISR2__SBE1__SHIFT) && GICD_SPISR2__SBE1__SHIFT != 16
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SBE1"

#elif defined(GICD_SPISR2__FIR0__SHIFT) && GICD_SPISR2__FIR0__SHIFT != 17
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for FIR0"

#elif defined(GICD_SPISR2__FIR1__SHIFT) && GICD_SPISR2__FIR1__SHIFT != 18
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for FIR1"

#elif defined(GICD_SPISR2__SCAL0__SHIFT) && GICD_SPISR2__SCAL0__SHIFT != 19
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCAL0"

#elif defined(GICD_SPISR2__SCRN0__SHIFT) && GICD_SPISR2__SCRN0__SHIFT != 21
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCRN0"

#elif defined(GICD_SPISR2__SCRN1__SHIFT) && GICD_SPISR2__SCRN1__SHIFT != 22
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCRN1"

#elif defined(GICD_SPISR2__ADC_DONE__SHIFT) && GICD_SPISR2__ADC_DONE__SHIFT != 23
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for ADC_DONE"

#elif defined(GICD_SPISR2__ADC_CRITA__SHIFT) && GICD_SPISR2__ADC_CRITA__SHIFT != 24
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for ADC_CRITA"

#elif defined(GICD_SPISR2__ADC_CRITB__SHIFT) && GICD_SPISR2__ADC_CRITB__SHIFT != 25
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for ADC_CRITB"

#elif defined(GICD_SPISR2__M3_0_0__SHIFT) && GICD_SPISR2__M3_0_0__SHIFT != 26
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for M3_0_0"

#elif defined(GICD_SPISR2__M3_0_1__SHIFT) && GICD_SPISR2__M3_0_1__SHIFT != 27
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for M3_0_1"

#elif defined(GICD_SPISR2__M3_0_2__SHIFT) && GICD_SPISR2__M3_0_2__SHIFT != 28
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for M3_0_2"

#elif defined(GICD_SPISR2__M3_1_0__SHIFT) && GICD_SPISR2__M3_1_0__SHIFT != 29
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for M3_1_0"

#elif defined(GICD_SPISR2__M3_1_1__SHIFT) && GICD_SPISR2__M3_1_1__SHIFT != 30
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for M3_1_1"

#elif defined(GICD_SPISR2__M3_1_2__SHIFT) && GICD_SPISR2__M3_1_2__SHIFT != 31
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for M3_1_2"

#elif defined(GICD_SPISR3__TGEN2_0__SHIFT) && GICD_SPISR3__TGEN2_0__SHIFT != 0
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_0"

#elif defined(GICD_SPISR3__TGEN2_1__SHIFT) && GICD_SPISR3__TGEN2_1__SHIFT != 1
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_1"

#elif defined(GICD_SPISR3__TGEN2_2__SHIFT) && GICD_SPISR3__TGEN2_2__SHIFT != 2
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_2"

#elif defined(GICD_SPISR3__TGEN2_3__SHIFT) && GICD_SPISR3__TGEN2_3__SHIFT != 3
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_3"

#elif defined(GICD_SPISR3__TGEN2_4__SHIFT) && GICD_SPISR3__TGEN2_4__SHIFT != 4
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_4"

#elif defined(GICD_SPISR3__TGEN2_5__SHIFT) && GICD_SPISR3__TGEN2_5__SHIFT != 5
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_5"

#elif defined(GICD_SPISR3__TGEN2_6__SHIFT) && GICD_SPISR3__TGEN2_6__SHIFT != 6
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_6"

#elif defined(GICD_SPISR3__TGEN2_7__SHIFT) && GICD_SPISR3__TGEN2_7__SHIFT != 7
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_7"

#elif defined(GICD_SPISR3__TGEN2_8__SHIFT) && GICD_SPISR3__TGEN2_8__SHIFT != 8
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_8"

#elif defined(GICD_SPISR3__TGEN2_9__SHIFT) && GICD_SPISR3__TGEN2_9__SHIFT != 9
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_9"

#elif defined(GICD_SPISR3__TGEN2_10__SHIFT) && GICD_SPISR3__TGEN2_10__SHIFT != 10
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_10"

#elif defined(GICD_SPISR3__TGEN2_11__SHIFT) && GICD_SPISR3__TGEN2_11__SHIFT != 11
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_11"

#elif defined(GICD_SPISR3__TGEN2_12__SHIFT) && GICD_SPISR3__TGEN2_12__SHIFT != 12
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_12"

#elif defined(GICD_SPISR3__TGEN2_13__SHIFT) && GICD_SPISR3__TGEN2_13__SHIFT != 13
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_13"

#elif defined(GICD_SPISR3__TGEN_M30_WD__SHIFT) && GICD_SPISR3__TGEN_M30_WD__SHIFT != 14
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN_M30_WD"

#elif defined(GICD_SPISR3__TGEN_M31_WD__SHIFT) && GICD_SPISR3__TGEN_M31_WD__SHIFT != 15
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN_M31_WD"

#elif defined(GICD_SPISR3__TGEN2_WD__SHIFT) && GICD_SPISR3__TGEN2_WD__SHIFT != 16
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_WD"

#elif defined(GICD_SPISR3__TGEN2_17__SHIFT) && GICD_SPISR3__TGEN2_17__SHIFT != 17
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for TGEN2_17"

#elif defined(GICD_SPISR3__UART3__SHIFT) && GICD_SPISR3__UART3__SHIFT != 20
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART3"

#elif defined(GICD_SPISR3__UART4__SHIFT) && GICD_SPISR3__UART4__SHIFT != 21
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART4"

#elif defined(GICD_SPISR3__SC0BD__SHIFT) && GICD_SPISR3__SC0BD__SHIFT != 22
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC0BD"

#elif defined(GICD_SPISR3__SC0LD__SHIFT) && GICD_SPISR3__SC0LD__SHIFT != 23
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC0LD"

#elif defined(GICD_SPISR3__SC0DD__SHIFT) && GICD_SPISR3__SC0DD__SHIFT != 24
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC0DD"

#elif defined(GICD_SPISR3__SC0CD__SHIFT) && GICD_SPISR3__SC0CD__SHIFT != 25
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC0CD"

#elif defined(GICD_SPISR3__SCA0ERR__SHIFT) && GICD_SPISR3__SCA0ERR__SHIFT != 26
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCA0ERR"

#elif defined(GICD_SPISR3__SC1BD__SHIFT) && GICD_SPISR3__SC1BD__SHIFT != 27
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC1BD"

#elif defined(GICD_SPISR3__SC1LD__SHIFT) && GICD_SPISR3__SC1LD__SHIFT != 28
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC1LD"

#elif defined(GICD_SPISR3__SC1DD__SHIFT) && GICD_SPISR3__SC1DD__SHIFT != 29
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC1DD"

#elif defined(GICD_SPISR3__SC1CD__SHIFT) && GICD_SPISR3__SC1CD__SHIFT != 30
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SC1CD"

#elif defined(GICD_SPISR3__SCA1ERR__SHIFT) && GICD_SPISR3__SCA1ERR__SHIFT != 31
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCA1ERR"

#elif defined(GICD_SPISR4__LSR0DD__SHIFT) && GICD_SPISR4__LSR0DD__SHIFT != 0
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR0DD"

#elif defined(GICD_SPISR4__LSR0DE__SHIFT) && GICD_SPISR4__LSR0DE__SHIFT != 1
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR0DE"

#elif defined(GICD_SPISR4__LSR0CD__SHIFT) && GICD_SPISR4__LSR0CD__SHIFT != 2
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR0CD"

#elif defined(GICD_SPISR4__LSR1DD__SHIFT) && GICD_SPISR4__LSR1DD__SHIFT != 3
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR1DD"

#elif defined(GICD_SPISR4__LSR1DE__SHIFT) && GICD_SPISR4__LSR1DE__SHIFT != 4
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR1DE"

#elif defined(GICD_SPISR4__LSR1CD__SHIFT) && GICD_SPISR4__LSR1CD__SHIFT != 5
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR1CD"

#elif defined(GICD_SPISR4__LSR2DD__SHIFT) && GICD_SPISR4__LSR2DD__SHIFT != 6
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR2DD"

#elif defined(GICD_SPISR4__LSR2DE__SHIFT) && GICD_SPISR4__LSR2DE__SHIFT != 7
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR2DE"

#elif defined(GICD_SPISR4__LSR2CD__SHIFT) && GICD_SPISR4__LSR2CD__SHIFT != 8
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR2CD"

#elif defined(GICD_SPISR4__LSR3DD__SHIFT) && GICD_SPISR4__LSR3DD__SHIFT != 9
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR3DD"

#elif defined(GICD_SPISR4__LSR3DE__SHIFT) && GICD_SPISR4__LSR3DE__SHIFT != 10
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR3DE"

#elif defined(GICD_SPISR4__LSR3CD__SHIFT) && GICD_SPISR4__LSR3CD__SHIFT != 11
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR3CD"

#elif defined(GICD_SPISR4__LSR4DD__SHIFT) && GICD_SPISR4__LSR4DD__SHIFT != 12
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR4DD"

#elif defined(GICD_SPISR4__LSR4DE__SHIFT) && GICD_SPISR4__LSR4DE__SHIFT != 13
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR4DE"

#elif defined(GICD_SPISR4__LSR4CD__SHIFT) && GICD_SPISR4__LSR4CD__SHIFT != 14
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR4CD"

#elif defined(GICD_SPISR4__LSR5DD__SHIFT) && GICD_SPISR4__LSR5DD__SHIFT != 15
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR5DD"

#elif defined(GICD_SPISR4__LSR5DE__SHIFT) && GICD_SPISR4__LSR5DE__SHIFT != 16
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR5DE"

#elif defined(GICD_SPISR4__LSR5CD__SHIFT) && GICD_SPISR4__LSR5CD__SHIFT != 17
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR5CD"

#elif defined(GICD_SPISR4__LSR6DD__SHIFT) && GICD_SPISR4__LSR6DD__SHIFT != 18
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR6DD"

#elif defined(GICD_SPISR4__LSR6DE__SHIFT) && GICD_SPISR4__LSR6DE__SHIFT != 19
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR6DE"

#elif defined(GICD_SPISR4__LSR6CD__SHIFT) && GICD_SPISR4__LSR6CD__SHIFT != 20
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR6CD"

#elif defined(GICD_SPISR4__LSR7DD__SHIFT) && GICD_SPISR4__LSR7DD__SHIFT != 21
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR7DD"

#elif defined(GICD_SPISR4__LSR7DE__SHIFT) && GICD_SPISR4__LSR7DE__SHIFT != 22
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR7DE"

#elif defined(GICD_SPISR4__LSR7CD__SHIFT) && GICD_SPISR4__LSR7CD__SHIFT != 23
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for LSR7CD"

#elif defined(GICD_SPISR4__UART5__SHIFT) && GICD_SPISR4__UART5__SHIFT != 24
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART5"

#elif defined(GICD_SPISR4__UART6__SHIFT) && GICD_SPISR4__UART6__SHIFT != 25
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART6"

#elif defined(GICD_SPISR4__UART7__SHIFT) && GICD_SPISR4__UART7__SHIFT != 26
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for UART7"

#elif defined(GICD_SPISR4__CCIEVOVF0__SHIFT) && GICD_SPISR4__CCIEVOVF0__SHIFT != 27
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CCIEVOVF0"

#elif defined(GICD_SPISR4__CCIEVOVF1__SHIFT) && GICD_SPISR4__CCIEVOVF1__SHIFT != 28
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CCIEVOVF1"

#elif defined(GICD_SPISR4__CCIEVOVF2__SHIFT) && GICD_SPISR4__CCIEVOVF2__SHIFT != 29
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CCIEVOVF2"

#elif defined(GICD_SPISR4__CCIEVOVF3__SHIFT) && GICD_SPISR4__CCIEVOVF3__SHIFT != 30
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CCIEVOVF3"

#elif defined(GICD_SPISR4__CCIEVOVF4__SHIFT) && GICD_SPISR4__CCIEVOVF4__SHIFT != 31
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CCIEVOVF4"

#elif defined(GICD_SPISR5__CCI__SHIFT) && GICD_SPISR5__CCI__SHIFT != 0
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CCI"

#elif defined(GICD_SPISR5__SYS_BERR__SHIFT) && GICD_SPISR5__SYS_BERR__SHIFT != 1
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SYS_BERR"

#elif defined(GICD_SPISR5__IPM1_BERR__SHIFT) && GICD_SPISR5__IPM1_BERR__SHIFT != 2
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IPM1_BERR"

#elif defined(GICD_SPISR5__IPM2_BERR__SHIFT) && GICD_SPISR5__IPM2_BERR__SHIFT != 3
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IPM2_BERR"

#elif defined(GICD_SPISR5__SCA_BERR__SHIFT) && GICD_SPISR5__SCA_BERR__SHIFT != 4
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCA_BERR"

#elif defined(GICD_SPISR5__PRT_BERR__SHIFT) && GICD_SPISR5__PRT_BERR__SHIFT != 5
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PRT_BERR"

#elif defined(GICD_SPISR5__CIP_BERR__SHIFT) && GICD_SPISR5__CIP_BERR__SHIFT != 6
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for CIP_BERR"

#elif defined(GICD_SPISR5__DDR_SRPD__SHIFT) && GICD_SPISR5__DDR_SRPD__SHIFT != 7
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for DDR_SRPD"

#elif defined(GICD_SPISR5__OTP__SHIFT) && GICD_SPISR5__OTP__SHIFT != 8
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for OTP"

#elif defined(GICD_SPISR5__IRQS169__SHIFT) && GICD_SPISR5__IRQS169__SHIFT != 9
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS169"

#elif defined(GICD_SPISR5__PRTPIO0__SHIFT) && GICD_SPISR5__PRTPIO0__SHIFT != 10
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PRTPIO0"

#elif defined(GICD_SPISR5__PRTPIO1__SHIFT) && GICD_SPISR5__PRTPIO1__SHIFT != 11
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PRTPIO1"

#elif defined(GICD_SPISR5__PRTPIO2__SHIFT) && GICD_SPISR5__PRTPIO2__SHIFT != 12
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PRTPIO2"

#elif defined(GICD_SPISR5__PRTPIO3__SHIFT) && GICD_SPISR5__PRTPIO3__SHIFT != 13
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PRTPIO3"

#elif defined(GICD_SPISR5__PRTPION__SHIFT) && GICD_SPISR5__PRTPION__SHIFT != 14
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for PRTPION"

#elif defined(GICD_SPISR5__SCAPIO0__SHIFT) && GICD_SPISR5__SCAPIO0__SHIFT != 15
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCAPIO0"

#elif defined(GICD_SPISR5__SCAPIO1__SHIFT) && GICD_SPISR5__SCAPIO1__SHIFT != 16
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCAPIO1"

#elif defined(GICD_SPISR5__SCAPIO2__SHIFT) && GICD_SPISR5__SCAPIO2__SHIFT != 17
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCAPIO2"

#elif defined(GICD_SPISR5__SCAPIO3__SHIFT) && GICD_SPISR5__SCAPIO3__SHIFT != 18
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCAPIO3"

#elif defined(GICD_SPISR5__SCAPION__SHIFT) && GICD_SPISR5__SCAPION__SHIFT != 19
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for SCAPION"

#elif defined(GICD_SPISR5__IRQS180__SHIFT) && GICD_SPISR5__IRQS180__SHIFT != 20
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS180"

#elif defined(GICD_SPISR5__IRQS181__SHIFT) && GICD_SPISR5__IRQS181__SHIFT != 21
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS181"

#elif defined(GICD_SPISR5__IRQS182__SHIFT) && GICD_SPISR5__IRQS182__SHIFT != 22
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS182"

#elif defined(GICD_SPISR5__IRQS183__SHIFT) && GICD_SPISR5__IRQS183__SHIFT != 23
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS183"

#elif defined(GICD_SPISR5__IRQS184__SHIFT) && GICD_SPISR5__IRQS184__SHIFT != 24
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS184"

#elif defined(GICD_SPISR5__IRQS185__SHIFT) && GICD_SPISR5__IRQS185__SHIFT != 25
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS185"

#elif defined(GICD_SPISR5__IRQS186__SHIFT) && GICD_SPISR5__IRQS186__SHIFT != 26
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS186"

#elif defined(GICD_SPISR5__IRQS187__SHIFT) && GICD_SPISR5__IRQS187__SHIFT != 27
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS187"

#elif defined(GICD_SPISR5__IRQS188__SHIFT) && GICD_SPISR5__IRQS188__SHIFT != 28
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS188"

#elif defined(GICD_SPISR5__IRQS189__SHIFT) && GICD_SPISR5__IRQS189__SHIFT != 29
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS189"

#elif defined(GICD_SPISR5__IRQS190__SHIFT) && GICD_SPISR5__IRQS190__SHIFT != 30
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS190"

#elif defined(GICD_SPISR5__IRQS191__SHIFT) && GICD_SPISR5__IRQS191__SHIFT != 31
#  error "icu6300.h doesn't match qbsoc_a7_regs.h for IRQS191"

#endif


typedef unsigned int InterruptVector;

#ifndef ICU_H     // if no Quasar ICU wrapper,
#error "Chip-specific ICU file should only be included via icu.h"
#endif

#endif
