/*
 *
 * Copyright (c) 2015, The Linux Foundation.
 * All rights reserved.
 *
 * Redistribution and use
 * in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer
 * below) provided that the following conditions are met :
 *   *Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *   *Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and
 *    the following disclaimer
 *    in the documentation and/or other materials provided
 *    with the distribution.
 *
 *  NO EXPRESS OR IMPLIED LICENSES TO ANY PARTYS PATENT
 *  RIGHTS ARE GRANTED BY THIS LICENSE.
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS
 *  AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *  AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 *  OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 *  OF SUCH DAMAGE
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include "qioctl.h"

int main(int argc, char** argv)
{
	int fd;
	unsigned long val, pa;
	int rc;
	int size;
	unsigned char* pb;

	/* open qmem device
	*/
	fd = open("/dev/qmem", O_RDWR);
	if(fd < 0)
		return fprintf(stderr, "Can't open /dev/qmem\n");

	do
	{
		/* ask how big a chunk I can get
		*/
		rc = ioctl(fd, QMEMGETMAXALLOCSIZE, (unsigned long)&val);
		if(rc) {
			fprintf(stderr, "ioctl getmaxallocsize failed: %d\n", rc);
			break;
		}
		printf("Got max alloc size=%ld (%08lx)\n", val, val);
		
		/* ask to alloc a chunk of memory
		*/
		size = 4321;
		val = size;
		rc = ioctl(fd, QMEMALLOC, (unsigned long)&val);
		if(rc) {
			fprintf(stderr, "ioctl alloc failed: %d\n", rc);
			break;
		}
		/* this is the physical, dma-able address as returned from alloc
		*/
		pa = val;
		
		printf("Allocated %d bytes, got physaddr=%08lx\n", size, pa);
		
		/* mmap the physaddr to get a user-space pointer
		*/
		pb = mmap(0, size, PROT_READ | PROT_WRITE, MAP_FILE | MAP_SHARED, fd, pa);
		if(! pb || pb == (void*)-1) {
			fprintf(stderr, "mmap of alloc failed\n");
			break;
		}
		printf("mapped alloc %08lx to pointer %p\n", pa, pb);
#if 1
		/* attempt to free the thing
		*/
		val = pa;
		rc = ioctl(fd, QMEMFREE, (unsigned long)&val);
		if(rc) {
			fprintf(stderr, "ioctl free failed: %d\n", rc);
		}
#endif
		/* unmap it and attempt to free it again
		*/
		munmap(pb, size);
		
		val = pa;
		rc = ioctl(fd, QMEMFREE, (unsigned long)&val);
		if(rc) {
			fprintf(stderr, "ioctl free failed again!: %d\n", rc);
			break;
		}
		printf("freed alloc %08lx\n", pa);
	}
	while(0);
	
	close(fd);
	return rc;
}



