/*
 * Quasar LCD controller kernel driver
 * 
 * Copyright (c) 2015, The Linux Foundation.
 * All rights reserved.
 *
 * Redistribution and use
 * in source and binary forms, with or without modification,
 * are permitted (subject to the limitations in the disclaimer
 * below) provided that the following conditions are met :
 *   *Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the
 *    following disclaimer.
 *   *Redistributions in binary form must reproduce the
 *    above copyright notice, this list of conditions and
 *    the following disclaimer
 *    in the documentation and/or other materials provided
 *    with the distribution.
 *
 *  NO EXPRESS OR IMPLIED LICENSES TO ANY PARTYS PATENT
 *  RIGHTS ARE GRANTED BY THIS LICENSE.
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS
 *  AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING,
 *  BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 *  AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 *  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 *  OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 *  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 *  OR PROFITS;
 *  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 *  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 *  OF SUCH DAMAGE
 *
 */
// =========================================================
//
//  $DateTime: 2022/03/14 10:30:50 $
//  $Change: 58883 $
//
// =========================================================
#include "core.h"
#include "pll.h"

void qfb_setup_vx1(struct device *dev, struct qfb_info *qfb_info)
{
	uint32_t val;

	qfb_setup_pll(dev, qfb_info);

	// LCD_LVDSVX1_CSR1
	// set LCD_LVDSVX1_CSR1#TX_SER_ORDER to MSB if specify data-mirror
	val = qfb_rreg32(qfb_info->base_gpf, LCD_LVDSVX1_CSR1_OFF);
	val &= LCD_LVDSVX1_CSR1__TX_SER_ORDER__INV_MASK;
	val |= (qfb_info->panel.data_mirror) ? 
		(0 << LCD_LVDSVX1_CSR1__TX_SER_ORDER__SHIFT) : (1 << LCD_LVDSVX1_CSR1__TX_SER_ORDER__SHIFT);

	// Vx1 to LVDS conversion
	val &= LCD_LVDSVX1_CSR1__VX1TOLVDS_CONVEN__INV_MASK;
	val |= (qfb_info->panel.vx1_adap_lvds << LCD_LVDSVX1_CSR1__VX1TOLVDS_CONVEN__SHIFT);
	qfb_wreg32(qfb_info->base_gpf, LCD_LVDSVX1_CSR1_OFF, val);

	// LCD_LVDSVX1_CSR2
	val = qfb_rreg32(qfb_info->base_gpf, LCD_LVDSVX1_CSR2_OFF);
	val &= LCD_LVDSVX1_CSR2__LVDSVX1_MLVDS2EN__INV_MASK;
	val &= LCD_LVDSVX1_CSR2__LVDSVX1_MLVDS4EN__INV_MASK; 
	// XXX: not sure we need to set this or not
	val = (val & LCD_LVDSVX1_CSR2__LVDSVX1_RESOVRD__INV_MASK) |
		  (0x5 << LCD_LVDSVX1_CSR2__LVDSVX1_RESOVRD__SHIFT);
	qfb_wreg32(qfb_info->base_gpf, LCD_LVDSVX1_CSR2_OFF, val);

	// Power on Vx1 Link
	val = qfb_rreg32(qfb_info->base_intf, LCDVX1TX_VBO_PDCTRL_OFF);
	val = (val & LCDVX1TX_VBO_PDCTRL__NPOWDVBO__INV_MASK) | (0x1 << LCDVX1TX_VBO_PDCTRL__NPOWDVBO__SHIFT);
	qfb_wreg32(qfb_info->base_intf, LCDVX1TX_VBO_PDCTRL_OFF, val);

	// Notify Link PLL locked
	val = qfb_rreg32(qfb_info->base_intf, LCDVX1TX_VBO_TXPLLLOCK_OFF);
	val = (val & LCDVX1TX_VBO_TXPLLLOCK__PLLLOCKED__INV_MASK) | (1 << LCDVX1TX_VBO_TXPLLLOCK__PLLLOCKED__SHIFT);
	qfb_wreg32(qfb_info->base_intf, LCDVX1TX_VBO_TXPLLLOCK_OFF, val);

	// Reset panel
	val = qfb_rreg32(qfb_info->base_prtpio, PRT_PIODIRA_OFF);
	val &= (~0x00001000);
	qfb_wreg32(qfb_info->base_prtpio, PRT_PIODIRA_OFF, val);

	val = qfb_rreg32(qfb_info->base_prtpio, PRT_PIOSETA_OFF);
	val |= 0x00001000;
	qfb_wreg32(qfb_info->base_prtpio, PRT_PIOSETA_OFF, val);
}
