// =========================================================
//
//           Q QQ QQ Q
//       QQ QQ QQ QQ QQ Q
//    QQ QQ QQ QQ QQ QQ QQ QQ     BBBBBBBB      iiii
//  Q QQ QQ             QQ QQ Q   BBBBBBBBBB    iii   ttt
// QQ QQ       QQ QQ       QQ QQ  BBB    BBB          ttt
// QQ QQ       QQ QQ       QQ QQ  BBB    BBB          tttttt
// QQ QQ       QQ QQ       QQ QQ  BBBBBBBBBB    iii   ttttt
// QQ QQ       QQ QQ       QQ QQ  BBBBBBBBBBB   iii   ttt
// QQ QQ       QQ QQ       QQ QQ  BBB     BBBB  iii   ttt
//  Q QQ       QQ QQ       QQ Q   BBB     BBBB  iii   ttt
//    QQ QQ             QQ QQ     BBBBBBBBBBBB  iii   tttttt
//     Q QQ QQ QQ QQ       Q      BBBBBBBBBB    iii    tttt
//          QQ QQ QQ QQ
//           Q QQ QQ Q            
// 
// Copyright (C) 2017-2018 QBit Semiconductor LTD.
// =========================================================
//
//  $DateTime: 2021/10/28 10:29:17 $
//  $Change: 54504 $
//
// =========================================================
#ifndef __DRIVERS_QFB_MEM_H
#define __DRIVERS_QFB_MEM_H

#include <linux/device.h>
#include <linux/dma-mapping.h>

void *qfb_bi_req_mem(struct device *dev, int biid, size_t sz);
void *qfb_ow_req_mem(struct device *dev, int biid, int owid, size_t sz);
void *qfb_pal_req_mem(struct device *dev, size_t sz);
void *qfb_fs_bi_req_mem(struct device *dev, int ndid, size_t sz);
void *qfb_fs_ow_req_mem(struct device *dev, int ndid, int owid, size_t sz);

size_t qfb_bi_get_sz(struct device *dev, int biid);
size_t qfb_ow_get_sz(struct device *dev, int biid, int owid);
size_t qfb_pal_get_sz(struct device *dev);
size_t qfb_fs_bi_get_sz(struct device *dev, int ndid);
size_t qfb_fs_ow_get_sz(struct device *dev, int ndid, int owid);

int qfb_bi_free_mem(struct device *dev, int biid);
int qfb_ow_free_mem(struct device *dev, int biid, int owid);
int qfb_pal_free_mem(struct device *dev);
int qfb_fs_bi_free_mem(struct device *dev, int ndid);
int qfb_fs_ow_free_mem(struct device *dev, int ndid, int owid);

int qfb_bi_flush_mem(struct device *dev, int biid);
int qfb_ow_flush_mem(struct device *dev, int biid, int owid);
int qfb_pal_flush_mem(struct device *dev);
int qfb_fs_bi_flush_mem(struct device *dev, int ndid);
int qfb_fs_ow_flush_mem(struct device *dev, int ndid, int owid);

dma_addr_t qfb_bi_get_dma(struct device *dev, int biid);
dma_addr_t qfb_ow_get_dma(struct device *dev, int biid, int owid);
dma_addr_t qfb_pal_get_dma(struct device *dev);
dma_addr_t qfb_fs_bi_get_dma(struct device *dev, int ndid);
dma_addr_t qfb_fs_ow_get_dma(struct device *dev, int ndid, int owid);

void qfb_release_all_mem(struct device *dev);

#endif
