	//>Driver Setup
	IOREMAP(LCD_Vx1TX_BASE,0x350);
	//	[DRVAMP] (Amplitude)
	iValue=0x000000000;
	//		SRS_SIG0 = Vx1, 300 mV (0x5)
	iValue|=0x00000005;
	WRREG_UINT32(LCDVX1TX_DRVAMP,iValue);
	//	[EMVL] (Emphasis Strength)
	iValue=0x000000000;
	//		EMLVL0 = 0% (0x0) [IGNORE]
	iValue|=0x00000000;
	WRREG_UINT32(LCDVX1TX_EMLVL,iValue);
	//	[DRVCNT]
	iValue=0x00000000;
	//		DRVDAT = 0 (0x0)
	iValue|=0x00000000;
	//		DRVMEM = Off (0x0)
	iValue|=0x00000000;
	//		NLVLS = 0.56V/1.26V (0x3F), Level Shift Bias Control for DRV
	iValue|=0x03F00000;
	//		TMCOROFF = Off (0x0) [TBD], Termination Resistance Correction
	iValue|=0x00000000;
	//		EME = Off (0x0), Emphasis Enable
	iValue|=0x00000000;
	//		NVCOMO0125 = 0 (0x0), Mode Selection
	iValue|=0x00000000;
	//		NPORTEN = Connected (0x0), Built-in Terminating Resistor
	iValue|=0x00000000;
	//		LVDSEN = Off (0x0), LVDS Mode Enable
	iValue|=0x00000000;
	//		EMT = 338ps (0x0) [IGNORE], Emphasis Period
	//		PNDIFF_ADJ = -5.5ps (0x0) [IGNORE/TBD], IntraPair Skew Control
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	//	[TRMCNT] [IGNORE/TBD]
	//		VCNSEL = eFuse (0x0)
	//		TERMSEL = eFuse (0x0)
	//		TERM = [IGNORE]
	//		VCNT = [IGNORE]
	IOUNMAP();
	
	//>Driver Test > Turn On (DRVMEN)
	IOREMAP(LCDVX1TX_DRVCNT,0x4);
	//	DRVCNT.DRVDAT = 0 (0x0)
	iValue=RDREG_UINT32(LCDVX1TX_DRVCNT);
	iValue&=(~0x20000000);
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	//	DRVMEM = On (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_DRVCNT);
	iValue|=0x10000000;
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	IOUNMAP();
	
	//>PLL Setup
	IOREMAP(LCD_Vx1TX_BASE,0x350);
	//	FOUT = ( 25M X ( M + K' ) X FIDIV X PDIV ) / ( 2 X QDIV X MDIV )
	//	PLLANACNT
	iValue=0x00000000;
	//		DIVL = 0 (0x0) [FIXED]
	iValue|=0x00000000;
	//		CP2EN2 = Off (0x0)
	iValue|=0x00000000;
	//		CP2EN = Off (0x0)
	iValue|=0x00000000;
	//		VCOLMT = 4 (0x4)
	iValue|=0x00400000;
	//		REG4 = 1.14R/0.876f (0x4)
	iValue|=0x00040000;
	//		REG3 = 1.14R/0.875f (0x4)
	iValue|=0x00004000;
	//		REG2 = 6/20 Iref  (0x6)
	iValue|=0x00000060;
	//		REG1 = 6114.0 GHz/V (0x8)
	iValue|=0x00000008;
	WRREG_UINT32(LCDVX1TX_PLLANACNT,iValue);
	//	PLLDIGCNT
	iValue=0x00000000;
	//		PLLBYPS = Off (0x0)
	iValue|=0x00000000;
	//		DIVOUTON = Off (0x0)
	iValue|=0x00000000;
	//		VCOSEL = Internal (0x0)
	iValue|=0x00000000;
	//		TESTCNT = Hi-Z (0x0)
	iValue|=0x00000000;
	//		VCOOUT25EN = Off (0x0)
	iValue|=0x00000000;
	//		OFFSETON = Off (0x0)
	iValue|=0x00000000;
	//		QDIV = 1 (0x0)
	iValue|=0x00000100;
	//iValue|=0x00000000;
	//		PDIV = 2 (0x2)
	iValue|=0x00000020;
	//		FIDIV = 1 (0x0)
	iValue|=0x00000000;
	WRREG_UINT32(LCDVX1TX_PLLDIGCNT,iValue);
	//	SSCNT1
	iValue=0x00000000;
	//		MIN = 48 (0x30)
	iValue|=0x00000030;
	//		KIN = 0 (0x0)
	iValue|=0x00000000;
	WRREG_UINT32(LCDVX1TX_SSCCNT1,iValue);
	//	SSCNT2
	iValue=0x00000000;
	//		NRST = Reset (0x0)
	iValue|=0x00000000;
	//		NRSTDS = Integer (0x0)
	iValue|=0x00000000;
	//		SSCEN = Disable (0x0)
	iValue|=0x00000000;
	//		DSIGMODE = 2nd Order (0x0)
	iValue|=0x00000000;
	//		UPCNTIN = 208 (0xD0)
	iValue|=0x00D00000;
	//		DKIN = 242 (0xF2)
	iValue|=0x000000F2;
	WRREG_UINT32(LCDVX1TX_SSCCNT2,iValue);
	IOUNMAP();
	
	//>VCO Low Frequency Oscillation Control > Turn On (OFFSETON)
	IOREMAP(LCDVX1TX_PLLDIGCNT,0x4);
	//	LCDVX1TX_PLLDIGCNT.
	iValue=RDREG_UINT32(LCDVX1TX_PLLDIGCNT);
	iValue|=0x00001000;
	WRREG_UINT32(LCDVX1TX_PLLDIGCNT,iValue);
	IOUNMAP();
	
	//>PHY Power > Up (NPDWN)
	IOREMAP(LCDVX1TX_ENTCNT1,0x4);
	//	ENTCNT1.NPDWN = Power On (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_ENTCNT1);
	iValue|=0x00000010;
	WRREG_UINT32(LCDVX1TX_ENTCNT1,iValue);
	IOUNMAP();
	
	//>PHY Reset > Cancel (NRESET)
	IOREMAP(LCDVX1TX_ENTCNT1,0x4);
	//	ENTCNT1.NRESET = Set (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_ENTCNT1);
	iValue|=0x00000020;
	WRREG_UINT32(LCDVX1TX_ENTCNT1,iValue);
	IOUNMAP();
	
	//>SSC Reset > Cancel (NRST)
	IOREMAP(LCDVX1TX_SSCCNT2,0x4);
	//	SSCCNT2.NRST = Set (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_SSCCNT2);
	iValue|=0x80000000;
	WRREG_UINT32(LCDVX1TX_SSCCNT2,iValue);
	IOUNMAP();
	
	//>Driver Power > Up (ENT)
	IOREMAP(LCDVX1TX_ENTCNT2,0x4);
	//	ENTCNT2.ENT = On (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_ENTCNT2);
	iValue|=0x00000001;
	WRREG_UINT32(LCDVX1TX_ENTCNT2,iValue);
	IOUNMAP();
	
	//>Wait 10us
	IOREMAP(LCDGPF_BASE,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 10us (0xFA)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x000000FA;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	
	//>Driver Test > Turn Off (DRVMEN)
	IOREMAP(LCDVX1TX_DRVCNT,0x4);
	//	LCDVX1TX_DRVCNT.DRVMEM = Off (0x0)
	iValue=RDREG_UINT32(LCDVX1TX_DRVCNT);
	iValue&=(~0x10000000);
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	IOUNMAP();
	
	//>Wait 40us
	IOREMAP(LCDGPF_BASE,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 40us (0x3E8)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x000003E8;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	
	//>PLL Fractional Mode > Enable
	//[TBD]
	
	//>Wait 950us
	IOREMAP(LCDGPF_BASE,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 950us (0x5CC6)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x00005CC6;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	
	//>VCO Low Frequency Oscillation Control > Turn Off (OFFSETON)
	IOREMAP(LCDVX1TX_PLLDIGCNT,0x4);
	//	PLLDIGCNT.OFFSETON = Off (0x0)
	iValue=RDREG_UINT32(LCDVX1TX_PLLDIGCNT);
	iValue&=(~0x00001000);
	WRREG_UINT32(LCDVX1TX_PLLDIGCNT,iValue);
	IOUNMAP();
	
	//Wait 4ms
	IOREMAP(LCDGPF_BASE,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 4ms (0x186A0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x000186A0;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	
	//GPF
	IOREMAP(LCDGPF_BASE,0x30);
	//	[LCD_LVDSVX1_CSR1]
	iValue=RDREG_UINT32(LCD_LVDSVX1_CSR1);
	//		TX_MODE = Vx1 (0x4)
	iValue&=(~0x00000007);
	iValue|=0x00000004;
	//		TX_SRGB_CLK_POL [IGNORE]
	//		TX_SRGB_G_ORDER [IGNORE]
	//		TX_SER_ORDER [IGNORE]
	iValue&=(~0x00000100);
	iValue|=0x00000000;
	//		VX1_BYTE_MODE = 3-Byte Mode (0x0)
	iValue&=(~0x0000C000);
	iValue|=0x00000000;
	//		LVDSPHY_PCLK [IGNORE]
	//		LVCT4 [IGNORE]
	//		VX1TOLVDS_CONVEN
	if (V_LCD_VX1_LVDS_CONV)
	{
		iValue|=0x20000000;
	}
	WRREG_UINT32(LCD_LVDSVX1_CSR1,iValue);
	//	[LCD_LVDSVX1_CSR2]
	iValue=RDREG_UINT32(LCD_LVDSVX1_CSR2);
	//	LVDSPHY_LCDDATA_EN [IGNORE]
	//	VX1_HTPDNOVRD = Overwrite Low (0x0)
	iValue&=(~0x00000030);
	iValue|=0x00000020;
	//	VX1_LOCKOVRD = Don't Overwrite (0x0)
	iValue&=(~0x000000C0);
	iValue|=0x00000000;
	//	LVDSPHY_BYPASSC = Not Bypassed (0x0) [DEFAULT]
	//	LVDSPHY_BYPASSD0 = Not Bypassed (0x0) [DEFAULT]
	//	LVDSPHY_BYPASSD1 = Not Bypassed (0x0) [DEFAULT]
	//	LVDSPHY_BYPASSD2 = Not Bypassed (0x0) [DEFAULT]
	//	LVDSPHY_BYPASSD3 = Not Bypassed (0x0) [DEFAULT]
	//	LVDSPHY_SERSELC = 7:1 (0x0) [DEFAULT]
	//	LVDSPHY_SERSELD0 = 7:1 (0x0) [DEFAULT]
	//	LVDSPHY_SERSELD1 = 7:1 (0x0) [DEFAULT]
	//	LVDSPHY_SERSELD2 = 7:1 (0x0) [DEFAULT]
	//	LVDSPHY_SERSELD3 = 7:1 (0x0) [DEFAULT]
	//	LVDSVX1_RESOVRD = LVDS PHY Reset, VX1 LINK Not Reset(0x5)
	iValue&=(~0x00700000);
	iValue|=0x00500000;
	//	LVDSPHY_LCDDATA_POPTHRESH = 4 (0x4) [DEFAULT]
	//	LVDSVX1_MLVDS2EN = 0 (0x0) [DEFAULT]
	iValue&=(~0x40000000);
	//	LVDSVX1_MLVDS4EN = 0 (0x0) [DEFAULT]
	iValue&=(~0x80000000);
	WRREG_UINT32(LCD_LVDSVX1_CSR2,iValue);
	//LCD_LVDSVX1_CSR4 [IGNORE]
	//LCD_PCLK_CST
	iValue=RDREG_UINT32(LCD_PCLK_CST);
	//	DIS = Enable (0x0) [DEFULAT]
	//	SEL = LVDS TX PLL (0x1)
	iValue&=(~0x00000003);
	iValue|=0x00000001;
	WRREG_UINT32(LCD_PCLK_CST,iValue);
	//LCD_PCLK_DIVCTRL = 3 (50/50) [DEFAULT]
	WRREG_UINT32(LCD_PCLK_DIVCTRL,0x02010203);
	//LCD_PCLK_DIVCTRL_TEST [DEFAULT]
	//LCDADBCTL [DEFAULT]
	IOUNMAP();
	
	//DB9K
	IOREMAP(LCD_CR1,0x1000);
	//[Stop Engine]
	//	LCD_CR1
	iValue=RDREG_UINT32(LCD_CR1);
	//		LCE = (0) Disable
	iValue&=(~0x00000001);
	WRREG_UINT32(LCD_CR1,iValue);
	//	LCD_PCTR
	iValue=RDREG_UINT32(LCD_PCTR);
	//		PCR = (0) Reset Held
	iValue&=(~0x00000400);
	WRREG_UINT32(LCD_PCTR,iValue);
	//	LCD_PWMFR
	iValue=RDREG_UINT32(LCD_PWMFR);
	iValue&=(~0x01400000);
	WRREG_UINT32(LCD_PWMFR,iValue);

	//[Setup]
	//	LCD_PCTR
	iValue=RDREG_UINT32(LCD_PCTR);
	//		Clean
	iValue&=(0x00000BFF);
	//		PCD = (0) <IGNORE>, PCB = (0) <IGNORE>, PCI = (1) PCLK_IN, PCR = <SKIP>, PCI2 = (0) PCLK_IN
	iValue|=(0x00000200);
	WRREG_UINT32(LCD_PCTR,iValue);
	//	LCD_CR1
	iValue=RDREG_UINT32(LCD_CR1);
	//		Clean
	iValue&=(~0x03EFFFFC);
	//		BPP = (XXX)
	iValue|=V_LCD_BPP;
	//		RBG = (X)
	iValue|=V_LCD_RGB;
	//		EPO = (0) Little, EBO = (0) Little
	iValue|=0X00000000;
	//		DEP = Active High (0x1), PCP = Rising Edge (0x0) ,HSP = Active Low (0x1), VSP = Active Low (0x1)
	iValue|=0X00000D00;
	//		OPS = (XX)
	iValue|=V_LCD_OPS;
	//		PSS = (0) <IITC>
	iValue|=V_LCD_PALETTE;
	//		FDW = (01) 8 Beat Burst
	iValue|=V_LCD_BURST;
	//		LPS = (0) 1 LCD Port Output
	iValue|=0x00000000;
	//		FBP = (X)
	if (V_LCD_BPP == V_LCD_CT_BPP_24)
	{
		iValue|=V_LCD_PACK;
	}
	//		DFR = (X), DFB = (0) Ignored, DFE = (0) Disable
	iValue|=(V_LCD_FD|0x00400000);
	//		HSS = (01) Coincident
	iValue|=0x01000000;
	//		SAU
	iValue|=V_LCD_SAU;
	WRREG_UINT32(LCD_CR1,iValue);
	//	LCD_HTR
	//		HFP = (8), PPL = (32), HBP = (16), HSW = (1)
	iValue=((V_LCD_SW_H<<24)|(V_LCD_PH_BACK<<16)|((V_LCD_WIDTH/16)<<8)|V_LCD_PH_FRONT);
	WRREG_UINT32(LCD_HTR,iValue);
	//	LCD_VTR1
	//		VSR = (1), VFP = (10), VBP = (5)
	iValue=0x00000001|(V_LCD_PV_FRONT<<8)|(V_LCD_PV_BACK<<16);
	WRREG_UINT32(LCD_VTR1,iValue);
	//	LCD_VTR2
	//		LPP = (20)
	iValue=V_LCD_HEIGHT;
	WRREG_UINT32(LCD_VTR2,iValue);
	//	LCD_IMR
	//		Disable All
	iValue=V_LCD_ISR;
	WRREG_UINT32(LCD_IMR,iValue);
	//	LCD_ISR
	//		Clean All
	iValue=0x0000FFFF;
	WRREG_UINT32(LCD_ISR,iValue);
	//	LCD_IVR
	//		Read All
	iValue=RDREG_UINT32(LCD_IVR);
	//	LCD_ISCR
	//		VSC = (000) Inactive
	iValue=0x00000000;
	WRREG_UINT32(LCD_ISCR,iValue);
	//	LCD_DBAR
	WRREG_UINT32(LCD_DBAR,pmMeta->iAddress);
	//	LCD_DEAR
	WRREG_UINT32(LCD_DEAR,pmMeta->iAddress+V_LCD_WIDTH*V_LCD_HEIGHT*V_LCD_BD);
	//	LCD_DCAR
	iValue=RDREG_UINT32(LCD_DCAR);
	//	LCD_PWMFR
	//		<IGNORE>
	//	LCD_PWMDCR
	//		<IGNORE>
	//	LCD_DFLAR
	//		<IGNORE>
	//	LCD_HPPLOR
	//		HPOE = (0) Dieable, HPPLO <IGNORE>
	iValue=0x00000000|0x00000000;
	WRREG_UINT32(LCD_HPPLOR,iValue);
	//	LCD_HVTER
	//		VSWE = (0), HSWE = (0), VBPE = (0), VFPE = (0), HBPE = (0), HFPE = (0)
	iValue=0x00000000|0x00000000|0x00000000|0x00000000|0x00000000|0x00000000;
	WRREG_UINT32(LCD_HVTER,iValue);
	//	LCD_GPIOR
	//		<IGNORE>
	//	LCD_CIR
	//		<IGNORE>
	//	LCD_PALT
	//		<IGNORE>

	//	LCD_OWERLCD_OWER
	//		OWE1 = (1), OWE0 = (1)
	iValue=V_LCD_OW;
	WRREG_UINT32(LCD_OWER,iValue);
	//	LCD_MRR
	//		MRR = (0), DEAR_MRR = (0)
	iValue=V_LCD_MRR;
	if(V_LCD_MRR){iValue|=(((unsigned long)pmMeta->iAddress+V_LCD_WIDTH*V_LCD_HEIGHT*V_LCD_BD));}
	WRREG_UINT32(LCD_MRR,iValue);
	IOUNMAP();

	//>Overlay 
	IOREMAP(PRT_OVLCTL1,0x4);
	//	PRT_OVLCTL1.ACH11 = PGPO12 (0x7)
	iValue=RDREG_UINT32(PRT_OVLCTL1);
	iValue&=(~0x0000F000);
	iValue|=0x00007000;
	WRREG_UINT32(PRT_OVLCTL1,iValue);
	IOUNMAP();
	
	//>GPIO
	IOREMAP(PRT_PIOXMSK,0x100);
	iValue=RDREG_UINT32(PRT_PIODIRA);
	iValue&=(~0x00001000);
	WRREG_UINT32(PRT_PIODIRA,iValue);
	iValue=RDREG_UINT32(PRT_PIOSETA);
	iValue|=0x00001000;
	WRREG_UINT32(PRT_PIOSETA,iValue);
	IOUNMAP();
	
	//>[Start Engine]
	IOREMAP(LCD_PCTR,0x4);
	//	LCD_PCTR
	iValue=RDREG_UINT32(LCD_PCTR);
	iValue|=0x00000400;
	WRREG_UINT32(LCD_PCTR,iValue);
	IOUNMAP();
	
	IOREMAP(LCDVX1TX_VBO_TXPLLLOCK,0x150);
	//[LCDVX1TX_VBO_SYNCPOL] (HV Sync Polarity)
	iValue=RDREG_UINT32(LCDVX1TX_VBO_SYNCPOL);
	//	VBOHPOL = Low Active (0x0) [DEFAULT]
	//	VBOVPOL = Low Active (0x0) [DEFAULT]
	//	VIOHPOL = Low Active (0x0) [DEFAULT]
	//	VIOVPOL = Low Active (0x0) [DEFAULT]
	WRREG_UINT32(LCDVX1TX_VBO_SYNCPOL,iValue);
	//[LCDVX1TX_VBO_SELCTRL1] (Output Lane Switch Mux)
	iValue=RDREG_UINT32(LCDVX1TX_VBO_SELCTRL1);
	//	LANE3SEL = 3 (0x3) [DEFAULT]
	//	LANE2SEL = 2 (0x1) [DEFAULT]
	//	LANE1SEL = 1 (0x1) [DEFAULT]
	//	LANE0SEL = 0 (0x0) [DEFAULT]
	WRREG_UINT32(LCDVX1TX_VBO_SELCTRL1,iValue);
	//[LCDVX1TX_VBO_SELCTRL9] (Inverter)
	iValue=RDREG_UINT32(LCDVX1TX_VBO_SELCTRL9);
	//	OUTINVEN3 = Not Inverted (0x0) [DEFAULT]
	//	OUTINVEN2 = Not Inverted (0x0) [DEFAULT]
	//	OUTINVEN1 = Not Inverted (0x0) [DEFAULT]
	//	OUTINVEN0 = Not Inverted (0x0) [DEFAULT]
	WRREG_UINT32(LCDVX1TX_VBO_SELCTRL9,iValue);
	//[LCDVX1TX_VBO_MODESET] (GPIO for Other Purpose)
	iValue=RDREG_UINT32(LCDVX1TX_VBO_MODESET);
	//	CLKSELREG = 0 (0x0) [DEFUALT]
	WRREG_UINT32(LCDVX1TX_VBO_MODESET,iValue);
	IOUNMAP();
	
	//Power On Vx1 Link
	IOREMAP(LCDVX1TX_VBO_PDCTRL,0x4);
	//	LCDVX1TX_VBO_PDCTRL.NPOWDVBO = On (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_VBO_PDCTRL);
	iValue|=0x00000001;
	WRREG_UINT32(LCDVX1TX_VBO_PDCTRL,iValue);
	IOUNMAP();
	
	//GPF
	IOREMAP(LCD_LVDSVX1_CSR2,0x4);
	//	LCD_LVDSVX1_CSR2.LVDSPHY_LCDDATA_EN (Final Control)
	iValue=RDREG_UINT32(LCD_LVDSVX1_CSR2);
	iValue|=0x00000001;
	WRREG_UINT32(LCD_LVDSVX1_CSR2,iValue);
	IOUNMAP();
	
	//	LCD_CR1
	IOREMAP(LCD_CR1,0x4);
	iValue=RDREG_UINT32(LCD_CR1);
	iValue|=0x00000001;
	WRREG_UINT32(LCD_CR1,iValue);
	IOUNMAP();

	//Notify Link PLL Locked
	IOREMAP(LCDVX1TX_VBO_TXPLLLOCK,0x4);
	//	LCDVX1TX_VBO_TXPLLLOCK.PLLLOCKED = Locked (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_VBO_TXPLLLOCK);
	iValue|=0x00000001;
	WRREG_UINT32(LCDVX1TX_VBO_TXPLLLOCK,iValue);
	IOUNMAP();
