
	//[PHY Setup]
	//>Setup Driver
	IOREMAP(0x05612000,0x350);
	//	DRVAMP (Amplitude)
	iValue=0x000000000;
	//		SRS_SIG0 = LVDS, 350 mV (0x6)
	iValue|=0x00000006;
	WRREG_UINT32(LCDVX1TX_DRVAMP,iValue);
	//	EMVL (Emphasis Strength)
	iValue=0x000000000;
	//		EMLVL0 = 0% (0x0) [IGNORE]
	iValue|=0x00000000;
	WRREG_UINT32(LCDVX1TX_EMLVL,iValue);
	//	DRVCNT
	iValue=0x00000000;
	//		DRVDAT = 0 (0x0)
	iValue|=0x00000000;
	//		DRVMEM = Off (0x0)
	iValue|=0x00000000;
	//		NLVLS = 0.56V/1.26V (0x3F), Level Shift Bias Control for DRV
	iValue|=0x03F00000;
	//		TMCOROFF = Off (0x0) [TBD], Termination Resistance Correction
	iValue|=0x00000000;
	//		EME = Off (0x0), Emphasis Enable
	iValue|=0x00000000;
	//		NVCOMO0125 = 0 (0x0), Mode Selection
	iValue|=0x00000000;
	//		NPORTEN = On (0x1), Built-in Terminating Resistor
	iValue|=0x00000800;
	//		LVDSEN = Off (0x0), LVDS Mode Enable
	iValue|=0x00000000;
	//		EMT = 338ps (0x0) [IGNORE], Emphasis Period
	//		PNDIFF_ADJ = -5.5ps (0x0) [IGNORE/TBD], IntraPair Skew Control
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	//	TRMCNT [IGNORE/TBD]
	IOUNMAP();
	//>Driver Test > Turn On (DRVMEN)
	IOREMAP(0x05612000,0x350);
	//	DRVCNT.DRVDAT = 0 (0x0)
	iValue=RDREG_UINT32(LCDVX1TX_DRVCNT);
	iValue&=(~0x20000000);
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	//	DRVMEM = On (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_DRVCNT);
	iValue|=0x10000000;
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	IOUNMAP();
	//>PLL Setup
	IOREMAP(0x05612000,0x350);
	//	FOUT = ( 25M X ( M + K' ) X FIDIV X PDIV ) / ( 2 X QDIV X MDIV )
	//	PLLANACNT
	iValue=0x00000000;
	//		DIVL = 0 (0x0) [FIXED]
	iValue|=0x00000000;
	//		CP2EN2 = Off (0x0)
	iValue|=0x00000000;
	//		CP2EN = On (0x1)
	iValue|=0x01000000;
	//		VCOLMT = 4 (0x4)
	iValue|=0x00400000;
	//		REG4 = 1.14R/0.876f (0x4)
	iValue|=0x00040000;
	//		REG3 = 1.14R/0.875f (0x4)
	iValue|=0x00004000;
	//		REG2 = 6/20 Iref  (0x6)
	iValue|=0x00000060;
	//		REG1 = 4858.3 GHz/V (0x6)
	iValue|=0x0000000A;
	WRREG_UINT32(LCDVX1TX_PLLANACNT,iValue);
	//	PLLDIGCNT
	iValue=0x00000000;
	//		PLLBYPS = Off (0x0)
	iValue|=0x00000000;
	//		DIVOUTON = Off (0x0)
	iValue|=0x00000000;
	//		VCOSEL = Internal (0x0)
	iValue|=0x00000000;
	//		TESTCNT = Hi-Z (0x0)
	iValue|=0x00000000;
	//		VCOOUT25EN = Off (0x0)
	//iValue|=0x00000000;
	iValue|=0x00010000;
	//		OFFSETON = Off (0x0)
	iValue|=0x00000000;
	//		QDIV = 4 (0x2)
	iValue|=0x00000100;
	//		PDIV = 4 (0x1)
	iValue|=0x00000010;
	//		FIDIV = 1 (0x0)
	iValue|=0x00000000;
	WRREG_UINT32(LCDVX1TX_PLLDIGCNT,iValue);
	//	SSCNT1
	iValue=0x00000000;
	//		MIN = 40 (0x28)
#ifdef Q6300RDK
	iValue|=0x00000017;
#else
	iValue|=0x0000001C;
#endif
	//		KIN = 0 (0x0)
	iValue|=0x00000000;
	WRREG_UINT32(LCDVX1TX_SSCCNT1,iValue);
	//	SSCNT2
	iValue=0x00000000;
	//		NRST = Reset (0x0)
	iValue|=0x00000000;
	//		NRSTDS = Integer (0x0)
	iValue|=0x00000000;
	//		SSCEN = Disable (0x0)
	iValue|=0x00000000;
	//		DSIGMODE = 2nd Order (0x0)
	iValue|=0x00000000;
	//		UPCNTIN = 208 (0xD0)
	iValue|=0x00D00000;
	//		DKIN = 202 (0xCA)
	iValue|=0x000000CA;
	WRREG_UINT32(LCDVX1TX_SSCCNT2,iValue);
	//VCO Low Frequency Oscillation Control > Turn On (OFFSETON)
	iValue=RDREG_UINT32(LCDVX1TX_PLLDIGCNT);
	iValue|=0x00001000;
	WRREG_UINT32(LCDVX1TX_PLLDIGCNT,iValue);
	IOUNMAP();
	//>PHY Power > Up (NPDWN)
	IOREMAP(LCDVX1TX_ENTCNT1,0x4);
	//	ENTCNT1.NPDWN = Power On (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_ENTCNT1);
	iValue|=0x00000010;
	WRREG_UINT32(LCDVX1TX_ENTCNT1,iValue);
	IOUNMAP();
	//>PHY Reset > Cancel (NRESET)
	IOREMAP(LCDVX1TX_ENTCNT1,0x4);
	//	ENTCNT1.NRESET = Set (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_ENTCNT1);
	iValue|=0x00000020;
	WRREG_UINT32(LCDVX1TX_ENTCNT1,iValue);
	IOUNMAP();
	//>SSC Reset > Cancel (NRST)
	IOREMAP(LCDVX1TX_SSCCNT2,0x4);
	//	SSCCNT2.NRST = Set (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_SSCCNT2);
	iValue|=0x80000000;
	WRREG_UINT32(LCDVX1TX_SSCCNT2,iValue);
	IOUNMAP();
	//>Driver Power > Up (ENT)
	IOREMAP(LCDVX1TX_ENTCNT2,0x4);
	//	ENTCNT2.ENT = On (0x1)
	iValue=RDREG_UINT32(LCDVX1TX_ENTCNT2);
	iValue|=0x00000001;
	WRREG_UINT32(LCDVX1TX_ENTCNT2,iValue);
	IOUNMAP();
	//>Wait 10us
	IOREMAP(0x05648000,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 10us (0xFA)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x000000FA;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	//>Driver Test > Turn Off (DRVMEN)
	IOREMAP(LCDVX1TX_DRVCNT,0x4);
	//	LCDVX1TX_DRVCNT.DRVMEM = Off (0x0)
	iValue=RDREG_UINT32(LCDVX1TX_DRVCNT);
	iValue&=(~0x10000000);
	WRREG_UINT32(LCDVX1TX_DRVCNT,iValue);
	IOUNMAP();
	//>Wait 40us
	IOREMAP(0x05648000,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 40us (0x3E8)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x000003E8;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	//>PLL Fractional Mode > Enable
	//	[TBD]
	//>Wait 950us
	IOREMAP(0x05648000,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 950us (0x5CC6)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x00005CC6;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	//>VCO Low Frequency Oscillation Control > Turn Off (OFFSETON)
	IOREMAP(LCDVX1TX_PLLDIGCNT,0x4);
	//	PLLDIGCNT.OFFSETON = Off (0x0)
	iValue=RDREG_UINT32(LCDVX1TX_PLLDIGCNT);
	iValue&=(~0x00001000);
	WRREG_UINT32(LCDVX1TX_PLLDIGCNT,iValue);
	IOUNMAP();
	//Wait 4ms
	IOREMAP(0x05648000,0x30);
	//	LCD_LVDSVX1_PLLLOCK1
	//		LOCK_TIME_EN = Off (0x0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME = 4ms (0x186A0)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue&=(~0x0001FFFF);
	iValue|=0x000186A0;
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//		LOCK_TIME_EN = On (0x1)
	iValue=RDREG_UINT32(LCD_LVDSVX1_PLLLOCK1);
	iValue|=(0x00080000);
	WRREG_UINT32(LCD_LVDSVX1_PLLLOCK1,iValue);
	//	LCD_LVDSVX1_PLLLOCK2.LOCK_TIMER_DONE = Expired (0x1)
	while( !(RDREG_UINT32(LCD_LVDSVX1_PLLLOCK2)&0x00000001) );
	IOUNMAP();
	//[IO Setup]
	//>Turn On VREF
	IOREMAP(0x0410F2E0,0x4);
	//	LVDS_VREF.LCD = Normal Operation (0x0)
	iValue=RDREG_UINT32(LVDS_VREF);
	iValue&=(~0x00000001);
	WRREG_UINT32(LVDS_VREF,iValue);
	IOUNMAP();
	//[PRT Block Setup]
	IOREMAP(0x05604124,0x8);
	//>Switch IO Pad
	//	LCD_LVDS_EN.D3/D2/CK/D1/D0 = Analog Mode (0x0)
	iValue=RDREG_UINT32(LCD_LVDS_EN);
	iValue&=(~0x0000001F);
	WRREG_UINT32(LCD_LVDS_EN,iValue);
	//	LCD_LVDS_PD.D3/D2/CK/D1/D0 = Powered Up (0x0)
	iValue=RDREG_UINT32(LCD_LVDS_PD);
	iValue&=(~0x0000001F);
	WRREG_UINT32(LCD_LVDS_PD,iValue);
	IOUNMAP();
	//[Overlay Block Setup]
	//>Set Overlay
#ifndef Q6300RDK
	IOREMAP(0x05605000,0x4);
	iValue=RDREG_UINT32(PRT_OVLCTL1);
	iValue&=(~0x0000F000);
	iValue|=0x00007000;
	WRREG_UINT32(PRT_OVLCTL1,iValue);
	IOUNMAP();
	//[PIO Block Setup]
	//>Set GPIO Function
	IOREMAP(0x05603040,0x4);
	iValue=RDREG_UINT32(PRT_PIODIRA);
	iValue&=(~0x00001000);
	WRREG_UINT32(PRT_PIODIRA,iValue);
	IOUNMAP();
#endif
	//[GPF Block]
	//>Set Converter
	IOREMAP(0x05648000,0x30);
	//	LCD_LVDSVX1_CSR1
	iValue=RDREG_UINT32(LCD_LVDSVX1_CSR1);
	//		TX_MODE
	iValue&=(~0x00000007);
	iValue|=0x00000002;	//24.1
	//		TX_SRGB_CLK_POL [IGNORE]
	//		TX_SRGB_G_ORDER [IGNORE]
	//		TX_SER_ORDER = MSB (0x0)
	iValue&=(~0x00000100);
	iValue|=0x00000000;
	//		VX1_BYTE_MODE [IGNORE]
	//		LVDSPHY_PCLK = --___-- (0x63)
	iValue&=(~0x00FF0000);
	iValue|=0x00630000;
	//		LVCT4 = 0 (0x0)
	iValue&=(~0x02000000);
	iValue|=0x00000000;
	WRREG_UINT32(LCD_LVDSVX1_CSR1,iValue);
	//	LCD_LVDSVX1_CSR2
	iValue=RDREG_UINT32(LCD_LVDSVX1_CSR2);
	//		LVDSPHY_LCDDATA_EN [IGNORE]
	//		VX1_HTPDNOVRD [IGNORE]
	//		VX1_LOCKOVRD [IGNORE]
	//		LVDSPHY_BYPASSC = Not Bypassed (0x0) [DEFAULT]
	//		LVDSPHY_BYPASSD0 = Not Bypassed (0x0) [DEFAULT]
	//		LVDSPHY_BYPASSD1 = Not Bypassed (0x0) [DEFAULT]
	//		LVDSPHY_BYPASSD2 = Not Bypassed (0x0) [DEFAULT]
	//		LVDSPHY_BYPASSD3 = Not Bypassed (0x0) [DEFAULT]
	//		LVDSPHY_SERSELC = 7:1 (0x0) [DEFAULT]
	//		LVDSPHY_SERSELD0 = 7:1 (0x0) [DEFAULT]
	//		LVDSPHY_SERSELD1 = 7:1 (0x0) [DEFAULT]
	//		LVDSPHY_SERSELD2 = 7:1 (0x0) [DEFAULT]
	//		LVDSPHY_SERSELD3 = 7:1 (0x0) [DEFAULT]
	//		LVDSVX1_RESOVRD = Normal (0x0) [DEFAULT]
	//		LVDSPHY_LCDDATA_POPTHRESH = 4 (0x4) [DEFAULT]
	//		LVDSVX1_MLVDS2EN = 1 (0x1)
	iValue|=0x40000000;
	//		LVDSVX1_MLVDS4EN = 0 (0x0) [DEFAULT]
	WRREG_UINT32(LCD_LVDSVX1_CSR2,iValue);
	//	LCD_LVDSVX1_CSR4 [IGNORE]
	//	LCD_PCLK_CST
	iValue=RDREG_UINT32(LCD_PCLK_CST);
	//		DIS = Enable (0x0) [DEFULAT]
	//		SEL = LVDS TX PLL (0x1)
	iValue&=(~0x00000003);
	iValue|=0x00000001;
	WRREG_UINT32(LCD_PCLK_CST,iValue);
	//	LCD_PCLK_DIVCTRL.NEG_PWL_START/NEG_PWH_START/POS_PWL_START/DIV_VALUE = Disabled (0x00000001)
	WRREG_UINT32(LCD_PCLK_DIVCTRL,0x00000001);
	//	LCD_PCLK_DIVCTRL_TEST [DEFAULT]
	//	LCDADBCTL [DEFAULT]
	IOUNMAP();
	//[DB9K Block Setup]
	IOREMAP(0x05640000,0x1000);
	//>Stop Engine
	//	LCD_CR1
	iValue=RDREG_UINT32(LCD_CR1);
	//		LCE = Disable (0x0)
	iValue&=(~0x00000001);
	WRREG_UINT32(LCD_CR1,iValue);
	//	LCD_PCTR
	iValue=RDREG_UINT32(LCD_PCTR);
	//		PCR = Reset Held (0x0)
	iValue&=(~0x00000400);
	WRREG_UINT32(LCD_PCTR,iValue);
	//	LCD_PWMFR [Disable]
	iValue=RDREG_UINT32(LCD_PWMFR);
	iValue&=(~0x01400000);
	WRREG_UINT32(LCD_PWMFR,iValue);
	//>Setup DB9K
	//	LCD_PCTR
	iValue=RDREG_UINT32(LCD_PCTR);
	//		Clean
	iValue&=(0x00000BFF);
	//		PCD = [IGNORE], PCB = [IGNORE], PCI = PCLK_IN (0x1), PCR = [IGNORE], PCI2 = PCLK_IN (0x0)
	iValue|=(0x00000200);
	WRREG_UINT32(LCD_PCTR,iValue);
	//	LCD_CR1
	iValue=RDREG_UINT32(LCD_CR1);
	//		Clean
	iValue&=(~0x03EFFFFC);
	//		BPP = [PARAMETER]
	iValue|=V_LCD_BPP;
	//		RBG = [PARAMETER]
	iValue|=V_LCD_RGB;
	//		EPO = Little (0x0), EBO = Little (0x0)
	iValue|=0x00000000;
	//		DEP = Active High (0x1), PCP = Rising Edge (0x0), HSP = Active Low (0x1), VSP = Active Low (0x1)
	iValue|=0x00000100;
	//		OPS = [PARAMETER]
	iValue|=V_LCD_OPS;
	//		PSS = [PARAMETER]
	iValue|=V_LCD_PALETTE;
	//		FDW = [PARAMETER]
	iValue|=V_LCD_BURST;
	//		LPS = 1 LCD Port Output (0x0)
	iValue|=0x00000000;
	//		FBP = [PARAMETER]
	if (V_LCD_BPP == V_LCD_CT_BPP_24)
	{
		iValue|=V_LCD_PACK;
	}
	//		DFR = [IGNORE], DFB = Disable (0x0), DFE = Disable (0x0)
	iValue|=0x00000000;
	//		HSS = Coincident (0x1)
	iValue|=0x01000000;
	//		SAU = [PARAMETER]
	iValue|=V_LCD_SAU;
	WRREG_UINT32(LCD_CR1,iValue);
	//	LCD_HTR
	//		HFP = [PARAMETER], PPL = [PARAMETER], HBP = [PARAMETER], HSW = [PARAMETER]
	iValue=((V_LCD_SW_H<<24)|(V_LCD_PH_BACK<<16)|((V_LCD_WIDTH/16)<<8)|V_LCD_PH_FRONT);
	WRREG_UINT32(LCD_HTR,iValue);
	//	LCD_VTR1
	//		VSW = 1 (0x1), VFP = [PARAMETER], VBP = [PARAMETER]
	iValue=0x00000001|(V_LCD_PV_FRONT<<8)|(V_LCD_PV_BACK<<16);
	WRREG_UINT32(LCD_VTR1,iValue);
	//	LCD_VTR2
	//		LPP = [PARAMETER]
	iValue=V_LCD_HEIGHT;
	WRREG_UINT32(LCD_VTR2,iValue);
	//	LCD_IMR
	//		[ALL] = [PARAMETER]
	WRREG_UINT32(LCD_IMR,V_LCD_ISR);
	//	LCD_ISR
	//		>Clean All
	WRREG_UINT32(LCD_ISR,0x0000FFFF);
	//	LCD_IVR
	//		>Read All
	iValue=RDREG_UINT32(LCD_IVR);
	//	LCD_ISCR
	//		VSC = Inactive (0x0)
	iValue=0x00000000;
	WRREG_UINT32(LCD_ISCR,iValue);
	//	LCD_DBAR
	WRREG_UINT32(LCD_DBAR,pmMeta->iAddress);
	//	LCD_DEAR
	WRREG_UINT32(LCD_DEAR,pmMeta->iAddress+V_LCD_WIDTH*V_LCD_HEIGHT*V_LCD_BD);
	//	LCD_DCAR [IGNORE]
	//	LCD_PWMFR [IGNORE]
	//	LCD_PWMDCR [IGNORE]
	//	LCD_DFLAR [IGNORE]
	//	LCD_HPPLOR
	//		HPOE = Disable (0x0), HPPLO [IGNORE]
	iValue=0x00000000|0x00000000;
	WRREG_UINT32(LCD_HPPLOR,iValue);
	//	LCD_HVTER
	//		VSWE = (0), HSWE = (0), VBPE = (0), VFPE = (0), HBPE = (0), HFPE = (0)
	iValue=0x00000000|0x00000000|0x00000000|0x00000000|0x00000000|0x00000000;
	WRREG_UINT32(LCD_HVTER,iValue);
	//	LCD_GPIOR [IGNORE]
	//	LCD_CIR [IGNORE]
	//	LCD_PALT [IGNORE]
	//	LCD_OWER [IGNORE]
	//	LCD_MRR [PARAMETER]
	iValue=V_LCD_MRR;
	if(V_LCD_MRR){iValue|=(((unsigned long)pmMeta->iAddress+V_LCD_WIDTH*V_LCD_HEIGHT*V_LCD_BD));}
	WRREG_UINT32(LCD_MRR,iValue);
	IOUNMAP();
	//[Initialization Procedure]
	//>Release Reset
#ifndef Q6300RDK
	IOREMAP(0x056030C0,0x4);
	iValue=RDREG_UINT32(PRT_PIOSETA);
	iValue|=0x00001000;
	WRREG_UINT32(PRT_PIOSETA,iValue);
	IOUNMAP();
#endif
	//>Start Engine
	//	LCD_PCTR
	IOREMAP(0x05640014,0x4);
	iValue=RDREG_UINT32(LCD_PCTR);
	iValue|=0x00000400;
	WRREG_UINT32(LCD_PCTR,iValue);
	IOUNMAP();
	//>Release Converter
	//	LCD_LVDSVX1_CSR2.LVDSPHY_LCDDATA_EN (Final Control)
	IOREMAP(0x05648008,0x4);
	iValue=RDREG_UINT32(LCD_LVDSVX1_CSR2);
	iValue|=0x00000001;
	WRREG_UINT32(LCD_LVDSVX1_CSR2,iValue);
	IOUNMAP();
	//>Start LCD Engine
	//	LCD_CR1
	IOREMAP(0x05640000,0x4);
	iValue=RDREG_UINT32(LCD_CR1);
	iValue|=0x00000001;
	WRREG_UINT32(LCD_CR1,iValue);
	IOUNMAP();
	
