/******************************************************************************
	[Defines]
******************************************************************************/
//[Register Setting Constant]
//	Serializer
#define V_LCD_CT_SER_18				0x00000007
#define V_LCD_CT_SER_16				0x00000006
#define V_LCD_CT_SER_24				0x00000005
//	BPP
#define V_LCD_CT_BPP_24				0x00000018	
#define V_LCD_CT_BPP_18				0x00000014
#define V_LCD_CT_BPP_16				0x00000010
#define V_LCD_CT_BPP_8				0x0000000C
#define V_LCD_CT_BPP_4				0x00000008
#define V_LCD_CT_BPP_2				0x00000004
#define V_LCD_CT_BPP_1				0x00000000
//	Image Data Packed
#define V_LCD_CT_IDP_ON				0x00080000
#define V_LCD_CT_IDP_OFF			0x00000000
//	RGB ORDER
#define V_LCD_CT_RGB_RGB			0x00000000
#define V_LCD_CT_RGB_RBG			0x00000020
//	OPS
//		Middle Color Enhance
#define V_LCD_CT_MCE_ON				0x00000000
#define V_LCD_CT_MCE_OFF			0x00001000
//		Pin Alignment
#define V_LCD_CT_PA_24				0x00002000
#define V_LCD_CT_PA_18				0x00000000
//	DMA Burst
#define V_LCD_CT_BURST_8			0x00010000
#define V_LCD_CT_BURST_4			0x00000000
//	Palette Source
#define V_LCD_CT_PAL_SLAVE			0x00000000
#define V_LCD_CT_PAL_FB				0x00008000
//	Frame Descriptor
#define V_LCD_CT_FD_ON				0x00800000
#define V_LCD_CT_FD_OFF				0x00000000
//	Overlay Window
#define V_LCD_CT_OW0_ON				0x00000001
#define V_LCD_CT_OW0_OFF			0x00000000
#define V_LCD_CT_OW1_ON				0x00000002
#define V_LCD_CT_OW1_OFF			0x00000000
//	Divider
#define V_LCD_CT_DBDIV_3			0x02010203
#define V_LCD_CT_DBDIV_2			0x00000202
#define V_LCD_CT_DBDIV_1			0x00000001
//	Alpha Blending
//		OW0
#define V_LCD_CT_AB_SRC_REG			0x00000001
#define V_LCD_CT_AB_SRC_FB			0x00000000
#define V_LCD_CT_AB_INV_OFF			0x00000000
#define V_LCD_CT_AB_INV_ON			0x00000002
#define V_LCD_CT_AB_ENB_OFF			0x00000000
#define V_LCD_CT_AB_ENB_ON			0x00000004
#define V_LCD_CT_SAU_ON				0x04000000
#define V_LCD_CT_SAU_OFF			0x00000000
//ISR
#define V_LCD_CT_ISR_BAUM			0x00000080
//FD Options
//	Load Enable
#define V_LCD_FD_OPT_LE_BASE		0x00000001
#define V_LCD_FD_OPT_LE_OW0			0x00000006
#define V_LCD_FD_OPT_LE_OW1			0x00000018
//	Interrupt Enable
#define V_LCD_FD_OPT_IE_NODE		0x00020000
#define V_LCD_FD_OPT_IE_LIST		0x00040000
//	Turn On Enable
#define V_LCD_FD_OPT_TE_OW0			0x00080000
#define V_LCD_FD_OPT_TE_OW1			0x00100000
#define V_LCD_FD_OPT_LE_OWE			0x80000000
/******************************************************************************
	[Defines]
******************************************************************************/
//	System
#define V_LCD_SW_H			1
#define V_LCD_MRR			0
#define V_LCD_MRR_OW0		0
#define V_LCD_MRR_OW1		0
#define V_LCD_DIVIDER		4
#define V_LCD_DBDIV			V_LCD_CT_DBDIV_3
#define V_LCD_BURST			V_LCD_CT_BURST_4
#define V_LCD_PALETTE		V_LCD_CT_PAL_SLAVE
#define V_LCD_FD			V_LCD_CT_FD_OFF
#define V_LCD_OW			(V_LCD_CT_OW0_OFF|V_LCD_CT_OW1_OFF)
#define V_LCD_AB_OPT_OW0	(V_LCD_CT_AB_SRC_REG|V_LCD_CT_AB_INV_OFF|V_LCD_CT_AB_ENB_OFF)
#define V_LCD_AB_OPT_OW1	(V_LCD_CT_AB_SRC_REG|V_LCD_CT_AB_INV_OFF|V_LCD_CT_AB_ENB_OFF)
#define V_LCD_AB_VAL_OW0	128
#define V_LCD_AB_VAL_OW1	64
#define V_LCD_SAU			V_LCD_CT_SAU_OFF
#define V_LCD_ISR			(V_LCD_CT_ISR_BAUM)
#define V_LCD_VX1_LVDS_CONV 0 
//	Dimensions
#define V_LCD_SER_MODE		V_LCD_CT_SER_24
#define V_LCD_BD			3
#define V_LCD_BPP			V_LCD_CT_BPP_24
#define V_LCD_PACK			V_LCD_CT_IDP_ON
#define V_LCD_RGB			V_LCD_CT_RGB_RGB
#define V_LCD_OPS			(V_LCD_CT_PA_24|V_LCD_CT_MCE_ON)
//	Porch
#define V_LCD_PH_BACK		200
#define V_LCD_PH_FRONT		100
#define V_LCD_PV_BACK		17
#define V_LCD_PV_FRONT		18
//	Base
#define V_LCD_WIDTH			1024
#define V_LCD_HEIGHT		600
//	OW0
#define V_LCD_OW0_X			32
#define V_LCD_OW0_Y			32
#define V_LCD_OW0_WIDTH		256
#define V_LCD_OW0_HEIGHT	192
//	OW1
#define V_LCD_OW1_X			320
#define V_LCD_OW1_Y			240
#define V_LCD_OW1_WIDTH		300
#define V_LCD_OW1_HEIGHT	200
// PHY
#define V_DEF_LVDS_PHY      1
#define V_DEF_VX1_PHY       2
#define V_LCD_PHY           V_DEF_LVDS_PHY
