
#define MAX_QUEUE_ELEMENT_COUNT 16

typedef void *HU32C;

typedef struct _s_u32c_info
{
	char szName[8];
	int idxWrite;
	int idxRead;
	int nMaxCount;
	unsigned long  au32Array[MAX_QUEUE_ELEMENT_COUNT];
} S_U32INFO, *PS_U32INFO;

#ifndef NULL
#define NULL ((void *)0)
#endif

HU32C u32cCreate(const char *szName, void *pBuff, int nBuffSize, int nU32MaxCount)
{
	int i;
	void *p = pBuff;
	PS_U32INFO pInfo;
	if(NULL == p)
	{
		printk("U32C Fatal error: buffer is NULL\n");
		return NULL;
	}

	if(nU32MaxCount > MAX_QUEUE_ELEMENT_COUNT)
		nU32MaxCount = MAX_QUEUE_ELEMENT_COUNT;
	
	if((sizeof(unsigned long)*nU32MaxCount+sizeof(S_U32INFO)) > nBuffSize)
	{
		printk("U32C Fatal error: buffer size is not enough\n");
		return NULL;
	}
	memset(p, 0, nBuffSize);
	pInfo = p;
	for(i = 0; i < (sizeof(pInfo->szName)-1);i++) pInfo->szName[i] = szName[i];
	pInfo->nMaxCount = nU32MaxCount;
	return pInfo;
}

void u32cResetData(HU32C hU32c)
{
	PS_U32INFO pInfo = (PS_U32INFO)hU32c;
	int i;
	
	pInfo->idxRead = pInfo->idxWrite = 0;
	for(i = 0; i < pInfo->nMaxCount; i++)
	{
		pInfo->au32Array[i] = 0;
	}
}


int u32cGetDataCount(HU32C hU32c)
{
	PS_U32INFO pInfo = (PS_U32INFO)hU32c;
	int idxRead = pInfo->idxRead;
	int idxWrite = pInfo->idxWrite;
	int nMaxCnt = pInfo->nMaxCount;

	if(idxRead == idxWrite)
	{
		return 0;
	} 
	else
	if(idxWrite > idxRead)
	{
		return idxWrite - idxRead;
	}
	else
	{
		return nMaxCnt-idxRead+idxWrite;
	}
}

int u32cGetFreeCount(HU32C hU32c)
{
	PS_U32INFO pInfo = (PS_U32INFO)hU32c;
	int idxRead = pInfo->idxRead;
	int idxWrite = pInfo->idxWrite;
	int nMaxCnt = pInfo->nMaxCount;

	if(idxRead == idxWrite)
	{
		return nMaxCnt;
	} 
	else
	if(idxWrite > idxRead)
	{
		return nMaxCnt-idxWrite+idxRead;
	}
	else
	{
		return idxRead - idxWrite;
	}
	
}

int u32cPushData(HU32C hU32c, unsigned long data)
{
	PS_U32INFO pInfo = (PS_U32INFO)hU32c;
	int idx;
	if(u32cGetFreeCount(hU32c) <= 1)
	{
		printk("U32C Fatal error: Free szie size is not enough  in push data\n");
		return -1;
	}
	idx = pInfo->idxWrite;
	pInfo->au32Array[idx] = data;
	idx++;
	if(idx >= pInfo->nMaxCount)
	{
		idx = 0;
	}
	pInfo->idxWrite = idx;
	return 0;
}

int u32cPopupData(HU32C hU32c, unsigned long *pnData)
{
	int nRet = 0;
	unsigned long data;
	PS_U32INFO pInfo = (PS_U32INFO)hU32c;
	int idx;
	idx = pInfo->idxRead;
	if(idx == pInfo->idxWrite)
	{
		printk("U32C error: no data to read\n");
		return -1;
	}
	data = pInfo->au32Array[idx] ;
	pInfo->au32Array[idx] = 0;
	idx++;
	if(idx >= pInfo->nMaxCount)
	{
		idx = 0;
	}
	pInfo->idxRead = idx;
	if(NULL != pnData)
	{
		*pnData = data;		
	}
	return nRet;
}
