# Copyright (c) 2012, 2015, The Linux Foundation. All rights reserved.
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 and
# only version 2 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

#
# Make file template for building Qbit h/w unit drivers inside the Quasar
# build system
#
# This is a relatively standard kernel module makefile.  It depends on a few
# variables to be passed in, and depends on a fixed directory structure
# Meant to be included in a driver makefile, and the driver makefile invoked
# on the command line, or in a sub-make
#
# Assuming the directory structure is like
#
# |
# +- kernel
# |   +- drivers         ---- this directory
# |      +- <a driver>           ---- driver sources in single sub-dir here
# |      +- <multi-drivers tree> ---- a sub-dir with multiple related drivers
# |         +- <driver 1>        ----  one of a set of related drivers
# |         +- <driver 2>        ----  next of a set
# |   +- <kernel source>         ---- the kernel source named $(QUASAR_KERNEL_VERSION)
# |   +- <object dir>            ---- config. obj directory named $(QUASAR_TARGET)
# |
#
# The variables passed in, defaulted here are:
#
TARGET ?= 6300
QUASAR_TARGET ?= $(TARGET)
QUASAR_SOCREV ?= $(SOCREV)
QUASAR_SOCVAR ?= $(SOCVAR)

ifndef QUASAR_KERNEL_REV
$(error Kernel version not set, please set QUASAR_KERNEL_REV to the name of your Linux kernel directory (in quasar/kernel).)
endif
QUASAR_KERNEL_VERSION ?= $(QUASAR_KERNEL_REV)

ifdef QUASAR_ARM_TOOL_CHAIN_LINUX_HF
    export CROSS_COMPILE?=${QUASAR_ARM_TOOL_CHAIN_LINUX_HF}/bin/arm-linux-gnueabihf-
else
    export CROSS_COMPILE?=/tools/linaro/gcc-linaro-4.9.4-2017.01-i686_arm-linux-gnueabihf/bin/arm-linux-gnueabihf-
endif
export ARCH?=arm

# To override these, in a driver directory do (for example)
#
# > make TARGET=6300 QUASAR_KERNEL_VERSION=linux-2.6.33.y-quasar
#

# before including this template makefile, the driver makefile can
# define these to override the defaults.  The defaults are to create
# a driver named <directoryname>.ko based on a single "C" file called
# <directoryname>.c.
#
# since there is a special builtin method of building a module from a
# single file (modulename-y not defined) where the single c file is named
# the same as the object, make sure to not define DRIVER_OBJS if you 
# want to build that way (example, to make qdsp.ko from qdsp/qdsp.c, no
# defines of DRIVER_NAME or DRIVER_OBJS need be made.
#

ifneq ($(KERNELRELEASE),)

###############################################################################
#
# kernel kbuild part of makefile, used when kbuild enters this dir
# and uses the Makefile to get obj-m $(M)-y
# 
# the driver makefile can set DRIVER_NAME and DRIVER_OBJS to use non-defaults
#
DRIVER_NAME ?= $(notdir $(M))
DRIVER_OBJS ?=

obj-m  := $(DRIVER_NAME).o
ifneq ($(DRIVER_OBJS),)
	$(DRIVER_NAME)-y := $(DRIVER_OBJS)
endif

else

###############################################################################
#
# normal part of makefile, used first, before recursive make (below)
# where kernel module make re-reads this
#

# kernel source dir, relative to the module source dir.  For drivers in
# directories lower than one under the "drivers" directory, the makefile
# there should specify the relative path the the "drivers" directory 
# here defaulted to two levels up
#

# kernel object dir, relative to kernel source dir
#
PWD  := $(shell pwd)
KERNEL_PARENT := $(shell echo $(PWD) | sed "s/\(.*\/kernel\)\/.*\/.*/\1/")
DRIVERS_DIR := $(KERNEL_PARENT)/drivers
ODIR := $(KERNEL_PARENT)/work/$(QUASAR_TARGET)
KDIR := $(KERNEL_PARENT)/$(QUASAR_KERNEL_VERSION)

all:
	$(MAKE) -C $(KDIR) O=$(ODIR) M=$(PWD) EXTRA_CFLAGS="-I$(DRIVERS_DIR) -DQ$(QUASAR_TARGET) -DQ$(QUASAR_TARGET)$(SOCREV) -DQ$(QUASAR_TARGET)$(SOCVAR) $(KERNEL_CC_FLAG)" modules
	$(MAKE) -C $(KDIR) O=$(ODIR) INSTALL_MOD_PATH=. M=$(PWD) modules_install

clean:
	rm -rf .tmp_versions .*.cmd *.ko *.mod.c *.mod.o *.o

endif

