/*=================================================================================================
Filename:    vos_usr_if.h
Description: usr interface for VOS kernel  
Data:        Initial revision. Bob@2020-03-30
==================================================================================================*/
#ifndef VOS_USR_IF_H
#define VOS_USR_IF_H

//memory
#define DMEM_MAGIC_ID 0xbeae
typedef struct tag_DMEM_HEAD {
    unsigned short nMagicId;
    unsigned short nMemId;
	unsigned long nSize;
	void *pMallocPtr; //kernel vir address
	void *puMallocPtr; //user vir address
	void *pPhysical;
	void *pPrev;
	void *pNext;

	//below for debug
	char pFuncName[12];
	unsigned short nLines;
	unsigned short nPrefixSize;
}DMEM_PREFIX;
#define     ALIGN_RIGHT(a,b)        (((a)+(b)-1)/(b)*(b))

typedef struct tag_RPC_CMD {
    unsigned long ulCmd;
	unsigned long ulPar[4];
	unsigned long ulResult;
	unsigned long output[3];
	char sInfo[256];
}KRPC_S;

#define KQUE_FIXED_SIZE (10*4)

typedef enum {
	VOSCMD_DMALLOC = 0x1000,
	VOSCMD_DFREE,
	VOSCMD_DMALLOC_UNCACHED,	
	VOSCMD_DMA_CACHE2PHY,  //before device read: make cache write to phyMem
	VOSCMD_DMA_CACHE_MISS, //after device write: make cache miss
	VOSCMD_DPOOL_CREATE,
	VOSCMD_DPOOL_MALLOC,
	VOSCMD_DPOOL_FREE,
	VOSCMD_DPOOL_FREE_ALL,
	VOSCMD_DPOOL_SHOW,
	VOSCMD_MTMPOOL_CREATE,
	VOSCMD_MTMPOOL_MALLOC,
	VOSCMD_MTMPOOL_FREE,
	VOSCMD_MTMPOOL_FREE_ALL,
	VOSCMD_MTMPOOL_DESTROY,
	VOSCMD_MTMPOOL_SHOW,
	VOSCMD_DMALLOC_WRITECOMBINE,
	
	READ_CMD = 0x2000,
	WRITE_CMD,
	MAP_CMD,
	UNMAP_CMD,
	MAP_READ_CMD,
	MAP_WRITE_CMD,
	PHY_TO_VIRT_CMD,
	VIRT_TO_PHY_CMD,
	TS_REC_CMD,
	TS_REC_SHOW_CMD,
	KQUE_GET_CMD,
	KQUE_SEND_CMD,
	
	KVCT_D_CMD = 0x3000,
	KVCT_M_CMD,
	KVCT_D_VAR_CMD,
	KVCT_M_VAR_CMD,
	KVCT_MK_STR_CMD,
	KVCT_CALL_FUNC_CMD,
}eVOS_CMD_TYPE;

#define UMEM_DEV_NAME "/dev/mem"
#define VOS_DEV_NAME "/dev/vosdev"

#endif /*end #ifndef VOS_USR_IF_H*/


