/*=================================================================================================
Filename:    vos_kernel_if.h
Description: extern API of abstraction functions of Linux kernel  
Data:        Initial revision. Bob@2019-12-05
==================================================================================================*/
#ifndef VOS_KERNEL_IF_H
#define VOS_KERNEL_IF_H

extern int g_nVosDbgLev;
typedef int BOOL;
#define VOS_NO_WAIT                      0
#define VOS_WAIT_FOREVER                 0xFFFFFFFFUL
typedef enum _e_result
{
	VOS_OK = 0,
	VOS_ERROR = 1,
	VOS_TIMEOUT = 2,
	VOS_PARAM_WRONG_TYPE = 3,
	VOS_PARAM_OUTRANGE = 4,
	VOS_ID_NULL = 5,
} E_RESULT;

//misc
#define VOS_ASSERT(a) vos_assert(a, #a, __FILE__, __LINE__)
#define vosPrintf(a, b...) vos_Printf(a,##b)
#define VOS_ERROR_RPT(a) if(a != 0)vos_Printf("Errno=%d, file:%s, Lines=%d\r\n", a, __FILE__, __LINE__);
#define vos_dbgPrint(level, a, b...) if(level>g_nVosDbgLev)vos_Printf(a,##b);
void vos_intAttach( unsigned long int_num, unsigned long flags, void *handler, const char* name, void* context );
void vos_intDetach( unsigned long int_num, void* context);
void vos_intEnable( unsigned long int_num );
void vos_intDisable( unsigned long int_num );
void DBG_tracePut(char * pStr, ...);

void vos_showStack(void);
void vos_assert(int bFlag, char *pMsg, char * pName, int nLines);
void vos_Printf(const char* template, ...);
void vos_PrintfLong(const char* pStr);
int vos_fileRead(const char * filename, char *pBuff, int size);
int vos_fileWrite(char* filename, char* data, int size);
int vos_fileAppend(char* filename, char* data, int size);
void vos_ddPrint(unsigned long ulAddr, unsigned long ulUnits, unsigned long ulWidth);
void vos_logFileOut(char *pFileName, int nPintFlag, const char* template, ...);
unsigned long vos_GetSysCntMs(void);
unsigned long vos_GetSysCntUs(void);
unsigned long vos_GetSysCntNs(void);
#define vos_kLogOut(a, b...) vos_logFileOut("/tmp/kvos.log", 1, a,##b)

//DLK: double link
typedef unsigned long HVOSDLK;
typedef int (*pfDlFunc)(void *pData, unsigned long nKey);

typedef struct  tagVDLK {
  struct  tagVDLK *next;       // forward link
  struct  tagVDLK *prev;       // backward link
  unsigned short     nHeadId;    // Id
  unsigned short     flag;    // reserve
} DLK_NODE;

#define DLK_WALK_LOOP_START(pNode, pHead) pNode=pHead;do{if(pNode==NULL)break;
#define DLK_WALK_LOOP_END(pNode, pHead) pNode=pNode->next;}while(pNode!=pHead);

HVOSDLK vos_dlkCreate(int nDataSize, int mutexFlag, pfDlFunc pfGetKey);
void vos_dlkSetSort(HVOSDLK hDlk, pfDlFunc pfGetKey, unsigned long nSortFlag);
void vos_dlkAddMutex(HVOSDLK hDlk, char *pName);
int vos_dlkDestroy(HVOSDLK hDlk);
int vos_dlkClean(HVOSDLK hDlk);
DLK_NODE * vos_dlkInsert(HVOSDLK hDlk, DLK_NODE *pNode, void *pData);
DLK_NODE * vos_dlkInsertNode(HVOSDLK hDlk, DLK_NODE *pNode, DLK_NODE *pNew);
DLK_NODE * vos_dlkFind(HVOSDLK hDlk, unsigned long nKey);
void vos_dlkDelete(HVOSDLK hDlk, DLK_NODE *pNode);
int vos_dlkDeleteByKey(HVOSDLK hDlk, unsigned long nKey);
DLK_NODE * vos_dlkGetHead(HVOSDLK hDlk);
DLK_NODE * vos_dlkGetTail(HVOSDLK hDlk);
DLK_NODE * vos_dlkGetNext(HVOSDLK hDlk, DLK_NODE *pNode);
int vos_dlkGetCnt(HVOSDLK hDlk);
int vos_dlkShow(HVOSDLK hDlk, DLK_NODE *pShow);
DLK_NODE * vos_dlkCp2New(HVOSDLK hDlk, DLK_NODE *pNode);
int vos_dlkSave2Mem(HVOSDLK hDlk, void *pMem);
HVOSDLK vos_dlkRecoverFromMem(void *pMem);
void vos_dlkRm(DLK_NODE *qp);
void * vos_dlkInsertData(HVOSDLK hDlk, void *pData);
void * vos_dlkInsertDataSort(HVOSDLK hDlk, void *pData, unsigned long nSortKey);

//memory
void * vos_malloc(unsigned long size);
void vos_free(void *pVaddr);
void * vos_kmalloc(unsigned long size, const char* file, unsigned long line);
void vos_kfree(void *pVaddr);
void *vos_kmalloc_coherent(unsigned long size, void *pPhyAddr);
void vos_kfree_coherent(unsigned long size, void *pKvirAddr, void *pPhyAddr);

unsigned long vos_memPhy2vir(unsigned long nPhyAddr);
unsigned long vos_memVir2Phy(unsigned long nVirAddr);
unsigned long vos_phyAddrRd(unsigned long phyAddr, unsigned long len);
unsigned long vos_phyAddrWt(unsigned long phyAddr, unsigned long val, unsigned long len);
unsigned long vos_phyAddrMap(unsigned long phyAddr, unsigned long size);
unsigned long vos_phyAddrUnmap(unsigned long vAddr);
#define VOS_KMALLOC(size) vos_kmalloc(size, __FILE__, __LINE__)

void * vos_dmalloc(int flag, unsigned long size, void *pPhyAddr);
void vos_dfree(int flag, unsigned long size, void *pKvirAddr, void *pPhyAddr);
void *vos_dmemCoherence(unsigned long kv_addr, int len, int type);

void  *vos_dplMalloc(int size, char *szFunc, int nLine);
void  vos_dplFree(void *pVirAddr);
void *vos_dplGetPhyAddr(void *pVirAddr);
void vos_dplShowPool(int prtlLog);

//RBUF: ring buffer
typedef unsigned long HRBUF;

HRBUF vos_rbufCreate(unsigned long nUnitSize, unsigned long nMaxCnt, int mutexFlag);
int vos_rbufDelete(HRBUF hRbuf);
int vos_rbufWrite(HRBUF hRbuf, void *pData, int nSize, int nWaitForMSec); //nSize == 0, write one unit data
int vos_rbufRead(HRBUF hRbuf, void *pData, int nSize, int nWaitForMSec); //nSize == 0, read one unit data
int vos_rbufClean(HRBUF hRbuf);
int vos_rbufShow(HRBUF hRbuf, int flag);
int vos_rbufWriteTrace(HRBUF hRbuf, void *pData);
unsigned long vos_rbufDataSizeGet(HRBUF hRbuf);
unsigned long vos_rbufFreeSizeGet(HRBUF hRbuf);

//task
typedef unsigned long HVOSTASK;
typedef unsigned long (*TaskFunc)(void *pParam);
void vos_taskSleep(unsigned long ulMilliSeconds);
void vos_taskDelay(unsigned long ulMilliSeconds);
void vos_taskDelayUs(unsigned long ulUs);
HVOSTASK vos_taskCreate(void *pfTask, void *pParam, char * szTskName);

//Mutex
typedef unsigned long HVOSMUTEX;
HVOSMUTEX vos_mutexCreate(char * pName, int bInitMutex);
int vos_mutexLock(HVOSMUTEX hMutex);
int vos_mutexUnlock(HVOSMUTEX hMutex);
int vos_mutexClose(HVOSMUTEX hMutex);
int vos_mutexShowAll(void);

//Semaphore
typedef unsigned long HVOSSEM;
HVOSSEM vos_semCreate(char * strSemName, unsigned long nSemCnt);
int vos_semTake(HVOSSEM hSem, unsigned long nWaitForMSec);
int vos_semGive(HVOSSEM hSem);
int vos_semClose(HVOSSEM hSem);
int vos_semGetCnt(HVOSSEM hVsem);
int vos_semShowAll(void);

//message Queue
typedef unsigned long HVOSQUEUE;
HVOSQUEUE vos_queueCreate(char * strQueName, int nMaxCounter, int nMaxItemSize);
int vos_queueWrite(HVOSQUEUE hQueue, void *pMsg, int nWaitForMSec);
BOOL vos_queueRead(HVOSQUEUE hQueue, void * pMsg, int nWaitForMSec);
int vos_queueClose(HVOSQUEUE hQueue);
int vos_queueClear(HVOSQUEUE hQueue);
int vos_queueShowAll(void);
int vos_queueGetMsgCnt(HVOSQUEUE hQueue);
char * vos_queueGetName(HVOSQUEUE hQueue);
int vos_kqueRecv(void *pQueMsg, int index);
int vos_kqueSend(void *pQueMsg, int index);

//timer
typedef unsigned long HVOSTIMER;
typedef void (*TimeFunc)(unsigned long);

HVOSTIMER vos_timerCreate(char * Name, TimeFunc pfFunc, void *pParam, int nMilliSec, int nInterMilliSec, int autoAct);
int vos_timerEnable(HVOSTIMER vTimerId);
int vos_timerDisble(HVOSTIMER vTimerId);
int vos_timerDelete(HVOSTIMER vTimerId);
int vos_timerShowAll(void);

//MPL: memory pool
typedef unsigned long * HVOSMPL;

HVOSMPL vos_mplCreatePoolPhy(const char * szDesc, int type, void * pPoolBuf, int nSize, unsigned int nPhyAddr, int mutxFlag);
HVOSMPL vos_mplCreatePool(const char * szDesc, void * pBaseBuf, int nSize);
void * vos_mplAlloc(HVOSMPL hPool, int nSize, int align, const char * szFile, int nLine);
void * vos_mplRealloc(HVOSMPL hPool, void * pOrgMem, int nSize, int align, const char * szFile, int nLine);
void vos_mplFree(HVOSMPL hPool, void * pMem);
void vos_mplFreeAll(HVOSMPL hPool);
void vos_mplDestroy(HVOSMPL hPool);
unsigned int vos_mplGetPoolAddrStart(HVOSMPL hPool);
HVOSMPL vos_mplGetPoolByMem(void * pMem);
void vos_mplGetSize(HVOSMPL hPool, unsigned long *pTotal, unsigned long *pUsed, unsigned long *pPeakUsed);
void *vos_mplGetPhyAddr(HVOSMPL hPool, void * pMem);
void * vos_mplGetKvirAddr(HVOSMPL hPool, void *pPhyAddr);
int vos_mplCheck(HVOSMPL hPool, void * pMem);
unsigned int vos_mplInfo(HVOSMPL hPool, unsigned int *pMaxFreeSize, int nPrtFlag);


//vos_mtmPool
typedef void * HVOSMTP;

HVOSMTP vos_mtpCreate(char *pName, int type, int memType);
void vos_mtpAddPool(HVOSMTP hMtmPool, int nPoolSize, void * pPoolBuf, unsigned int nPhyAddr);
void *vos_mtpMalloc(HVOSMTP hMtmPool, int nSize, int align, const char * szFile, int nLine);
void vos_mtpFree(HVOSMTP hMtmPool, void *pAddr);
void vos_mtpFreeAll(HVOSMTP hMtmPool);
HVOSMTP vos_mtpCreatePool(char *pName, int type, int memType, int nPoolNum, int nPoolSize);
void vos_mtpDestroyPool(HVOSMTP hMtmPool);
void vos_mtpShow(HVOSMTP hMtmPool, int nPrtFlag);
unsigned long vos_mtpGetUsedSize(HVOSMTP hMtmPool);
void * vos_mtpGetKvirAddr(HVOSMTP hMtmPool, void *pPhyAddr);

#define VOS_MTP_MALLOC(pMtmPool, size) vos_mtpMalloc(pMtmPool, size, 4, __FILE__, __LINE__)

//vos_dpool
unsigned long vos_dplCreate(unsigned long nPoolSize, unsigned long nPhyStartAddr, unsigned long nKvirStartAddr);
void vos_dplShowPool(int prtlLog);
void *vos_dplGetPhyAddr(void *pVirAddr);
void  *vos_dplMalloc(int size, char *szFunc, int nLine);
void  vos_dplFree(void *pVirAddr);
int vos_dplCheck(void *pVirAddr);
unsigned long vos_mdplCreate(int type, int nPoolNum, int nPoolSize);
void  *vos_mdplMalloc(int size, char *szFunc, int nLine);
void *vos_mdplGetPhyAddr(void *pVirAddr);
void  vos_mdplFree(void *pVirAddr);
void vos_mdplShowPool(int prtlLog);

#endif /*end #ifndef VOS_KERNEL_IF_H*/


