/******************************************************************************
 *
 * Copyright(c) 2013 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 *
 ******************************************************************************/
#ifndef __RTW_PRINTER_H__
#define __RTW_PRINTER_H__

#include <drv_types.h>

#if defined(CONFIG_CHECK_NULL_SSID) && (!defined(CONFIG_RTW_PRINTER_UTILITY))

	#error "Enable CONFIG_RTW_PRINTER before enable CONFIG_CHECK_NULL_SSID\n"

#endif


#ifdef CONFIG_RTW_PRINTER_UTILITY

void ex_rtw_printer_set_retry_limit(PADAPTER padapter, u16 addr, u8 case_id);

#ifdef CONFIG_THERMAL_PROTECT
/**
 * enum nl80211_connect_failed_reason - connection request failed reasons
 * @NL80211_CONN_FAIL_MAX_CLIENTS: Maximum number of clients that can be
 *	handled by the AP is reached.
 * @NL80211_CONN_FAIL_BLOCKED_CLIENT: Connection request is rejected due to ACL.
 * @NL80211_CONN_FAIL_HIGH_THERMAL: Add custom reason for high thermal notification.
 * 20170816 garyhsieh
 */
#define NL80211_CONN_FAIL_HIGH_THERMAL 2


enum THERMAL_PROTECT_STATE {
	THERMAL_PROTECT_DISABLE = 0,
	THERMAL_PROTECT_START = 1,
	THERMAL_PROTECT_FUCTION_OFF = 2,
	THERMAL_PROTECT_STATE_MAX,
};

struct rtl_thermal_proctect {
	u8 	state;
	u32 current_detect_count;
	u32 last_detect_count;
	u8 tdefence_handling;
};

#define THERMAL_DETECT_VALUE 0x2D   /* Thermal value 0x2D */
#define THERMAL_DETECT_DURATION 4 /* (N+1) * 100ms */

void rtw_hal_thermal_detect_cmd(PADAPTER padapter);
u8 rtw_set_tx_power_level_hdl(_adapter *padapter, u8 *pbuf);
u8 rtw_set_tx_power_level_cmd(_adapter *padapter);
void rtw_printer_thermal_proctect_init(PADAPTER padapter);
void rtw_printer_thermal_proctect_def_init(PADAPTER padapter);
void rtw_printer_thermal_protect(PADAPTER padapter);
void rtw_printer_thermal_detection(PADAPTER padapter, u32 thermal_value);
bool ex_rtw_printer_thermal_defence(_adapter *adapter);
u8 ex_rtw_printer_if_thermal_defence_is_handling(_adapter *adapter);
u8 ex_rtw_printer_thermal_defence_hdl(_adapter *padapter, u8 *pbuf);
u8 ex_rtw_printer_hal_thermal_defence_cmd(_adapter *adapter);
#else 
#define ex_rtw_printer_thermal_defence(adapter) _FALSE
#define ex_rtw_printer_thermal_defence_hdl(padapter,pbuf) _FALSE
#define ex_rtw_printer_if_thermal_defence_is_handling(adapter) _FALSE
#define ex_rtw_printer_hal_thermal_defence_cmd(padapter) _FALSE
#endif /* CONFIG_THERMAL_PROTECT */


// :: Detect and Show the wake packet !
#if 0
void ex_rtw_printer_set_en_bcn_ctrl_bit(_adapter *padapter, u8 enable);
#endif

#else

#define ex_rtw_printer_set_retry_limit(padapter, addr , case_id) 

// 
#define ex_rtw_printer_thermal_defence(adapter) _FALSE
#define ex_rtw_printer_thermal_defence_hdl(padapter,pbuf) _FALSE 
#define ex_rtw_printer_if_thermal_defence_is_handling(adapter) _FALSE
#define ex_rtw_printer_hal_thermal_defence_cmd(padapter) _FALSE
#if 0
#define ex_rtw_printer_set_en_bcn_ctrl_bit(padapter,enable)
#endif

#endif  /* CONFIG_PRINTER */
#endif  /* !__RTW_PRINTER_H__ */

