/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef __RTW_FPGA_VERIFICATION_H__
#define __RTW_FPGA_VERIFICATION_H__

#include <drv_types.h>

#if (RTW_FPGA_VERIFICATION==1)

#define EX_RTW_FPGA_SKIP_BBRF_REG_ACCESS _TRUE
#define EX_RTW_FPGA_SKIP_PHYDM_WATCH_DOG _TRUE
#define EX_RTW_FPGA_ALLOW_BBRF_ACCESS(addr) ((addr==0x1704 || addr==0x1700 || \
	addr==0x4c || addr==0xcb4 || addr==0x974 || addr==0x1990 || \
	addr==0xcbc || addr==0x70)?_TRUE:_FALSE)


void ex_rtw_fpga_set_rftype_id(PADAPTER adapter);
bool ex_rw_fpga_skip_set_chn_bw(unsigned char channel, unsigned char channel_offset, unsigned short bwmode);
bool ex_rtw_fpga_skip_read_efuse(PADAPTER adapter);
bool ex_rtw_fpga_skip_load_tx_power(PADAPTER adapter);
bool ex_rtw_fpga_skip_check_fw_ractrl(PADAPTER adapter);
void ex_rtw_fpga_dump_current_function(PADAPTER adapter,const  char * func);
void ex_rtw_fpga_dump_rx_report(PADAPTER adapter, const char * ic_type, struct rx_pkt_attrib *a, u8 *rx_buf);

#else   /* RTW_FPGA_VERIFICATION */

#define EX_RTW_FPGA_SKIP_BBRF_REG_ACCESS _FALSE
#define EX_RTW_FPGA_SKIP_PHYDM_WATCH_DOG _FALSE
#define EX_RTW_FPGA_ALLOW_BBRF_ACCESS(addr) _TRUE

#define ex_rtw_fpga_set_rftype_id(adapter)
#define ex_rw_fpga_skip_set_chn_bw(channel,channel_offset,bwmode) _FALSE
#define ex_rtw_fpga_skip_read_efuse(adapter) _FALSE
#define ex_rtw_fpga_skip_load_tx_power(adapter) _FALSE
#define ex_rtw_fpga_skip_check_fw_ractrl(adapter) _FALSE 
#define ex_rtw_fpga_dump_current_function(adapter, func)
#define ex_rtw_fpga_dump_rx_report(adapter, ic_type, a, rx_buf) 

#endif  /* RTW_FPGA_VERIFICATION */
#endif  /* !__RTW_FPGA_VERIFICATION_H__ */

