/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef __RTW_AUTOSUSPEND_H__
#define __RTW_AUTOSUSPEND_H__

#include <drv_types.h>

#ifdef CONFIG_AUTOSUSPEND

#define CONFIG_AUTOSUSPEND_KEEP_OLD_AS	0

enum AS_STATE {
	AS_NORMAL = 0,
	AS_SUSPEND_WAITING = 1,
	AS_SUSPEND_PROCESSING = 2,
	AS_SUSPEND,
	AS_RESUME_PROCESSING,
	AS_STATE_MAX,
};

enum AS_LEAVE_RESON{
	REASON_TX = 0,
	REASON_RX = 1,
	REASON_DISCONNECT = 2,
	REASON_SYSTEM = 3,
	REASON_DISMATCH = 4,
	REASON_CONCURRENT = 5,
	REASON_UNKNOWN,
};

const char *as_state_str(u8 state);


struct autosuspend_priv {
	u8	bInternalAssociatedAutoSuspend; 
	u8	bInternalAutoSuspend_processing; 
	u8	bInternalAutoResume_processing; 
	u8	bInternalAutoBlock; 
	s8	InternalAutoSuspend_waitcnt;
	u8	leaveAutoSuspendReason;
	u8	state;
};

struct autosuspend_cancel_parm {
	u8 bFromSystemCall;
};


#define AS_BLK_NONE 0x00
#define AS_BLK_ALL 0x01
#define AS_BLK_TX 0x02
#define AS_BLK_MAX 0x03


/* var : */

#define AUTUSUSPEND_PRIV struct autosuspend_priv aspriv

#define AS_WAIT_TIMEOUT 1   /* second */
#define aspriv_as_state(pwrpriv) ((pwrpriv)->aspriv.state)
#define aspriv_as_state_str(pwrpriv) as_state_str((pwrpriv)->aspriv.state)
#define aspriv_chk_as_state(pwrpriv,_state) ((pwrpriv)->aspriv.state == (_state))
#if CONFIG_AUTOSUSPEND_DEBUG
#define aspriv_set_as_state(pwrpriv,_state) \
	do { \
		((pwrpriv)->aspriv.state = (_state)); \
		RTW_INFO("##########################\n"); \
		RTW_INFO("set_as_state:%s\n", as_state_str(_state)); \
		RTW_INFO("##########################\n"); \
	} while (0)
#else
#define aspriv_set_as_state(pwrpriv,_state) ((pwrpriv)->aspriv.state = (_state))
#endif



/* public : */
void ex_autosuspend_priv_init(_adapter *padapter);
void ex_autosuspend_init(_adapter *padapter);
void ex_autosuspend_deinit(_adapter *padapter);
void ex_autosuspend_enter(_adapter *padapter);
void ex_autosuspend_resume_end(_adapter *padapter);
void ex_autosuspend_sys_resume_end(_adapter *padapter);

bool ex_autosuspend_connected_entry(_adapter *padapter);
bool ex_autosuspend_cancel_nas_in_suspend(_adapter *padapter, pm_message_t message);
void ex_autosuspend_suspend_end(_adapter *padapter, bool ret_suspend);

bool ex_autosuspend_leave(_adapter *padapter);
bool ex_autoresume_entry_in_resume(_adapter *padapter, int *b_resume_result);
void ex_autosuspend_cancel(_adapter *padapter, u8 bFromSystemCall);
u8 ex_autosuspend_cancel_cmd(_adapter *padapter, u8 bFromSystemCall);
u8 ex_autosuspend_cancel_hdl(_adapter *padapter, u8 *pbuf);
void ex_autosuspend_switch(_adapter *padapter, u8 bBlockOn);
void ex_autosuspend_check_waitcnt(_adapter *padapter);
void ex_autosuspend_check_netif_queue(_adapter *padapter);
int ex_autosuspend_check_autosuspend_status(_adapter *padapter);
u8 ex_autosuspend_check_tx_pkt_enqueue(_adapter *padapter);
void ex_autosuspend_check_indicate_disconnect(_adapter *padapter);
void ex_autosuspend_check_wow_reason(_adapter *padapter);
void ex_autosuspend_intf_up_check_concurrent_state(_adapter *padapter);
void ex_autosuspend_intf_down_check_concurrent_state(_adapter *padapter);
void ex_autosuspend_watchdog_check_concurrent_state(_adapter *padapter);

void ex_autosuspend_set_not_xmitframe_fw_dl(_adapter *padapter, u8 method );
void ex_autosuspend_set_check_period(u8 *value);
int ex_autosuspend_dump_pm_cnt(struct dvobj_priv *dvobj, bool bdump);
bool ex_autosuspend_if_in_autosuspend(_adapter *padapter);


bool ex_autosuspend_active_chk_alive(PADAPTER padapter);
void ex_autosuspend_revise_receive_bcn_count(PADAPTER padapter, u8 *pframe);
void ex_autosuspend_revise_receive_probersp_count(PADAPTER padapter, u8 *pframe, u32 packet_len);
bool ex_autosuspend_check_retry_probersp(PADAPTER padapter, u8 *pframe, u32 packet_len);
#else

#define CONFIG_AUTOSUSPEND_KEEP_OLD_AS	1
#define AUTUSUSPEND_PRIV 

#define ex_autosuspend_priv_init(padapter) 
#define ex_autosuspend_init(padapter) 
#define ex_autosuspend_deinit(padapter)
#define ex_autosuspend_enter(padapter) 
#define ex_autosuspend_connected_entry(padapter)  _FALSE
#define ex_autosuspend_cancel_nas_in_suspend(padapter,  message)  _FALSE
#define ex_autosuspend_suspend_end(padapter, ret_suspend)
#define ex_autosuspend_resume_end(padapter)
#define ex_autosuspend_sys_resume_end(padapter)


#define ex_autosuspend_leave(padapter)  _FALSE
#define ex_autoresume_entry_in_resume(padapter, b_resume_result) _FALSE
#define ex_autosuspend_cancel(padapter, bFromSystemCall) 
#define ex_autosuspend_cancel_cmd(padapter, bFromSystemCall) _FALSE
#define ex_autosuspend_switch(padapter, bBlockOn) 

#define ex_autosuspend_check_waitcnt(padapter) 
#define ex_autosuspend_check_netif_queue(padapter)
#define ex_autosuspend_check_autosuspend_status(padapter) 1
#define ex_autosuspend_check_tx_pkt_enqueue(padapter) _FALSE
#define ex_autosuspend_check_indicate_disconnect(padapter) 
#define ex_autosuspend_check_wow_reason(padapter) 
#define ex_autosuspend_intf_up_check_concurrent_state(padapter)
#define ex_autosuspend_intf_down_check_concurrent_state(padapter)
#define ex_autosuspend_watchdog_check_concurrent_state(padapter)

#define ex_autosuspend_set_not_xmitframe_fw_dl(padapter, method ) 
#define ex_autosuspend_set_check_period(value);
#define ex_autosuspend_dump_pm_cnt(dvobj, bdump) 0
#define ex_autosuspend_if_in_autosuspend(padapter)  _FALSE

#define ex_autosuspend_active_chk_alive(padapter) _TRUE
#define ex_autosuspend_revise_receive_bcn_count(padapter, pframe);
#define ex_autosuspend_revise_receive_probersp_count(padapter, pframe, packet_len);
#define ex_autosuspend_check_retry_probersp(padapter, pframe, packet_len) 0

#endif  /* CONFIG_AUTOSUSPEND */
#endif  /* !__RTW_AUTOSUSPEND_H__ */

