/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef _RTL8822BU_HAL_H_
#define _RTL8822BU_HAL_H_

#ifdef CONFIG_USB_HCI
	#include <drv_types.h>		/* PADAPTER */

	#ifdef CONFIG_USB_HCI
		#ifdef USB_PACKET_OFFSET_SZ
			#define PACKET_OFFSET_SZ (USB_PACKET_OFFSET_SZ)
		#else
			#define PACKET_OFFSET_SZ (8)
		#endif
		#define TXDESC_OFFSET (TXDESC_SIZE + PACKET_OFFSET_SZ)
	#endif

	/* undefine MAX_RECVBUF_SZ from rtl8822b_hal.h  */
	#ifdef MAX_RECVBUF_SZ
		#undef MAX_RECVBUF_SZ
	#endif

	/* recv_buffer must be large than usb agg size */
	#ifndef MAX_RECVBUF_SZ
		#ifndef CONFIG_MINIMAL_MEMORY_USAGE
			#ifdef CONFIG_PLATFORM_NOVATEK_NT72668
				#define MAX_RECVBUF_SZ (15360) /* 15k */
				#elif defined(CONFIG_PLATFORM_HISILICON)
				/* use 16k to workaround for HISILICON platform */
				#define MAX_RECVBUF_SZ (16384)
			#else
				#define MAX_RECVBUF_SZ (32768)
			#endif
		#else
			#define MAX_RECVBUF_SZ (4000)
		#endif
	#endif /* !MAX_RECVBUF_SZ */

	/* rtl8822bu_ops.c */
	void rtl8822bu_set_hal_ops(PADAPTER padapter);
	void rtl8822bu_set_hw_type(struct dvobj_priv *pdvobj);

	/* rtl8822bu_io.c */
	void rtl8822bu_set_intf_ops(struct _io_ops *pops);

#endif /* CONFIG_USB_HCI */


#endif /* _RTL8822BU_HAL_H_ */
