/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef __RTL8821A_SPEC_H__
#define __RTL8821A_SPEC_H__

#include <drv_conf.h>
/* This file should based on "hal_com_reg.h" */
#include <hal_com_reg.h>
/* Because 8812a and 8821a is the same serial,
 * most of 8821a register definitions are the same as 8812a. */
#include <rtl8812a_spec.h>


/* ************************************************************
 * 8821A Regsiter offset definition
 * ************************************************************ */

/* ************************************************************
 * MAC register
 * ************************************************************ */

/* -----------------------------------------------------
 *	0x0000h ~ 0x00FFh	System Configuration
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 *	0x0100h ~ 0x01FFh	MACTOP General Configuration
 * ----------------------------------------------------- */
#define REG_WOWLAN_WAKE_REASON          REG_MCUTST_WOWLAN

/* -----------------------------------------------------
 *	0x0200h ~ 0x027Fh	TXDMA Configuration
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 *	0x0280h ~ 0x02FFh	RXDMA Configuration
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 *	0x0300h ~ 0x03FFh	PCIe
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 *	0x0400h ~ 0x047Fh	Protocol Configuration
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 *	0x0500h ~ 0x05FFh	EDCA Configuration
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 *	0x0600h ~ 0x07FFh	WMAC Configuration
 * ----------------------------------------------------- */


/* ************************************************************
 * SDIO Bus Specification
 * ************************************************************ */

/* -----------------------------------------------------
 * SDIO CMD Address Mapping
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 * I/O bus domain (Host)
 * ----------------------------------------------------- */

/* -----------------------------------------------------
 * SDIO register
 * ----------------------------------------------------- */
#define SDIO_REG_FREE_TXPG2		0x024
#define SDIO_REG_HCPWM1_8821A	0x025

/* ************************************************************
 * Regsiter Bit and Content definition
 * ************************************************************ */

#endif /* __RTL8821A_SPEC_H__ */
