/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

/******************************************** CONST  ************************/
#define NUM_OF_REGISTER_BANK	13
#define NUM_OF_TOTAL_DWORD (NUM_OF_REGISTER_BANK * 64)
#define TOTAL_LEN_FOR_HIOE ((NUM_OF_TOTAL_DWORD + 1) * 8)
#define LPS_POFF_STATIC_FILE_LEN (TOTAL_LEN_FOR_HIOE + TXDESC_SIZE)
#define LPS_POFF_DYNAMIC_FILE_LEN	(512 + TXDESC_SIZE)
/******************************************** CONST  ************************/

/******************************************** MACRO   ************************/
/* HOIE Entry Definition */
#define SET_HOIE_ENTRY_LOW_DATA(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE),	0, 16, __Value)
#define SET_HOIE_ENTRY_HIGH_DATA(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE), 16, 16, __Value)
#define SET_HOIE_ENTRY_MODE_SELECT(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 0, 1, __Value)
#define SET_HOIE_ENTRY_ADDRESS(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 1, 14, __Value)
#define SET_HOIE_ENTRY_BYTE_MASK(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 15, 4, __Value)
#define SET_HOIE_ENTRY_IO_LOCK(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 19, 1, __Value)
#define SET_HOIE_ENTRY_RD_EN(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 20, 1, __Value)
#define SET_HOIE_ENTRY_WR_EN(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 21, 1, __Value)
#define SET_HOIE_ENTRY_RAW_RW(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 22, 1, __Value)
#define SET_HOIE_ENTRY_RAW(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 23, 1, __Value)
#define SET_HOIE_ENTRY_IO_DELAY(__pHOIE, __Value) \
	SET_BITS_TO_LE_4BYTE((__pHOIE)+4, 24, 8, __Value)

/*********************Function Definition*******************************************/
void rtl8723d_lps_poff_init(PADAPTER padapter);
void rtl8723d_lps_poff_deinit(PADAPTER padapter);
bool rtl8723d_lps_poff_get_txbndy_status(PADAPTER padapter);
void rtl8723d_lps_poff_h2c_ctrl(PADAPTER padapter, u8 enable);
void rtl8723d_lps_poff_set_ps_mode(PADAPTER padapter, bool bEnterLPS);
bool rtl8723d_lps_poff_get_status(PADAPTER padapter);
void rtl8723d_lps_poff_wow(PADAPTER padapter);
