/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef __HALBTC_WIFIONLY_H__
#define __HALBTC_WIFIONLY_H__

#include <drv_types.h>
#include <hal_data.h>

/* Define the ICs that support wifi only cfg in coex. codes */
#if defined(CONFIG_RTL8723B) || defined(CONFIG_RTL8822B) || defined(CONFIG_RTL8821C) || defined(CONFIG_RTL8822C)
#define CONFIG_BTCOEX_SUPPORT_WIFI_ONLY_CFG 1
#else
#define CONFIG_BTCOEX_SUPPORT_WIFI_ONLY_CFG 0
#endif

/* Define the ICs that support hal btc common file structure */
#if defined(CONFIG_RTL8822C)
#define CONFIG_BTCOEX_SUPPORT_BTC_CMN 1
#else
#define CONFIG_BTCOEX_SUPPORT_BTC_CMN 0
#endif

#if (CONFIG_BTCOEX_SUPPORT_WIFI_ONLY_CFG == 1)

typedef enum _WIFIONLY_CHIP_INTERFACE {
	WIFIONLY_INTF_UNKNOWN	= 0,
	WIFIONLY_INTF_PCI		= 1,
	WIFIONLY_INTF_USB		= 2,
	WIFIONLY_INTF_SDIO		= 3,
	WIFIONLY_INTF_MAX
} WIFIONLY_CHIP_INTERFACE, *PWIFIONLY_CHIP_INTERFACE;

typedef enum _WIFIONLY_CUSTOMER_ID {
	CUSTOMER_NORMAL			= 0,
	CUSTOMER_HP_1			= 1
} WIFIONLY_CUSTOMER_ID, *PWIFIONLY_CUSTOMER_ID;

struct wifi_only_haldata {
	u16		customer_id;
	u8		efuse_pg_antnum;
	u8		efuse_pg_antpath;
	u8		rfe_type;
	u8		ant_div_cfg;
};

struct wifi_only_cfg {
	void *Adapter;
	struct wifi_only_haldata	haldata_info;
	WIFIONLY_CHIP_INTERFACE	chip_interface;
};

void halwifionly_write1byte(void *pwifionlyContext, u32 RegAddr, u8 Data);
void halwifionly_write2byte(void *pwifionlyContext, u32 RegAddr, u16 Data);
void halwifionly_write4byte(void *pwifionlyContext, u32 RegAddr, u32 Data);
u8 halwifionly_read1byte(void *pwifionlyContext, u32 RegAddr);
u16 halwifionly_read2byte(void *pwifionlyContext, u32 RegAddr);
u32 halwifionly_read4byte(void *pwifionlyContext, u32 RegAddr);
void halwifionly_bitmaskwrite1byte(void *pwifionlyContext, u32 regAddr, u8 bitMask, u8 data);
void halwifionly_phy_set_rf_reg(void *pwifionlyContext, enum rf_path eRFPath, u32 RegAddr, u32 BitMask, u32 Data);
void halwifionly_phy_set_bb_reg(void *pwifionlyContext, u32 RegAddr, u32 BitMask, u32 Data);
void hal_btcoex_wifionly_switchband_notify(PADAPTER padapter);
void hal_btcoex_wifionly_scan_notify(PADAPTER padapter);
void hal_btcoex_wifionly_connect_notify(PADAPTER padapter);
void hal_btcoex_wifionly_hw_config(PADAPTER padapter);
void hal_btcoex_wifionly_initlizevariables(PADAPTER padapter);
void hal_btcoex_wifionly_AntInfoSetting(PADAPTER padapter);
#else
#define hal_btcoex_wifionly_switchband_notify(padapter)
#define hal_btcoex_wifionly_scan_notify(padapter)
#define hal_btcoex_wifionly_connect_notify(padapter)
#define hal_btcoex_wifionly_hw_config(padapter)
#define hal_btcoex_wifionly_initlizevariables(padapter)
#define hal_btcoex_wifionly_AntInfoSetting(padapter)
#endif

#endif
