/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef __DRV_TYPES_CE_H__
#define __DRV_TYPES_CE_H__

#include <drv_conf.h>
#include <osdep_service.h>

#include <Sdcardddk.h>

#define MAX_ACTIVE_REG_PATH 256

#define MAX_MCAST_LIST_NUM					32



/* for ioctl */
#define MAKE_DRIVER_VERSION(_MainVer, _MinorVer)	((((u32)(_MainVer))<<16)+_MinorVer)

#define NIC_HEADER_SIZE				14			/* !< can be moved to typedef.h */
#define NIC_MAX_PACKET_SIZE			1514		/* !< can be moved to typedef.h */
#define NIC_MAX_SEND_PACKETS			10		/* max number of send packets the MiniportSendPackets function can accept, can be moved to typedef.h */
#define NIC_VENDOR_DRIVER_VERSION       MAKE_DRIVER_VERSION(0, 001)	/* !< can be moved to typedef.h */
#define NIC_MAX_PACKET_SIZE			1514		/* !< can be moved to typedef.h */

typedef struct _MP_REG_ENTRY {

	NDIS_STRING		RegName;	/* variable name text */
	BOOLEAN			bRequired;	/* 1->required, 0->optional */

	u8			Type;		/* NdisParameterInteger/NdisParameterHexInteger/NdisParameterStringle/NdisParameterMultiString */
	uint			FieldOffset;	/* offset to MP_ADAPTER field */
	uint			FieldSize;	/* size (in bytes) of the field */

#ifdef UNDER_AMD64
	u64			Default;
#else
	u32			Default;		/* default value to use */
#endif

	u32			Min;			/* minimum value allowed */
	u32			Max;		/* maximum value allowed */
} MP_REG_ENTRY, *PMP_REG_ENTRY;

#ifdef CONFIG_USB_HCI
typedef struct _USB_EXTENSION {
	LPCUSB_FUNCS    _lpUsbFuncs;
	USB_HANDLE	    _hDevice;
	PVOID		    pAdapter;

#if 0
	USB_ENDPOINT_DESCRIPTOR		_endpACLIn;
	USB_ENDPOINT_DESCRIPTOR		_endpACLOutHigh;
	USB_ENDPOINT_DESCRIPTOR		_endpACLOutNormal;

	USB_PIPE        pPipeIn;
	USB_PIPE        pPipeOutNormal;
	USB_PIPE        pPipeOutHigh;
#endif

} USB_EXTENSION, *PUSB_EXTENSION;
#endif


typedef struct _OCTET_STRING {
	u8      *Octet;
	u16      Length;
} OCTET_STRING, *POCTET_STRING;





#endif
