/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef _LINUX_BYTEORDER_SWABB_H
#define _LINUX_BYTEORDER_SWABB_H

/*
 * linux/byteorder/swabb.h
 * SWAp Bytes Bizarrely
 *	swaHHXX[ps]?(foo)
 *
 * Support for obNUXIous pdp-endian and other bizarre architectures.
 * Will Linux ever run on such ancient beasts? if not, this file
 * will be but a programming pearl. Still, it's a reminder that we
 * shouldn't be making too many assumptions when trying to be portable.
 *
 */

/*
 * Meaning of the names I chose (vaxlinux people feel free to correct them):
 * swahw32	swap 16-bit half-words in a 32-bit word
 * swahb32	swap 8-bit halves of each 16-bit half-word in a 32-bit word
 *
 * No 64-bit support yet. I don't know NUXI conventions for long longs.
 * I guarantee it will be a mess when it's there, though :->
 * It will be even worse if there are conflicting 64-bit conventions.
 * Hopefully, no one ever used 64-bit objects on NUXI machines.
 *
 */

#define ___swahw32(x) \
	({ \
		__u32 __x = (x); \
		((__u32)(\
			 (((__u32)(__x) & (__u32)0x0000ffffUL) << 16) | \
			 (((__u32)(__x) & (__u32)0xffff0000UL) >> 16))); \
	})
#define ___swahb32(x) \
	({ \
		__u32 __x = (x); \
		((__u32)(\
			 (((__u32)(__x) & (__u32)0x00ff00ffUL) << 8) | \
			 (((__u32)(__x) & (__u32)0xff00ff00UL) >> 8))); \
	})

#define ___constant_swahw32(x) \
	((__u32)(\
		 (((__u32)(x) & (__u32)0x0000ffffUL) << 16) | \
		 (((__u32)(x) & (__u32)0xffff0000UL) >> 16)))
#define ___constant_swahb32(x) \
	((__u32)(\
		 (((__u32)(x) & (__u32)0x00ff00ffUL) << 8) | \
		 (((__u32)(x) & (__u32)0xff00ff00UL) >> 8)))

/*
 * provide defaults when no architecture-specific optimization is detected
 */
#ifndef __arch__swahw32
	#define __arch__swahw32(x) ___swahw32(x)
#endif
#ifndef __arch__swahb32
	#define __arch__swahb32(x) ___swahb32(x)
#endif

#ifndef __arch__swahw32p
	#define __arch__swahw32p(x) __swahw32(*(x))
#endif
#ifndef __arch__swahb32p
	#define __arch__swahb32p(x) __swahb32(*(x))
#endif

#ifndef __arch__swahw32s
	#define __arch__swahw32s(x) do { *(x) = __swahw32p((x)); } while (0)
#endif
#ifndef __arch__swahb32s
	#define __arch__swahb32s(x) do { *(x) = __swahb32p((x)); } while (0)
#endif


/*
 * Allow constant folding
 */
#if defined(__GNUC__) && (__GNUC__ >= 2) && defined(__OPTIMIZE__)
#  define __swahw32(x) \
	(__builtin_constant_p((__u32)(x)) ? \
	 ___swahw32((x)) : \
	 __fswahw32((x)))
#  define __swahb32(x) \
	(__builtin_constant_p((__u32)(x)) ? \
	 ___swahb32((x)) : \
	 __fswahb32((x)))
#else
#  define __swahw32(x) __fswahw32(x)
#  define __swahb32(x) __fswahb32(x)
#endif /* OPTIMIZE */


__inline static__ __const__ __u32 __fswahw32(__u32 x)
{
	return __arch__swahw32(x);
}
__inline static__ __u32 __swahw32p(__u32 *x)
{
	return __arch__swahw32p(x);
}
__inline static__ void __swahw32s(__u32 *addr)
{
	__arch__swahw32s(addr);
}


__inline static__ __const__ __u32 __fswahb32(__u32 x)
{
	return __arch__swahb32(x);
}
__inline static__ __u32 __swahb32p(__u32 *x)
{
	return __arch__swahb32p(x);
}
__inline static__ void __swahb32s(__u32 *addr)
{
	__arch__swahb32s(addr);
}

#ifdef __BYTEORDER_HAS_U64__
	/*
	* Not supported yet
	*/
#endif /* __BYTEORDER_HAS_U64__ */

#if defined(PLATFORM_LINUX)
	#define swahw32 __swahw32
	#define swahb32 __swahb32
	#define swahw32p __swahw32p
	#define swahb32p __swahb32p
	#define swahw32s __swahw32s
	#define swahb32s __swahb32s
#endif

#endif /* _LINUX_BYTEORDER_SWABB_H */
