/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef _LINUX_BYTEORDER_SWAB_H
#define _LINUX_BYTEORDER_SWAB_H

#if !defined(CONFIG_PLATFORM_MSTAR)
#ifndef __u16
	typedef unsigned short __u16;
#endif

#ifndef __u32
	typedef unsigned int	__u32;
#endif

#ifndef __u8
	typedef unsigned char __u8;
#endif

#ifndef __u64
	typedef unsigned long long	__u64;
#endif


__inline static __u16  ___swab16(__u16 x)
{
	__u16 __x = x;
	return
		 (__u16)(
			 (((__u16)(__x)&(__u16)0x00ffU) << 8) |
			 (((__u16)(__x)&(__u16)0xff00U) >> 8));

}

__inline static __u32  ___swab32(__u32 x)
{
	__u32 __x = (x);
	return  (__u32)(
			(((__u32)(__x)&(__u32)0x000000ffUL) << 24) |
			(((__u32)(__x)&(__u32)0x0000ff00UL) <<  8) |
			(((__u32)(__x)&(__u32)0x00ff0000UL) >>  8) |
			(((__u32)(__x)&(__u32)0xff000000UL) >> 24));
}

__inline static __u64  ___swab64(__u64 x)
{
	__u64 __x = (x);

	return
		 (__u64)(\
		 (__u64)(((__u64)(__x)&(__u64)0x00000000000000ffULL) << 56) | \
		 (__u64)(((__u64)(__x)&(__u64)0x000000000000ff00ULL) << 40) | \
		 (__u64)(((__u64)(__x)&(__u64)0x0000000000ff0000ULL) << 24) | \
		 (__u64)(((__u64)(__x)&(__u64)0x00000000ff000000ULL) <<  8) | \
		 (__u64)(((__u64)(__x)&(__u64)0x000000ff00000000ULL) >>  8) | \
		 (__u64)(((__u64)(__x)&(__u64)0x0000ff0000000000ULL) >> 24) | \
		 (__u64)(((__u64)(__x)&(__u64)0x00ff000000000000ULL) >> 40) | \
		 (__u64)(((__u64)(__x)&(__u64)0xff00000000000000ULL) >> 56));
	\
}
#endif /* CONFIG_PLATFORM_MSTAR */

#ifndef __arch__swab16
__inline static __u16 __arch__swab16(__u16 x)
{
	return ___swab16(x);
}

#endif

#ifndef __arch__swab32
__inline static __u32 __arch__swab32(__u32 x)
{
	__u32 __tmp = (x) ;
	return ___swab32(__tmp);
}
#endif

#ifndef __arch__swab64

__inline static __u64 __arch__swab64(__u64 x)
{
	__u64 __tmp = (x) ;
	return ___swab64(__tmp);
}


#endif

#ifndef __swab16
	#define __swab16(x) __fswab16(x)
	#define __swab32(x) __fswab32(x)
	#define __swab64(x) __fswab64(x)
#endif /* __swab16 */

#ifdef PLATFORM_FREEBSD
	__inline static __u16 __fswab16(__u16 x)
#else
	__inline static const __u16 __fswab16(__u16 x)
#endif /* PLATFORM_FREEBSD */
{
	return __arch__swab16(x);
}
#ifdef PLATFORM_FREEBSD
	__inline static __u32 __fswab32(__u32 x)
#else
	__inline static const __u32 __fswab32(__u32 x)
#endif /* PLATFORM_FREEBSD */
{
	return __arch__swab32(x);
}

#if defined(PLATFORM_LINUX) || defined(PLATFORM_WINDOWS)
	#define swab16 __swab16
	#define swab32 __swab32
	#define swab64 __swab64
	#define swab16p __swab16p
	#define swab32p __swab32p
	#define swab64p __swab64p
	#define swab16s __swab16s
	#define swab32s __swab32s
	#define swab64s __swab64s
#endif

#endif /* _LINUX_BYTEORDER_SWAB_H */
