/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#define _RTL8821CU_LED_C_

#include <drv_types.h>		/* PADAPTER */
#include <hal_data.h>		/* PHAL_DATA_TYPE */
#include <hal_com_led.h>	/* PLED_USB */
#include "../../hal_halmac.h" /* HALMAC API */
#ifdef CONFIG_RTW_SW_LED

/*
 * =============================================================================
 * LED object.
 * =============================================================================
 */


/*
 * =============================================================================
 * Prototype of protected function.
 * =============================================================================
 */

/*
 * =============================================================================
 * LED routines.
 * =============================================================================
 */

/*
 * Description:
 * Turn on LED according to LedPin specified.
 */
static void swledon(PADAPTER padapter, PLED_USB led)
{
	PHAL_DATA_TYPE hal = GET_HAL_DATA(padapter);

	if (RTW_CANNOT_RUN(padapter))
		return;

	switch (led->LedPin) {
	case LED_PIN_GPIO0:
		break;
	case LED_PIN_LED0:
	case LED_PIN_LED1:
	case LED_PIN_LED2:
	default:
		rtw_halmac_led_switch(adapter_to_dvobj(padapter), 1);
		break;
	}

	led->bLedOn = _TRUE;
}


/*
 * Description:
 * Turn off LED according to LedPin specified.
 */
static void swledoff(PADAPTER padapter, PLED_USB led)
{
	PHAL_DATA_TYPE hal = GET_HAL_DATA(padapter);

	if (RTW_CANNOT_RUN(padapter))
		return;

	switch (led->LedPin) {
	case LED_PIN_GPIO0:
		break;
	case LED_PIN_LED0:
	case LED_PIN_LED1:
	case LED_PIN_LED2:
	default:
		rtw_halmac_led_switch(adapter_to_dvobj(padapter), 0);
		break;
	}

	led->bLedOn = _FALSE;
}

/*
 * =============================================================================
 * Interface to manipulate LED objects.
 * =============================================================================
 */

/*
 * =============================================================================
 * Default LED behavior.
 * =============================================================================
 */

/*
 * Description:
 * Initialize all LED_871x objects.
 */
void rtl8821cu_initswleds(PADAPTER padapter)
{
	struct led_priv *ledpriv = adapter_to_led(padapter);
	u8 enable = 1;
	u8 mode = 3;

	ledpriv->LedControlHandler = LedControlUSB;
	ledpriv->SwLedOn = swledon;
	ledpriv->SwLedOff = swledoff;

	InitLed(padapter, &(ledpriv->SwLed0), LED_PIN_LED0);
	InitLed(padapter, &(ledpriv->SwLed1), LED_PIN_LED1);
	InitLed(padapter, &(ledpriv->SwLed2), LED_PIN_LED2);

	rtw_halmac_led_cfg(adapter_to_dvobj(padapter), enable, mode);
}

/*
 * Description:
 * DeInitialize all LED_819xUsb objects.
 */
void rtl8821cu_deinitswleds(PADAPTER padapter)
{
	struct led_priv *ledpriv = adapter_to_led(padapter);
	u8 enable = 0;
	u8 mode = 3;

	DeInitLed(&(ledpriv->SwLed0));
	DeInitLed(&(ledpriv->SwLed1));
	DeInitLed(&(ledpriv->SwLed2));

	rtw_halmac_led_cfg(adapter_to_dvobj(padapter), enable, mode);
}
#endif
