/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef _RTL8821CU_H_
#define _RTL8821CU_H_

#include <drv_types.h>		/* PADAPTER, basic_types.h, rtw_xmit.h and etc. */

#define USB_AGG_EN_8821C			BIT(7)

#ifdef CONFIG_LPS_LCLK
/* for CONFIG_LPS_LCLK setting in rtl8821cu_ops.c */
#define REG_USB_HRPWM_8821C		0xFE58
#define REG_USB_HCPWM_8821C		0xFE57
#endif /* CONFIG_LPS_LCLK */

/* rtl8821cu_halinit.c */
u32 rtl8821cu_hal_init(PADAPTER);
u32 rtl8821cu_hal_deinit(PADAPTER);
u32 rtl8821cu_inirp_init(PADAPTER);
u32 rtl8821cu_inirp_deinit(PADAPTER);
void rtl8821cu_interface_configure(PADAPTER);

/* rtl8821cu_halmac.c */
int rtl8821cu_halmac_init_adapter(PADAPTER);

/* rtl8821cu_io.c */

/* rtl8821cu_led.c */
void rtl8821cu_initswleds(PADAPTER);
void rtl8821cu_deinitswleds(PADAPTER);

/* rtl8821cu_xmit.c */
#define OFFSET_SZ 0
#define MAX_TX_AGG_PACKET_NUMBER_8821C 0xff

s32 rtl8821cu_init_xmit_priv(PADAPTER);
void rtl8821cu_free_xmit_priv(PADAPTER);
s32 rtl8821cu_mgnt_xmit(PADAPTER, struct xmit_frame *);
s32 rtl8821cu_hal_xmit(PADAPTER, struct xmit_frame *);
s32 rtl8821cu_hal_xmitframe_enqueue(PADAPTER, struct xmit_frame *);
s32 rtl8821cu_hostap_mgnt_xmit_entry(PADAPTER, _pkt *);
#ifdef CONFIG_XMIT_THREAD_MODE
s32 rtl8821cu_xmit_buf_handler(PADAPTER padapter);
#endif /* CONFIG_XMIT_THREAD_MODE */

/* rtl8821cu_recv.c */
int rtl8821cu_init_recv_priv(PADAPTER);
void rtl8821cu_free_recv_priv(PADAPTER);

#endif /* _RTL8821CU_H_ */
