/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/
#ifndef __PHYDM_HAL_TXBF_API_H__
#define __PHYDM_HAL_TXBF_API_H__

#if (defined(CONFIG_BB_TXBF_API))

#if (DM_ODM_SUPPORT_TYPE != ODM_AP)
#if defined(DM_ODM_CE_MAC80211)
#define tx_bf_nr(a, b) ({	\
	u8 __tx_bf_nr_a = (a);	\
	u8 __tx_bf_nr_b = (b);	\
	((__tx_bf_nr_a > __tx_bf_nr_b) ? (__tx_bf_nr_b) : (__tx_bf_nr_a)); })
#else
#define tx_bf_nr(a, b) ((a > b) ? (b) : (a))
#endif

u8 beamforming_get_htndp_tx_rate(void *dm_void, u8 bfer_str_num);

u8 beamforming_get_vht_ndp_tx_rate(void *dm_void, u8 bfer_str_num);

#endif

#if (RTL8822B_SUPPORT == 1 || RTL8822C_SUPPORT == 1 || RTL8192F_SUPPORT == 1 ||\
	RTL8814B_SUPPORT == 1 || RTL8198F_SUPPORT == 1)

u8 phydm_get_beamforming_sounding_info(void *dm_void, u16 *throughput,
				       u8 total_bfee_num, u8 *tx_rate);
u8 phydm_get_ndpa_rate(void *dm_void);

u8 phydm_get_mu_bfee_snding_decision(void *dm_void, u16 throughput);

#else
#define phydm_get_beamforming_sounding_info(dm, tp, bfee_num, rate) 0
#define phydm_get_ndpa_rate(dm)
#define phydm_get_mu_bfee_snding_decision(dm, tp)

#endif

#ifdef PHYDM_IC_JGR3_SERIES_SUPPORT
struct phydm_bf_rate_info_jgr3 {
	u8			enable;
	u8			mu_ratio_th;
	u32			pre_mu_ratio;
	u16			num_mu_vht_pkt[VHT_RATE_NUM];
	u16			num_qry_vht_pkt[VHT_RATE_NUM];
};

/*this function is only used for BFer*/
void phydm_txbf_rfmode(void *dm_void, u8 su_bfee_cnt, u8 mu_bfee_cnt);
void phydm_txbf_avoid_hang(void *dm_void);
void phydm_mu_rsoml_init(void *dm_void);
void phydm_mu_rsoml_decision(void *dm_void);

#if (RTL8814B_SUPPORT == 1)
void phydm_txbf_80p80_rfmode(void *dm_void, u8 su_bfee_cnt, u8 mu_bfee_cnt);
#endif

#endif /*#PHYDM_IC_JGR3_SERIES_SUPPORT*/
void phydm_bf_debug(void *dm_void, char input[][16], u32 *_used, char *output,
		    u32 *_out_len);
#endif
#endif
