/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

/*Image2HeaderVersion: R3 1.5.8*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8821C_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8821c_agc_tab[] = {
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xE52C0003,
		0x81C, 0xE42E0003,
		0x81C, 0xE3300003,
		0x81C, 0xE2320003,
		0x81C, 0xE1340003,
		0x81C, 0xC4360003,
		0x81C, 0xC3380003,
		0x81C, 0xC23A0003,
		0x81C, 0xC13C0003,
		0x81C, 0x883E0003,
		0x81C, 0x87400003,
		0x81C, 0x86420003,
		0x81C, 0x85440003,
		0x81C, 0x84460003,
		0x81C, 0x83480003,
		0x81C, 0x824A0003,
		0x81C, 0x814C0003,
		0x81C, 0x804E0003,
		0x81C, 0x64500003,
		0x81C, 0x63520003,
		0x81C, 0x62540003,
		0x81C, 0x61560003,
		0x81C, 0x60580003,
		0x81C, 0x475A0003,
		0x81C, 0x465C0003,
		0x81C, 0x455E0003,
		0x81C, 0x44600003,
		0x81C, 0x43620003,
		0x81C, 0x42640003,
		0x81C, 0x41660003,
		0x81C, 0x40680003,
		0x81C, 0x236A0003,
		0x81C, 0x226C0003,
		0x81C, 0x056E0003,
		0x81C, 0x04700003,
		0x81C, 0x03720003,
		0x81C, 0x02740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xE52C0003,
		0x81C, 0xE42E0003,
		0x81C, 0xE3300003,
		0x81C, 0xE2320003,
		0x81C, 0xE1340003,
		0x81C, 0xC4360003,
		0x81C, 0xC3380003,
		0x81C, 0xC23A0003,
		0x81C, 0xC13C0003,
		0x81C, 0x883E0003,
		0x81C, 0x87400003,
		0x81C, 0x86420003,
		0x81C, 0x85440003,
		0x81C, 0x84460003,
		0x81C, 0x83480003,
		0x81C, 0x824A0003,
		0x81C, 0x814C0003,
		0x81C, 0x804E0003,
		0x81C, 0x64500003,
		0x81C, 0x63520003,
		0x81C, 0x62540003,
		0x81C, 0x61560003,
		0x81C, 0x60580003,
		0x81C, 0x475A0003,
		0x81C, 0x465C0003,
		0x81C, 0x455E0003,
		0x81C, 0x44600003,
		0x81C, 0x43620003,
		0x81C, 0x42640003,
		0x81C, 0x41660003,
		0x81C, 0x40680003,
		0x81C, 0x236A0003,
		0x81C, 0x226C0003,
		0x81C, 0x056E0003,
		0x81C, 0x04700003,
		0x81C, 0x03720003,
		0x81C, 0x02740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
	0xA0000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xCA2C0003,
		0x81C, 0xC92E0003,
		0x81C, 0xC8300003,
		0x81C, 0xC7320003,
		0x81C, 0xC6340003,
		0x81C, 0xC5360003,
		0x81C, 0xC4380003,
		0x81C, 0xC33A0003,
		0x81C, 0xC23C0003,
		0x81C, 0xC13E0003,
		0x81C, 0x88400003,
		0x81C, 0x87420003,
		0x81C, 0x86440003,
		0x81C, 0x85460003,
		0x81C, 0x84480003,
		0x81C, 0x834A0003,
		0x81C, 0x674C0003,
		0x81C, 0x664E0003,
		0x81C, 0x65500003,
		0x81C, 0x64520003,
		0x81C, 0x63540003,
		0x81C, 0x62560003,
		0x81C, 0x61580003,
		0x81C, 0x455A0003,
		0x81C, 0x445C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x25640003,
		0x81C, 0x24660003,
		0x81C, 0x23680003,
		0x81C, 0x226A0003,
		0x81C, 0x216C0003,
		0x81C, 0x016E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
	0xB0000000,	0x00000000,
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xE72C0103,
		0x81C, 0xE62E0103,
		0x81C, 0xE5300103,
		0x81C, 0xE4320103,
		0x81C, 0xE3340103,
		0x81C, 0xE2360103,
		0x81C, 0xE1380103,
		0x81C, 0xE03A0103,
		0x81C, 0xC33C0103,
		0x81C, 0xC23E0103,
		0x81C, 0xC1400103,
		0x81C, 0xC0420103,
		0x81C, 0xA3440103,
		0x81C, 0xA2460103,
		0x81C, 0xA1480103,
		0x81C, 0xA04A0103,
		0x81C, 0x824C0103,
		0x81C, 0x814E0103,
		0x81C, 0x80500103,
		0x81C, 0x62520103,
		0x81C, 0x61540103,
		0x81C, 0x60560103,
		0x81C, 0x24580103,
		0x81C, 0x235A0103,
		0x81C, 0x225C0103,
		0x81C, 0x215E0103,
		0x81C, 0x20600103,
		0x81C, 0x03620103,
		0x81C, 0x02640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF6000103,
		0x81C, 0xF5020103,
		0x81C, 0xF4040103,
		0x81C, 0xF3060103,
		0x81C, 0xF2080103,
		0x81C, 0xF10A0103,
		0x81C, 0xF00C0103,
		0x81C, 0xEF0E0103,
		0x81C, 0xEE100103,
		0x81C, 0xED120103,
		0x81C, 0xEC140103,
		0x81C, 0xCE160103,
		0x81C, 0xEA180103,
		0x81C, 0xE91A0103,
		0x81C, 0xE81C0103,
		0x81C, 0xE71E0103,
		0x81C, 0xE6200103,
		0x81C, 0xE5220103,
		0x81C, 0xE4240103,
		0x81C, 0xE3260103,
		0x81C, 0xE2280103,
		0x81C, 0xE12A0103,
		0x81C, 0xC32C0103,
		0x81C, 0xA62E0103,
		0x81C, 0xC1300103,
		0x81C, 0xA4320103,
		0x81C, 0xA3340103,
		0x81C, 0xA2360103,
		0x81C, 0xA1380103,
		0x81C, 0x833A0103,
		0x81C, 0x823C0103,
		0x81C, 0x813E0103,
		0x81C, 0x63400103,
		0x81C, 0x62420103,
		0x81C, 0x61440103,
		0x81C, 0x60460103,
		0x81C, 0x25480103,
		0x81C, 0x244A0103,
		0x81C, 0x234C0103,
		0x81C, 0x064E0103,
		0x81C, 0x21500103,
		0x81C, 0x04520103,
		0x81C, 0x03540103,
		0x81C, 0x02560103,
		0x81C, 0x01580103,
		0x81C, 0x005A0103,
		0x81C, 0x005C0103,
		0x81C, 0x005E0103,
		0x81C, 0x00600103,
		0x81C, 0x00620103,
		0x81C, 0x00640103,
		0x81C, 0x00660103,
		0x81C, 0x00680103,
		0x81C, 0x006A0103,
		0x81C, 0x006C0103,
		0x81C, 0x006E0103,
		0x81C, 0x00700103,
		0x81C, 0x00720103,
		0x81C, 0x00740103,
		0x81C, 0x00760103,
		0x81C, 0x00780103,
		0x81C, 0x007A0103,
		0x81C, 0x007C0103,
		0x81C, 0x007E0103,
	0xA0000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xE72C0103,
		0x81C, 0xE62E0103,
		0x81C, 0xE5300103,
		0x81C, 0xE4320103,
		0x81C, 0xE3340103,
		0x81C, 0xE2360103,
		0x81C, 0xE1380103,
		0x81C, 0xE03A0103,
		0x81C, 0xA83C0103,
		0x81C, 0xA73E0103,
		0x81C, 0xA6400103,
		0x81C, 0xA5420103,
		0x81C, 0xA4440103,
		0x81C, 0xA3460103,
		0x81C, 0xA2480103,
		0x81C, 0xA14A0103,
		0x81C, 0x834C0103,
		0x81C, 0x824E0103,
		0x81C, 0x81500103,
		0x81C, 0x63520103,
		0x81C, 0x62540103,
		0x81C, 0x61560103,
		0x81C, 0x25580103,
		0x81C, 0x245A0103,
		0x81C, 0x235C0103,
		0x81C, 0x225E0103,
		0x81C, 0x04600103,
		0x81C, 0x03620103,
		0x81C, 0x02640103,
		0x81C, 0x01660103,
		0x81C, 0x01680103,
		0x81C, 0x016A0103,
		0x81C, 0x016C0103,
		0x81C, 0x016E0103,
		0x81C, 0x01700103,
		0x81C, 0x01720103,
		0x81C, 0x01740103,
		0x81C, 0x01760103,
		0x81C, 0x01780103,
		0x81C, 0x017A0103,
		0x81C, 0x017C0103,
		0x81C, 0x017E0103,
	0xB0000000,	0x00000000,
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000203,
		0x81C, 0xFA020203,
		0x81C, 0xF9040203,
		0x81C, 0xF8060203,
		0x81C, 0xF7080203,
		0x81C, 0xF60A0203,
		0x81C, 0xF50C0203,
		0x81C, 0xF40E0203,
		0x81C, 0xF3100203,
		0x81C, 0xF2120203,
		0x81C, 0xF1140203,
		0x81C, 0xF0160203,
		0x81C, 0xEF180203,
		0x81C, 0xEE1A0203,
		0x81C, 0xED1C0203,
		0x81C, 0xEC1E0203,
		0x81C, 0xEB200203,
		0x81C, 0xEA220203,
		0x81C, 0xE9240203,
		0x81C, 0xE8260203,
		0x81C, 0xE7280203,
		0x81C, 0xE62A0203,
		0x81C, 0xE52C0203,
		0x81C, 0xE42E0203,
		0x81C, 0xE3300203,
		0x81C, 0xE2320203,
		0x81C, 0xE1340203,
		0x81C, 0xC5360203,
		0x81C, 0xC4380203,
		0x81C, 0xC33A0203,
		0x81C, 0xC23C0203,
		0x81C, 0xC13E0203,
		0x81C, 0xA4400203,
		0x81C, 0xA3420203,
		0x81C, 0xA2440203,
		0x81C, 0xA1460203,
		0x81C, 0xA0480203,
		0x81C, 0x834A0203,
		0x81C, 0x824C0203,
		0x81C, 0x814E0203,
		0x81C, 0x63500203,
		0x81C, 0x62520203,
		0x81C, 0x61540203,
		0x81C, 0x60560203,
		0x81C, 0x23580203,
		0x81C, 0x225A0203,
		0x81C, 0x215C0203,
		0x81C, 0x205E0203,
		0x81C, 0x04600203,
		0x81C, 0x03620203,
		0x81C, 0x02640203,
		0x81C, 0x01660203,
		0x81C, 0x01680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF6000203,
		0x81C, 0xF5020203,
		0x81C, 0xF4040203,
		0x81C, 0xF3060203,
		0x81C, 0xF2080203,
		0x81C, 0xF10A0203,
		0x81C, 0xF00C0203,
		0x81C, 0xEF0E0203,
		0x81C, 0xEE100203,
		0x81C, 0xED120203,
		0x81C, 0xEC140203,
		0x81C, 0xEB160203,
		0x81C, 0xEA180203,
		0x81C, 0xE91A0203,
		0x81C, 0xE81C0203,
		0x81C, 0xE71E0203,
		0x81C, 0xE6200203,
		0x81C, 0xE5220203,
		0x81C, 0xE4240203,
		0x81C, 0xE3260203,
		0x81C, 0xE2280203,
		0x81C, 0xE12A0203,
		0x81C, 0xE02C0203,
		0x81C, 0xC22E0203,
		0x81C, 0xC1300203,
		0x81C, 0xC0320203,
		0x81C, 0xA3340203,
		0x81C, 0xA2360203,
		0x81C, 0xA1380203,
		0x81C, 0xA03A0203,
		0x81C, 0x833C0203,
		0x81C, 0x823E0203,
		0x81C, 0x81400203,
		0x81C, 0x80420203,
		0x81C, 0x62440203,
		0x81C, 0x61460203,
		0x81C, 0x42480203,
		0x81C, 0x414A0203,
		0x81C, 0x234C0203,
		0x81C, 0x224E0203,
		0x81C, 0x21500203,
		0x81C, 0x20520203,
		0x81C, 0x03540203,
		0x81C, 0x02560203,
		0x81C, 0x01580203,
		0x81C, 0x005A0203,
		0x81C, 0x005C0203,
		0x81C, 0x005E0203,
		0x81C, 0x00600203,
		0x81C, 0x00620203,
		0x81C, 0x00640203,
		0x81C, 0x00660203,
		0x81C, 0x00680203,
		0x81C, 0x006A0203,
		0x81C, 0x006C0203,
		0x81C, 0x006E0203,
		0x81C, 0x00700203,
		0x81C, 0x00720203,
		0x81C, 0x00740203,
		0x81C, 0x00760203,
		0x81C, 0x00780203,
		0x81C, 0x007A0203,
		0x81C, 0x007C0203,
		0x81C, 0x007E0203,
	0xA0000000,	0x00000000,
		0x81C, 0xFC000203,
		0x81C, 0xFB020203,
		0x81C, 0xFA040203,
		0x81C, 0xF9060203,
		0x81C, 0xF8080203,
		0x81C, 0xF70A0203,
		0x81C, 0xF60C0203,
		0x81C, 0xF50E0203,
		0x81C, 0xF4100203,
		0x81C, 0xF3120203,
		0x81C, 0xF2140203,
		0x81C, 0xF1160203,
		0x81C, 0xF0180203,
		0x81C, 0xEF1A0203,
		0x81C, 0xEE1C0203,
		0x81C, 0xED1E0203,
		0x81C, 0xEC200203,
		0x81C, 0xEB220203,
		0x81C, 0xEA240203,
		0x81C, 0xE9260203,
		0x81C, 0xE8280203,
		0x81C, 0xE72A0203,
		0x81C, 0xE62C0203,
		0x81C, 0xE52E0203,
		0x81C, 0xE4300203,
		0x81C, 0xE3320203,
		0x81C, 0xE2340203,
		0x81C, 0xE1360203,
		0x81C, 0xC5380203,
		0x81C, 0xC43A0203,
		0x81C, 0xC33C0203,
		0x81C, 0xC23E0203,
		0x81C, 0xA6400203,
		0x81C, 0xA5420203,
		0x81C, 0xA4440203,
		0x81C, 0xA3460203,
		0x81C, 0xA2480203,
		0x81C, 0x844A0203,
		0x81C, 0x834C0203,
		0x81C, 0x824E0203,
		0x81C, 0x64500203,
		0x81C, 0x63520203,
		0x81C, 0x62540203,
		0x81C, 0x61560203,
		0x81C, 0x60580203,
		0x81C, 0x235A0203,
		0x81C, 0x225C0203,
		0x81C, 0x215E0203,
		0x81C, 0x04600203,
		0x81C, 0x03620203,
		0x81C, 0x02640203,
		0x81C, 0x01660203,
		0x81C, 0x01680203,
		0x81C, 0x016A0203,
		0x81C, 0x016C0203,
		0x81C, 0x016E0203,
		0x81C, 0x01700203,
		0x81C, 0x01720203,
		0x81C, 0x01740203,
		0x81C, 0x01760203,
		0x81C, 0x01780203,
		0x81C, 0x017A0203,
		0x81C, 0x017C0203,
		0x81C, 0x017E0203,
	0xB0000000,	0x00000000,
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xF0160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xE52C0303,
		0x81C, 0xE42E0303,
		0x81C, 0xE3300303,
		0x81C, 0xE2320303,
		0x81C, 0xE1340303,
		0x81C, 0xC4360303,
		0x81C, 0xC3380303,
		0x81C, 0xC23A0303,
		0x81C, 0xC13C0303,
		0x81C, 0xA53E0303,
		0x81C, 0xA4400303,
		0x81C, 0xA3420303,
		0x81C, 0xA2440303,
		0x81C, 0xA1460303,
		0x81C, 0x83480303,
		0x81C, 0x824A0303,
		0x81C, 0x814C0303,
		0x81C, 0x644E0303,
		0x81C, 0x63500303,
		0x81C, 0x62520303,
		0x81C, 0x61540303,
		0x81C, 0x60560303,
		0x81C, 0x23580303,
		0x81C, 0x225A0303,
		0x81C, 0x215C0303,
		0x81C, 0x045E0303,
		0x81C, 0x03600303,
		0x81C, 0x02620303,
		0x81C, 0x01640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xF5000303,
		0x81C, 0xF4020303,
		0x81C, 0xF3040303,
		0x81C, 0xF2060303,
		0x81C, 0xF1080303,
		0x81C, 0xF00A0303,
		0x81C, 0xEF0C0303,
		0x81C, 0xEE0E0303,
		0x81C, 0xED100303,
		0x81C, 0xEC120303,
		0x81C, 0xEB140303,
		0x81C, 0xEA160303,
		0x81C, 0xE9180303,
		0x81C, 0xE81A0303,
		0x81C, 0xE71C0303,
		0x81C, 0xE61E0303,
		0x81C, 0xE5200303,
		0x81C, 0xE4220303,
		0x81C, 0xE3240303,
		0x81C, 0xE2260303,
		0x81C, 0xE1280303,
		0x81C, 0xE02A0303,
		0x81C, 0xA72C0303,
		0x81C, 0xA62E0303,
		0x81C, 0xA5300303,
		0x81C, 0xA4320303,
		0x81C, 0xA3340303,
		0x81C, 0xA2360303,
		0x81C, 0xA1380303,
		0x81C, 0xA03A0303,
		0x81C, 0x823C0303,
		0x81C, 0x643E0303,
		0x81C, 0x63400303,
		0x81C, 0x62420303,
		0x81C, 0x61440303,
		0x81C, 0x60460303,
		0x81C, 0x24480303,
		0x81C, 0x234A0303,
		0x81C, 0x224C0303,
		0x81C, 0x054E0303,
		0x81C, 0x04500303,
		0x81C, 0x03520303,
		0x81C, 0x02540303,
		0x81C, 0x01560303,
		0x81C, 0x00580303,
		0x81C, 0x005A0303,
		0x81C, 0x005C0303,
		0x81C, 0x005E0303,
		0x81C, 0x00600303,
		0x81C, 0x00620303,
		0x81C, 0x00640303,
		0x81C, 0x00660303,
		0x81C, 0x00680303,
		0x81C, 0x006A0303,
		0x81C, 0x006C0303,
		0x81C, 0x006E0303,
		0x81C, 0x00700303,
		0x81C, 0x00720303,
		0x81C, 0x00740303,
		0x81C, 0x00760303,
		0x81C, 0x00780303,
		0x81C, 0x007A0303,
		0x81C, 0x007C0303,
		0x81C, 0x007E0303,
	0xA0000000,	0x00000000,
		0x81C, 0xFC000303,
		0x81C, 0xFB020303,
		0x81C, 0xFA040303,
		0x81C, 0xF9060303,
		0x81C, 0xF8080303,
		0x81C, 0xF70A0303,
		0x81C, 0xF60C0303,
		0x81C, 0xF50E0303,
		0x81C, 0xF4100303,
		0x81C, 0xF3120303,
		0x81C, 0xF2140303,
		0x81C, 0xF1160303,
		0x81C, 0xF0180303,
		0x81C, 0xEF1A0303,
		0x81C, 0xEE1C0303,
		0x81C, 0xED1E0303,
		0x81C, 0xEC200303,
		0x81C, 0xEB220303,
		0x81C, 0xEA240303,
		0x81C, 0xE9260303,
		0x81C, 0xE8280303,
		0x81C, 0xE72A0303,
		0x81C, 0xE62C0303,
		0x81C, 0xE52E0303,
		0x81C, 0xE4300303,
		0x81C, 0xE3320303,
		0x81C, 0xE2340303,
		0x81C, 0xE1360303,
		0x81C, 0xC4380303,
		0x81C, 0xC33A0303,
		0x81C, 0xC23C0303,
		0x81C, 0xC13E0303,
		0x81C, 0xA5400303,
		0x81C, 0xA4420303,
		0x81C, 0xA3440303,
		0x81C, 0xA2460303,
		0x81C, 0xA1480303,
		0x81C, 0x834A0303,
		0x81C, 0x824C0303,
		0x81C, 0x814E0303,
		0x81C, 0x64500303,
		0x81C, 0x63520303,
		0x81C, 0x62540303,
		0x81C, 0x61560303,
		0x81C, 0x24580303,
		0x81C, 0x235A0303,
		0x81C, 0x225C0303,
		0x81C, 0x215E0303,
		0x81C, 0x04600303,
		0x81C, 0x03620303,
		0x81C, 0x02640303,
		0x81C, 0x01660303,
		0x81C, 0x01680303,
		0x81C, 0x016A0303,
		0x81C, 0x016C0303,
		0x81C, 0x016E0303,
		0x81C, 0x01700303,
		0x81C, 0x01720303,
		0x81C, 0x01740303,
		0x81C, 0x01760303,
		0x81C, 0x01780303,
		0x81C, 0x017A0303,
		0x81C, 0x017C0303,
		0x81C, 0x017E0303,
	0xB0000000,	0x00000000,
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000803,
		0x81C, 0xFB020803,
		0x81C, 0xFA040803,
		0x81C, 0xF9060803,
		0x81C, 0xF8080803,
		0x81C, 0xF70A0803,
		0x81C, 0xF60C0803,
		0x81C, 0xF50E0803,
		0x81C, 0xF4100803,
		0x81C, 0xF3120803,
		0x81C, 0xF2140803,
		0x81C, 0xF1160803,
		0x81C, 0xF0180803,
		0x81C, 0xEF1A0803,
		0x81C, 0xEE1C0803,
		0x81C, 0xED1E0803,
		0x81C, 0xB5200803,
		0x81C, 0xB4220803,
		0x81C, 0xB3240803,
		0x81C, 0xB2260803,
		0x81C, 0xB1280803,
		0x81C, 0xB02A0803,
		0x81C, 0xAF2C0803,
		0x81C, 0xAE2E0803,
		0x81C, 0xAD300803,
		0x81C, 0xAC320803,
		0x81C, 0xAB340803,
		0x81C, 0xAA360803,
		0x81C, 0xA9380803,
		0x81C, 0xA83A0803,
		0x81C, 0xA73C0803,
		0x81C, 0xA63E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFC000803,
		0x81C, 0xFB020803,
		0x81C, 0xFA040803,
		0x81C, 0xF9060803,
		0x81C, 0xF8080803,
		0x81C, 0xF70A0803,
		0x81C, 0xF60C0803,
		0x81C, 0xF50E0803,
		0x81C, 0xF4100803,
		0x81C, 0xF3120803,
		0x81C, 0xF2140803,
		0x81C, 0xF1160803,
		0x81C, 0xF0180803,
		0x81C, 0xEF1A0803,
		0x81C, 0xEE1C0803,
		0x81C, 0xED1E0803,
		0x81C, 0xB5200803,
		0x81C, 0xB4220803,
		0x81C, 0xB3240803,
		0x81C, 0xB2260803,
		0x81C, 0xB1280803,
		0x81C, 0xB02A0803,
		0x81C, 0xAF2C0803,
		0x81C, 0xAE2E0803,
		0x81C, 0xAD300803,
		0x81C, 0xAC320803,
		0x81C, 0xAB340803,
		0x81C, 0xAA360803,
		0x81C, 0xA9380803,
		0x81C, 0xA83A0803,
		0x81C, 0xA73C0803,
		0x81C, 0xA63E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xA0000000,	0x00000000,
		0x81C, 0xFC000803,
		0x81C, 0xFB020803,
		0x81C, 0xFA040803,
		0x81C, 0xF9060803,
		0x81C, 0xF8080803,
		0x81C, 0xF70A0803,
		0x81C, 0xF60C0803,
		0x81C, 0xF50E0803,
		0x81C, 0xF4100803,
		0x81C, 0xF3120803,
		0x81C, 0xF2140803,
		0x81C, 0xF1160803,
		0x81C, 0xF0180803,
		0x81C, 0xEF1A0803,
		0x81C, 0xEE1C0803,
		0x81C, 0xED1E0803,
		0x81C, 0xB5200803,
		0x81C, 0xB4220803,
		0x81C, 0xB3240803,
		0x81C, 0xB2260803,
		0x81C, 0xB1280803,
		0x81C, 0xB02A0803,
		0x81C, 0xAF2C0803,
		0x81C, 0xAE2E0803,
		0x81C, 0xAD300803,
		0x81C, 0xAC320803,
		0x81C, 0xAB340803,
		0x81C, 0xAA360803,
		0x81C, 0xA9380803,
		0x81C, 0xA83A0803,
		0x81C, 0xA73C0803,
		0x81C, 0xA63E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xB0000000,	0x00000000,
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000913,
		0x81C, 0xFE020913,
		0x81C, 0xFD040913,
		0x81C, 0xFC060913,
		0x81C, 0xFB080913,
		0x81C, 0xFA0A0913,
		0x81C, 0xF90C0913,
		0x81C, 0xF80E0913,
		0x81C, 0xF7100913,
		0x81C, 0xF6120913,
		0x81C, 0xF5140913,
		0x81C, 0xF4160913,
		0x81C, 0xF3180913,
		0x81C, 0xF21A0913,
		0x81C, 0xF11C0913,
		0x81C, 0x941E0913,
		0x81C, 0x93200913,
		0x81C, 0x92220913,
		0x81C, 0x91240913,
		0x81C, 0x90260913,
		0x81C, 0x8F280913,
		0x81C, 0x8E2A0913,
		0x81C, 0x8D2C0913,
		0x81C, 0x8C2E0913,
		0x81C, 0x8B300913,
		0x81C, 0x8A320913,
		0x81C, 0x89340913,
		0x81C, 0x88360913,
		0x81C, 0x87380913,
		0x81C, 0x863A0913,
		0x81C, 0x853C0913,
		0x81C, 0x843E0913,
		0x81C, 0x83400913,
		0x81C, 0x82420913,
		0x81C, 0x81440913,
		0x81C, 0x07460913,
		0x81C, 0x06480913,
		0x81C, 0x054A0913,
		0x81C, 0x044C0913,
		0x81C, 0x034E0913,
		0x81C, 0x02500913,
		0x81C, 0x01520913,
		0x81C, 0x88540903,
		0x81C, 0x87560903,
		0x81C, 0x86580903,
		0x81C, 0x855A0903,
		0x81C, 0x845C0903,
		0x81C, 0x835E0903,
		0x81C, 0x82600903,
		0x81C, 0x81620903,
		0x81C, 0x07640903,
		0x81C, 0x06660903,
		0x81C, 0x05680903,
		0x81C, 0x046A0903,
		0x81C, 0x036C0903,
		0x81C, 0x026E0903,
		0x81C, 0x01700903,
		0x81C, 0x01720903,
		0x81C, 0x01740903,
		0x81C, 0x01760903,
		0x81C, 0x01780903,
		0x81C, 0x017A0903,
		0x81C, 0x017C0903,
		0x81C, 0x017E0903,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000913,
		0x81C, 0xFE020913,
		0x81C, 0xFD040913,
		0x81C, 0xFC060913,
		0x81C, 0xFB080913,
		0x81C, 0xFA0A0913,
		0x81C, 0xF90C0913,
		0x81C, 0xF80E0913,
		0x81C, 0xF7100913,
		0x81C, 0xF6120913,
		0x81C, 0xF5140913,
		0x81C, 0xF4160913,
		0x81C, 0xF3180913,
		0x81C, 0xF21A0913,
		0x81C, 0xF11C0913,
		0x81C, 0x941E0913,
		0x81C, 0x93200913,
		0x81C, 0x92220913,
		0x81C, 0x91240913,
		0x81C, 0x90260913,
		0x81C, 0x8F280913,
		0x81C, 0x8E2A0913,
		0x81C, 0x8D2C0913,
		0x81C, 0x8C2E0913,
		0x81C, 0x8B300913,
		0x81C, 0x8A320913,
		0x81C, 0x89340913,
		0x81C, 0x88360913,
		0x81C, 0x87380913,
		0x81C, 0x863A0913,
		0x81C, 0x853C0913,
		0x81C, 0x843E0913,
		0x81C, 0x83400913,
		0x81C, 0x82420913,
		0x81C, 0x81440913,
		0x81C, 0x07460913,
		0x81C, 0x06480913,
		0x81C, 0x054A0913,
		0x81C, 0x044C0913,
		0x81C, 0x034E0913,
		0x81C, 0x02500913,
		0x81C, 0x01520913,
		0x81C, 0x88540903,
		0x81C, 0x87560903,
		0x81C, 0x86580903,
		0x81C, 0x855A0903,
		0x81C, 0x845C0903,
		0x81C, 0x835E0903,
		0x81C, 0x82600903,
		0x81C, 0x81620903,
		0x81C, 0x07640903,
		0x81C, 0x06660903,
		0x81C, 0x05680903,
		0x81C, 0x046A0903,
		0x81C, 0x036C0903,
		0x81C, 0x026E0903,
		0x81C, 0x01700903,
		0x81C, 0x01720903,
		0x81C, 0x01740903,
		0x81C, 0x01760903,
		0x81C, 0x01780903,
		0x81C, 0x017A0903,
		0x81C, 0x017C0903,
		0x81C, 0x017E0903,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000913,
		0x81C, 0xFE020913,
		0x81C, 0xFD040913,
		0x81C, 0xFC060913,
		0x81C, 0xFB080913,
		0x81C, 0xFA0A0913,
		0x81C, 0xF90C0913,
		0x81C, 0xF80E0913,
		0x81C, 0xF7100913,
		0x81C, 0xF6120913,
		0x81C, 0xF5140913,
		0x81C, 0xF4160913,
		0x81C, 0xF3180913,
		0x81C, 0xF21A0913,
		0x81C, 0xF11C0913,
		0x81C, 0x941E0913,
		0x81C, 0x93200913,
		0x81C, 0x92220913,
		0x81C, 0x91240913,
		0x81C, 0x90260913,
		0x81C, 0x8F280913,
		0x81C, 0x8E2A0913,
		0x81C, 0x8D2C0913,
		0x81C, 0x8C2E0913,
		0x81C, 0x8B300913,
		0x81C, 0x8A320913,
		0x81C, 0x89340913,
		0x81C, 0x88360913,
		0x81C, 0x87380913,
		0x81C, 0x863A0913,
		0x81C, 0x853C0913,
		0x81C, 0x843E0913,
		0x81C, 0x83400913,
		0x81C, 0x82420913,
		0x81C, 0x81440913,
		0x81C, 0x07460913,
		0x81C, 0x06480913,
		0x81C, 0x054A0913,
		0x81C, 0x044C0913,
		0x81C, 0x034E0913,
		0x81C, 0x02500913,
		0x81C, 0x01520913,
		0x81C, 0x88540903,
		0x81C, 0x87560903,
		0x81C, 0x86580903,
		0x81C, 0x855A0903,
		0x81C, 0x845C0903,
		0x81C, 0x835E0903,
		0x81C, 0x82600903,
		0x81C, 0x81620903,
		0x81C, 0x07640903,
		0x81C, 0x06660903,
		0x81C, 0x05680903,
		0x81C, 0x046A0903,
		0x81C, 0x036C0903,
		0x81C, 0x026E0903,
		0x81C, 0x01700903,
		0x81C, 0x01720903,
		0x81C, 0x01740903,
		0x81C, 0x01760903,
		0x81C, 0x01780903,
		0x81C, 0x017A0903,
		0x81C, 0x017C0903,
		0x81C, 0x017E0903,
	0xB0000000,	0x00000000,
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000022,
	0xA0000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8821c_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8821c_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8821c_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8821c(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_agc_tab(void)
{
		return 56;
}

/******************************************************************************
 *                           agc_tab_diff.TXT
 ******************************************************************************/

const u32 array_mp_8821c_agc_tab_diff_wlg[] = {
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xE52C0003,
		0x81C, 0xE42E0003,
		0x81C, 0xE3300003,
		0x81C, 0xE2320003,
		0x81C, 0xE1340003,
		0x81C, 0xC4360003,
		0x81C, 0xC3380003,
		0x81C, 0xC23A0003,
		0x81C, 0xC13C0003,
		0x81C, 0x883E0003,
		0x81C, 0x87400003,
		0x81C, 0x86420003,
		0x81C, 0x85440003,
		0x81C, 0x84460003,
		0x81C, 0x83480003,
		0x81C, 0x824A0003,
		0x81C, 0x814C0003,
		0x81C, 0x804E0003,
		0x81C, 0x64500003,
		0x81C, 0x63520003,
		0x81C, 0x62540003,
		0x81C, 0x61560003,
		0x81C, 0x60580003,
		0x81C, 0x475A0003,
		0x81C, 0x465C0003,
		0x81C, 0x455E0003,
		0x81C, 0x44600003,
		0x81C, 0x43620003,
		0x81C, 0x42640003,
		0x81C, 0x41660003,
		0x81C, 0x40680003,
		0x81C, 0x236A0003,
		0x81C, 0x226C0003,
		0x81C, 0x056E0003,
		0x81C, 0x04700003,
		0x81C, 0x03720003,
		0x81C, 0x02740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000803,
		0x81C, 0xFE020803,
		0x81C, 0xFD040803,
		0x81C, 0xFC060803,
		0x81C, 0xFB080803,
		0x81C, 0xFA0A0803,
		0x81C, 0xF90C0803,
		0x81C, 0xF80E0803,
		0x81C, 0xF7100803,
		0x81C, 0xF6120803,
		0x81C, 0xF5140803,
		0x81C, 0xF4160803,
		0x81C, 0xF3180803,
		0x81C, 0xF21A0803,
		0x81C, 0xF11C0803,
		0x81C, 0xF01E0803,
		0x81C, 0xB7200803,
		0x81C, 0xB6220803,
		0x81C, 0xB5240803,
		0x81C, 0xB4260803,
		0x81C, 0xB3280803,
		0x81C, 0xB22A0803,
		0x81C, 0xB12C0803,
		0x81C, 0xAF2E0803,
		0x81C, 0xAE300803,
		0x81C, 0xAD320803,
		0x81C, 0xAC340803,
		0x81C, 0xAB360803,
		0x81C, 0xAA380803,
		0x81C, 0xA93A0803,
		0x81C, 0xA83C0803,
		0x81C, 0xA73E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xE52C0003,
		0x81C, 0xE42E0003,
		0x81C, 0xE3300003,
		0x81C, 0xE2320003,
		0x81C, 0xE1340003,
		0x81C, 0xC4360003,
		0x81C, 0xC3380003,
		0x81C, 0xC23A0003,
		0x81C, 0xC13C0003,
		0x81C, 0x883E0003,
		0x81C, 0x87400003,
		0x81C, 0x86420003,
		0x81C, 0x85440003,
		0x81C, 0x84460003,
		0x81C, 0x83480003,
		0x81C, 0x824A0003,
		0x81C, 0x814C0003,
		0x81C, 0x804E0003,
		0x81C, 0x64500003,
		0x81C, 0x63520003,
		0x81C, 0x62540003,
		0x81C, 0x61560003,
		0x81C, 0x60580003,
		0x81C, 0x475A0003,
		0x81C, 0x465C0003,
		0x81C, 0x455E0003,
		0x81C, 0x44600003,
		0x81C, 0x43620003,
		0x81C, 0x42640003,
		0x81C, 0x41660003,
		0x81C, 0x40680003,
		0x81C, 0x236A0003,
		0x81C, 0x226C0003,
		0x81C, 0x056E0003,
		0x81C, 0x04700003,
		0x81C, 0x03720003,
		0x81C, 0x02740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000803,
		0x81C, 0xFE020803,
		0x81C, 0xFD040803,
		0x81C, 0xFC060803,
		0x81C, 0xFB080803,
		0x81C, 0xFA0A0803,
		0x81C, 0xF90C0803,
		0x81C, 0xF80E0803,
		0x81C, 0xF7100803,
		0x81C, 0xF6120803,
		0x81C, 0xF5140803,
		0x81C, 0xF4160803,
		0x81C, 0xF3180803,
		0x81C, 0xF21A0803,
		0x81C, 0xF11C0803,
		0x81C, 0xF01E0803,
		0x81C, 0xB7200803,
		0x81C, 0xB6220803,
		0x81C, 0xB5240803,
		0x81C, 0xB4260803,
		0x81C, 0xB3280803,
		0x81C, 0xB22A0803,
		0x81C, 0xB12C0803,
		0x81C, 0xAF2E0803,
		0x81C, 0xAE300803,
		0x81C, 0xAD320803,
		0x81C, 0xAC340803,
		0x81C, 0xAB360803,
		0x81C, 0xAA380803,
		0x81C, 0xA93A0803,
		0x81C, 0xA83C0803,
		0x81C, 0xA73E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xA0000000,	0x00000000,
		0x81C, 0xFB000003,
		0x81C, 0xFA020003,
		0x81C, 0xF9040003,
		0x81C, 0xF8060003,
		0x81C, 0xF7080003,
		0x81C, 0xF60A0003,
		0x81C, 0xF50C0003,
		0x81C, 0xF40E0003,
		0x81C, 0xF3100003,
		0x81C, 0xF2120003,
		0x81C, 0xF1140003,
		0x81C, 0xF0160003,
		0x81C, 0xEF180003,
		0x81C, 0xEE1A0003,
		0x81C, 0xED1C0003,
		0x81C, 0xEC1E0003,
		0x81C, 0xEB200003,
		0x81C, 0xEA220003,
		0x81C, 0xE9240003,
		0x81C, 0xE8260003,
		0x81C, 0xE7280003,
		0x81C, 0xE62A0003,
		0x81C, 0xCA2C0003,
		0x81C, 0xC92E0003,
		0x81C, 0xC8300003,
		0x81C, 0xC7320003,
		0x81C, 0xC6340003,
		0x81C, 0xC5360003,
		0x81C, 0xC4380003,
		0x81C, 0xC33A0003,
		0x81C, 0xC23C0003,
		0x81C, 0xC13E0003,
		0x81C, 0x88400003,
		0x81C, 0x87420003,
		0x81C, 0x86440003,
		0x81C, 0x85460003,
		0x81C, 0x84480003,
		0x81C, 0x834A0003,
		0x81C, 0x674C0003,
		0x81C, 0x664E0003,
		0x81C, 0x65500003,
		0x81C, 0x64520003,
		0x81C, 0x63540003,
		0x81C, 0x62560003,
		0x81C, 0x61580003,
		0x81C, 0x455A0003,
		0x81C, 0x445C0003,
		0x81C, 0x435E0003,
		0x81C, 0x42600003,
		0x81C, 0x41620003,
		0x81C, 0x25640003,
		0x81C, 0x24660003,
		0x81C, 0x23680003,
		0x81C, 0x226A0003,
		0x81C, 0x216C0003,
		0x81C, 0x016E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000803,
		0x81C, 0xFE020803,
		0x81C, 0xFD040803,
		0x81C, 0xFC060803,
		0x81C, 0xFB080803,
		0x81C, 0xFA0A0803,
		0x81C, 0xF90C0803,
		0x81C, 0xF80E0803,
		0x81C, 0xF7100803,
		0x81C, 0xF6120803,
		0x81C, 0xF5140803,
		0x81C, 0xF4160803,
		0x81C, 0xF3180803,
		0x81C, 0xF21A0803,
		0x81C, 0xF11C0803,
		0x81C, 0xF01E0803,
		0x81C, 0xB7200803,
		0x81C, 0xB6220803,
		0x81C, 0xB5240803,
		0x81C, 0xB4260803,
		0x81C, 0xB3280803,
		0x81C, 0xB22A0803,
		0x81C, 0xB12C0803,
		0x81C, 0xAF2E0803,
		0x81C, 0xAE300803,
		0x81C, 0xAD320803,
		0x81C, 0xAC340803,
		0x81C, 0xAB360803,
		0x81C, 0xAA380803,
		0x81C, 0xA93A0803,
		0x81C, 0xA83C0803,
		0x81C, 0xA73E0803,
		0x81C, 0x88400803,
		0x81C, 0x87420803,
		0x81C, 0x86440803,
		0x81C, 0x85460803,
		0x81C, 0x84480803,
		0x81C, 0x834A0803,
		0x81C, 0x674C0803,
		0x81C, 0x664E0803,
		0x81C, 0x65500803,
		0x81C, 0x64520803,
		0x81C, 0x63540803,
		0x81C, 0x62560803,
		0x81C, 0x61580803,
		0x81C, 0x455A0803,
		0x81C, 0x445C0803,
		0x81C, 0x435E0803,
		0x81C, 0x42600803,
		0x81C, 0x41620803,
		0x81C, 0x25640803,
		0x81C, 0x24660803,
		0x81C, 0x23680803,
		0x81C, 0x226A0803,
		0x81C, 0x216C0803,
		0x81C, 0x016E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xB0000000,	0x00000000,
};

const u32 array_mp_8821c_agc_tab_diff_btg[] = {
	0x80001004,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000013,
		0x81C, 0xFE020013,
		0x81C, 0xFD040013,
		0x81C, 0xFC060013,
		0x81C, 0xFB080013,
		0x81C, 0xFA0A0013,
		0x81C, 0xF90C0013,
		0x81C, 0xF80E0013,
		0x81C, 0xF7100013,
		0x81C, 0xF6120013,
		0x81C, 0xF5140013,
		0x81C, 0xF4160013,
		0x81C, 0xF3180013,
		0x81C, 0xF21A0013,
		0x81C, 0xF11C0013,
		0x81C, 0xF01E0013,
		0x81C, 0xEF200013,
		0x81C, 0xEE220013,
		0x81C, 0xED240013,
		0x81C, 0xEC260013,
		0x81C, 0xEB280013,
		0x81C, 0xEA2A0013,
		0x81C, 0xE92C0013,
		0x81C, 0xE82E0013,
		0x81C, 0xE7300013,
		0x81C, 0x8B320013,
		0x81C, 0x8A340013,
		0x81C, 0x89360013,
		0x81C, 0x88380013,
		0x81C, 0x873A0013,
		0x81C, 0x863C0013,
		0x81C, 0x853E0013,
		0x81C, 0x84400013,
		0x81C, 0x83420013,
		0x81C, 0x82440013,
		0x81C, 0x81460013,
		0x81C, 0x08480013,
		0x81C, 0x074A0013,
		0x81C, 0x064C0013,
		0x81C, 0x054E0013,
		0x81C, 0x04500013,
		0x81C, 0x03520013,
		0x81C, 0x88540003,
		0x81C, 0x87560003,
		0x81C, 0x86580003,
		0x81C, 0x855A0003,
		0x81C, 0x845C0003,
		0x81C, 0x835E0003,
		0x81C, 0x82600003,
		0x81C, 0x81620003,
		0x81C, 0x07640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000813,
		0x81C, 0xFE020813,
		0x81C, 0xFD040813,
		0x81C, 0xFC060813,
		0x81C, 0xFB080813,
		0x81C, 0xFA0A0813,
		0x81C, 0xF90C0813,
		0x81C, 0xF80E0813,
		0x81C, 0xF7100813,
		0x81C, 0xF6120813,
		0x81C, 0xF5140813,
		0x81C, 0xF4160813,
		0x81C, 0xF3180813,
		0x81C, 0xF21A0813,
		0x81C, 0xF11C0813,
		0x81C, 0x941E0813,
		0x81C, 0x93200813,
		0x81C, 0x92220813,
		0x81C, 0x91240813,
		0x81C, 0x90260813,
		0x81C, 0x8F280813,
		0x81C, 0x8E2A0813,
		0x81C, 0x8D2C0813,
		0x81C, 0x8C2E0813,
		0x81C, 0x8B300813,
		0x81C, 0x8A320813,
		0x81C, 0x89340813,
		0x81C, 0x88360813,
		0x81C, 0x87380813,
		0x81C, 0x863A0813,
		0x81C, 0x853C0813,
		0x81C, 0x843E0813,
		0x81C, 0x83400813,
		0x81C, 0x82420813,
		0x81C, 0x81440813,
		0x81C, 0x07460813,
		0x81C, 0x06480813,
		0x81C, 0x054A0813,
		0x81C, 0x044C0813,
		0x81C, 0x034E0813,
		0x81C, 0x02500813,
		0x81C, 0x01520813,
		0x81C, 0x88540803,
		0x81C, 0x87560803,
		0x81C, 0x86580803,
		0x81C, 0x855A0803,
		0x81C, 0x845C0803,
		0x81C, 0x835E0803,
		0x81C, 0x82600803,
		0x81C, 0x81620803,
		0x81C, 0x07640803,
		0x81C, 0x06660803,
		0x81C, 0x05680803,
		0x81C, 0x046A0803,
		0x81C, 0x036C0803,
		0x81C, 0x026E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0x90001005,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000013,
		0x81C, 0xFE020013,
		0x81C, 0xFD040013,
		0x81C, 0xFC060013,
		0x81C, 0xFB080013,
		0x81C, 0xFA0A0013,
		0x81C, 0xF90C0013,
		0x81C, 0xF80E0013,
		0x81C, 0xF7100013,
		0x81C, 0xF6120013,
		0x81C, 0xF5140013,
		0x81C, 0xF4160013,
		0x81C, 0xF3180013,
		0x81C, 0xF21A0013,
		0x81C, 0xF11C0013,
		0x81C, 0xF01E0013,
		0x81C, 0xEF200013,
		0x81C, 0xEE220013,
		0x81C, 0xED240013,
		0x81C, 0xEC260013,
		0x81C, 0xEB280013,
		0x81C, 0xEA2A0013,
		0x81C, 0xE92C0013,
		0x81C, 0xE82E0013,
		0x81C, 0xE7300013,
		0x81C, 0x8B320013,
		0x81C, 0x8A340013,
		0x81C, 0x89360013,
		0x81C, 0x88380013,
		0x81C, 0x873A0013,
		0x81C, 0x863C0013,
		0x81C, 0x853E0013,
		0x81C, 0x84400013,
		0x81C, 0x83420013,
		0x81C, 0x82440013,
		0x81C, 0x81460013,
		0x81C, 0x08480013,
		0x81C, 0x074A0013,
		0x81C, 0x064C0013,
		0x81C, 0x054E0013,
		0x81C, 0x04500013,
		0x81C, 0x03520013,
		0x81C, 0x88540003,
		0x81C, 0x87560003,
		0x81C, 0x86580003,
		0x81C, 0x855A0003,
		0x81C, 0x845C0003,
		0x81C, 0x835E0003,
		0x81C, 0x82600003,
		0x81C, 0x81620003,
		0x81C, 0x07640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000813,
		0x81C, 0xFE020813,
		0x81C, 0xFD040813,
		0x81C, 0xFC060813,
		0x81C, 0xFB080813,
		0x81C, 0xFA0A0813,
		0x81C, 0xF90C0813,
		0x81C, 0xF80E0813,
		0x81C, 0xF7100813,
		0x81C, 0xF6120813,
		0x81C, 0xF5140813,
		0x81C, 0xF4160813,
		0x81C, 0xF3180813,
		0x81C, 0xF21A0813,
		0x81C, 0xF11C0813,
		0x81C, 0x941E0813,
		0x81C, 0x93200813,
		0x81C, 0x92220813,
		0x81C, 0x91240813,
		0x81C, 0x90260813,
		0x81C, 0x8F280813,
		0x81C, 0x8E2A0813,
		0x81C, 0x8D2C0813,
		0x81C, 0x8C2E0813,
		0x81C, 0x8B300813,
		0x81C, 0x8A320813,
		0x81C, 0x89340813,
		0x81C, 0x88360813,
		0x81C, 0x87380813,
		0x81C, 0x863A0813,
		0x81C, 0x853C0813,
		0x81C, 0x843E0813,
		0x81C, 0x83400813,
		0x81C, 0x82420813,
		0x81C, 0x81440813,
		0x81C, 0x07460813,
		0x81C, 0x06480813,
		0x81C, 0x054A0813,
		0x81C, 0x044C0813,
		0x81C, 0x034E0813,
		0x81C, 0x02500813,
		0x81C, 0x01520813,
		0x81C, 0x88540803,
		0x81C, 0x87560803,
		0x81C, 0x86580803,
		0x81C, 0x855A0803,
		0x81C, 0x845C0803,
		0x81C, 0x835E0803,
		0x81C, 0x82600803,
		0x81C, 0x81620803,
		0x81C, 0x07640803,
		0x81C, 0x06660803,
		0x81C, 0x05680803,
		0x81C, 0x046A0803,
		0x81C, 0x036C0803,
		0x81C, 0x026E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000013,
		0x81C, 0xFE020013,
		0x81C, 0xFD040013,
		0x81C, 0xFC060013,
		0x81C, 0xFB080013,
		0x81C, 0xFA0A0013,
		0x81C, 0xF90C0013,
		0x81C, 0xF80E0013,
		0x81C, 0xF7100013,
		0x81C, 0xF6120013,
		0x81C, 0xF5140013,
		0x81C, 0xF4160013,
		0x81C, 0xF3180013,
		0x81C, 0xF21A0013,
		0x81C, 0xF11C0013,
		0x81C, 0xF01E0013,
		0x81C, 0xEF200013,
		0x81C, 0xEE220013,
		0x81C, 0xED240013,
		0x81C, 0xEC260013,
		0x81C, 0xEB280013,
		0x81C, 0xEA2A0013,
		0x81C, 0xE92C0013,
		0x81C, 0xE82E0013,
		0x81C, 0xE7300013,
		0x81C, 0x8A320013,
		0x81C, 0x89340013,
		0x81C, 0x88360013,
		0x81C, 0x87380013,
		0x81C, 0x863A0013,
		0x81C, 0x853C0013,
		0x81C, 0x843E0013,
		0x81C, 0x83400013,
		0x81C, 0x82420013,
		0x81C, 0x81440013,
		0x81C, 0x07460013,
		0x81C, 0x06480013,
		0x81C, 0x054A0013,
		0x81C, 0x044C0013,
		0x81C, 0x034E0013,
		0x81C, 0x02500013,
		0x81C, 0x01520013,
		0x81C, 0x88540003,
		0x81C, 0x87560003,
		0x81C, 0x86580003,
		0x81C, 0x855A0003,
		0x81C, 0x845C0003,
		0x81C, 0x835E0003,
		0x81C, 0x82600003,
		0x81C, 0x81620003,
		0x81C, 0x07640003,
		0x81C, 0x06660003,
		0x81C, 0x05680003,
		0x81C, 0x046A0003,
		0x81C, 0x036C0003,
		0x81C, 0x026E0003,
		0x81C, 0x01700003,
		0x81C, 0x01720003,
		0x81C, 0x01740003,
		0x81C, 0x01760003,
		0x81C, 0x01780003,
		0x81C, 0x017A0003,
		0x81C, 0x017C0003,
		0x81C, 0x017E0003,
		0x81C, 0xFF000813,
		0x81C, 0xFE020813,
		0x81C, 0xFD040813,
		0x81C, 0xFC060813,
		0x81C, 0xFB080813,
		0x81C, 0xFA0A0813,
		0x81C, 0xF90C0813,
		0x81C, 0xF80E0813,
		0x81C, 0xF7100813,
		0x81C, 0xF6120813,
		0x81C, 0xF5140813,
		0x81C, 0xF4160813,
		0x81C, 0xF3180813,
		0x81C, 0xF21A0813,
		0x81C, 0xF11C0813,
		0x81C, 0x961E0813,
		0x81C, 0x95200813,
		0x81C, 0x94220813,
		0x81C, 0x93240813,
		0x81C, 0x92260813,
		0x81C, 0x91280813,
		0x81C, 0x8F2A0813,
		0x81C, 0x8E2C0813,
		0x81C, 0x8D2E0813,
		0x81C, 0x8C300813,
		0x81C, 0x8B320813,
		0x81C, 0x8A340813,
		0x81C, 0x89360813,
		0x81C, 0x88380813,
		0x81C, 0x873A0813,
		0x81C, 0x863C0813,
		0x81C, 0x853E0813,
		0x81C, 0x84400813,
		0x81C, 0x83420813,
		0x81C, 0x82440813,
		0x81C, 0x08460813,
		0x81C, 0x07480813,
		0x81C, 0x064A0813,
		0x81C, 0x054C0813,
		0x81C, 0x044E0813,
		0x81C, 0x03500813,
		0x81C, 0x02520813,
		0x81C, 0x89540803,
		0x81C, 0x88560803,
		0x81C, 0x87580803,
		0x81C, 0x865A0803,
		0x81C, 0x855C0803,
		0x81C, 0x845E0803,
		0x81C, 0x83600803,
		0x81C, 0x82620803,
		0x81C, 0x07640803,
		0x81C, 0x06660803,
		0x81C, 0x05680803,
		0x81C, 0x046A0803,
		0x81C, 0x036C0803,
		0x81C, 0x026E0803,
		0x81C, 0x01700803,
		0x81C, 0x01720803,
		0x81C, 0x01740803,
		0x81C, 0x01760803,
		0x81C, 0x01780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xB0000000,	0x00000000,
};

void
odm_read_and_config_mp_8821c_agc_tab_diff(struct dm_struct *dm,
					  const u32 array[],
					  u32 array_len)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8821c(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_agc_tab_diff(void)
{
		return 56;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8821c_phy_reg[] = {
		0x800, 0x9020D010,
		0x804, 0x80018180,
		0x808, 0x04028211,
		0x80C, 0x13D10011,
		0x810, 0x21104255,
		0x814, 0x020C3D10,
		0x818, 0x84A10385,
		0x81C, 0x1E1E081F,
		0x820, 0x0001AAAA,
		0x824, 0x00030FE0,
		0x828, 0x0000CCCC,
		0x82C, 0x75CB7010,
		0x830, 0x79A0EAAA,
		0x834, 0x072E698A,
		0x838, 0x87766461,
		0x83C, 0x9194B2B6,
		0x840, 0x171740E0,
		0x844, 0x4D3D7CDB,
		0x848, 0x4AD0408B,
		0x84C, 0x6AFBF7A5,
		0x850, 0x28A74706,
		0x854, 0x0001520C,
		0x858, 0x4060C000,
		0x85C, 0x74010160,
		0x860, 0x68A7C321,
		0x864, 0x79F27432,
		0x868, 0x8CA7A314,
		0x86C, 0x558C2878,
		0x870, 0x55555555,
		0x874, 0x27612C2E,
		0x878, 0xC0003152,
		0x87C, 0x5C8FC000,
		0x880, 0x00000000,
		0x884, 0x00000000,
		0x888, 0x00000000,
		0x88C, 0x00000000,
		0x890, 0x00000000,
		0x894, 0x00000000,
		0x898, 0x00000000,
		0x89C, 0x00000000,
		0x8A0, 0x00000013,
		0x8A4, 0x7F7F7F7F,
		0x8A8, 0x2202033E,
		0x8AC, 0xF00F000A,
		0x8B0, 0x00000600,
		0x8B4, 0x000FC080,
		0x8B8, 0xEC0057FF,
		0x8BC, 0x2CB520A3,
		0x8C0, 0xFFE04020,
		0x8C4, 0x47C00000,
		0x8C8, 0x00025165,
		0x8CC, 0x08188492,
		0x8D0, 0x0000B800,
		0x8D4, 0x860308A0,
		0x8D8, 0x290B5612,
		0x8DC, 0x00000000,
		0x8E0, 0x32D16777,
		0x8E4, 0x49092925,
		0x8E8, 0xFFFFC42C,
		0x8EC, 0x99999999,
		0x8F0, 0x00009999,
		0x8F4, 0x00D80FA1,
		0x8F8, 0x400000C0,
		0x8FC, 0x00000130,
		0x900, 0x00C00000,
		0x904, 0x0FFF0FFF,
		0x908, 0x00000000,
		0x90C, 0x13000000,
		0x910, 0x0000FC00,
		0x914, 0xC6380000,
		0x918, 0x1C1028C0,
		0x91C, 0x64B11A1C,
		0x920, 0xE0767233,
		0x924, 0x855A2500,
		0x928, 0x4AB0E4E4,
		0x92C, 0xFFFEB200,
		0x930, 0xFFFFFFFE,
		0x934, 0x001FFFFF,
		0x938, 0x00008480,
		0x93C, 0xE41C0642,
		0x940, 0x0E470430,
		0x944, 0x00000000,
		0x948, 0xAC000000,
		0x94C, 0x10000083,
		0x950, 0xB2010080,
		0x954, 0x86510080,
		0x958, 0x00000181,
		0x95C, 0x04248000,
		0x960, 0x00000000,
		0x964, 0x00000000,
		0x968, 0x00000000,
		0x96C, 0x00000000,
		0x970, 0x00001FFF,
		0x974, 0x04000FFF,
		0x978, 0x00000000,
		0x97C, 0x00000000,
		0x980, 0x00000000,
		0x984, 0x00000000,
		0x988, 0x00000000,
		0x98C, 0x23440000,
		0x990, 0x27100000,
		0x994, 0xFFFF0100,
		0x998, 0xFFFFFF5C,
		0x99C, 0xFFFFFFFF,
		0x9A0, 0x000000FF,
		0x9A4, 0x80000088,
		0x9A8, 0x0C2F0000,
		0x9AC, 0x01560000,
		0x9B0, 0x70000000,
		0x9B4, 0x00000000,
		0x9B8, 0x00000000,
		0x9BC, 0x00000000,
		0x9C0, 0x00000000,
		0x9C4, 0x00000000,
		0x9C8, 0x00000000,
		0x9CC, 0x00000000,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x02000402,
		0x9E8, 0x000022D4,
		0x9EC, 0x00000000,
		0x9F0, 0x00000000,
		0x9F4, 0x00000000,
		0x9F8, 0x00000000,
		0x9FC, 0xEFFFF7FF,
		0xA00, 0x00D040C8,
		0xA04, 0x80FF800C,
		0xA08, 0x9C838300,
		0xA0C, 0x297E000F,
		0xA10, 0x9500BB78,
		0xA14, 0x1114D028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0xE82C0000,
		0xA24, 0x64B80C1C,
		0xA28, 0x00008810,
		0xA2C, 0x00D20000,
		0xA70, 0x101FBF00,
		0xA74, 0x00000107,
		0xA78, 0x00008900,
		0xA7C, 0x225B0606,
		0xA80, 0x21807532,
		0xA84, 0x80120000,
		0xA88, 0x048C0000,
		0xA8C, 0x12345678,
		0xA90, 0xABCDEF00,
		0xA94, 0x001B1B89,
		0xA98, 0x00000000,
		0xA9C, 0x3F000000,
		0xAA0, 0x00000000,
		0xAA4, 0x00080000,
		0xAA8, 0xEACF0004,
		0xAAC, 0x01235667,
		0xAB0, 0x00000000,
		0xB00, 0xE1000440,
		0xB04, 0x00800000,
		0xB08, 0xFF02030B,
		0xB0C, 0x01EAA406,
		0xB10, 0x00030690,
		0xB14, 0x006000FA,
		0xB18, 0x00000002,
		0xB1C, 0x00000002,
		0xB20, 0x4B00001F,
		0xB24, 0x4E8E3E40,
		0xB28, 0x03020100,
		0xB2C, 0x07060504,
		0xB30, 0x0B0A0908,
		0xB34, 0x0F0E0D0C,
		0xB38, 0x13121110,
		0xB3C, 0x0000003A,
		0xB40, 0x00000000,
		0xB44, 0x80000000,
		0xB48, 0x3F0000FA,
		0xB4C, 0x88C80020,
		0xB50, 0x00000000,
		0xB54, 0x00004241,
		0xB58, 0xE0008208,
		0xB5C, 0x41EFFFF9,
		0xB60, 0x00000000,
		0xB64, 0x00200063,
		0xB68, 0x0000003A,
		0xB6C, 0x00000102,
		0xB70, 0x4E6D1870,
		0xB74, 0x03020100,
		0xB78, 0x07060504,
		0xB7C, 0x0B0A0908,
		0xB80, 0x0F0E0D0C,
		0xB84, 0x13121110,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xC00, 0x00000007,
		0xC04, 0x03050020,
		0xC08, 0x60403231,
		0xC0C, 0x00012345,
		0xC10, 0x00000100,
		0xC14, 0x01000000,
		0xC18, 0x00000000,
		0xC1C, 0x40040053,
		0xC20, 0x400503A3,
		0xC24, 0x00000000,
		0xC28, 0x00000000,
		0xC2C, 0x00000000,
		0xC30, 0x00000000,
		0xC34, 0x00000000,
		0xC38, 0x00000000,
		0xC3C, 0x00000000,
		0xC40, 0x00000000,
		0xC44, 0x00000000,
		0xC48, 0x00000000,
		0xC4C, 0x00000000,
		0xC50, 0x00000020,
		0xC54, 0x00000000,
		0xC58, 0xD8020402,
		0xC5C, 0xDE000120,
		0xC68, 0x0000003F,
		0xC6C, 0x0000122A,
		0xC70, 0x00000000,
		0xC74, 0x00000000,
		0xC78, 0x00000000,
		0xC7C, 0x00000000,
		0xC80, 0x00000000,
		0xC84, 0x00000000,
		0xC88, 0x00000000,
		0xC8C, 0x07000000,
		0xC94, 0x01000100,
		0xC98, 0x201C8000,
		0xC9C, 0x00000000,
		0xCA0, 0x0000A555,
		0xCA4, 0x08040201,
		0xCA8, 0x80402010,
		0xCAC, 0x00000000,
	0x80001005,	0x00000000,	0x40000000,	0x00000000,
		0xCB0, 0x77777717,
		0xCB4, 0x00000073,
	0xA0000000,	0x00000000,
		0xCB0, 0x77775747,
		0xCB4, 0x10000077,
	0xB0000000,	0x00000000,
		0xCB8, 0x00000000,
		0xCBC, 0x00000000,
		0xCC0, 0x00000000,
		0xCC4, 0x00000000,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x00000000,
		0xCD4, 0x00000000,
		0xCD8, 0x00000000,
		0xCDC, 0x00000000,
		0xCE0, 0x00000000,
		0xCE4, 0x00000000,
		0xCE8, 0x00000000,
		0xCEC, 0x00000000,
		0xE00, 0x00000007,
		0xE04, 0x00000020,
		0xE08, 0x60403231,
		0xE0C, 0x00012345,
		0xE10, 0x00000100,
		0xE14, 0x01000000,
		0xE18, 0x00000000,
		0xE1C, 0x40040053,
		0xE20, 0x00020103,
		0xE24, 0x00000000,
		0xE28, 0x00000000,
		0xE2C, 0x00000000,
		0xE30, 0x00000000,
		0xE34, 0x00000000,
		0xE38, 0x00000000,
		0xE3C, 0x00000000,
		0xE40, 0x00000000,
		0xE44, 0x00000000,
		0xE48, 0x00000000,
		0xE4C, 0x00000000,
		0xE50, 0x00000020,
		0xE54, 0x00000000,
		0xE58, 0xD8020402,
		0xE5C, 0xDE000120,
		0xE68, 0x59799979,
		0xE6C, 0x0000122A,
		0xE70, 0x99795979,
		0xE74, 0x99795979,
		0xE78, 0x99799979,
		0xE7C, 0x99791979,
		0xE80, 0x19791979,
		0xE84, 0x19791979,
		0xE88, 0x00000000,
		0xE8C, 0x07000000,
		0xE94, 0x01000100,
		0xE98, 0x201C8000,
		0xE9C, 0x00000000,
		0xEA0, 0x0000A555,
		0xEA4, 0x08040201,
		0xEA8, 0x80402010,
		0xEAC, 0x00000000,
		0xEB0, 0x98543210,
		0xEB4, 0x000000BA,
		0xEB8, 0x00000000,
		0xEBC, 0x00000000,
		0xEC0, 0x00000000,
		0xEC4, 0x00000000,
		0xEC8, 0x00000000,
		0xECC, 0x00000000,
		0xED0, 0x00000000,
		0xED4, 0x00000000,
		0xED8, 0x00000000,
		0xEDC, 0x00000000,
		0xEE0, 0x00000000,
		0xEE4, 0x00000000,
		0xEE8, 0x00000000,
		0xEEC, 0x00000000,
		0x1900, 0x00000000,
		0x1904, 0x00238000,
		0x1908, 0x00000000,
		0x190C, 0x00000000,
		0x1910, 0x00001800,
		0x1914, 0x00000000,
		0x1918, 0x00000000,
		0x191C, 0x00000000,
		0x1920, 0x00000000,
		0x1924, 0x00000000,
		0x1928, 0x00000000,
		0x192C, 0x00000000,
		0x1930, 0x00000000,
		0x1934, 0x00000000,
		0x1938, 0x00000000,
		0x193C, 0x00000000,
		0x1940, 0x00000000,
		0x1944, 0x00000000,
		0x1948, 0x00000000,
		0x194C, 0x00000000,
		0x1950, 0x00000000,
		0x1954, 0x00000000,
		0x1958, 0x00000000,
		0x195C, 0x00000000,
		0x1960, 0x00000000,
		0x1964, 0x00000000,
		0x1968, 0x00000000,
		0x196C, 0x00000000,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x03000000,
		0x1988, 0x21401E88,
		0x198C, 0x00004000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000053,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x010A0000,
		0x19AC, 0x0E47E47F,
		0x19B0, 0x00008000,
		0x19B4, 0x0E47E47F,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0x77777777,
		0x19D8, 0x00000777,
		0x19DC, 0x133E0F37,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x01A00000,
		0x19FC, 0x00000000,
		0x1C00, 0x00000100,
		0x1C04, 0x01000000,
		0x1C08, 0x00000100,
		0x1C0C, 0x01000000,
		0x1C10, 0x00000100,
		0x1C14, 0x01000000,
		0x1C18, 0x00000100,
		0x1C1C, 0x01000000,
		0x1C20, 0x00000100,
		0x1C24, 0x01000000,
		0x1C28, 0x00000100,
		0x1C2C, 0x01000000,
		0x1C30, 0x00000100,
		0x1C34, 0x01000000,
		0x1C38, 0x00000000,
		0x1C3C, 0x00008000,
		0x1C40, 0x000C0100,
		0x1C44, 0x000000F3,
		0x1C48, 0x1A8249A8,
		0x1C4C, 0x1461C826,
		0x1C50, 0x0001469E,
		0x1C54, 0x58D158D1,
		0x1C58, 0x04490088,
		0x1C5C, 0x04004400,
		0x1C60, 0x00000000,
		0x1C64, 0x04004400,
		0x1C68, 0x0B7B7B75,
		0x1C6C, 0x01000000,
		0x1C70, 0x00A08145,
		0x1C74, 0x2080E0E0,
		0x1C78, 0x00000000,
		0x1C7C, 0x00000010,
		0x1C80, 0x00000100,
		0x1C84, 0x01000000,
		0x1C88, 0x00000100,
		0x1C8C, 0x01000000,
		0x1C90, 0x00000100,
		0x1C94, 0x01000000,
		0x1C98, 0x00000100,
		0x1C9C, 0x01000000,
		0x1CA0, 0x00000100,
		0x1CA4, 0x01000000,
		0x1CA8, 0x00000100,
		0x1CAC, 0x01000000,
		0x1CB0, 0x00000100,
		0x1CB4, 0x01000000,
		0x1CB8, 0x00000000,
		0x1CBC, 0x00000000,
		0x1CC0, 0x201B0100,
		0x1CC4, 0x00308000,
		0x1CC8, 0x5B74B6E9,
		0x1CCC, 0x01000000,
		0x1CD0, 0x00000400,
		0x1CD4, 0x01000000,
		0x1CD8, 0x01B8ADEB,
		0x1CDC, 0x01000000,
		0x1CE0, 0x00030003,
		0x1CE4, 0x4E4A0306,
		0x1CE8, 0x00000100,
		0x1CEC, 0x01000000,
		0x1CF0, 0x00000100,
		0x1CF4, 0x01000000,
		0x1CF8, 0x01B8ADEB,
		0x1CFC, 0x00000000,
		0xC60, 0x700B8040,
		0xC60, 0x700B8040,
		0xC60, 0x70146040,
		0xC60, 0x70246040,
		0xC60, 0x70346040,
		0xC60, 0x70446040,
		0xC60, 0x705B2040,
		0xC60, 0x70646040,
		0xC60, 0x707B8040,
		0xC60, 0x708B8040,
		0xC60, 0x709B8040,
		0xC60, 0x70AB8040,
		0xC60, 0x70BB6040,
		0xC60, 0x70C06040,
		0xC60, 0x70D06040,
		0xC60, 0x70EF6040,
		0xC60, 0x70F06040,
		0xE60, 0x700B8040,
		0xE60, 0x700B8040,
		0xE60, 0x70146040,
		0xE60, 0x70246040,
		0xE60, 0x70346040,
		0xE60, 0x70446040,
		0xE60, 0x705B2040,
		0xE60, 0x70646040,
		0xE60, 0x707B8040,
		0xE60, 0x708B8040,
		0xE60, 0x709B8040,
		0xE60, 0x70AB8040,
		0xE60, 0x70BB6040,
		0xE60, 0x70C06040,
		0xE60, 0x70D06040,
		0xE60, 0x70EF6040,
		0xE60, 0x70F06040,
		0xC64, 0x00800000,
		0xC64, 0x08800001,
		0xC64, 0x00800002,
		0xC64, 0x00800003,
		0xC64, 0x00800004,
		0xC64, 0x00800005,
		0xC64, 0x00800006,
		0xC64, 0x08800007,
		0xC64, 0x00004000,
		0xE64, 0x00800000,
		0xE64, 0x08800001,
		0xE64, 0x00800002,
		0xE64, 0x00800003,
		0xE64, 0x00800004,
		0xE64, 0x00800005,
		0xE64, 0x00800006,
		0xE64, 0x08800007,
		0xE64, 0x00004000,
		0x1B00, 0xF8000008,
		0x1B00, 0xF80A7008,
		0x1B00, 0xF8015008,
		0x1B00, 0xF8000008,
		0x1B04, 0xE24629D2,
		0x1B08, 0x00000080,
		0x1B0C, 0x00000000,
		0x1B10, 0x00011C00,
		0x1B14, 0x00000000,
		0x1B18, 0x00292903,
		0x1B1C, 0xA2193C32,
		0x1B20, 0x01840008,
		0x1B24, 0x01860008,
		0x1B28, 0x80060300,
		0x1B2C, 0x00000003,
		0x1B30, 0x20000000,
		0x1B34, 0x00000800,
		0x1B3C, 0x20000000,
		0x1BC0, 0x01000000,
		0x1BCC, 0x00000000,
		0x1B90, 0x0001E018,
		0x1B94, 0xF76D9F84,
		0x1BC8, 0x000C44AA,
		0x1BCC, 0x11978200,
		0x1B8C, 0x00002000,
		0x1B9C, 0x5B554F48,
		0x1BA0, 0x6F6B6661,
		0x1BA4, 0x817D7874,
		0x1BA8, 0x908C8884,
		0x1BAC, 0x9D9A9793,
		0x1BB0, 0xAAA7A4A1,
		0x1BB4, 0xB6B3B0AD,
		0x1B40, 0x02CE03E8,
		0x1B44, 0x01FD024C,
		0x1B48, 0x01A101C9,
		0x1B4C, 0x016A0183,
		0x1B50, 0x01430153,
		0x1B54, 0x01280134,
		0x1B58, 0x0112011C,
		0x1B5C, 0x01000107,
		0x1B60, 0x00F200F9,
		0x1B64, 0x00E500EB,
		0x1B68, 0x00DA00E0,
		0x1B6C, 0x00D200D6,
		0x1B70, 0x00C900CD,
		0x1B74, 0x00C200C5,
		0x1B78, 0x00BB00BE,
		0x1B7C, 0x00B500B8,
		0x1BDC, 0x40CAFFE1,
		0x1BDC, 0x4080A1E3,
		0x1BDC, 0x405165E5,
		0x1BDC, 0x403340E7,
		0x1BDC, 0x402028E9,
		0x1BDC, 0x401419EB,
		0x1BDC, 0x400D10ED,
		0x1BDC, 0x40080AEF,
		0x1BDC, 0x400506F1,
		0x1BDC, 0x400304F3,
		0x1BDC, 0x400203F5,
		0x1BDC, 0x400102F7,
		0x1BDC, 0x400101F9,
		0x1BDC, 0x400101FB,
		0x1BDC, 0x400101FD,
		0x1BDC, 0x400101FF,
		0x1BDC, 0x40CAFF81,
		0x1BDC, 0x4080A183,
		0x1BDC, 0x40516585,
		0x1BDC, 0x40334087,
		0x1BDC, 0x40202889,
		0x1BDC, 0x4014198B,
		0x1BDC, 0x400D108D,
		0x1BDC, 0x40080A8F,
		0x1BDC, 0x40050691,
		0x1BDC, 0x40030493,
		0x1BDC, 0x40020395,
		0x1BDC, 0x40010297,
		0x1BDC, 0x40010199,
		0x1BDC, 0x4001019B,
		0x1BDC, 0x4001019D,
		0x1BDC, 0x4001019F,
		0x1BDC, 0x00000000,
		0x1BDC, 0xD0000001,
		0x1BDC, 0xD0000003,
		0x1BDC, 0xD0000005,
		0x1BDC, 0xD0000007,
		0x1BDC, 0xD0000009,
		0x1BDC, 0xD000000B,
		0x1BDC, 0xD000000D,
		0x1BDC, 0xD000000F,
		0x1BDC, 0xD0000011,
		0x1BDC, 0xD0000013,
		0x1BDC, 0xD0000015,
		0x1BDC, 0xD0000017,
		0x1BDC, 0xD0000019,
		0x1BDC, 0xD000001B,
		0x1BDC, 0xD000001D,
		0x1BDC, 0xD000001F,
		0x1BDC, 0xD0000021,
		0x1BDC, 0xD0000023,
		0x1BDC, 0xD0000025,
		0x1BDC, 0xD0000027,
		0x1BDC, 0xD0000029,
		0x1BDC, 0xD000002B,
		0x1BDC, 0xD000002D,
		0x1BDC, 0xD000002F,
		0x1BDC, 0xD0000031,
		0x1BDC, 0xD0000033,
		0x1BDC, 0xD0000035,
		0x1BDC, 0xD0000037,
		0x1BDC, 0xD0000039,
		0x1BDC, 0xD000003B,
		0x1BDC, 0xD000003D,
		0x1BDC, 0xD000003F,
		0x1BDC, 0xD0000041,
		0x1BDC, 0xD0000043,
		0x1BDC, 0xD0000045,
		0x1BDC, 0xD0000047,
		0x1BDC, 0xD0000049,
		0x1BDC, 0xD000004B,
		0x1BDC, 0xD000004D,
		0x1BDC, 0xD000004F,
		0x1BDC, 0xD0000051,
		0x1BDC, 0xD0000053,
		0x1BDC, 0xD0000055,
		0x1BDC, 0xD0000057,
		0x1BDC, 0xD0000059,
		0x1BDC, 0xD000005B,
		0x1BDC, 0xD000005D,
		0x1BDC, 0xD000005F,
		0x1BDC, 0xD0000061,
		0x1BDC, 0xD0000063,
		0x1BDC, 0xD0000065,
		0x1BDC, 0xD0000067,
		0x1BDC, 0xD0000069,
		0x1BDC, 0xD000006B,
		0x1BDC, 0xD000006D,
		0x1BDC, 0xD000006F,
		0x1BDC, 0xD0000071,
		0x1BDC, 0xD0000073,
		0x1BDC, 0xD0000075,
		0x1BDC, 0xD0000077,
		0x1BDC, 0xD0000079,
		0x1BDC, 0xD000007B,
		0x1BDC, 0xD000007D,
		0x1BDC, 0xD000007F,
		0x1BDC, 0x90000081,
		0x1BDC, 0x90000083,
		0x1BDC, 0x90000085,
		0x1BDC, 0x90000087,
		0x1BDC, 0x90000089,
		0x1BDC, 0x9000008B,
		0x1BDC, 0x9000008D,
		0x1BDC, 0x9000008F,
		0x1BDC, 0x90000091,
		0x1BDC, 0x90000093,
		0x1BDC, 0x90000095,
		0x1BDC, 0x90000097,
		0x1BDC, 0x90000099,
		0x1BDC, 0x9000009B,
		0x1BDC, 0x9000009D,
		0x1BDC, 0x9000009F,
		0x1BDC, 0x900000A1,
		0x1BDC, 0x900000A3,
		0x1BDC, 0x900000A5,
		0x1BDC, 0x900000A7,
		0x1BDC, 0x900000A9,
		0x1BDC, 0x900000AB,
		0x1BDC, 0x900000AD,
		0x1BDC, 0x900000AF,
		0x1BDC, 0x900000B1,
		0x1BDC, 0x900000B3,
		0x1BDC, 0x900000B5,
		0x1BDC, 0x900000B7,
		0x1BDC, 0x900000B9,
		0x1BDC, 0x900000BB,
		0x1BDC, 0x900000BD,
		0x1BDC, 0x900000BF,
		0x1BDC, 0x900000C1,
		0x1BDC, 0x900000C3,
		0x1BDC, 0x900000C5,
		0x1BDC, 0x900000C7,
		0x1BDC, 0x900000C9,
		0x1BDC, 0x900000CB,
		0x1BDC, 0x900000CD,
		0x1BDC, 0x900000CF,
		0x1BDC, 0x900000D1,
		0x1BDC, 0x900000D3,
		0x1BDC, 0x900000D5,
		0x1BDC, 0x900000D7,
		0x1BDC, 0x900000D9,
		0x1BDC, 0x900000DB,
		0x1BDC, 0x900000DD,
		0x1BDC, 0x900000DF,
		0x1BDC, 0x900000E1,
		0x1BDC, 0x900000E3,
		0x1BDC, 0x900000E5,
		0x1BDC, 0x900000E7,
		0x1BDC, 0x900000E9,
		0x1BDC, 0x900000EB,
		0x1BDC, 0x900000ED,
		0x1BDC, 0x900000EF,
		0x1BDC, 0x900000F1,
		0x1BDC, 0x900000F3,
		0x1BDC, 0x900000F5,
		0x1BDC, 0x900000F7,
		0x1BDC, 0x900000F9,
		0x1BDC, 0x900000FB,
		0x1BDC, 0x900000FD,
		0x1BDC, 0x900000FF,
		0x1BDC, 0x00000000,
		0x1B00, 0xF8000000,
		0x1B80, 0x00000007,
		0x1B80, 0x090A0005,
		0x1B80, 0x090A0007,
		0x1B80, 0x0FFE0015,
		0x1B80, 0x0FFE0017,
		0x1B80, 0x00220025,
		0x1B80, 0x00220027,
		0x1B80, 0x00040035,
		0x1B80, 0x00040037,
		0x1B80, 0x05C00045,
		0x1B80, 0x05C00047,
		0x1B80, 0x00070055,
		0x1B80, 0x00070057,
		0x1B80, 0x64000065,
		0x1B80, 0x64000067,
		0x1B80, 0x00020075,
		0x1B80, 0x00020077,
		0x1B80, 0x00080085,
		0x1B80, 0x00080087,
		0x1B80, 0x80000095,
		0x1B80, 0x80000097,
		0x1B80, 0x090800A5,
		0x1B80, 0x090800A7,
		0x1B80, 0x0F0200B5,
		0x1B80, 0x0F0200B7,
		0x1B80, 0x002200C5,
		0x1B80, 0x002200C7,
		0x1B80, 0x000400D5,
		0x1B80, 0x000400D7,
		0x1B80, 0x05C000E5,
		0x1B80, 0x05C000E7,
		0x1B80, 0x000700F5,
		0x1B80, 0x000700F7,
		0x1B80, 0x64020105,
		0x1B80, 0x64020107,
		0x1B80, 0x00020115,
		0x1B80, 0x00020117,
		0x1B80, 0x00040125,
		0x1B80, 0x00040127,
		0x1B80, 0x4A000135,
		0x1B80, 0x4A000137,
		0x1B80, 0x4B040145,
		0x1B80, 0x4B040147,
		0x1B80, 0x85030155,
		0x1B80, 0x85030157,
		0x1B80, 0x40090165,
		0x1B80, 0x40090167,
		0x1B80, 0xE02A0175,
		0x1B80, 0xE02A0177,
		0x1B80, 0x4B050185,
		0x1B80, 0x4B050187,
		0x1B80, 0x86030195,
		0x1B80, 0x86030197,
		0x1B80, 0x400B01A5,
		0x1B80, 0x400B01A7,
		0x1B80, 0xE02A01B5,
		0x1B80, 0xE02A01B7,
		0x1B80, 0x4B0001C5,
		0x1B80, 0x4B0001C7,
		0x1B80, 0x000701D5,
		0x1B80, 0x000701D7,
		0x1B80, 0x4C0001E5,
		0x1B80, 0x4C0001E7,
		0x1B80, 0x000401F5,
		0x1B80, 0x000401F7,
		0x1B80, 0x4D040205,
		0x1B80, 0x4D040207,
		0x1B80, 0x2EE00215,
		0x1B80, 0x2EE00217,
		0x1B80, 0x00000225,
		0x1B80, 0x00000227,
		0x1B80, 0x2EF00235,
		0x1B80, 0x2EF00237,
		0x1B80, 0x00000245,
		0x1B80, 0x00000247,
		0x1B80, 0x20810255,
		0x1B80, 0x20810257,
		0x1B80, 0x23450265,
		0x1B80, 0x23450267,
		0x1B80, 0x4D000275,
		0x1B80, 0x4D000277,
		0x1B80, 0x00040285,
		0x1B80, 0x00040287,
		0x1B80, 0x30000295,
		0x1B80, 0x30000297,
		0x1B80, 0xE1D602A5,
		0x1B80, 0xE1D602A7,
		0x1B80, 0xF01102B5,
		0x1B80, 0xF01102B7,
		0x1B80, 0xF11102C5,
		0x1B80, 0xF11102C7,
		0x1B80, 0xF21102D5,
		0x1B80, 0xF21102D7,
		0x1B80, 0xF31102E5,
		0x1B80, 0xF31102E7,
		0x1B80, 0xF41102F5,
		0x1B80, 0xF41102F7,
		0x1B80, 0xF5110305,
		0x1B80, 0xF5110307,
		0x1B80, 0xF6110315,
		0x1B80, 0xF6110317,
		0x1B80, 0xF7110325,
		0x1B80, 0xF7110327,
		0x1B80, 0xF8110335,
		0x1B80, 0xF8110337,
		0x1B80, 0xF9110345,
		0x1B80, 0xF9110347,
		0x1B80, 0xFA110355,
		0x1B80, 0xFA110357,
		0x1B80, 0xFB110365,
		0x1B80, 0xFB110367,
		0x1B80, 0xFC110375,
		0x1B80, 0xFC110377,
		0x1B80, 0xFD110385,
		0x1B80, 0xFD110387,
		0x1B80, 0xFE110395,
		0x1B80, 0xFE110397,
		0x1B80, 0xFF1103A5,
		0x1B80, 0xFF1103A7,
		0x1B80, 0x000103B5,
		0x1B80, 0x000103B7,
		0x1B80, 0x305503C5,
		0x1B80, 0x305503C7,
		0x1B80, 0x306D03D5,
		0x1B80, 0x306D03D7,
		0x1B80, 0x30B803E5,
		0x1B80, 0x30B803E7,
		0x1B80, 0x30BB03F5,
		0x1B80, 0x30BB03F7,
		0x1B80, 0x306F0405,
		0x1B80, 0x306F0407,
		0x1B80, 0x307A0415,
		0x1B80, 0x307A0417,
		0x1B80, 0x30850425,
		0x1B80, 0x30850427,
		0x1B80, 0x30C50435,
		0x1B80, 0x30C50437,
		0x1B80, 0x30BF0445,
		0x1B80, 0x30BF0447,
		0x1B80, 0x30D30455,
		0x1B80, 0x30D30457,
		0x1B80, 0x30DE0465,
		0x1B80, 0x30DE0467,
		0x1B80, 0x30E90475,
		0x1B80, 0x30E90477,
		0x1B80, 0x304C0485,
		0x1B80, 0x304C0487,
		0x1B80, 0x31180495,
		0x1B80, 0x31180497,
		0x1B80, 0x312904A5,
		0x1B80, 0x312904A7,
		0x1B80, 0x313E04B5,
		0x1B80, 0x313E04B7,
		0x1B80, 0x4D0404C5,
		0x1B80, 0x4D0404C7,
		0x1B80, 0x2EE004D5,
		0x1B80, 0x2EE004D7,
		0x1B80, 0x000004E5,
		0x1B80, 0x000004E7,
		0x1B80, 0x2EF004F5,
		0x1B80, 0x2EF004F7,
		0x1B80, 0x00000505,
		0x1B80, 0x00000507,
		0x1B80, 0x20810515,
		0x1B80, 0x20810517,
		0x1B80, 0xA3B50525,
		0x1B80, 0xA3B50527,
		0x1B80, 0x4D000535,
		0x1B80, 0x4D000537,
		0x1B80, 0x30000545,
		0x1B80, 0x30000547,
		0x1B80, 0xE1690555,
		0x1B80, 0xE1690557,
		0x1B80, 0x4D040565,
		0x1B80, 0x4D040567,
		0x1B80, 0x20800575,
		0x1B80, 0x20800577,
		0x1B80, 0x00000585,
		0x1B80, 0x00000587,
		0x1B80, 0x4D000595,
		0x1B80, 0x4D000597,
		0x1B80, 0x550705A5,
		0x1B80, 0x550705A7,
		0x1B80, 0xE16105B5,
		0x1B80, 0xE16105B7,
		0x1B80, 0xE16105C5,
		0x1B80, 0xE16105C7,
		0x1B80, 0x4D0405D5,
		0x1B80, 0x4D0405D7,
		0x1B80, 0x208805E5,
		0x1B80, 0x208805E7,
		0x1B80, 0x020005F5,
		0x1B80, 0x020005F7,
		0x1B80, 0x4D000605,
		0x1B80, 0x4D000607,
		0x1B80, 0x550F0615,
		0x1B80, 0x550F0617,
		0x1B80, 0xE1610625,
		0x1B80, 0xE1610627,
		0x1B80, 0x4F020635,
		0x1B80, 0x4F020637,
		0x1B80, 0x4E000645,
		0x1B80, 0x4E000647,
		0x1B80, 0x53020655,
		0x1B80, 0x53020657,
		0x1B80, 0x52010665,
		0x1B80, 0x52010667,
		0x1B80, 0xE1650675,
		0x1B80, 0xE1650677,
		0x1B80, 0x4D080685,
		0x1B80, 0x4D080687,
		0x1B80, 0x57100695,
		0x1B80, 0x57100697,
		0x1B80, 0x570006A5,
		0x1B80, 0x570006A7,
		0x1B80, 0x4D0006B5,
		0x1B80, 0x4D0006B7,
		0x1B80, 0x000106C5,
		0x1B80, 0x000106C7,
		0x1B80, 0xE16906D5,
		0x1B80, 0xE16906D7,
		0x1B80, 0x000106E5,
		0x1B80, 0x000106E7,
		0x1B80, 0x308F06F5,
		0x1B80, 0x308F06F7,
		0x1B80, 0x00230705,
		0x1B80, 0x00230707,
		0x1B80, 0xE1C90715,
		0x1B80, 0xE1C90717,
		0x1B80, 0x00020725,
		0x1B80, 0x00020727,
		0x1B80, 0x54E90735,
		0x1B80, 0x54E90737,
		0x1B80, 0x0BA60745,
		0x1B80, 0x0BA60747,
		0x1B80, 0x00230755,
		0x1B80, 0x00230757,
		0x1B80, 0xE1C90765,
		0x1B80, 0xE1C90767,
		0x1B80, 0x00020775,
		0x1B80, 0x00020777,
		0x1B80, 0x4D300785,
		0x1B80, 0x4D300787,
		0x1B80, 0x30A80795,
		0x1B80, 0x30A80797,
		0x1B80, 0x308B07A5,
		0x1B80, 0x308B07A7,
		0x1B80, 0x002207B5,
		0x1B80, 0x002207B7,
		0x1B80, 0xE1C907C5,
		0x1B80, 0xE1C907C7,
		0x1B80, 0x000207D5,
		0x1B80, 0x000207D7,
		0x1B80, 0x54E807E5,
		0x1B80, 0x54E807E7,
		0x1B80, 0x0BA607F5,
		0x1B80, 0x0BA607F7,
		0x1B80, 0x00220805,
		0x1B80, 0x00220807,
		0x1B80, 0xE1C90815,
		0x1B80, 0xE1C90817,
		0x1B80, 0x00020825,
		0x1B80, 0x00020827,
		0x1B80, 0x4D300835,
		0x1B80, 0x4D300837,
		0x1B80, 0x30A80845,
		0x1B80, 0x30A80847,
		0x1B80, 0x63F10855,
		0x1B80, 0x63F10857,
		0x1B80, 0xE1690865,
		0x1B80, 0xE1690867,
		0x1B80, 0xE1C90875,
		0x1B80, 0xE1C90877,
		0x1B80, 0x63F40885,
		0x1B80, 0x63F40887,
		0x1B80, 0xE1690895,
		0x1B80, 0xE1690897,
		0x1B80, 0xE1C908A5,
		0x1B80, 0xE1C908A7,
		0x1B80, 0x0BA808B5,
		0x1B80, 0x0BA808B7,
		0x1B80, 0x63F808C5,
		0x1B80, 0x63F808C7,
		0x1B80, 0xE16908D5,
		0x1B80, 0xE16908D7,
		0x1B80, 0xE1C908E5,
		0x1B80, 0xE1C908E7,
		0x1B80, 0x0BA908F5,
		0x1B80, 0x0BA908F7,
		0x1B80, 0x63FC0905,
		0x1B80, 0x63FC0907,
		0x1B80, 0xE1690915,
		0x1B80, 0xE1690917,
		0x1B80, 0xE1C90925,
		0x1B80, 0xE1C90927,
		0x1B80, 0x63FF0935,
		0x1B80, 0x63FF0937,
		0x1B80, 0xE1690945,
		0x1B80, 0xE1690947,
		0x1B80, 0xE1C90955,
		0x1B80, 0xE1C90957,
		0x1B80, 0x63000965,
		0x1B80, 0x63000967,
		0x1B80, 0xE1690975,
		0x1B80, 0xE1690977,
		0x1B80, 0xE1C90985,
		0x1B80, 0xE1C90987,
		0x1B80, 0x63030995,
		0x1B80, 0x63030997,
		0x1B80, 0xE16909A5,
		0x1B80, 0xE16909A7,
		0x1B80, 0xE1C909B5,
		0x1B80, 0xE1C909B7,
		0x1B80, 0xF4D409C5,
		0x1B80, 0xF4D409C7,
		0x1B80, 0x630709D5,
		0x1B80, 0x630709D7,
		0x1B80, 0xE16909E5,
		0x1B80, 0xE16909E7,
		0x1B80, 0xE1C909F5,
		0x1B80, 0xE1C909F7,
		0x1B80, 0xF5DB0A05,
		0x1B80, 0xF5DB0A07,
		0x1B80, 0x630B0A15,
		0x1B80, 0x630B0A17,
		0x1B80, 0xE1690A25,
		0x1B80, 0xE1690A27,
		0x1B80, 0xE1C90A35,
		0x1B80, 0xE1C90A37,
		0x1B80, 0x630E0A45,
		0x1B80, 0x630E0A47,
		0x1B80, 0xE1690A55,
		0x1B80, 0xE1690A57,
		0x1B80, 0xE1C90A65,
		0x1B80, 0xE1C90A67,
		0x1B80, 0x4D300A75,
		0x1B80, 0x4D300A77,
		0x1B80, 0x55010A85,
		0x1B80, 0x55010A87,
		0x1B80, 0x57040A95,
		0x1B80, 0x57040A97,
		0x1B80, 0x57000AA5,
		0x1B80, 0x57000AA7,
		0x1B80, 0x96000AB5,
		0x1B80, 0x96000AB7,
		0x1B80, 0x57080AC5,
		0x1B80, 0x57080AC7,
		0x1B80, 0x57000AD5,
		0x1B80, 0x57000AD7,
		0x1B80, 0x95000AE5,
		0x1B80, 0x95000AE7,
		0x1B80, 0x4D000AF5,
		0x1B80, 0x4D000AF7,
		0x1B80, 0x6C070B05,
		0x1B80, 0x6C070B07,
		0x1B80, 0x7B200B15,
		0x1B80, 0x7B200B17,
		0x1B80, 0x7A000B25,
		0x1B80, 0x7A000B27,
		0x1B80, 0x79000B35,
		0x1B80, 0x79000B37,
		0x1B80, 0x7F200B45,
		0x1B80, 0x7F200B47,
		0x1B80, 0x7E000B55,
		0x1B80, 0x7E000B57,
		0x1B80, 0x7D000B65,
		0x1B80, 0x7D000B67,
		0x1B80, 0x00010B75,
		0x1B80, 0x00010B77,
		0x1B80, 0x62850B85,
		0x1B80, 0x62850B87,
		0x1B80, 0xE1690B95,
		0x1B80, 0xE1690B97,
		0x1B80, 0x00010BA5,
		0x1B80, 0x00010BA7,
		0x1B80, 0x5C320BB5,
		0x1B80, 0x5C320BB7,
		0x1B80, 0xE1C50BC5,
		0x1B80, 0xE1C50BC7,
		0x1B80, 0xE1950BD5,
		0x1B80, 0xE1950BD7,
		0x1B80, 0x00010BE5,
		0x1B80, 0x00010BE7,
		0x1B80, 0x5C320BF5,
		0x1B80, 0x5C320BF7,
		0x1B80, 0x63F40C05,
		0x1B80, 0x63F40C07,
		0x1B80, 0x62850C15,
		0x1B80, 0x62850C17,
		0x1B80, 0x0BB00C25,
		0x1B80, 0x0BB00C27,
		0x1B80, 0xE1690C35,
		0x1B80, 0xE1690C37,
		0x1B80, 0xE1C90C45,
		0x1B80, 0xE1C90C47,
		0x1B80, 0x5C320C55,
		0x1B80, 0x5C320C57,
		0x1B80, 0x63FC0C65,
		0x1B80, 0x63FC0C67,
		0x1B80, 0x62850C75,
		0x1B80, 0x62850C77,
		0x1B80, 0x0BB10C85,
		0x1B80, 0x0BB10C87,
		0x1B80, 0xE1690C95,
		0x1B80, 0xE1690C97,
		0x1B80, 0xE1C90CA5,
		0x1B80, 0xE1C90CA7,
		0x1B80, 0x63030CB5,
		0x1B80, 0x63030CB7,
		0x1B80, 0xE1690CC5,
		0x1B80, 0xE1690CC7,
		0x1B80, 0xE1C90CD5,
		0x1B80, 0xE1C90CD7,
		0x1B80, 0xF7040CE5,
		0x1B80, 0xF7040CE7,
		0x1B80, 0x630B0CF5,
		0x1B80, 0x630B0CF7,
		0x1B80, 0xE1690D05,
		0x1B80, 0xE1690D07,
		0x1B80, 0xE1C90D15,
		0x1B80, 0xE1C90D17,
		0x1B80, 0x00010D25,
		0x1B80, 0x00010D27,
		0x1B80, 0x30F70D35,
		0x1B80, 0x30F70D37,
		0x1B80, 0x00230D45,
		0x1B80, 0x00230D47,
		0x1B80, 0xE1CE0D55,
		0x1B80, 0xE1CE0D57,
		0x1B80, 0x00020D65,
		0x1B80, 0x00020D67,
		0x1B80, 0x54E90D75,
		0x1B80, 0x54E90D77,
		0x1B80, 0x0BA60D85,
		0x1B80, 0x0BA60D87,
		0x1B80, 0x00230D95,
		0x1B80, 0x00230D97,
		0x1B80, 0xE1CE0DA5,
		0x1B80, 0xE1CE0DA7,
		0x1B80, 0x00020DB5,
		0x1B80, 0x00020DB7,
		0x1B80, 0x4D100DC5,
		0x1B80, 0x4D100DC7,
		0x1B80, 0x30A80DD5,
		0x1B80, 0x30A80DD7,
		0x1B80, 0x30F10DE5,
		0x1B80, 0x30F10DE7,
		0x1B80, 0x00220DF5,
		0x1B80, 0x00220DF7,
		0x1B80, 0xE1CE0E05,
		0x1B80, 0xE1CE0E07,
		0x1B80, 0x00020E15,
		0x1B80, 0x00020E17,
		0x1B80, 0x54E80E25,
		0x1B80, 0x54E80E27,
		0x1B80, 0x0BA60E35,
		0x1B80, 0x0BA60E37,
		0x1B80, 0x00220E45,
		0x1B80, 0x00220E47,
		0x1B80, 0xE1CE0E55,
		0x1B80, 0xE1CE0E57,
		0x1B80, 0x00020E65,
		0x1B80, 0x00020E67,
		0x1B80, 0x4D100E75,
		0x1B80, 0x4D100E77,
		0x1B80, 0x30A80E85,
		0x1B80, 0x30A80E87,
		0x1B80, 0x5C320E95,
		0x1B80, 0x5C320E97,
		0x1B80, 0x54F00EA5,
		0x1B80, 0x54F00EA7,
		0x1B80, 0x67F10EB5,
		0x1B80, 0x67F10EB7,
		0x1B80, 0xE1950EC5,
		0x1B80, 0xE1950EC7,
		0x1B80, 0xE1CE0ED5,
		0x1B80, 0xE1CE0ED7,
		0x1B80, 0x67F40EE5,
		0x1B80, 0x67F40EE7,
		0x1B80, 0xE1950EF5,
		0x1B80, 0xE1950EF7,
		0x1B80, 0xE1CE0F05,
		0x1B80, 0xE1CE0F07,
		0x1B80, 0x5C320F15,
		0x1B80, 0x5C320F17,
		0x1B80, 0x54F10F25,
		0x1B80, 0x54F10F27,
		0x1B80, 0x0BA80F35,
		0x1B80, 0x0BA80F37,
		0x1B80, 0x67F80F45,
		0x1B80, 0x67F80F47,
		0x1B80, 0xE1950F55,
		0x1B80, 0xE1950F57,
		0x1B80, 0xE1CE0F65,
		0x1B80, 0xE1CE0F67,
		0x1B80, 0x5C320F75,
		0x1B80, 0x5C320F77,
		0x1B80, 0x54F10F85,
		0x1B80, 0x54F10F87,
		0x1B80, 0x0BA90F95,
		0x1B80, 0x0BA90F97,
		0x1B80, 0x67FC0FA5,
		0x1B80, 0x67FC0FA7,
		0x1B80, 0xE1950FB5,
		0x1B80, 0xE1950FB7,
		0x1B80, 0xE1CE0FC5,
		0x1B80, 0xE1CE0FC7,
		0x1B80, 0x67FF0FD5,
		0x1B80, 0x67FF0FD7,
		0x1B80, 0xE1950FE5,
		0x1B80, 0xE1950FE7,
		0x1B80, 0xE1CE0FF5,
		0x1B80, 0xE1CE0FF7,
		0x1B80, 0x5C321005,
		0x1B80, 0x5C321007,
		0x1B80, 0x54F21015,
		0x1B80, 0x54F21017,
		0x1B80, 0x67001025,
		0x1B80, 0x67001027,
		0x1B80, 0xE1951035,
		0x1B80, 0xE1951037,
		0x1B80, 0xE1CE1045,
		0x1B80, 0xE1CE1047,
		0x1B80, 0x67031055,
		0x1B80, 0x67031057,
		0x1B80, 0xE1951065,
		0x1B80, 0xE1951067,
		0x1B80, 0xE1CE1075,
		0x1B80, 0xE1CE1077,
		0x1B80, 0xF9CC1085,
		0x1B80, 0xF9CC1087,
		0x1B80, 0x67071095,
		0x1B80, 0x67071097,
		0x1B80, 0xE19510A5,
		0x1B80, 0xE19510A7,
		0x1B80, 0xE1CE10B5,
		0x1B80, 0xE1CE10B7,
		0x1B80, 0xFAD310C5,
		0x1B80, 0xFAD310C7,
		0x1B80, 0x5C3210D5,
		0x1B80, 0x5C3210D7,
		0x1B80, 0x54F310E5,
		0x1B80, 0x54F310E7,
		0x1B80, 0x670B10F5,
		0x1B80, 0x670B10F7,
		0x1B80, 0xE1951105,
		0x1B80, 0xE1951107,
		0x1B80, 0xE1CE1115,
		0x1B80, 0xE1CE1117,
		0x1B80, 0x670E1125,
		0x1B80, 0x670E1127,
		0x1B80, 0xE1951135,
		0x1B80, 0xE1951137,
		0x1B80, 0xE1CE1145,
		0x1B80, 0xE1CE1147,
		0x1B80, 0x4D101155,
		0x1B80, 0x4D101157,
		0x1B80, 0x30A81165,
		0x1B80, 0x30A81167,
		0x1B80, 0x00011175,
		0x1B80, 0x00011177,
		0x1B80, 0x6C001185,
		0x1B80, 0x6C001187,
		0x1B80, 0x00061195,
		0x1B80, 0x00061197,
		0x1B80, 0x530011A5,
		0x1B80, 0x530011A7,
		0x1B80, 0x57F711B5,
		0x1B80, 0x57F711B7,
		0x1B80, 0x582111C5,
		0x1B80, 0x582111C7,
		0x1B80, 0x592E11D5,
		0x1B80, 0x592E11D7,
		0x1B80, 0x5A3811E5,
		0x1B80, 0x5A3811E7,
		0x1B80, 0x5B4111F5,
		0x1B80, 0x5B4111F7,
		0x1B80, 0x00071205,
		0x1B80, 0x00071207,
		0x1B80, 0x5C001215,
		0x1B80, 0x5C001217,
		0x1B80, 0x4B001225,
		0x1B80, 0x4B001227,
		0x1B80, 0x4E8F1235,
		0x1B80, 0x4E8F1237,
		0x1B80, 0x4F151245,
		0x1B80, 0x4F151247,
		0x1B80, 0x00041255,
		0x1B80, 0x00041257,
		0x1B80, 0xE1B31265,
		0x1B80, 0xE1B31267,
		0x1B80, 0xAB001275,
		0x1B80, 0xAB001277,
		0x1B80, 0x00011285,
		0x1B80, 0x00011287,
		0x1B80, 0x6C001295,
		0x1B80, 0x6C001297,
		0x1B80, 0x000612A5,
		0x1B80, 0x000612A7,
		0x1B80, 0x530012B5,
		0x1B80, 0x530012B7,
		0x1B80, 0x57F712C5,
		0x1B80, 0x57F712C7,
		0x1B80, 0x582112D5,
		0x1B80, 0x582112D7,
		0x1B80, 0x592E12E5,
		0x1B80, 0x592E12E7,
		0x1B80, 0x5A3812F5,
		0x1B80, 0x5A3812F7,
		0x1B80, 0x5B411305,
		0x1B80, 0x5B411307,
		0x1B80, 0x00071315,
		0x1B80, 0x00071317,
		0x1B80, 0x5C001325,
		0x1B80, 0x5C001327,
		0x1B80, 0x4B401335,
		0x1B80, 0x4B401337,
		0x1B80, 0x4E971345,
		0x1B80, 0x4E971347,
		0x1B80, 0x4F111355,
		0x1B80, 0x4F111357,
		0x1B80, 0x00041365,
		0x1B80, 0x00041367,
		0x1B80, 0xE1B31375,
		0x1B80, 0xE1B31377,
		0x1B80, 0xAB001385,
		0x1B80, 0xAB001387,
		0x1B80, 0x8B001395,
		0x1B80, 0x8B001397,
		0x1B80, 0xAB0013A5,
		0x1B80, 0xAB0013A7,
		0x1B80, 0x8A1913B5,
		0x1B80, 0x8A1913B7,
		0x1B80, 0x301D13C5,
		0x1B80, 0x301D13C7,
		0x1B80, 0x000113D5,
		0x1B80, 0x000113D7,
		0x1B80, 0x6C0113E5,
		0x1B80, 0x6C0113E7,
		0x1B80, 0x000613F5,
		0x1B80, 0x000613F7,
		0x1B80, 0x53011405,
		0x1B80, 0x53011407,
		0x1B80, 0x57F71415,
		0x1B80, 0x57F71417,
		0x1B80, 0x58211425,
		0x1B80, 0x58211427,
		0x1B80, 0x592E1435,
		0x1B80, 0x592E1437,
		0x1B80, 0x5A381445,
		0x1B80, 0x5A381447,
		0x1B80, 0x5B411455,
		0x1B80, 0x5B411457,
		0x1B80, 0x00071465,
		0x1B80, 0x00071467,
		0x1B80, 0x5C001475,
		0x1B80, 0x5C001477,
		0x1B80, 0x4B001485,
		0x1B80, 0x4B001487,
		0x1B80, 0x4E871495,
		0x1B80, 0x4E871497,
		0x1B80, 0x4F1114A5,
		0x1B80, 0x4F1114A7,
		0x1B80, 0x000414B5,
		0x1B80, 0x000414B7,
		0x1B80, 0xE1B314C5,
		0x1B80, 0xE1B314C7,
		0x1B80, 0xAB0014D5,
		0x1B80, 0xAB0014D7,
		0x1B80, 0x000614E5,
		0x1B80, 0x000614E7,
		0x1B80, 0x577714F5,
		0x1B80, 0x577714F7,
		0x1B80, 0x00071505,
		0x1B80, 0x00071507,
		0x1B80, 0x4E861515,
		0x1B80, 0x4E861517,
		0x1B80, 0x00041525,
		0x1B80, 0x00041527,
		0x1B80, 0x00011535,
		0x1B80, 0x00011537,
		0x1B80, 0x00011545,
		0x1B80, 0x00011547,
		0x1B80, 0x7B241555,
		0x1B80, 0x7B241557,
		0x1B80, 0x7A401565,
		0x1B80, 0x7A401567,
		0x1B80, 0x79001575,
		0x1B80, 0x79001577,
		0x1B80, 0x55031585,
		0x1B80, 0x55031587,
		0x1B80, 0x31611595,
		0x1B80, 0x31611597,
		0x1B80, 0x7B1C15A5,
		0x1B80, 0x7B1C15A7,
		0x1B80, 0x7A4015B5,
		0x1B80, 0x7A4015B7,
		0x1B80, 0x550B15C5,
		0x1B80, 0x550B15C7,
		0x1B80, 0x316115D5,
		0x1B80, 0x316115D7,
		0x1B80, 0x7B2015E5,
		0x1B80, 0x7B2015E7,
		0x1B80, 0x7A0015F5,
		0x1B80, 0x7A0015F7,
		0x1B80, 0x55131605,
		0x1B80, 0x55131607,
		0x1B80, 0x74011615,
		0x1B80, 0x74011617,
		0x1B80, 0x74001625,
		0x1B80, 0x74001627,
		0x1B80, 0x8E001635,
		0x1B80, 0x8E001637,
		0x1B80, 0x00011645,
		0x1B80, 0x00011647,
		0x1B80, 0x57021655,
		0x1B80, 0x57021657,
		0x1B80, 0x57001665,
		0x1B80, 0x57001667,
		0x1B80, 0x97001675,
		0x1B80, 0x97001677,
		0x1B80, 0x00011685,
		0x1B80, 0x00011687,
		0x1B80, 0x4F781695,
		0x1B80, 0x4F781697,
		0x1B80, 0x538816A5,
		0x1B80, 0x538816A7,
		0x1B80, 0xE17516B5,
		0x1B80, 0xE17516B7,
		0x1B80, 0x548016C5,
		0x1B80, 0x548016C7,
		0x1B80, 0x540016D5,
		0x1B80, 0x540016D7,
		0x1B80, 0x548116E5,
		0x1B80, 0x548116E7,
		0x1B80, 0x540016F5,
		0x1B80, 0x540016F7,
		0x1B80, 0x54821705,
		0x1B80, 0x54821707,
		0x1B80, 0x54001715,
		0x1B80, 0x54001717,
		0x1B80, 0xE1801725,
		0x1B80, 0xE1801727,
		0x1B80, 0xBF1D1735,
		0x1B80, 0xBF1D1737,
		0x1B80, 0x301D1745,
		0x1B80, 0x301D1747,
		0x1B80, 0xE1551755,
		0x1B80, 0xE1551757,
		0x1B80, 0xE15A1765,
		0x1B80, 0xE15A1767,
		0x1B80, 0xE15E1775,
		0x1B80, 0xE15E1777,
		0x1B80, 0xE1651785,
		0x1B80, 0xE1651787,
		0x1B80, 0xE1C51795,
		0x1B80, 0xE1C51797,
		0x1B80, 0x551317A5,
		0x1B80, 0x551317A7,
		0x1B80, 0xE16117B5,
		0x1B80, 0xE16117B7,
		0x1B80, 0x551517C5,
		0x1B80, 0x551517C7,
		0x1B80, 0xE16517D5,
		0x1B80, 0xE16517D7,
		0x1B80, 0xE1C517E5,
		0x1B80, 0xE1C517E7,
		0x1B80, 0x000117F5,
		0x1B80, 0x000117F7,
		0x1B80, 0x54BF1805,
		0x1B80, 0x54BF1807,
		0x1B80, 0x54C01815,
		0x1B80, 0x54C01817,
		0x1B80, 0x54A31825,
		0x1B80, 0x54A31827,
		0x1B80, 0x54C11835,
		0x1B80, 0x54C11837,
		0x1B80, 0x54A41845,
		0x1B80, 0x54A41847,
		0x1B80, 0x4C181855,
		0x1B80, 0x4C181857,
		0x1B80, 0xBF071865,
		0x1B80, 0xBF071867,
		0x1B80, 0x54C21875,
		0x1B80, 0x54C21877,
		0x1B80, 0x54A41885,
		0x1B80, 0x54A41887,
		0x1B80, 0xBF041895,
		0x1B80, 0xBF041897,
		0x1B80, 0x54C118A5,
		0x1B80, 0x54C118A7,
		0x1B80, 0x54A318B5,
		0x1B80, 0x54A318B7,
		0x1B80, 0xBF0118C5,
		0x1B80, 0xBF0118C7,
		0x1B80, 0xE1D318D5,
		0x1B80, 0xE1D318D7,
		0x1B80, 0x54DF18E5,
		0x1B80, 0x54DF18E7,
		0x1B80, 0x000118F5,
		0x1B80, 0x000118F7,
		0x1B80, 0x54BF1905,
		0x1B80, 0x54BF1907,
		0x1B80, 0x54E51915,
		0x1B80, 0x54E51917,
		0x1B80, 0x050A1925,
		0x1B80, 0x050A1927,
		0x1B80, 0x54DF1935,
		0x1B80, 0x54DF1937,
		0x1B80, 0x00011945,
		0x1B80, 0x00011947,
		0x1B80, 0x7F201955,
		0x1B80, 0x7F201957,
		0x1B80, 0x7E001965,
		0x1B80, 0x7E001967,
		0x1B80, 0x7D001975,
		0x1B80, 0x7D001977,
		0x1B80, 0x55011985,
		0x1B80, 0x55011987,
		0x1B80, 0x5C311995,
		0x1B80, 0x5C311997,
		0x1B80, 0xE16119A5,
		0x1B80, 0xE16119A7,
		0x1B80, 0xE16519B5,
		0x1B80, 0xE16519B7,
		0x1B80, 0x548019C5,
		0x1B80, 0x548019C7,
		0x1B80, 0x540019D5,
		0x1B80, 0x540019D7,
		0x1B80, 0x548119E5,
		0x1B80, 0x548119E7,
		0x1B80, 0x540019F5,
		0x1B80, 0x540019F7,
		0x1B80, 0x54821A05,
		0x1B80, 0x54821A07,
		0x1B80, 0x54001A15,
		0x1B80, 0x54001A17,
		0x1B80, 0xE1801A25,
		0x1B80, 0xE1801A27,
		0x1B80, 0xBFED1A35,
		0x1B80, 0xBFED1A37,
		0x1B80, 0x301D1A45,
		0x1B80, 0x301D1A47,
		0x1B80, 0x00231A55,
		0x1B80, 0x00231A57,
		0x1B80, 0x7B201A65,
		0x1B80, 0x7B201A67,
		0x1B80, 0x7A001A75,
		0x1B80, 0x7A001A77,
		0x1B80, 0x79001A85,
		0x1B80, 0x79001A87,
		0x1B80, 0xE1C91A95,
		0x1B80, 0xE1C91A97,
		0x1B80, 0x00021AA5,
		0x1B80, 0x00021AA7,
		0x1B80, 0x00011AB5,
		0x1B80, 0x00011AB7,
		0x1B80, 0x00221AC5,
		0x1B80, 0x00221AC7,
		0x1B80, 0x7B201AD5,
		0x1B80, 0x7B201AD7,
		0x1B80, 0x7A001AE5,
		0x1B80, 0x7A001AE7,
		0x1B80, 0x79001AF5,
		0x1B80, 0x79001AF7,
		0x1B80, 0xE1C91B05,
		0x1B80, 0xE1C91B07,
		0x1B80, 0x00021B15,
		0x1B80, 0x00021B17,
		0x1B80, 0x00011B25,
		0x1B80, 0x00011B27,
		0x1B80, 0x74021B35,
		0x1B80, 0x74021B37,
		0x1B80, 0x003F1B45,
		0x1B80, 0x003F1B47,
		0x1B80, 0x74001B55,
		0x1B80, 0x74001B57,
		0x1B80, 0x00021B65,
		0x1B80, 0x00021B67,
		0x1B80, 0x00011B75,
		0x1B80, 0x00011B77,
		0x1B80, 0x4D041B85,
		0x1B80, 0x4D041B87,
		0x1B80, 0x2EF81B95,
		0x1B80, 0x2EF81B97,
		0x1B80, 0x00001BA5,
		0x1B80, 0x00001BA7,
		0x1B80, 0x23301BB5,
		0x1B80, 0x23301BB7,
		0x1B80, 0x00241BC5,
		0x1B80, 0x00241BC7,
		0x1B80, 0x23E01BD5,
		0x1B80, 0x23E01BD7,
		0x1B80, 0x003F1BE5,
		0x1B80, 0x003F1BE7,
		0x1B80, 0x23FC1BF5,
		0x1B80, 0x23FC1BF7,
		0x1B80, 0xBFCE1C05,
		0x1B80, 0xBFCE1C07,
		0x1B80, 0x2EF01C15,
		0x1B80, 0x2EF01C17,
		0x1B80, 0x00001C25,
		0x1B80, 0x00001C27,
		0x1B80, 0x4D001C35,
		0x1B80, 0x4D001C37,
		0x1B80, 0x00011C45,
		0x1B80, 0x00011C47,
		0x1B80, 0x549F1C55,
		0x1B80, 0x549F1C57,
		0x1B80, 0x54FF1C65,
		0x1B80, 0x54FF1C67,
		0x1B80, 0x54001C75,
		0x1B80, 0x54001C77,
		0x1B80, 0x00011C85,
		0x1B80, 0x00011C87,
		0x1B80, 0x5C311C95,
		0x1B80, 0x5C311C97,
		0x1B80, 0x07141CA5,
		0x1B80, 0x07141CA7,
		0x1B80, 0x54001CB5,
		0x1B80, 0x54001CB7,
		0x1B80, 0x5C321CC5,
		0x1B80, 0x5C321CC7,
		0x1B80, 0x00011CD5,
		0x1B80, 0x00011CD7,
		0x1B80, 0x5C321CE5,
		0x1B80, 0x5C321CE7,
		0x1B80, 0x07141CF5,
		0x1B80, 0x07141CF7,
		0x1B80, 0x54001D05,
		0x1B80, 0x54001D07,
		0x1B80, 0x5C311D15,
		0x1B80, 0x5C311D17,
		0x1B80, 0x00011D25,
		0x1B80, 0x00011D27,
		0x1B80, 0x4C981D35,
		0x1B80, 0x4C981D37,
		0x1B80, 0x4C181D45,
		0x1B80, 0x4C181D47,
		0x1B80, 0x00011D55,
		0x1B80, 0x00011D57,
		0x1B80, 0x5C321D65,
		0x1B80, 0x5C321D67,
		0x1B80, 0x62841D75,
		0x1B80, 0x62841D77,
		0x1B80, 0x66861D85,
		0x1B80, 0x66861D87,
		0x1B80, 0x6C031D95,
		0x1B80, 0x6C031D97,
		0x1B80, 0x7B201DA5,
		0x1B80, 0x7B201DA7,
		0x1B80, 0x7A001DB5,
		0x1B80, 0x7A001DB7,
		0x1B80, 0x79001DC5,
		0x1B80, 0x79001DC7,
		0x1B80, 0x7F201DD5,
		0x1B80, 0x7F201DD7,
		0x1B80, 0x7E001DE5,
		0x1B80, 0x7E001DE7,
		0x1B80, 0x7D001DF5,
		0x1B80, 0x7D001DF7,
		0x1B80, 0x09011E05,
		0x1B80, 0x09011E07,
		0x1B80, 0x0C011E15,
		0x1B80, 0x0C011E17,
		0x1B80, 0x0BA61E25,
		0x1B80, 0x0BA61E27,
		0x1B80, 0x00011E35,
		0x1B80, 0x00011E37,
		0x1B80, 0x00000006,
		0x1B80, 0x00000002,

};

void
odm_read_and_config_mp_8821c_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8821c_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8821c_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8821c(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_phy_reg(void)
{
		return 56;
}

/******************************************************************************
 *                           phy_reg_mp.TXT
 ******************************************************************************/

const u32 array_mp_8821c_phy_reg_mp[] = {
		0x810, 0x21104285,
		0xAA8, 0xEAD30004,

};

void
odm_read_and_config_mp_8821c_phy_reg_mp(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8821c_phy_reg_mp) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8821c_phy_reg_mp;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8821c(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8821c_phy_reg_mp(void)
{
		return 56;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8821C
const u32 array_mp_8821c_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36363636,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x22222224,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x34343434,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x32343434,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x32343434,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x24262830,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x20202022
};

#endif

void
odm_read_and_config_mp_8821c_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8821C

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8821c_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8821c_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8821c(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

/******************************************************************************
 *                           phy_reg_pg_type0x28.TXT
 ******************************************************************************/

#ifdef CONFIG_8821C_TYPE0X28
const u32 array_mp_8821c_phy_reg_pg_type0x28[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x32343638,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36363636,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x34363636,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x22222224,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x40404040,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x32343638,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x38383838,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x36363636,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x30323436,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x26262628
};

#endif

void
odm_read_and_config_mp_8821c_phy_reg_pg_type0x28(struct dm_struct *dm)
{
#ifdef CONFIG_8821C_TYPE0X28

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8821c_phy_reg_pg_type0x28) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8821c_phy_reg_pg_type0x28;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8821c(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

