/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __PHYDM_PMAC_TX_SETTING_H__
#define __PHYDM_PMAC_TX_SETTING_H__

#define PMAC_TX_SETTING_VERSION "1.3"

/* @1 ============================================================
 * 1  Definition
 * 1 ============================================================
 */
#define RANDOM_BY_PN32 0x12
/* @1 ============================================================
 * 1  structure
 * 1 ============================================================
 */
struct phydm_pmac_info {
	u8 en_pmac_tx:1; /*@ disable pmac 1: enable pmac */
	u8 mode:3; /*@ 0: Packet TX 3:Continuous TX */
	/* @u8 Ntx:4; */
	u8 tx_rate; /* @should be HW rate*/
	/* @u8 TX_RATE_HEX; */
	u8 tx_sc;
	/* @u8 bSGI:1; */
	u8 is_short_preamble:1;
	/* @u8 bSTBC:1; */
	/* @u8 bLDPC:1; */
	u8 ndp_sound:1;
	u8 bw:3; /* @0:20 1:40 2:80Mhz */
	u8 m_stbc; /* @bSTBC + 1 */
	u16 packet_period;
	u32 packet_count;
	/* @u32 PacketLength; */
	u8 packet_pattern;
	u16 sfd;
	u8 signal_field;
	u8 service_field;
	u16 length;
	u8 crc16[2];
	u8 lsig[3];
	u8 ht_sig[6];
	u8 vht_sig_a[6];
	u8 vht_sig_b[4];
	u8 vht_sig_b_crc;
	u8 vht_delimiter[4];
	/* @u8 mac_addr[6]; */
};

struct phydm_pmac_tx {
	boolean is_cck_rate;
	boolean is_ofdm_rate;
	boolean is_ht_rate;
	boolean is_vht_rate;
	boolean cck_cont_tx;
	boolean ofdm_cont_tx;
	u8 path;
	u32 tx_scailing;
};

/* @1 ============================================================
 * 1  enumeration
 * 1 ============================================================
 */

enum phydm_pmac_mode {
	NONE_TEST,
	PKTS_TX,
	PKTS_RX,
	CONT_TX,
	OFDM_SINGLE_TONE_TX,
	CCK_CARRIER_SIPPRESSION_TX
};

/* @1 ============================================================
 * 1  function prototype
 * 1 ============================================================
 */
void phydm_start_cck_cont_tx(void *dm_void, struct phydm_pmac_info *tx_info);

void phydm_stop_cck_cont_tx(void *dm_void);

void phydm_start_ofdm_cont_tx(void *dm_void);

void phydm_stop_ofdm_cont_tx(void *dm_void);

void phydm_set_single_tone(void *dm_void, boolean is_single_tone,
			   boolean en_pmac_tx, u8 path);

void phydm_set_pmac_tx(void *dm_void, struct phydm_pmac_info *tx_info,
		       enum rf_path mpt_rf_path);

void phydm_set_tmac_tx(void *dm_void);

#endif
