/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __PHYDM_MP_H__
#define __PHYDM_MP_H__

#define MP_VERSION "1.3"

/* @1 ============================================================
 * 1  Definition
 * 1 ============================================================
 */
/* @1 ============================================================
 * 1  structure
 * 1 ============================================================
 */
struct phydm_mp {
	/* @Rx OK count, statistics used in Mass Production Test.*/
	u64 tx_phy_ok_cnt;
	u64 rx_phy_ok_cnt;
	/* @Rx CRC32 error count, statistics used in Mass Production Test.*/
	u64 rx_phy_crc_err_cnt;
	/* @The Value of IO operation is depend of MptActType.*/
	u32 io_value;
	u32 rf_reg0;
	/* @u32 rfe_sel_a_0;*/
	/* @u32 rfe_sel_b_0;*/
	/* @u32 rfe_sel_c_0;*/
	/* @u32 rfe_sel_d_0;*/
	/* @u32 rfe_sel_a_1;*/
	/* @u32 rfe_sel_b_1;*/
	/* @u32 rfe_sel_c_1;*/
	/* @u32 rfe_sel_d_1;*/
};

/* @1 ============================================================
 * 1  enumeration
 * 1 ============================================================
 */
enum TX_MODE_OFDM {
	OFDM_OFF = 0,	
	OFDM_CONT_TX = 1,
	OFDM_SINGLE_CARRIER = 2,
	OFDM_SINGLE_TONE = 4,
};
/* @1 ============================================================
 * 1  function prototype
 * 1 ============================================================
 */
void phydm_mp_set_crystal_cap(void *dm_void, u8 crystal_cap);

void phydm_mp_set_single_tone(void *dm_void, boolean is_single_tone, u8 path);

void phydm_mp_set_carrier_supp(void *dm_void, boolean is_carrier_supp,
			       u32 rate_index);

void phydm_mp_set_single_carrier(void *dm_void, boolean is_single_carrier);

void phydm_mp_reset_rx_counters_phy(void *dm_void);

void phydm_mp_get_tx_ok(void *dm_void, u32 rate_index);

void phydm_mp_get_rx_ok(void *dm_void);
#endif
