/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __PHYDMDYNAMICTXPOWER_H__
#define __PHYDMDYNAMICTXPOWER_H__

#ifdef CONFIG_DYNAMIC_TX_TWR
/* @============================================================
 *  Definition
 * ============================================================
 */

/* 2019.2.12, refine code structure and set macid 127 only for 22C*/
#define DYNAMIC_TXPWR_VERSION "1.8"

#if (DM_ODM_SUPPORT_TYPE == ODM_AP)
#define TX_POWER_NEAR_FIELD_THRESH_LVL2 74
#define TX_POWER_NEAR_FIELD_THRESH_LVL1 60
#define TX_POWER_NEAR_FIELD_THRESH_AP 0x3F
#elif (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#define TX_POWER_NEAR_FIELD_THRESH_LVL2 74
#define TX_POWER_NEAR_FIELD_THRESH_LVL1 67
#elif (DM_ODM_SUPPORT_TYPE == ODM_CE)
#define TX_POWER_NEAR_FIELD_THRESH_LVL2 74
#define TX_POWER_NEAR_FIELD_THRESH_LVL1 60
#endif

#if (DM_ODM_SUPPORT_TYPE == ODM_AP)
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL3 255
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL2 74
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL1 60
#elif (DM_ODM_SUPPORT_TYPE == ODM_WIN)
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL3 90
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL2 85
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL1 80
#elif (DM_ODM_SUPPORT_TYPE == ODM_CE)
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL3 90
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL2 85
#define TX_PWR_NEAR_FIELD_TH_JGR3_LVL1 80
#endif

#define tx_high_pwr_level_normal 0
#define tx_high_pwr_level_level1 1
#define tx_high_pwr_level_level2 2
#define tx_high_pwr_level_level3 3
#define tx_high_pwr_level_unchange 4

/* @============================================================
 * enumrate
 * ============================================================
 */
enum phydm_dtp_power_offset {
	PHYDM_OFFSET_ZERO = 0,
	PHYDM_OFFSET_MINUS_3DB = 1,
	PHYDM_OFFSET_MINUS_7DB = 2,
	PHYDM_OFFSET_MINUS_11DB = 3,
	PHYDM_OFFSET_ADD_3DB = 4,
	PHYDM_OFFSET_ADD_6DB = 5
};

enum phydm_dtp_power_offset_2nd {
	PHYDM_2ND_OFFSET_ZERO = 0,
	PHYDM_2ND_OFFSET_MINUS_3DB = 1,
	PHYDM_2ND_OFFSET_MINUS_7DB = 2,
	PHYDM_2ND_OFFSET_MINUS_11DB = 3
};

enum phydm_dtp_power_offset_bbram {
	/*@ HW min use 1dB*/
	PHYDM_BBRAM_OFFSET_ZERO = 0,
	PHYDM_BBRAM_OFFSET_MINUS_3DB = -3,
	PHYDM_BBRAM_OFFSET_MINUS_7DB = -7,
	PHYDM_BBRAM_OFFSET_MINUS_11DB = -11
};

enum phydm_dtp_power_pkt_type {
	RAM_PWR_OFST0		= 0,
	RAM_PWR_OFST1		= 1,
	REG_PWR_OFST0		= 2,
	REG_PWR_OFST1		= 3
};

/* @============================================================
 *  structure
 * ============================================================
 */

/* @============================================================
 *  Function Prototype
 * ============================================================
 */

extern void
odm_set_dyntxpwr(void *dm_void, u8 *desc, u8 mac_id);

void phydm_dynamic_tx_power(void *dm_void);

void phydm_dynamic_tx_power_init(void *dm_void);

void phydm_dtp_debug(void *dm_void, char input[][16], u32 *_used, char *output,
			     u32 *_out_len);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
void odm_dynamic_tx_power_win(void *dm_void);
#endif

#endif
#endif
