/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __PHYDMCFOTRACK_H__
#define __PHYDMCFOTRACK_H__

#define CFO_TRACKING_VERSION "2.3"

#define		CFO_TRK_ENABLE_TH	20 /* @kHz enable CFO_Track threshold*/
#define		CFO_TRK_STOP_TH		10 /* @kHz disable CFO_Track threshold*/
#define		CFO_TH_ATC		80 /* @kHz */

struct phydm_cfo_track_struct {
	boolean		is_atc_status;
	boolean		is_adjust;	/*@already modify crystal cap*/
	u8		crystal_cap;
	u8		crystal_cap_default;
	u8		def_x_cap;
	s32		CFO_tail[4];
	u32		CFO_cnt[4];
	s32		CFO_ave_pre;
	u32		packet_count;
	u32		packet_count_pre;
};

struct phydm_cfo_rpt {
	s32 cfo_rpt_s[PHYDM_MAX_RF_PATH];
	s32 cfo_rpt_l[PHYDM_MAX_RF_PATH];
	s32 cfo_rpt_acq[PHYDM_MAX_RF_PATH];
	s32 cfo_rpt_sec[PHYDM_MAX_RF_PATH];
	s32 cfo_rpt_end[PHYDM_MAX_RF_PATH];
};

void phydm_get_cfo_info(void *dm_void, struct phydm_cfo_rpt *cfo);

boolean phydm_set_crystal_cap_reg(void *dm_void, u8 crystal_cap);

void phydm_set_crystal_cap(void *dm_void, u8 crystal_cap);

void phydm_cfo_tracking_init(void *dm_void);

void phydm_cfo_tracking(void *dm_void);

void phydm_parsing_cfo(void *dm_void, void *pktinfo_void, s8 *pcfotail,
		       u8 num_ss);
void phydm_cfo_tracking_debug(void *dm_void, char input[][16], u32 *_used,
			      char *output, u32 *_out_len);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
void phy_Init_crystal_capacity(void *dm_void, u8 crystal_cap);
#endif
#endif
