/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __PHYDM_AUTO_DBG_H__
#define __PHYDM_AUTO_DBG_H__

#define AUTO_DBG_VERSION "1.0" /* @2017.05.015  Dino, Add phydm_auto_dbg.h*/

/* @1 ============================================================
 * 1  Definition
 * 1 ============================================================
 */

#define AUTO_CHK_HANG_STEP_MAX 3
#define DBGPORT_CHK_NUM 6

#ifdef PHYDM_AUTO_DEGBUG

/* @1 ============================================================
 * 1  enumeration
 * 1 ============================================================
 */

enum auto_dbg_type_e {
	AUTO_DBG_STOP		= 0,
	AUTO_DBG_CHECK_HANG	= 1,
	AUTO_DBG_CHECK_RA	= 2,
	AUTO_DBG_CHECK_DIG	= 3
};

/* @1 ============================================================
 * 1  structure
 * 1 ============================================================
 */

struct n_dbgport_803 {
	/*@BYTE 3*/
	u8 bb_rst_b : 1;
	u8 glb_rst_b : 1;
	u8 zero_1bit_1 : 1;
	u8 ofdm_rst_b : 1;
	u8 cck_txpe : 1;
	u8 ofdm_txpe : 1;
	u8 phy_tx_on : 1;
	u8 tdrdy : 1;
	/*@BYTE 2*/
	u8 txd : 8;
	/*@BYTE 1*/
	u8 cck_cca_pp : 1;
	u8 ofdm_cca_pp : 1;
	u8 rx_rst : 1;
	u8 rdrdy : 1;
	u8 rxd_7_4 : 4;
	/*@BYTE 0*/
	u8 rxd_3_0 : 4;
	u8 ofdm_tx_en : 1;
	u8 cck_tx_en : 1;
	u8 zero_1bit_2 : 1;
	u8 clk_80m : 1;
};

struct phydm_auto_dbg_struct {
	enum auto_dbg_type_e auto_dbg_type;
	u8 dbg_step;
	u16 dbg_port_table[DBGPORT_CHK_NUM];
	u32 dbg_port_val[DBGPORT_CHK_NUM];
	u16 ofdm_t_cnt;
	u16 ofdm_r_cnt;
	u16 cck_t_cnt;
	u16 cck_r_cnt;
	u16 ofdm_crc_error_cnt;
	u16 cck_crc_error_cnt;
};

/* @1 ============================================================
 * 1  function prototype
 * 1 ============================================================
 */

void phydm_dbg_port_dump(void *dm_void, u32 *used, char *output, u32 *out_len);

void phydm_auto_dbg_console(
	void *dm_void,
	char input[][16],
	u32 *_used,
	char *output,
	u32 *_out_len);

void phydm_auto_dbg_engine(void *dm_void);

void phydm_auto_dbg_engine_init(void *dm_void);
#endif
#endif
