/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __PHYDMANTDECT_H__
#define __PHYDMANTDECT_H__

#define ANTDECT_VERSION "2.1"

#if (defined(CONFIG_ANT_DETECTION))
/* @#if( DM_ODM_SUPPORT_TYPE & (ODM_WIN |ODM_CE)) */
/* @ANT Test */
#define ANTTESTALL 0x00 /*@ant A or B will be Testing*/
#define ANTTESTA 0x01 /*@ant A will be Testing*/
#define ANTTESTB 0x02 /*@ant B will be testing*/

#define MAX_ANTENNA_DETECTION_CNT 10

struct _ANT_DETECTED_INFO {
	boolean is_ant_detected;
	u32 db_for_ant_a;
	u32 db_for_ant_b;
	u32 db_for_ant_o;
};

enum dm_swas {
	antenna_a = 1,
	antenna_b = 2,
	antenna_max = 3,
};

/* @1 [1. Single Tone method] =================================================== */

void odm_single_dual_antenna_default_setting(
	void *dm_void);

boolean
odm_single_dual_antenna_detection(
	void *dm_void,
	u8 mode);

/* @1 [2. Scan AP RSSI method] ================================================== */

#define sw_ant_div_check_before_link odm_sw_ant_div_check_before_link

boolean
odm_sw_ant_div_check_before_link(
	void *dm_void);

/* @1 [3. PSD method] ========================================================== */

void odm_single_dual_antenna_detection_psd(
	void *dm_void);

void odm_sw_ant_detect_init(void *dm_void);
#endif
#endif
