/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef __HALRF_DEBUG_H__
#define __HALRF_DEBUG_H__

/*@============================================================*/
/*@include files*/
/*@============================================================*/

/*@============================================================*/
/*@Definition */
/*@============================================================*/

#if DBG

#if (DM_ODM_SUPPORT_TYPE == ODM_AP)
#define RF_DBG(dm, comp, fmt, args...)                     \
	do {                                               \
		if ((comp) & dm->rf_table.rf_dbg_comp) { \
			pr_debug("[RF] ");                 \
			RT_PRINTK(fmt, ##args);            \
		}                                          \
	} while (0)

#elif (DM_ODM_SUPPORT_TYPE == ODM_WIN)

static __inline void RF_DBG(PDM_ODM_T dm, int comp, char *fmt, ...)
{
	RT_STATUS rt_status;
	va_list args;
	char buf[PRINT_MAX_SIZE] = {0};

	if ((comp & dm->rf_table.rf_dbg_comp) == 0)
		return;

	if (fmt == NULL)
		return;

	va_start(args, fmt);
	rt_status = (RT_STATUS)RtlStringCbVPrintfA(buf, PRINT_MAX_SIZE, fmt, args);
	va_end(args);

	if (rt_status != RT_STATUS_SUCCESS) {
		DbgPrint("Failed (%d) to print message to buffer\n", rt_status);
		return;
	}

	DbgPrint("[RF] %s", buf);
}

#elif (DM_ODM_SUPPORT_TYPE == ODM_IOT)

#define RF_DBG(dm, comp, fmt, args...)                     \
	do {                                               \
		if ((comp) & dm->rf_table.rf_dbg_comp) { \
			RT_DEBUG(COMP_PHYDM, DBG_DMESG, "[RF] " fmt, ##args);  \
		}                                          \
	} while (0)

#else
#define RF_DBG(dm, comp, fmt, args...)                                         \
	do {                                                                   \
		struct dm_struct *__dm = dm;                                   \
		if ((comp) & __dm->rf_table.rf_dbg_comp) {                     \
			RT_TRACE(((struct rtl_priv *)__dm->adapter),           \
				 COMP_PHYDM, DBG_DMESG, "[RF] " fmt, ##args);  \
		}                                                              \
	} while (0)
#endif

#else /*#if DBG*/

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
static __inline void RF_DBG(struct dm_struct *dm, int comp, char *fmt, ...)
{
}
#else
#define RF_DBG(dm, comp, fmt, args...)
#endif

#endif /*#if DBG*/

/*@============================================================*/
/*@ enumeration */
/*@============================================================*/

/*@============================================================*/
/*@ structure */
/*@============================================================*/

/*@============================================================*/
/*@ function prototype */
/*@============================================================*/

void halrf_cmd_parser(void *dm_void, char input[][16], u32 *_used, char *output,
		      u32 *_out_len, u32 input_num);

void halrf_init_debug_setting(void *dm_void);

#endif /*__HALRF_H__*/
