/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#include "halmac_type.h"
#include "ui_info.h"

static u8 _pltfm_api_cmd52_r8(void *drv_adapter, u32 offset)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD52;

	return dev_ops->reg_read8(adapter, offset);
}

static u8 _pltfm_api_cmd53_r8(void *drv_adapter, u32 offset)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD53;

	return dev_ops->reg_read8(adapter, offset);
}

static u16 _pltfm_api_cmd53_r16(void *drv_adapter, u32 offset)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD53;

	return dev_ops->reg_read16(adapter, offset);
}

static u32 _pltfm_api_cmd53_r32(void *drv_adapter, u32 offset)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD53;

	return dev_ops->reg_read32(adapter, offset);
}

static u8 _pltfm_api_cmd53_rn(void *drv_adapter, u32 offset, u32 size, u8 *data)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD53;

	return dev_ops->reg_read_n(adapter, offset, size, data);
}

static void _pltfm_api_cmd52_w8(void *drv_adapter, u32 offset, u8 value)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD52;

	dev_ops->reg_write8(adapter, offset, value);
}

static void _pltfm_api_cmd53_w8(void *drv_adapter, u32 offset, u8 value)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD53;

	dev_ops->reg_write8(adapter, offset, value);
}

static void _pltfm_api_cmd53_w16(void *drv_adapter, u32 offset, u16 value)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD53;

	dev_ops->reg_write16(adapter, offset, value);
}

static void _pltfm_api_cmd53_w32(void *drv_adapter, u32 offset, u32 value)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	adapter->intf_info.sdio_handle.cmd_type = HOST_SDIO_CMD53;

	dev_ops->reg_write32(adapter, offset, value);
}

static u8 _pltfm_api_reg_r8(void *drv_adapter, u32 offset)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	return dev_ops->reg_read8(adapter, offset);
}

static u16 _pltfm_api_reg_r16(void *drv_adapter, u32 offset)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	return dev_ops->reg_read16(adapter, offset);
}

static u32 _pltfm_api_reg_r32(void *drv_adapter, u32 offset)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	return dev_ops->reg_read32(adapter, offset);
}

static void _pltfm_api_reg_w8(void *drv_adapter, u32 offset, u8 value)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	dev_ops->reg_write8(adapter, offset, value);
}

static void _pltfm_api_reg_w16(void *drv_adapter, u32 offset, u16 value)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	dev_ops->reg_write16(adapter, offset, value);
}

static void _pltfm_api_reg_w32(void *drv_adapter, u32 offset, u32 value)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	dev_ops->reg_write32(adapter, offset, value);
}

static u8 _pltfm_api_cia_cmd52_r8(void *drv_adapter, u32 offset)
{
	u8 val;
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	dev_ops->read_write_cia(adapter, offset, &val, 0);

	return val;
}

static u8 _pltfm_api_send_rsvd_page(void *drv_adapter, u8 *buf, u32 size)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	return dev_ops->send_to_rsvd_pg(adapter, size, buf);
}

static u8 _pltfm_api_send_h2c_pkt(void *drv_adapter, u8 *buf, u32 size)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	return dev_ops->send_h2c_pkt(adapter, size, buf);
}

static u8 _pltfm_api_free(void *drv_adapter, void *buf, u32 size)
{
	free(buf);

	return 1;
}

static void* _pltfm_api_malloc(void *drv_adapter, u32 size)
{
	return malloc(size);
}

static u8 _pltfm_api_memcpy(void *drv_adapter, void *dest, void *src, u32 size)
{
	memcpy(dest, src, size);

	return 1;
}

static u8 _pltfm_api_memset(void *drv_adapter, void *addr, u8 value, u32 size)
{
	memset(addr, value, size);

	return 1;
}

static void _pltfm_api_delay_us(void *drv_adapter, u32 us)
{
	if (us < 1000)
		Sleep(1);
	else
		Sleep(us / 1000);
}

static u8 _pltfm_api_mutex_init(void *drv_adapter, HALMAC_MUTEX *mutex)
{
	InitializeCriticalSection(mutex);

	return 1;
}

static u8 _pltfm_api_mutex_deinit(void *drv_adapter, HALMAC_MUTEX *mutex)
{
	DeleteCriticalSection(mutex);

	return 1;
}

static u8 _pltfm_api_mutex_lock(void *drv_adapter, HALMAC_MUTEX *mutex)
{
	EnterCriticalSection(mutex);

	return 1;
}

static u8 _pltfm_api_mutex_unlock(void *drv_adapter, HALMAC_MUTEX *mutex)
{
	LeaveCriticalSection(mutex);

	return 1;
}

static u8 _pltfm_api_msg_print(void *drv_adapter, u32 msg_type, u8 msg_level,
			       s8 *fmt, ...)
{
#define PRINT_MAX_BUF 4096
	va_list	args;
	char buf[PRINT_MAX_BUF];
	char prefix_buf[PRINT_MAX_BUF] = "[HALMAC]";

	va_start(args, fmt);
	vsnprintf_s(buf, sizeof(buf), _TRUNCATE, fmt, args);
	strcat_s(prefix_buf, sizeof(prefix_buf), buf);
	TRACE(prefix_buf);
	va_end(args);

	return 1;
#undef PRINT_MAX_BUF
}

static u8 _pltfm_api_buff_print(void *drv_adapter, u32 msg_type, u8 msg_level, s8 *buf,
				u32 size)
{
	_ASSERT_(1);

	return 1;
}

static u8 _pltfm_api_evnt_indn(void *drv_adapter,
			       enum halmac_feature_id feature_id,
			       enum halmac_cmd_process_status process_status,
			       u8 *buf, u32 size)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct c2h_event_info *info = &(adapter->c2h_info);

	if (process_status != HALMAC_CMD_PROCESS_DONE)
		return 1;

	_ASSERT_(size > C2H_BUF_MAX_SIZE);

	info->pkt_size = size;

	switch (feature_id) {
	case HALMAC_FEATURE_DUMP_PHYSICAL_EFUSE:
		info->phy_efuse_map = 1;
		memcpy(info->data, buf, size);
		break;
	case HALMAC_FEATURE_DUMP_LOGICAL_EFUSE:
		info->log_efuse_map = 1;
		memcpy(info->data, buf, size);
		break;
	case HALMAC_FEATURE_DUMP_LOGICAL_EFUSE_MASK:
		info->log_efuse_mask = 1;
		memcpy(info->data, buf, size);
		break;
	case HALMAC_FEATURE_CFG_PARA:
		info->cfg_param = 1;
		break;
	case HALMAC_FEATURE_UPDATE_PACKET:
		info->update_pkt = 1;
		break;
	case HALMAC_FEATURE_UPDATE_DATAPACK:
		info->update_datapkt = 1;
		break;
	case HALMAC_FEATURE_RUN_DATAPACK:
		info->run_datapkt = 1;
		break;
	case HALMAC_FEATURE_CHANNEL_SWITCH:
		info->ch_switch = 1;
		break;
	case HALMAC_FEATURE_FW_SNDING:
		info->fw_snding = 1;
		break;
	case HALMAC_FEATURE_SEND_SCAN_PACKET:
		info->send_scan_pkt = 1;
		break;
	case HALMAC_FEATURE_DROP_SCAN_PACKET:
		info->drop_scan_pkt = 1;
		break;
	default:
		MFC_MSG_ERR("unsupported c2h event!!\n");
		return 0;
	}

	return 1;
}

static u8 _pltfm_api_tx_pkt(void *drv_adapter, u8 *buf, u32 size)
{
	struct ui_adapter_e *adapter = (struct ui_adapter_e *)drv_adapter;
	struct host_ops_cb *dev_ops = adapter->intf_info.dev_ops;

	return dev_ops->tx(adapter, size, buf);
}

static u8 _pltfm_api_send_bcn_rsvd_page(void *drv_adapter, u8 *buf, u32 size)
{
	_ASSERT_(1);

	return 1;
}

static struct halmisc_platform_api misc_pltfm_api_cb = {
	_pltfm_api_tx_pkt,
	_pltfm_api_send_bcn_rsvd_page,
};

struct halmac_platform_api pltfm_api_cb = {
	_pltfm_api_cmd52_r8, /* SDIO_CMD52_READ */
	_pltfm_api_cmd53_r8, /* SDIO_CMD53_READ_8 */
	_pltfm_api_cmd53_r16, /* SDIO_CMD53_READ_16 */
	_pltfm_api_cmd53_r32, /* SDIO_CMD53_READ_32 */
	_pltfm_api_cmd53_rn, /* SDIO_CMD53_READ_N */
	_pltfm_api_cmd52_w8, /* SDIO_CMD52_WRITE */
	_pltfm_api_cmd53_w8, /* SDIO_CMD53_WRITE_8 */
	_pltfm_api_cmd53_w16, /* SDIO_CMD53_WRITE_8 */
	_pltfm_api_cmd53_w32, /* SDIO_CMD53_WRITE_8 */
	_pltfm_api_reg_r8, /* REG_READ_8 */
	_pltfm_api_reg_r16, /* REG_READ_8 */
	_pltfm_api_reg_r32, /* REG_READ_8 */
	_pltfm_api_reg_w8, /* REG_WRITE_8 */
	_pltfm_api_reg_w16, /* REG_WRITE_8 */
	_pltfm_api_reg_w32, /* REG_WRITE_8 */
	_pltfm_api_cia_cmd52_r8, /* SDIO_CMD52_CIA_READ */
	_pltfm_api_send_rsvd_page, /* SEND_RSVD_PAGE */
	_pltfm_api_send_h2c_pkt, /* SEND_H2C_PKT */
	_pltfm_api_free, /* RTL_FREE */
	_pltfm_api_malloc, /* RTL_MALLOC */
	_pltfm_api_memcpy, /* RTL_MEMCPY */
	_pltfm_api_memset, /* RTL_MEMSET */
	_pltfm_api_delay_us, /* RTL_DELAY_US */
	_pltfm_api_mutex_init, /* MUTEX_INIT */
	_pltfm_api_mutex_deinit, /* MUTEX_DEINIT */
	_pltfm_api_mutex_lock, /* MUTEX_LOCK */
	_pltfm_api_mutex_unlock, /* MUTEX_UNLOCK */
	_pltfm_api_msg_print, /* MSG_PRINT */
	_pltfm_api_buff_print, /* BUFF_PRINT */
	_pltfm_api_evnt_indn, /* EVENT_INDICATION */
	&misc_pltfm_api_cb,
};

