/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef _HALMAC_TX_BD_NIC_H_
#define _HALMAC_TX_BD_NIC_H_
#if (HALMAC_8814A_SUPPORT || HALMAC_8822B_SUPPORT || HALMAC_8197F_SUPPORT ||   \
	HALMAC_8821C_SUPPORT || HALMAC_8198F_SUPPORT || HALMAC_8822C_SUPPORT ||\
	HALMAC_8192F_SUPPORT || HALMAC_8197G_SUPPORT || HALMAC_8814B_SUPPORT)

/*TXBD_DW0*/

#define SET_TX_BD_OWN(txbd, value)                                             \
	SET_BITS_TO_LE_4BYTE(txbd + 0x00, 31, 1, value)
#define GET_TX_BD_OWN(txbd) LE_BITS_TO_4BYTE(txbd + 0x00, 31, 1)
#define SET_TX_BD_PSB(txbd, value)                                             \
	SET_BITS_TO_LE_4BYTE(txbd + 0x00, 16, 8, value)
#define GET_TX_BD_PSB(txbd) LE_BITS_TO_4BYTE(txbd + 0x00, 16, 8)
#define SET_TX_BD_TX_BUFF_SIZE0(txbd, value)                                   \
	SET_BITS_TO_LE_4BYTE(txbd + 0x00, 0, 16, value)
#define GET_TX_BD_TX_BUFF_SIZE0(txbd) LE_BITS_TO_4BYTE(txbd + 0x00, 0, 16)

/*TXBD_DW1*/

#define SET_TX_BD_PHYSICAL_ADDR0_LOW(txbd, value)                              \
	SET_BITS_TO_LE_4BYTE(txbd + 0x04, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR0_LOW(txbd) LE_BITS_TO_4BYTE(txbd + 0x04, 0, 32)

/*TXBD_DW2*/

#define SET_TX_BD_PHYSICAL_ADDR0_HIGH(txbd, value)                             \
	SET_BITS_TO_LE_4BYTE(txbd + 0x08, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR0_HIGH(txbd) LE_BITS_TO_4BYTE(txbd + 0x08, 0, 32)

/*TXBD_DW4*/

#define SET_TX_BD_A1(txbd, value)                                              \
	SET_BITS_TO_LE_4BYTE(txbd + 0x10, 31, 1, value)
#define GET_TX_BD_A1(txbd) LE_BITS_TO_4BYTE(txbd + 0x10, 31, 1)
#define SET_TX_BD_TX_BUFF_SIZE1(txbd, value)                                   \
	SET_BITS_TO_LE_4BYTE(txbd + 0x10, 0, 16, value)
#define GET_TX_BD_TX_BUFF_SIZE1(txbd) LE_BITS_TO_4BYTE(txbd + 0x10, 0, 16)

/*TXBD_DW5*/

#define SET_TX_BD_PHYSICAL_ADDR1_LOW(txbd, value)                              \
	SET_BITS_TO_LE_4BYTE(txbd + 0x14, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR1_LOW(txbd) LE_BITS_TO_4BYTE(txbd + 0x14, 0, 32)

/*TXBD_DW6*/

#define SET_TX_BD_PHYSICAL_ADDR1_HIGH(txbd, value)                             \
	SET_BITS_TO_LE_4BYTE(txbd + 0x18, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR1_HIGH(txbd) LE_BITS_TO_4BYTE(txbd + 0x18, 0, 32)

/*TXBD_DW8*/

#define SET_TX_BD_A2(txbd, value)                                              \
	SET_BITS_TO_LE_4BYTE(txbd + 0x20, 31, 1, value)
#define GET_TX_BD_A2(txbd) LE_BITS_TO_4BYTE(txbd + 0x20, 31, 1)
#define SET_TX_BD_TX_BUFF_SIZE2(txbd, value)                                   \
	SET_BITS_TO_LE_4BYTE(txbd + 0x20, 0, 16, value)
#define GET_TX_BD_TX_BUFF_SIZE2(txbd) LE_BITS_TO_4BYTE(txbd + 0x20, 0, 16)

/*TXBD_DW9*/

#define SET_TX_BD_PHYSICAL_ADDR2_LOW(txbd, value)                              \
	SET_BITS_TO_LE_4BYTE(txbd + 0x24, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR2_LOW(txbd) LE_BITS_TO_4BYTE(txbd + 0x24, 0, 32)

/*TXBD_DW10*/

#define SET_TX_BD_PHYSICAL_ADDR2_HIGH(txbd, value)                             \
	SET_BITS_TO_LE_4BYTE(txbd + 0x28, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR2_HIGH(txbd) LE_BITS_TO_4BYTE(txbd + 0x28, 0, 32)

/*TXBD_DW12*/

#define SET_TX_BD_A3(txbd, value)                                              \
	SET_BITS_TO_LE_4BYTE(txbd + 0x30, 31, 1, value)
#define GET_TX_BD_A3(txbd) LE_BITS_TO_4BYTE(txbd + 0x30, 31, 1)
#define SET_TX_BD_TX_BUFF_SIZE3(txbd, value)                                   \
	SET_BITS_TO_LE_4BYTE(txbd + 0x30, 0, 16, value)
#define GET_TX_BD_TX_BUFF_SIZE3(txbd) LE_BITS_TO_4BYTE(txbd + 0x30, 0, 16)

/*TXBD_DW13*/

#define SET_TX_BD_PHYSICAL_ADDR3_LOW(txbd, value)                              \
	SET_BITS_TO_LE_4BYTE(txbd + 0x34, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR3_LOW(txbd) LE_BITS_TO_4BYTE(txbd + 0x34, 0, 32)

/*TXBD_DW14*/

#define SET_TX_BD_PHYSICAL_ADDR3_HIGH(txbd, value)                             \
	SET_BITS_TO_LE_4BYTE(txbd + 0x38, 0, 32, value)
#define GET_TX_BD_PHYSICAL_ADDR3_HIGH(txbd) LE_BITS_TO_4BYTE(txbd + 0x38, 0, 32)

#endif

#endif
