/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef _HALMAC_STATE_MACHINE_H_
#define _HALMAC_STATE_MACHINE_H_

enum halmac_dlfw_state {
	HALMAC_DLFW_NONE = 0,
	HALMAC_DLFW_DONE = 1,
	HALMAC_GEN_INFO_SENT = 2,

	/* Data CPU firmware download framework */
	HALMAC_DLFW_INIT = 0x11,
	HALMAC_DLFW_START = 0x12,
	HALMAC_DLFW_CONF_READY = 0x13,
	HALMAC_DLFW_CPU_READY = 0x14,
	HALMAC_DLFW_MEM_READY = 0x15,
	HALMAC_DLFW_SW_READY = 0x16,
	HALMAC_DLFW_OFLD_READY = 0x17,

	HALMAC_DLFW_UNDEFINED = 0x7F,
};

enum halmac_gpio_cfg_state {
	HALMAC_GPIO_CFG_STATE_IDLE = 0,
	HALMAC_GPIO_CFG_STATE_BUSY = 1,
	HALMAC_GPIO_CFG_STATE_UNDEFINED = 0x7F,
};

enum halmac_rsvd_pg_state {
	HALMAC_RSVD_PG_STATE_IDLE = 0,
	HALMAC_RSVD_PG_STATE_BUSY = 1,
	HALMAC_RSVD_PG_STATE_UNDEFINED = 0x7F,
};

enum halmac_api_state {
	HALMAC_API_STATE_INIT = 0,
	HALMAC_API_STATE_HALT = 1,
	HALMAC_API_STATE_UNDEFINED = 0x7F,
};

enum halmac_cmd_construct_state {
	HALMAC_CMD_CNSTR_IDLE = 0,
	HALMAC_CMD_CNSTR_BUSY = 1,
	HALMAC_CMD_CNSTR_H2C_SENT = 2,
	HALMAC_CMD_CNSTR_CNSTR = 3,
	HALMAC_CMD_CNSTR_BUF_CLR = 4,
	HALMAC_CMD_CNSTR_UNDEFINED = 0x7F,
};

enum halmac_cmd_process_status {
	HALMAC_CMD_PROCESS_IDLE = 0x01, /* Init status */
	HALMAC_CMD_PROCESS_SENDING = 0x02, /* Wait ack */
	HALMAC_CMD_PROCESS_RCVD = 0x03, /* Rcvd ack */
	HALMAC_CMD_PROCESS_DONE = 0x04, /* Event done */
	HALMAC_CMD_PROCESS_ERROR = 0x05, /* Return code error */
	HALMAC_CMD_PROCESS_UNDEFINE = 0x7F,
};

enum halmac_mac_power {
	HALMAC_MAC_POWER_OFF = 0x0,
	HALMAC_MAC_POWER_ON = 0x1,
	HALMAC_MAC_POWER_UNDEFINE = 0x7F,
};

enum halmac_wlcpu_mode {
	HALMAC_WLCPU_ACTIVE = 0x0,
	HALMAC_WLCPU_ENTER_SLEEP = 0x1,
	HALMAC_WLCPU_SLEEP = 0x2,
	HALMAC_WLCPU_UNDEFINE = 0x7F,
};

struct halmac_efuse_state {
	enum halmac_cmd_construct_state cmd_cnstr_state;
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_cfg_param_state {
	enum halmac_cmd_construct_state cmd_cnstr_state;
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_scan_state {
	enum halmac_cmd_construct_state cmd_cnstr_state;
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_update_pkt_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
	u8 used_page;
};

struct halmac_scan_pkt_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_drop_pkt_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_iqk_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_dpk_state {
	enum halmac_cmd_process_status proc_status;
	u16 data_size;
	u16 seg_size;
	u8 *data;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_nan_func_ctrl_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_act_schdl_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
	u32 schedule_id;
};
struct halmac_bcn_req_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_nan_de_info_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_nan_cluster_info_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_nan_avail_t_bitmap_state {
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_pwr_tracking_state {
	enum halmac_cmd_process_status	proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_psd_state {
	enum halmac_cmd_process_status proc_status;
	u16 data_size;
	u16 seg_size;
	u8 *data;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_fw_snding_state {
	enum halmac_cmd_construct_state cmd_cnstr_state;
	enum halmac_cmd_process_status proc_status;
	u8 fw_rc;
	u16 seq_num;
};

struct halmac_state {
	struct halmac_efuse_state efuse_state;
	struct halmac_cfg_param_state cfg_param_state;
	struct halmac_scan_state scan_state;
	struct halmac_update_pkt_state update_pkt_state;
	struct halmac_scan_pkt_state scan_pkt_state;
	struct halmac_drop_pkt_state drop_pkt_state;
	struct halmac_iqk_state iqk_state;
	struct halmac_dpk_state dpk_state;
	struct halmac_pwr_tracking_state pwr_trk_state;
	struct halmac_psd_state psd_state;
	struct halmac_fw_snding_state fw_snding_state;
	struct halmac_nan_func_ctrl_state nan_func_ctrl_state;
	struct halmac_act_schdl_state act_schdl_state;
	struct halmac_bcn_req_state bcn_req_state;
	struct halmac_nan_de_info_state	nan_de_info_state;
	struct halmac_nan_cluster_info_state nan_cluster_info_state;
	struct halmac_nan_avail_t_bitmap_state nan_avail_t_bitmap_state;
	enum halmac_api_state api_state;
	enum halmac_mac_power mac_pwr;
	enum halmac_dlfw_state dlfw_state;
	enum halmac_wlcpu_mode wlcpu_mode;
	enum halmac_gpio_cfg_state gpio_cfg_state;
	enum halmac_rsvd_pg_state rsvd_pg_state;
};

#endif
