/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef HALMAC_POWER_SEQUENCE_CMD
#define HALMAC_POWER_SEQUENCE_CMD

#include "halmac_2_platform.h"

#define HALMAC_PWR_POLLING_CNT 20000

/* The value of cmd : 4 bits */

/* offset : the read register offset
 * msk : the mask of the read value
 * value : N/A, left by 0
 * Note : dirver shall implement this function by read & msk
 */
#define	HALMAC_PWR_CMD_READ		0x00
/* offset: the read register offset
 * msk: the mask of the write bits
 * value: write value
 * Note: driver shall implement this cmd by read & msk after write
 */
#define	HALMAC_PWR_CMD_WRITE	0x01
/* offset: the read register offset
 * msk: the mask of the polled value
 * value: the value to be polled, masked by the msd field.
 * Note: driver shall implement this cmd by
 * do{
 * if( (Read(offset) & msk) == (value & msk) )
 * break;
 * } while(not timeout);
 */
#define	HALMAC_PWR_CMD_POLLING	0x02
/* offset: the value to delay
 * msk: N/A
 * value: the unit of delay, 0: us, 1: ms
 */
#define	HALMAC_PWR_CMD_DELAY	0x03
/* offset: N/A
 * msk: N/A
 * value: N/A
 */
#define	HALMAC_PWR_CMD_END	0x04

/* The value of base : 4 bits */

/* define the base address of each block */
#define   HALMAC_PWR_ADDR_MAC	0x00
#define   HALMAC_PWR_ADDR_USB	0x01
#define   HALMAC_PWR_ADDR_PCIE	0x02
#define   HALMAC_PWR_ADDR_SDIO	0x03

/* The value of interface_msk : 4 bits */
#define	HALMAC_PWR_INTF_SDIO_MSK	BIT(0)
#define	HALMAC_PWR_INTF_USB_MSK		BIT(1)
#define	HALMAC_PWR_INTF_PCI_MSK		BIT(2)
#define	HALMAC_PWR_INTF_ALL_MSK		(BIT(0) | BIT(1) | BIT(2) | BIT(3))

/* The value of cut_msk : 8 bits */
#define	HALMAC_PWR_CUT_TESTCHIP_MSK		BIT(0)
#define	HALMAC_PWR_CUT_A_MSK			BIT(1)
#define	HALMAC_PWR_CUT_B_MSK			BIT(2)
#define	HALMAC_PWR_CUT_C_MSK			BIT(3)
#define	HALMAC_PWR_CUT_D_MSK			BIT(4)
#define	HALMAC_PWR_CUT_E_MSK			BIT(5)
#define	HALMAC_PWR_CUT_F_MSK			BIT(6)
#define	HALMAC_PWR_CUT_G_MSK			BIT(7)
#define	HALMAC_PWR_CUT_ALL_MSK			0xFF

enum halmac_pwrseq_cmd_delay_unit {
	HALMAC_PWR_DELAY_US,
	HALMAC_PWR_DELAY_MS,
};

struct halmac_wlan_pwr_cfg {
	u16 offset;
	u8 cut_msk;
	u8 interface_msk;
	u8 base:4;
	u8 cmd:4;
	u8 msk;
	u8 value;
};

#endif
