/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef _HALMAC_MIMO_88XX_H_
#define _HALMAC_MIMO_88XX_H_

#include "../halmac_api.h"

#if HALMAC_88XX_SUPPORT

enum halmac_ret_status
cfg_txbf_88xx(struct halmac_adapter *adapter, u8 userid, enum halmac_bw bw,
	      u8 txbf_en);

enum halmac_ret_status
cfg_mumimo_88xx(struct halmac_adapter *adapter,
		struct halmac_cfg_mumimo_para *param);

enum halmac_ret_status
cfg_sounding_88xx(struct halmac_adapter *adapter, enum halmac_snd_role role,
		  enum halmac_data_rate rate);

enum halmac_ret_status
del_sounding_88xx(struct halmac_adapter *adapter, enum halmac_snd_role role);

enum halmac_ret_status
su_bfee_entry_init_88xx(struct halmac_adapter *adapter, u8 userid, u16 paid);

enum halmac_ret_status
su_bfer_entry_init_88xx(struct halmac_adapter *adapter,
			struct halmac_su_bfer_init_para *param);

enum halmac_ret_status
mu_bfee_entry_init_88xx(struct halmac_adapter *adapter,
			struct halmac_mu_bfee_init_para *param);

enum halmac_ret_status
mu_bfer_entry_init_88xx(struct halmac_adapter *adapter,
			struct halmac_mu_bfer_init_para *param);

enum halmac_ret_status
su_bfee_entry_del_88xx(struct halmac_adapter *adapter, u8 userid);

enum halmac_ret_status
su_bfer_entry_del_88xx(struct halmac_adapter *adapter, u8 userid);

enum halmac_ret_status
mu_bfee_entry_del_88xx(struct halmac_adapter *adapter, u8 userid);

enum halmac_ret_status
mu_bfer_entry_del_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
cfg_csi_rate_88xx(struct halmac_adapter *adapter, u8 rssi, u8 cur_rate,
		  u8 fixrate_en, u8 *new_rate, u8 *bmp_ofdm54);

enum halmac_ret_status
fw_snding_88xx(struct halmac_adapter *adapter,
	       struct halmac_su_snding_info *su_info,
	       struct halmac_mu_snding_info *mu_info, u8 period);

enum halmac_ret_status
get_h2c_ack_fw_snding_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);

enum halmac_ret_status
get_fw_snding_status_88xx(struct halmac_adapter *adapter,
			  enum halmac_cmd_process_status *proc_status);

#endif /* HALMAC_88XX_SUPPORT */

#endif/* _HALMAC_MIMO_88XX_H_ */
