/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef _HALMAC_FW_88XX_H_
#define _HALMAC_FW_88XX_H_

#include "../halmac_api.h"

#if HALMAC_88XX_SUPPORT

#define HALMC_DDMA_POLLING_COUNT		1000

enum halmac_ret_status
download_firmware_88xx(struct halmac_adapter *adapter, u8 *fw_bin, u32 size);

enum halmac_ret_status
free_download_firmware_88xx(struct halmac_adapter *adapter,
			    enum halmac_dlfw_mem mem_sel, u8 *fw_bin, u32 size);

enum halmac_ret_status
reset_wifi_fw_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
get_fw_version_88xx(struct halmac_adapter *adapter,
		    struct halmac_fw_version *ver);

enum halmac_ret_status
check_fw_status_88xx(struct halmac_adapter *adapter, u8 *fw_status);

enum halmac_ret_status
dump_fw_dmem_88xx(struct halmac_adapter *adapter, u8 *dmem, u32 *size);

enum halmac_ret_status
cfg_max_dl_size_88xx(struct halmac_adapter *adapter, u32 size);

enum halmac_ret_status
enter_cpu_sleep_mode_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
get_cpu_mode_88xx(struct halmac_adapter *adapter,
		  enum halmac_wlcpu_mode *mode);

enum halmac_ret_status
send_general_info_88xx(struct halmac_adapter *adapter,
		       struct halmac_general_info *info);

enum halmac_ret_status
issue_bcn_req_88xx(struct halmac_adapter *adapter, struct halmac_bcn_req_para *bcn_para);

enum halmac_ret_status
get_ack_bcn_req_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);

enum halmac_ret_status
get_bcn_req_status_88xx(struct halmac_adapter *adapter,enum halmac_cmd_process_status *proc_status,u8 *data, u32 *size);

enum halmac_ret_status
issue_act_schedule_88xx(struct halmac_adapter *adapter, struct halmac_act_schdl_req_para *act_schdl_para);

enum halmac_ret_status
get_act_schdl_status_88xx(struct halmac_adapter *adapter,enum halmac_cmd_process_status *proc_status,u8 *data, u32 *size);

enum halmac_ret_status
get_ack_act_schdl_req_id_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);

enum halmac_ret_status
drv_fwctrl_88xx(struct halmac_adapter *adapter, u8 *payload, u32 size, u8 ack);

enum halmac_ret_status
nan_func_ctrl_88xx(struct halmac_adapter *adapter, struct halmac_nan_func_ctrl *nan_option);

enum halmac_ret_status
get_nan_status_88xx(struct halmac_adapter *adapter,enum halmac_cmd_process_status *proc_status);

enum halmac_ret_status
get_h2c_ack_nan_func_ctrl_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);

enum halmac_ret_status
issue_nan_de_info_88xx(struct halmac_adapter *adapter, struct halmac_nan_de_info *nan_de_info);

enum halmac_ret_status
nan_pause_faw_tx_88xx(struct halmac_adapter *adapter, u32 id_map);

enum halmac_ret_status
nan_get_cluster_info_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
nan_cluster_join_88xx(struct halmac_adapter *adapter,u8 is_allow);

enum halmac_ret_status
nan_set_avail_t_bitmap_88xx(struct halmac_adapter *adapter,
                            struct halmac_nan_avail_t_bitmap *nan_avail_t_bitmap);

enum halmac_ret_status
get_nan_de_info_status_88xx(struct halmac_adapter *adapter,
                            enum halmac_cmd_process_status *proc_status);
enum halmac_ret_status
get_nan_cluster_info_status_88xx(struct halmac_adapter *adapter,
                                 enum halmac_cmd_process_status *proc_status);
enum halmac_ret_status
get_nan_avail_t_bitmap_status_88xx(struct halmac_adapter *adapter,
                                   enum halmac_cmd_process_status *proc_status);

enum halmac_ret_status
get_h2c_ack_nan_de_info_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);
enum halmac_ret_status
get_h2c_ack_nan_cluster_info_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);
enum halmac_ret_status
get_h2c_ack_nan_avail_t_bitmap_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);

#endif /* HALMAC_88XX_SUPPORT */

#endif/* _HALMAC_FW_88XX_H_ */
