/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef _HALMAC_COMMON_88XX_H_
#define _HALMAC_COMMON_88XX_H_

#include "../halmac_api.h"
#include "../halmac_pwr_seq_cmd.h"
#include "../halmac_gpio_cmd.h"

#if HALMAC_88XX_SUPPORT

enum halmac_ret_status
ofld_func_cfg_88xx(struct halmac_adapter *adapter,
		   struct halmac_ofld_func_info *info);

enum halmac_ret_status
dl_drv_rsvd_page_88xx(struct halmac_adapter *adapter, u8 pg_offset, u8 *buf,
		      u32 size);

enum halmac_ret_status
dl_rsvd_page_88xx(struct halmac_adapter *adapter, u16 pg_addr, u8 *buf,
		  u32 size);

enum halmac_ret_status
get_hw_value_88xx(struct halmac_adapter *adapter, enum halmac_hw_id hw_id,
		  void *value);

enum halmac_ret_status
set_hw_value_88xx(struct halmac_adapter *adapter, enum halmac_hw_id hw_id,
		  void *value);

enum halmac_ret_status
get_watcher_88xx(struct halmac_adapter *adapter, enum halmac_watcher_sel sel,
		 void *value);

enum halmac_ret_status
set_h2c_pkt_hdr_88xx(struct halmac_adapter *adapter, u8 *hdr,
		     struct halmac_h2c_header_info *info, u16 *seq_num);

enum halmac_ret_status
set_nan_h2c_pkt_hdr_88xx(struct halmac_adapter *adapter, u8 *hdr,
		     struct halmac_h2c_header_info *info, u16 *seq_num);


enum halmac_ret_status
send_h2c_pkt_88xx(struct halmac_adapter *adapter, u8 *pkt);

enum halmac_ret_status
get_h2c_buf_free_space_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
get_c2h_info_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);

enum halmac_ret_status
mac_debug_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
cfg_parameter_88xx(struct halmac_adapter *adapter,
		   struct halmac_phy_parameter_info *info, u8 full_fifo);

enum halmac_ret_status
update_packet_88xx(struct halmac_adapter *adapter, enum halmac_packet_id pkt_id,
		   u8 *pkt, u32 size);

enum halmac_ret_status
send_scan_packet_88xx(struct halmac_adapter *adapter, u8 index,
		      u8 *pkt, u32 size);

enum halmac_ret_status
drop_scan_packet_88xx(struct halmac_adapter *adapter,
		      struct halmac_drop_pkt_option *option);

enum halmac_ret_status
bcn_ie_filter_88xx(struct halmac_adapter *adapter,
		   struct halmac_bcn_ie_info *info);

enum halmac_ret_status
update_datapack_88xx(struct halmac_adapter *adapter,
		     enum halmac_data_type data_type,
		     struct halmac_phy_parameter_info *info);

enum halmac_ret_status
run_datapack_88xx(struct halmac_adapter *adapter,
		  enum halmac_data_type data_type);

enum halmac_ret_status
send_bt_coex_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size, u8 ack);

enum halmac_ret_status
dump_fifo_88xx(struct halmac_adapter *adapter, enum hal_fifo_sel sel,
	       u32 start_addr, u32 size, u8 *data);

u32
get_fifo_size_88xx(struct halmac_adapter *adapter, enum hal_fifo_sel sel);

enum halmac_ret_status
set_h2c_header_88xx(struct halmac_adapter *adapter, u8 *hdr, u16 *seq, u8 ack);

enum halmac_ret_status
add_ch_info_88xx(struct halmac_adapter *adapter, struct halmac_ch_info *info);

enum halmac_ret_status
add_extra_ch_info_88xx(struct halmac_adapter *adapter,
		       struct halmac_ch_extra_info *info);

enum halmac_ret_status
ctrl_ch_switch_88xx(struct halmac_adapter *adapter,
		    struct halmac_ch_switch_option *opt);

enum halmac_ret_status
clear_ch_info_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
chk_txdesc_88xx(struct halmac_adapter *adapter, u8 *buf, u32 size);

enum halmac_ret_status
get_version_88xx(struct halmac_adapter *adapter, struct halmac_ver *ver);

enum halmac_ret_status
p2pps_88xx(struct halmac_adapter *adapter, struct halmac_p2pps *info);

enum halmac_ret_status
query_status_88xx(struct halmac_adapter *adapter,
		  enum halmac_feature_id feature_id,
		  enum halmac_cmd_process_status *proc_status, u8 *data,
		  u32 *size);

enum halmac_ret_status
cfg_drv_rsvd_pg_num_88xx(struct halmac_adapter *adapter,
			 enum halmac_drv_rsvd_pg_num pg_num);

enum halmac_ret_status
h2c_lb_88xx(struct halmac_adapter *adapter);

enum halmac_ret_status
pwr_seq_parser_88xx(struct halmac_adapter *adapter,
		    struct halmac_wlan_pwr_cfg **cmd_seq);

enum halmac_ret_status
parse_intf_phy_88xx(struct halmac_adapter *adapter,
		    struct halmac_intf_phy_para *param,
		    enum halmac_intf_phy_platform pltfm,
		    enum hal_intf_phy intf_phy);

enum halmac_ret_status
txfifo_is_empty_88xx(struct halmac_adapter *adapter, u32 chk_num);

u8*
smart_malloc_88xx(struct halmac_adapter *adapter, u32 size, u32 *new_size);

enum halmac_ret_status
ltecoex_reg_read_88xx(struct halmac_adapter *adapter, u16 offset, u32 *value);

enum halmac_ret_status
ltecoex_reg_write_88xx(struct halmac_adapter *adapter, u16 offset, u32 value);

#endif/* HALMAC_88XX_SUPPORT */

#endif/* _HALMAC_COMMON_88XX_H_ */
