/******************************************************************************
 * Copyright (c) 2007-2016 Realtek Semiconductor Corp. All Rights Reserved.
 * 
 * This program is dual-licensed under both the GPL version 2 and BSD
 * license. Either license may be used at your option.
 * 
 * 
 * License
 * 
 * 
 * GPL v2:
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 * 
 * 
 * Alternatively, this software may be distributed, used, and modified
 * under the terms of BSD license:
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name(s) of the above-listed copyright holder(s) nor the
 * names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ******************************************************************************/

#ifndef _HALMAC_8821C_CFG_H_
#define _HALMAC_8821C_CFG_H_

#include "../../halmac_hw_cfg.h"
#include "../halmac_88xx_cfg.h"

#if HALMAC_8821C_SUPPORT

#define TX_FIFO_SIZE_8821C	65536
#define RX_FIFO_SIZE_8821C	16384
#define TRX_SHARE_SIZE_8821C	32768

#define RX_DESC_DUMMY_SIZE_8821C	72 /* 8 * 9 Bytes */
#define RX_FIFO_EXPANDING_MODE_PKT_SIZE_MAX_8821C	80 /* 8 Byte alignment*/

/* should be 8 Byte alignment*/
#if (HALMAC_RX_FIFO_EXPANDING_MODE_PKT_SIZE <= \
	RX_FIFO_EXPANDING_MODE_PKT_SIZE_MAX_8821C)
#define RX_FIFO_EXPANDING_UNIT_8821C	(RX_DESC_SIZE_88XX + \
	RX_DESC_DUMMY_SIZE_8821C + HALMAC_RX_FIFO_EXPANDING_MODE_PKT_SIZE)
#else
#define RX_FIFO_EXPANDING_UNIT_8821C	(RX_DESC_SIZE_88XX + \
	RX_DESC_DUMMY_SIZE_8821C + RX_FIFO_EXPANDING_MODE_PKT_SIZE_MAX_8821C)
#endif

#define TX_FIFO_SIZE_LA_8821C	(TX_FIFO_SIZE_8821C >> 1)
#define TX_FIFO_SIZE_RX_EXPAND_1BLK_8821C	\
		(TX_FIFO_SIZE_8821C - TRX_SHARE_SIZE_8821C)
#define RX_FIFO_SIZE_RX_EXPAND_1BLK_8821C	\
		((((RX_FIFO_EXPANDING_UNIT_8821C << 8) - 1) >> 10) << 10)

#define EFUSE_SIZE_8821C		512
#define EEPROM_SIZE_8821C		512
#define BT_EFUSE_SIZE_8821C		128
#define PRTCT_EFUSE_SIZE_8821C	96

#define SEC_CAM_NUM_8821C		64

#define	OQT_ENTRY_AC_8821C		32
#define OQT_ENTRY_NOAC_8821C		32
#define MACID_MAX_8821C			128

#define WLAN_FW_IRAM_MAX_SIZE_8821C	65536
#define WLAN_FW_DRAM_MAX_SIZE_8821C	49152
#define WLAN_FW_ERAM_MAX_SIZE_8821C	49152
#define WLAN_FW_MAX_SIZE_8821C		(WLAN_FW_IRAM_MAX_SIZE_8821C + \
	WLAN_FW_DRAM_MAX_SIZE_8821C + WLAN_FW_ERAM_MAX_SIZE_8821C)

#endif /* HALMAC_8821C_SUPPORT */

#endif
