/******************************************************************************
 *
 * Copyright(c) 2013 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA
 *
 *
 ******************************************************************************/

#include <drv_types.h>
#include <hal_data.h>	/* HAL_DATA_TYPE */
#ifdef RTW_HALMAC
#include "../../hal/hal_halmac.h"
#endif


#ifdef CONFIG_RTW_PRINTER_UTILITY


/*  ============ private : =========================================================== */


/*  ============ pulic : =========================================================== */

/*

parameter:
	(1) padapter
	(2) addr : address of REG_RETRY_LIMIT
	(3) mode : we set REG_RETRY_LIMIT in 2 cases 
		case[0] init hal : set the same value for all fw state
		case[1] mlme join : we only re-write when fw state is station mode.

*/

void ex_rtw_printer_set_retry_limit(PADAPTER padapter, u16 addr, u8 case_id){

	struct registry_priv  *registry_par = &padapter->registrypriv;
	struct mlme_priv *pmlmepriv = &padapter->mlmepriv;
	u16	value16;

	if (case_id == 0  || ( case_id == 1 && check_fwstate(pmlmepriv, WIFI_STATION_STATE) == _TRUE))
	{
		value16 = BIT_LRL(registry_par->long_retry_lmt) | BIT_SRL(registry_par->short_retry_lmt);
		rtw_write16(padapter, addr, value16);

		//RTW_INFO("%s SRL(%d), LRL(%d) \n", __FUNCTION__, registry_par->short_retry_lmt, registry_par->long_retry_lmt);
		//RTW_INFO("%s set REG_RL(0x42a) = 0x%x\n", __FUNCTION__, rtw_read16(padapter, addr));	
	}
}

#ifdef CONFIG_THERMAL_PROTECT
void rtw_hal_thermal_detect_cmd(PADAPTER padapter)
{
	struct registry_priv  *registry_par = &padapter->registrypriv;
	u8 cmd[H2C_THERMAL_DETECT_LEN] = {0};
	u8 thermal_detect_enable = registry_par->thermal_detect_en;
	s8 thermal_detect_value = registry_par->thermal_detect_value;
	u8 thermal_detect_duration = registry_par->thermal_detect_duration;
	
	/* FW set thermal detect enable/disable */
	SET_H2CCMD_THERMAL_DETECT_EN(cmd, thermal_detect_enable);
	/* Set start value for thermal detect */
	SET_H2CCMD_THERMAL_DETECT_START_VALUE(cmd, thermal_detect_value);
	/* Set duration for thermal detect */
	SET_H2CCMD_THERMAL_DETECT_DURATION(cmd, thermal_detect_duration);
	
#ifdef CONFIG_THERMAL_PROTECT_DBG
	{
		u8 i = 0;

		RTW_INFO("=========================\n");
		RTW_INFO("Thermal Detect = %s\n", thermal_detect_enable?"Enable":"Disable");
		RTW_INFO("Thermal Detect Value = %x\n", thermal_detect_value);
		RTW_INFO("Thermal Detect Duration = %d\n", thermal_detect_duration);
		for (i = 0; i < H2C_THERMAL_DETECT_LEN; i++)
			printk("0x%x ", cmd[i]);
		printk("\n");
		RTW_INFO("=========================\n");
	}
#endif /* CONFIG_THERMAL_PROTECT_DBG */

	rtw_hal_fill_h2c_cmd(padapter, H2C_THERMAL_DETECT, H2C_THERMAL_DETECT_LEN, cmd);
}


u8 rtw_set_tx_power_level_hdl(_adapter *padapter, u8 *pbuf)
{
	PHAL_DATA_TYPE hal = GET_HAL_DATA(padapter);
	rtw_hal_set_tx_power_level(padapter, hal->current_channel);
	return H2C_SUCCESS;
}


u8 rtw_set_tx_power_level_cmd(_adapter *padapter)
{
	struct cmd_priv *pcmdpriv = &padapter->cmdpriv;
	struct cmd_obj *ph2c;
	u8 res = _SUCCESS;


	ph2c = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (ph2c == NULL) {
		res = _FAIL;
		goto exit;
	}

	init_h2fwcmd_w_parm_no_parm_rsp(ph2c, GEN_CMD_CODE(_Set_Tx_Pwr_Level));

	res = rtw_enqueue_cmd(pcmdpriv, ph2c);

exit:

	return res;
}

void rtw_printer_thermal_proctect_init(PADAPTER padapter) {
	padapter->thermal_proctect.state = THERMAL_PROTECT_DISABLE;
	padapter->thermal_proctect.current_detect_count = 0;
	padapter->thermal_proctect.last_detect_count = 0;
}

void rtw_printer_thermal_proctect_def_init(PADAPTER padapter) {
	padapter->thermal_proctect.tdefence_handling = 0;
}


void rtw_printer_thermal_protect(PADAPTER padapter) {
	PHAL_DATA_TYPE hal = GET_HAL_DATA(padapter);
	
	if(padapter->thermal_proctect.current_detect_count == 0)
		return;
#ifdef CONFIG_THERMAL_PROTECT_DBG
	RTW_INFO("%s => state(%d) current_detect_count = %d, last_detect_count = %d\n", __func__, padapter->thermal_proctect.state, padapter->thermal_proctect.current_detect_count, padapter->thermal_proctect.last_detect_count);
#endif /* CONFIG_THERMAL_PROTECT_DBG */

	switch (padapter->thermal_proctect.state) {
		case THERMAL_PROTECT_DISABLE:
			break;
		case THERMAL_PROTECT_START:
			/* If there is no more thermal detection, we restore the original tx power */
			if(padapter->thermal_proctect.current_detect_count == padapter->thermal_proctect.last_detect_count) {
				RTW_INFO("%s START -> DISABLE Restore the tx power\n", __func__);
				rtw_printer_thermal_proctect_init(padapter);
				rtw_set_tx_power_level_cmd(padapter);
			}
			padapter->thermal_proctect.last_detect_count = padapter->thermal_proctect.current_detect_count;
			break;
		case THERMAL_PROTECT_FUCTION_OFF:
			/* If there is no more thermal detection, we leave ips */
			if(padapter->thermal_proctect.current_detect_count == padapter->thermal_proctect.last_detect_count) {
				RTW_INFO("%s FUCTION_OFF -> DISABLE function on\n", __func__);
				rtw_printer_thermal_proctect_init(padapter);
			}
			padapter->thermal_proctect.last_detect_count = padapter->thermal_proctect.current_detect_count;
			break;
		default:
			padapter->thermal_proctect.last_detect_count = padapter->thermal_proctect.current_detect_count;
			break;
	}
	
}

void rtw_printer_thermal_detection(PADAPTER padapter, u32 thermal_value) {
	PHAL_DATA_TYPE hal = GET_HAL_DATA(padapter);
	struct registry_priv  *registry_par = &padapter->registrypriv;
	struct mlme_priv *pmlmepriv= &padapter->mlmepriv;
	u8 thermal_detect_value;
	u8 null_addr[ETH_ALEN] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

	thermal_detect_value = registry_par->thermal_detect_value;
	
	padapter->thermal_proctect.current_detect_count++;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3, 7, 0))
	cfg80211_conn_failed(padapter->pnetdev, null_addr, NL80211_CONN_FAIL_HIGH_THERMAL, GFP_KERNEL);
#endif
	switch (padapter->thermal_proctect.state) {
		case THERMAL_PROTECT_DISABLE:
			/* If we get the thermal detection, we reduce the tx power first */
			if(thermal_value >= thermal_detect_value) {
				RTW_INFO("%s DISABLE -> START Reduce the tx power\n", __func__);
				padapter->thermal_proctect.state = THERMAL_PROTECT_START;
				/* Reduce the tx power */
				rtw_set_tx_power_level_cmd(padapter);
			}
			break;
		case THERMAL_PROTECT_START:
			/* If we get the higher thermal value, we enter the ips */
			if(thermal_value >= (thermal_detect_value + 0xA)) {
				RTW_INFO("%s START -> FUCTION_OFF function off\n", __func__);
				padapter->thermal_proctect.state = THERMAL_PROTECT_FUCTION_OFF;
				if(check_fwstate(pmlmepriv, _FW_LINKED)) {
					rtw_disassoc_cmd(padapter, 0, RTW_CMDF_DIRECTLY);
					rtw_indicate_disconnect(padapter, 0, _FALSE);
					rtw_free_assoc_resources(padapter, 1);
				}
			}
			break;
		case THERMAL_PROTECT_FUCTION_OFF:
			/* Check if we connect again in Function off state */
			if(thermal_value >= (thermal_detect_value + 0xA)) {
				if(check_fwstate(pmlmepriv, _FW_LINKED)) {
					RTW_INFO("%s FUCTION_OFF -> FUCTION_OFF \n", __func__);
					rtw_disassoc_cmd(padapter, 0, RTW_CMDF_DIRECTLY);
					rtw_indicate_disconnect(padapter, 0, _FALSE);
					rtw_free_assoc_resources(padapter, 1);
				}
			}
			break;
		default:
			break;
	}
}

#define FW_STATUS_C2H_TIMEOUT	BIT(7)
#define FW_STATUS_CHK_FATAL		(BIT(1) | BIT(20))
#define FW_STATUS_CHK_ERR		(BIT(4) | BIT(5) | BIT(6) | BIT(7) | BIT(8) | BIT(9) | \
								BIT(12) | BIT(14) | BIT(15) | BIT(16) | BIT(17) | BIT(18) | BIT(19) | \
								BIT(21) |BIT(22) |BIT(25))
#define FW_STATUS_CHK_WARN		~(FW_STATUS_CHK_FATAL | FW_STATUS_CHK_ERR)

bool rtw_printer_thermal_defence_condition(PADAPTER padapter)
{
	boolean ret = _FALSE;	
	
#ifdef RTW_HALMAC
	struct dvobj_priv *dvobj = adapter_to_dvobj(padapter);
	struct pwrctrl_priv *pwrpriv = adapter_to_pwrctl(padapter);
	struct mlme_priv *pmlmepriv = &(padapter->mlmepriv);
	PHALMAC_ADAPTER mac;
	PHALMAC_API api;
	HALMAC_RET_STATUS status;
	u8 fw_status = _TRUE;
	u32 reg_txdma ;
	u32 reg_fwdbg6;

	mac = dvobj_to_halmac(dvobj);
	api = HALMAC_GET_API(mac);

	/* Condition 1: fw status false */
	status = api->halmac_check_fw_status(mac, &fw_status); 
	RTW_DBG("%s: halmac_check_fw_status ==> status=%x, fw_status=%d\n", __FUNCTION__, status, fw_status);
	if(((status == HALMAC_RET_SUCCESS) && (fw_status == _FALSE)) || (status != HALMAC_RET_SUCCESS))
	{
		//RTW_INFO("%s: halmac_check_fw_status ==> status=%x, fw_status=%d\n", __FUNCTION__, status, fw_status);
		RTW_INFO("%s: halmac_check_fw_status ==> Do thermal defence !!\n", __FUNCTION__);
		return _TRUE;
	} 
	else {
		reg_fwdbg6 = rtw_read32(padapter, REG_FW_DBG6);
		if((reg_fwdbg6 & FW_STATUS_CHK_WARN) != 0)
			rtw_write32(padapter, REG_FW_DBG6, reg_fwdbg6 & ~FW_STATUS_CHK_WARN);
		if((reg_fwdbg6 & FW_STATUS_C2H_TIMEOUT) != 0)
			rtw_write32(padapter, REG_FW_DBG6, reg_fwdbg6 & ~FW_STATUS_C2H_TIMEOUT);
	}

	/* Condition 2: TXDMA */
	reg_txdma = rtw_read32(padapter,REG_TXDMA_STATUS);
	if((pwrpriv->pwr_mode == PS_MODE_ACTIVE) && (reg_txdma!=0x00 && reg_txdma!=0xff && reg_txdma!=0xea))
	{
		RTW_INFO("%s: TXDMA ==> reg_txdma=%x, pwr_mode=%d\n", __FUNCTION__, reg_txdma, pwrpriv->pwr_mode);
		return _TRUE;
	}

#endif

	return ret;
}

bool ex_rtw_printer_thermal_defence(_adapter *adapter)
{
	struct dvobj_priv *dvobj = adapter_to_dvobj(adapter);
	struct pwrctrl_priv *pwrpriv = dvobj_to_pwrctl(dvobj);
	boolean ret = _FALSE;

	if((dvobj->traffic_stat.cur_tx_bytes + dvobj->traffic_stat.cur_rx_bytes) >= 4096)
	{
		RTW_DBG("%s: Don't check for thermal_defence if with high traffic (%lld)! \n", __FUNCTION__
			, (dvobj->traffic_stat.cur_tx_bytes + dvobj->traffic_stat.cur_rx_bytes));
		goto exit;
	}	

	if(ex_rtw_printer_if_thermal_defence_is_handling(adapter))
	{
		RTW_INFO("==>%s : thermal_defence_is_handling \n", __FUNCTION__);
		goto exit;
	}

	if(rtw_printer_thermal_defence_condition(adapter))
	{
		if (_TRUE == pwrpriv->bInternalAutoSuspend)
		{
			RTW_INFO("%s: cancel auto suspend \n", __FUNCTION__);
			ex_autosuspend_cancel_cmd(adapter,_FALSE);
		}
		
		if(ATOMIC_READ(&(adapter->cmdpriv.stop_req)) == _FALSE)
			ex_rtw_printer_hal_thermal_defence_cmd(adapter);
		
		ret = _TRUE;
	}

exit:
	return ret;
}


u8 ex_rtw_printer_thermal_defence_hdl(_adapter *padapter, u8 *pbuf)
{
#if defined(DBG_CONFIG_ERROR_DETECT)	
	rtw_hal_sreset_reset(padapter);
	padapter->thermal_proctect.tdefence_handling = 0;
#endif // DBG_CONFIG_ERROR_DETECT
	return H2C_SUCCESS;
}

/* return true if the thermal defence already in queue or in progress */
u8 ex_rtw_printer_if_thermal_defence_is_handling(_adapter *adapter)
{
	return adapter->thermal_proctect.tdefence_handling;
}


u8 ex_rtw_printer_hal_thermal_defence_cmd(_adapter *adapter)
{
	struct cmd_priv *pcmdpriv = &adapter->cmdpriv;
	struct cmd_obj *ph2c;
	u8 res = _SUCCESS;

	if(ex_rtw_printer_if_thermal_defence_is_handling(adapter))
	{
		RTW_INFO("==>%s : thermal_defence_is_handling \n", __FUNCTION__);
		res = _FAIL;
		goto exit;
	}
	
	ph2c = (struct cmd_obj *)rtw_zmalloc(sizeof(struct cmd_obj));
	if (ph2c == NULL) {
		res = _FAIL;
		goto exit;
	}

	RTW_INFO("==> %s: \n", __FUNCTION__);

	init_h2fwcmd_w_parm_no_parm_rsp(ph2c, GEN_CMD_CODE(_Tdefence));
	res = rtw_enqueue_cmd(pcmdpriv, ph2c);
	adapter->thermal_proctect.tdefence_handling = 1;

exit:
	return res;

}

#endif /* CONFIG_THERMAL_PROTECT */

#if 0
/* JIRA:[PRINTER-341] p2p-logo 5.1.20 */
void ex_rtw_printer_set_en_bcn_ctrl_bit(_adapter *padapter, u8 enable)
{

#ifdef CONFIG_RTL8821C
	RTW_INFO("%s(): set port(%d) en_beacon_ctrl bit %s\n", __func__, padapter->hw_port, enable?"enable":"disable");
	rtw_hal_set_hwreg(padapter, HW_VAR_EN_BCN_CTRL,(u8 *)&enable);
#endif

}
#endif

#endif  /* CONFIG_PRINTER_UTILITY */

